/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxyutil.ext99bill;

import com.xunlei.encrypt.util.Arith;
import com.xunlei.encrypt.util.Md5Encrypt;
import com.xunlei.monitor.bill99check.rmb.GatewayOrderDetail;
import com.xunlei.monitor.bill99check.rmb.GatewayOrderQueryRequest;
import com.xunlei.monitor.bill99check.rmb.GatewayOrderQueryResponse;
import com.xunlei.monitor.bill99check.rmb.GatewayOrderQueryServiceLocator;
import com.xunlei.monitor.bill99check.szx.GatewayPayOrderDetail;
import com.xunlei.monitor.bill99check.szx.GatewayPayOrderPQueryResponse;
import com.xunlei.monitor.bill99check.szx.GatewayPayOrderQueryRequest;
import com.xunlei.monitor.bill99check.szx.GatewayPayOrderQueryServiceLocator;
import com.xunlei.payproxyutil.result.ResultInfo;
import com.xunlei.payproxyutil.result.SuccessResultInfo;
import com.xunlei.payproxyutil.util.PayProxyUtilPropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ext99BillHelper {
    private static Logger logger = LoggerFactory.getLogger(Ext99BillHelper.class);

    public static ResultInfo getQueryResult(String orderid, String bankNo, double amt) {
        long payamount = Double.valueOf(Arith.mul(amt, 100.0)).longValue();
        String code = "10";
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.setCode(code);
        try {
            String card_merchantAcctId = "";
            String card_merchantKey = "";
            if (bankNo.equalsIgnoreCase("SZX") || bankNo.equalsIgnoreCase("LTJFK") || bankNo.equalsIgnoreCase("DXJFK")) {
                if (bankNo.equalsIgnoreCase("SZX")) {
                    card_merchantAcctId = PayProxyUtilPropertiesUtil.ext_99bill_szx_merchantAcctId;
                    card_merchantKey = PayProxyUtilPropertiesUtil.ext_99bill_szx_merchantKey;
                } else if (bankNo.equalsIgnoreCase("LTJFK")) {
                    card_merchantAcctId = PayProxyUtilPropertiesUtil.ext_99bill_ltjfk_merchantAcctId;
                    card_merchantKey = PayProxyUtilPropertiesUtil.ext_99bill_ltjfk_merchantKey;
                } else if (bankNo.equalsIgnoreCase("DXJFK")) {
                    card_merchantAcctId = PayProxyUtilPropertiesUtil.ext_99bill_dxjfk_merchantAcctId;
                    card_merchantKey = PayProxyUtilPropertiesUtil.ext_99bill_dxjfk_merchantKey;
                }
                GatewayPayOrderQueryRequest queryRequest = Ext99BillHelper.creat99billSZXQueryRequest(orderid, card_merchantAcctId, card_merchantKey);
                GatewayPayOrderQueryServiceLocator locator = new GatewayPayOrderQueryServiceLocator();
                GatewayPayOrderPQueryResponse queryResponse = locator.getszxGatewayPayOrderQuery().gatewayOrderQuery(queryRequest);
                String errCode = queryResponse.getErrCode();
                if (errCode != null && errCode.trim().length() > 0) {
                    String failDesp = "\u67e5\u8be2\u5931\u8d25\uff01\u9519\u8bef\u7801\u4e3a\uff1a" + errCode;
                    resultInfo.setMessage(failDesp);
                    return resultInfo;
                }
                GatewayPayOrderDetail[] orders = queryResponse.getOrders();
                if (orders != null && orders.length > 1) {
                    String failDesp = "\u8ba2\u5355\u53f7\u91cd\u590d\uff01";
                    resultInfo.setMessage(failDesp);
                    return resultInfo;
                }
                GatewayPayOrderDetail oneorder = orders[0];
                if (!oneorder.getPayResult().equals("10")) {
                    String failDesp = "\u652f\u4ed8\u7ed3\u679c\u4e0d\u6210\u529f\uff01";
                    resultInfo.setMessage(failDesp);
                    return resultInfo;
                }
                if (oneorder.getPayAmount() != payamount) {
                    String failDesp = "\u7528\u6237\u91d1\u989d\u4e0d\u7b26\uff01";
                    resultInfo.setMessage(failDesp);
                    return resultInfo;
                }
            } else {
                GatewayOrderQueryRequest queryRequest = Ext99BillHelper.creat99billBankQueryRequest(orderid, PayProxyUtilPropertiesUtil.ext_99bill_bank_merchantAcctId, PayProxyUtilPropertiesUtil.ext_99bill_bank_merchantKey);
                GatewayOrderQueryServiceLocator locator = new GatewayOrderQueryServiceLocator();
                GatewayOrderQueryResponse queryResponse = locator.getgatewayOrderQuery().gatewayOrderQuery(queryRequest);
                String errCode = queryResponse.getErrCode();
                if (errCode != null && errCode.trim().length() > 0) {
                    String failDesp = "\u67e5\u8be2\u5931\u8d25\uff01\u9519\u8bef\u7801\u4e3a\uff1a" + errCode;
                    resultInfo.setMessage(failDesp);
                    return resultInfo;
                }
                GatewayOrderDetail[] orders = queryResponse.getOrders();
                if (orders != null && orders.length > 1) {
                    String failDesp = "\u8ba2\u5355\u53f7\u91cd\u590d\uff01";
                    resultInfo.setMessage(failDesp);
                    return resultInfo;
                }
                GatewayOrderDetail oneorder = orders[0];
                if (!oneorder.getPayResult().equals("10")) {
                    String failDesp = "\u652f\u4ed8\u7ed3\u679c\u4e0d\u6210\u529f\uff01";
                    resultInfo.setMessage(failDesp);
                    return resultInfo;
                }
                if (oneorder.getPayAmount() != payamount) {
                    String failDesp = "\u7528\u6237\u652f\u4ed8\u91d1\u989d\u4e0d\u7b26\uff01";
                    resultInfo.setMessage(failDesp);
                    return resultInfo;
                }
            }
        }
        catch (Exception e) {
            logger.error("Monitor99BillokHandler monitor with Exception:{}, orderid:{}, bankNo:{}, orderamt:{}", new Object[]{e, orderid, bankNo, amt});
            e.printStackTrace();
            resultInfo.setMessage(e.getMessage());
            return resultInfo;
        }
        return new SuccessResultInfo();
    }

    private static GatewayPayOrderQueryRequest creat99billSZXQueryRequest(String orderid, String merchantAcctId, String merchantKey) {
        try {
            String signMsgVal = String.format(PayProxyUtilPropertiesUtil.ext_99bill_encrypt_source_format, merchantAcctId, orderid, merchantKey);
            byte[] bts = signMsgVal.getBytes(PayProxyUtilPropertiesUtil.ext_99bill_encrypt_charset);
            String signMsg = Md5Encrypt.md5Hex(bts);
            signMsg = signMsg.toUpperCase();
            GatewayPayOrderQueryRequest queryRequest = new GatewayPayOrderQueryRequest();
            queryRequest.setInputCharset(PayProxyUtilPropertiesUtil.ext_99bill_inputCharset);
            queryRequest.setVersion(PayProxyUtilPropertiesUtil.ext_99bill_version);
            queryRequest.setSignType(Integer.parseInt(PayProxyUtilPropertiesUtil.ext_99bill_signType));
            queryRequest.setMerchantAcctId(merchantAcctId);
            queryRequest.setQueryType(Integer.parseInt(PayProxyUtilPropertiesUtil.ext_99bill_queryType));
            queryRequest.setQueryMode(Integer.parseInt(PayProxyUtilPropertiesUtil.ext_99bill_queryMode));
            queryRequest.setOrderId(orderid);
            queryRequest.setSignMsg(signMsg);
            return queryRequest;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static GatewayOrderQueryRequest creat99billBankQueryRequest(String orderid, String merchantAcctId, String merchantKey) {
        try {
            String signMsgVal = String.format(PayProxyUtilPropertiesUtil.ext_99bill_encrypt_source_format, merchantAcctId, orderid, merchantKey);
            byte[] bts = signMsgVal.getBytes(PayProxyUtilPropertiesUtil.ext_99bill_encrypt_charset);
            String signMsg = Md5Encrypt.md5Hex(bts);
            signMsg = signMsg.toUpperCase();
            GatewayOrderQueryRequest queryRequest = new GatewayOrderQueryRequest();
            queryRequest.setInputCharset(PayProxyUtilPropertiesUtil.ext_99bill_inputCharset);
            queryRequest.setVersion(PayProxyUtilPropertiesUtil.ext_99bill_version);
            queryRequest.setSignType(Integer.parseInt(PayProxyUtilPropertiesUtil.ext_99bill_signType));
            queryRequest.setMerchantAcctId(merchantAcctId);
            queryRequest.setQueryType(Integer.parseInt(PayProxyUtilPropertiesUtil.ext_99bill_queryType));
            queryRequest.setQueryMode(Integer.parseInt(PayProxyUtilPropertiesUtil.ext_99bill_queryMode));
            queryRequest.setOrderId(orderid);
            queryRequest.setSignMsg(signMsg);
            return queryRequest;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

