/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxyutil.alipay;

import com.xunlei.encrypt.util.Md5Encrypt;
import com.xunlei.payproxyutil.alipay.Alipay;
import com.xunlei.payproxyutil.alipay.Response;
import com.xunlei.payproxyutil.alipay.Trade;
import com.xunlei.payproxyutil.result.ResultInfo;
import com.xunlei.payproxyutil.util.PayProxyUtilPropertiesUtil;
import java.net.URL;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class AlipayQueryHelper {
    private static Logger logger = Logger.getLogger(AlipayQueryHelper.class);

    private static Alipay parseAlipayResponse(Element alipayElement) {
        Alipay alipay = new Alipay();
        String is_success = alipayElement.elementTextTrim("is_success");
        String sign = alipayElement.elementTextTrim("sign");
        String sign_type = alipayElement.elementTextTrim("sign_type");
        alipay.setIs_success(is_success);
        alipay.setSign(sign);
        alipay.setSign_type(sign_type);
        if (!is_success.equals("T")) {
            String error = alipayElement.elementTextTrim("error");
            alipay.setError(error);
            return alipay;
        }
        Element respElement = alipayElement.element("response");
        Element tradeElement = respElement.element("trade");
        String buyer_id = tradeElement.elementTextTrim("buyer_id");
        String out_trade_no = tradeElement.elementTextTrim("out_trade_no");
        double total_fee = Double.parseDouble(tradeElement.elementTextTrim("total_fee"));
        String trade_no = tradeElement.elementTextTrim("trade_no");
        String trade_status = tradeElement.elementTextTrim("trade_status");
        String refund_status = tradeElement.elementText("refund_status");
        String refund_fee = tradeElement.elementText("refund_fee");
        String seller_email = tradeElement.elementText("seller_email");
        String buyer_email = tradeElement.elementText("buyer_email");
        String gmt_payment = tradeElement.elementText("gmt_payment");
        Trade trade = new Trade();
        trade.setBuyer_id(buyer_id);
        trade.setOut_trade_no(out_trade_no);
        trade.setTotal_fee(total_fee);
        trade.setTrade_no(trade_no);
        trade.setTrade_status(trade_status);
        trade.setRefund_fee(refund_fee);
        trade.setRefund_status(refund_status);
        trade.setSeller_email(seller_email);
        trade.setBuyer_email(buyer_email);
        trade.setGmt_payment(gmt_payment);
        Response response = new Response();
        response.setTrade(trade);
        alipay.setResponse(response);
        return alipay;
    }

    public static ResultInfo getQueryResult(String orderid, String sellerEmail) {
        if (sellerEmail != null) {
            sellerEmail = sellerEmail.trim();
        }
        String urlstr = null;
        StringBuilder builder = null;
        try {
            urlstr = AlipayQueryHelper.createMonitorUrl(orderid, sellerEmail);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"create alipay url with exception:{}", (Throwable)e);
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append("orderid:").append(orderid).append(", \u751f\u6210\u8bbf\u95ee\u652f\u4ed8\u5b9durl\u51fa\u9519:").append(e.getMessage());
            return new ResultInfo("10", builder.toString());
        }
        if (urlstr == null) {
            logger.error((Object)"\u652f\u4ed8\u5b9d\u8bbf\u95eeurl\u4e3anull");
            new ResultInfo("10", "\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        logger.info((Object)("\u652f\u4ed8\u5b9d\u67e5\u8be2url\u4e3a\uff1a " + urlstr));
        try {
            URL url = new URL(urlstr);
            SAXReader reader = new SAXReader();
            Document document = reader.read(url);
            Element root = document.getRootElement();
            logger.info((Object)("\u8bbf\u95ee\u652f\u4ed8\u5b9d\u7684\u8fd4\u56dexml\u4e3a\uff1a" + document.asXML()));
            Alipay alipay = AlipayQueryHelper.parseAlipayResponse(root);
            logger.info((Object)("\u89e3\u6790\u540ealipay\u503c\u4e3a\uff1a" + alipay));
            return AlipayQueryHelper.dealAlipayResponse(orderid, alipay);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(" ExtAlipayHandler monitor with Exception : " + e));
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append("orderid:").append(orderid).append(", \u8bbf\u95ee\u652f\u4ed8\u5b9durl").append(urlstr).append(",\u51fa\u9519:").append(e.getMessage());
            return new ResultInfo("10", builder.toString());
        }
    }

    public static ResultInfo getQueryResultForWireless(String orderid, String sellerEmail) {
        if (sellerEmail != null) {
            sellerEmail = sellerEmail.trim();
        }
        String urlstr = null;
        StringBuilder builder = null;
        try {
            urlstr = AlipayQueryHelper.createMonitorUrlForWireless(orderid, sellerEmail);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"create alipay url with exception:{}", (Throwable)e);
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append("orderid:").append(orderid).append(", \u751f\u6210\u8bbf\u95ee\u652f\u4ed8\u5b9durl\u51fa\u9519:").append(e.getMessage());
            return new ResultInfo("10", builder.toString());
        }
        if (urlstr == null) {
            logger.error((Object)"\u652f\u4ed8\u5b9d\u8bbf\u95eeurl\u4e3anull");
            new ResultInfo("10", "\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        logger.info((Object)("\u652f\u4ed8\u5b9d\u67e5\u8be2url\u4e3a\uff1a " + urlstr));
        try {
            URL url = new URL(urlstr);
            SAXReader reader = new SAXReader();
            Document document = reader.read(url);
            Element root = document.getRootElement();
            logger.info((Object)("\u8bbf\u95ee\u652f\u4ed8\u5b9d\u7684\u8fd4\u56dexml\u4e3a\uff1a" + document.asXML()));
            Alipay alipay = AlipayQueryHelper.parseAlipayResponse(root);
            logger.info((Object)("\u89e3\u6790\u540ealipay\u503c\u4e3a\uff1a" + alipay));
            return AlipayQueryHelper.dealAlipayResponse(orderid, alipay);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(" ExtAlipayHandler monitor with Exception : " + e));
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append("orderid:").append(orderid).append(", \u8bbf\u95ee\u652f\u4ed8\u5b9durl").append(urlstr).append(",\u51fa\u9519:").append(e.getMessage());
            return new ResultInfo("10", builder.toString());
        }
    }

    public static Alipay getQueryResultAsAlipay(String orderid, String sellerEmail) {
        if (sellerEmail != null) {
            sellerEmail = sellerEmail.trim();
        }
        String urlstr = null;
        StringBuilder builder = null;
        try {
            urlstr = AlipayQueryHelper.createMonitorUrl(orderid, sellerEmail);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"create alipay url with exception:{}", (Throwable)e);
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append("orderid:").append(orderid).append(", \u751f\u6210\u8bbf\u95ee\u652f\u4ed8\u5b9durl\u51fa\u9519:").append(e.getMessage());
            return new Alipay();
        }
        if (urlstr == null) {
            logger.error((Object)"\u652f\u4ed8\u5b9d\u8bbf\u95eeurl\u4e3anull");
            new ResultInfo("10", "\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        logger.info((Object)("\u652f\u4ed8\u5b9d\u67e5\u8be2url\u4e3a\uff1a " + urlstr));
        try {
            URL url = new URL(urlstr);
            SAXReader reader = new SAXReader();
            Document document = reader.read(url);
            Element root = document.getRootElement();
            logger.info((Object)("\u8bbf\u95ee\u652f\u4ed8\u5b9d\u7684\u8fd4\u56dexml\u4e3a\uff1a" + root.getText()));
            Alipay alipay = AlipayQueryHelper.parseAlipayResponse(root);
            logger.info((Object)("\u89e3\u6790\u540ealipay\u503c\u4e3a\uff1a" + alipay));
            return alipay;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(" ExtAlipayHandler monitor with Exception : " + e));
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append("orderid:").append(orderid).append(", \u8bbf\u95ee\u652f\u4ed8\u5b9durl").append(urlstr).append(",\u51fa\u9519:").append(e.getMessage());
            return new Alipay();
        }
    }

    private static ResultInfo dealAlipayResponse(String orderid, Alipay alipay) {
        if (alipay.getIs_success().equals("T")) {
            String trade_status = alipay.getResponse().getTrade().getTrade_status();
            if ("TRADE_FINISHED".equals(trade_status) || "TRADE_SUCCESS".equals(trade_status)) {
                String failDesp = "\u652f\u4ed8\u5b9d\u8bf7\u6c42\u8ba2\u5355, orderid:" + orderid + " \u652f\u4ed8\u6210\u529f";
                return new ResultInfo("00", failDesp, alipay);
            }
            String failDesp = "\u652f\u4ed8\u5b9d\u8bf7\u6c42\u8ba2\u5355, orderid:" + orderid + " \u672a\u652f\u4ed8\u6210\u529f";
            return new ResultInfo("10", failDesp, alipay);
        }
        String failDesp = "\u652f\u4ed8\u5b9d\u8bf7\u6c42\u8ba2\u5355, orderid:" + orderid + " \u672a\u652f\u4ed8\u6210\u529f";
        return new ResultInfo("10", failDesp, alipay);
    }

    private static String createMonitorUrl(String out_trade_no, String sellerEmail) throws Exception {
        String alipayUrl = null;
        String partner = "";
        String encryptKey = "";
        if (PayProxyUtilPropertiesUtil.alipay_seller_email.equals(sellerEmail)) {
            partner = PayProxyUtilPropertiesUtil.alipay_partner;
            encryptKey = PayProxyUtilPropertiesUtil.alipay_key;
        } else if (PayProxyUtilPropertiesUtil.alipay_credit_seller_email.equals(sellerEmail)) {
            partner = PayProxyUtilPropertiesUtil.alipay_credit_partner;
            encryptKey = PayProxyUtilPropertiesUtil.alipay_credit_key;
        } else {
            partner = PayProxyUtilPropertiesUtil.alipay_direct_bank_partner;
            encryptKey = PayProxyUtilPropertiesUtil.alipay_direct_bank_key;
        }
        alipayUrl = AlipayQueryHelper.createAlipayUrl(out_trade_no, partner, encryptKey);
        return alipayUrl;
    }

    private static String createMonitorUrlForWireless(String out_trade_no, String sellerEmail) throws Exception {
        String alipayUrl = null;
        String partner = "";
        String encryptKey = "";
        if (PayProxyUtilPropertiesUtil.alipay_seller_email.equals(sellerEmail)) {
            partner = PayProxyUtilPropertiesUtil.alipay_wireless_partner;
            encryptKey = PayProxyUtilPropertiesUtil.alipay_wireless_key;
        } else if (PayProxyUtilPropertiesUtil.ALIPAY_WAP_SS_SELLER_EMAIL.equals(sellerEmail)) {
            partner = PayProxyUtilPropertiesUtil.ALIPAY_WAP_SS_PARTNER;
            encryptKey = PayProxyUtilPropertiesUtil.ALIPAY_WAP_SS_KEY;
        } else {
            partner = PayProxyUtilPropertiesUtil.alipay_wireless_partner;
            encryptKey = PayProxyUtilPropertiesUtil.alipay_wireless_key;
        }
        alipayUrl = AlipayQueryHelper.createAlipayUrl(out_trade_no, partner, encryptKey);
        return alipayUrl;
    }

    public static String createAlipayUrl(String out_trade_no, String partner, String encryptKey) {
        String noencryptstr = String.format(PayProxyUtilPropertiesUtil.alipayEncryptSourceFormat, PayProxyUtilPropertiesUtil.alipay_input_charset, out_trade_no, partner);
        String encryptstr = String.valueOf(noencryptstr) + encryptKey;
        String sign = Md5Encrypt.md5(encryptstr, PayProxyUtilPropertiesUtil.alipay_input_charset);
        String url = String.format(PayProxyUtilPropertiesUtil.alipayUrlFormat, PayProxyUtilPropertiesUtil.alipay_input_charset, partner, out_trade_no, sign);
        return url;
    }
}

