/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.util;

import com.xunlei.payproxy.util.Md5Encrypt;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SignatureHelper {
    private static final Log log = LogFactory.getLog(SignatureHelper.class);

    public static boolean checkSign(Map param, String privateKey) {
        if (StringUtils.isEmpty((String)privateKey) || param == null) {
            return false;
        }
        String signMsg = (String)param.get("signMsg");
        if (StringUtils.isEmpty((String)signMsg)) {
            return false;
        }
        String signed = SignatureHelper.sign(param, privateKey);
        log.debug((Object)("signMsg = " + signMsg + ",signed = " + signed));
        return signMsg.equals(signed);
    }

    public static String sign(Map<String, String> param, String privateKey) {
        String content = SignatureHelper.getSignatureContent(param);
        log.info((Object)("\u9700\u8981\u7b7e\u540d\u5904\u7406\u7684URL\uff1a" + content));
        return SignatureHelper.sign(content, privateKey);
    }

    public static String sign(String content, String privateKey) {
        if (content == null) {
            return null;
        }
        return Md5Encrypt.md5(String.valueOf(content) + privateKey);
    }

    public static String getSignatureContent(Map<String, String> param) {
        return SignatureHelper.getSignatureContent(param, null);
    }

    public static String getSignatureContent(Map<String, String> param, String encodeCharset) {
        Properties prop = new Properties();
        for (String key : param.keySet()) {
            String value;
            if (key.equals("signMsg") || StringUtils.isEmpty((String)(value = param.get(key)))) continue;
            prop.setProperty(key, value);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> keys = new ArrayList<Object>(prop.keySet());
        Collections.sort(keys);
        int i = 0;
        while (i < keys.size()) {
            String key = (String)keys.get(i);
            String value = prop.getProperty(key);
            if (!StringUtils.isEmpty((String)encodeCharset)) {
                try {
                    value = URLEncoder.encode(prop.getProperty(key), encodeCharset);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sb.append(i == 0 ? "" : "&");
            sb.append(key).append("=").append(value);
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("areaId", "BJ");
        params.put("orderId", "127305170096");
        params.put("orderAmt", "1000");
        params.put("orderTime", "20100505172820");
        params.put("dealId", "2010050500230112");
        params.put("dealTime", "20100505173320");
        params.put("payResult", "Y");
        params.put("errCode", "");
        System.out.println(SignatureHelper.getSignatureContent(params));
    }
}

