/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.util;

import com.xunlei.payproxy.util.PayProxyURLException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PayProxyGatewayUtil {
    private static Log log = LogFactory.getLog(PayProxyGatewayUtil.class);
    public static String PAY_PROXY_PREFIX_URL = "http://proxy.pay.xunlei.com/payHandle?";
    public static String PAY_PROXY_ROYALTY_PREFIX_URL = "http://proxy.pay.xunlei.com/distributeRoyalty?";
    public static String PAY_PROXY_REFUND_FAST_PAY_PREFIX_URL = "http://proxy.pay.xunlei.com/refund?";
    private static String urlParamsCharset = "UTF-8";
    private static String signMsgCharset = "GBK";
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getCallPayProxyURL(Map<String, String> paramsMap, String bizKey) throws PayProxyURLException {
        if (paramsMap == null || paramsMap.isEmpty()) {
            throw new PayProxyURLException("the paramsMap is null or empty!!!");
        }
        if (PAY_PROXY_PREFIX_URL == null) {
            throw new PayProxyURLException("the payproxyURL is null, please set it's value");
        }
        if (urlParamsCharset == null || signMsgCharset == null) {
            throw new PayProxyURLException("the charset is null, please call ");
        }
        String signMsg = PayProxyGatewayUtil.sign(paramsMap, bizKey, signMsgCharset);
        paramsMap.put("signMsg", signMsg);
        return PAY_PROXY_PREFIX_URL + PayProxyGatewayUtil.getSignatureContent(paramsMap, urlParamsCharset);
    }

    public static String getRoyaltyUrl(Map<String, String> paramsMap, String bizKey) throws PayProxyURLException {
        return PayProxyGatewayUtil.createURL(PAY_PROXY_ROYALTY_PREFIX_URL, paramsMap, bizKey);
    }

    public static String getRefundFastpayUrl(Map<String, String> paramsMap, String bizKey) throws PayProxyURLException {
        return PayProxyGatewayUtil.createURL(PAY_PROXY_REFUND_FAST_PAY_PREFIX_URL, paramsMap, bizKey);
    }

    private static String createURL(String prefixUrl, Map<String, String> paramsMap, String bizKey) throws PayProxyURLException {
        if (paramsMap == null || paramsMap.isEmpty()) {
            throw new PayProxyURLException("the paramsMap is null or empty!!!");
        }
        if (prefixUrl == null) {
            throw new PayProxyURLException("the prefixUrl is null, please set it's value");
        }
        if (urlParamsCharset == null || signMsgCharset == null) {
            throw new PayProxyURLException("the charset is null, please set it's value");
        }
        String content = PayProxyGatewayUtil.getSignatureContent(paramsMap, null);
        String pageCharset = paramsMap.get("pageCharset");
        String charset = PayProxyGatewayUtil.getCharset(pageCharset);
        String signMsg = PayProxyGatewayUtil.sign(content, bizKey, charset);
        paramsMap.put("signMsg", signMsg);
        return prefixUrl + PayProxyGatewayUtil.getSignatureContent(paramsMap, charset);
    }

    public static String sign(Map<String, String> paramsMap, String bizKey, String charset) throws PayProxyURLException {
        String content = PayProxyGatewayUtil.getSignatureContent(paramsMap, null);
        log.info((Object)("\u9700\u8981\u7b7e\u540d\u5904\u7406\u7684URL\uff1a" + content));
        return PayProxyGatewayUtil.sign(content, bizKey, charset);
    }

    private static String sign(String content, String bizKey, String charset) {
        if (content == null) {
            return null;
        }
        return PayProxyGatewayUtil.md5(String.valueOf(content) + bizKey, charset);
    }

    private static String getSignatureContent(Map<String, String> paramsMap, String charset) throws PayProxyURLException {
        if (paramsMap == null || paramsMap.isEmpty()) {
            return null;
        }
        ArrayList<String> keysList = new ArrayList<String>(paramsMap.keySet());
        Collections.sort(keysList);
        StringBuilder builder = new StringBuilder();
        Iterator itor = keysList.iterator();
        boolean first = true;
        while (itor.hasNext()) {
            String key = (String)itor.next();
            String value = paramsMap.get(key);
            if (value == null || value.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                builder.append("&");
            }
            if (charset != null) {
                try {
                    value = URLEncoder.encode(value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new PayProxyURLException(e.getMessage());
                }
            }
            builder.append(key).append("=").append(value);
        }
        return builder.toString();
    }

    private static String md5(String text, String charset) {
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("System doesn't support MD5 algorithm.");
        }
        try {
            msgDigest.update(text.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("System doesn't support your  EncodingException.");
        }
        byte[] bytes = msgDigest.digest();
        String md5Str = new String(PayProxyGatewayUtil.encodeHex(bytes));
        return md5Str;
    }

    private static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int i = 0;
        int j = 0;
        while (i < l) {
            out[j++] = hexDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = hexDigits[0xF & data[i]];
            ++i;
        }
        return out;
    }

    private static String getCharset(String pageCharset) {
        if ("2".equals(pageCharset)) {
            return "GBK";
        }
        if ("3".equals(pageCharset)) {
            return "GB2312";
        }
        return "UTF-8";
    }
}

