/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.alipay.util;

import com.xunlei.alipay.util.SignProtocolException;
import com.xunlei.encrypt.util.Md5Encrypt;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SignProtocolUtil {
    private static Log log = LogFactory.getLog(SignProtocolUtil.class);
    private static final String SIGN_PROTOCOL_URL = "http://proxy.pay.xunlei.com/signProtocol";
    private static final String QUERY_SIGN_PROTOCOL_URL = "http://proxy.pay.xunlei.com/querysignProtocol";
    private static final String urlParamsCharset = "UTF-8";
    private static final String signMsgCharset = "GBK";

    public static String getSignProtocolUrl(Map<String, String> paramsMap, String bizKey) throws SignProtocolException {
        if (paramsMap == null || paramsMap.isEmpty()) {
            throw new SignProtocolException("the paramsMap is null or empty!!!");
        }
        if (SIGN_PROTOCOL_URL == null) {
            throw new SignProtocolException("the signProtocol url is null, please set it's value");
        }
        String signMsg = SignProtocolUtil.sign(paramsMap, bizKey);
        paramsMap.put("signMsg", signMsg);
        return SIGN_PROTOCOL_URL + "?" + SignProtocolUtil.getSignatureContent(paramsMap, urlParamsCharset);
    }

    public static String getQuerySignProtocolUrl(Map<String, String> paramsMap, String bizKey) throws SignProtocolException {
        if (paramsMap == null || paramsMap.isEmpty()) {
            throw new SignProtocolException("the paramsMap is null or empty!!!");
        }
        if (QUERY_SIGN_PROTOCOL_URL == null) {
            throw new SignProtocolException("the querysignProtocol url is null, please set it's value");
        }
        String signMsg = SignProtocolUtil.sign(paramsMap, bizKey);
        paramsMap.put("signMsg", signMsg);
        return QUERY_SIGN_PROTOCOL_URL + "?" + SignProtocolUtil.getSignatureContent(paramsMap, urlParamsCharset);
    }

    public static String sign(Map<String, String> paramsMap, String bizKey) throws SignProtocolException {
        String content = SignProtocolUtil.getSignatureContent(paramsMap, null);
        log.info((Object)("\u9700\u8981\u7b7e\u540d\u5904\u7406\u7684URL\uff1a" + content));
        return SignProtocolUtil.sign(content, bizKey);
    }

    private static String sign(String content, String bizKey) {
        if (content == null) {
            return null;
        }
        return Md5Encrypt.md5(String.valueOf(content) + bizKey, signMsgCharset);
    }

    private static String getSignatureContent(Map<String, String> paramsMap, String charset) throws SignProtocolException {
        if (paramsMap == null || paramsMap.isEmpty()) {
            return null;
        }
        ArrayList<String> keysList = new ArrayList<String>(paramsMap.keySet());
        Collections.sort(keysList);
        StringBuilder builder = new StringBuilder();
        Iterator itor = keysList.iterator();
        boolean first = true;
        while (itor.hasNext()) {
            String key = (String)itor.next();
            String value = paramsMap.get(key);
            if (value == null || value.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                builder.append("&");
            }
            if (charset != null) {
                try {
                    value = URLEncoder.encode(value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SignProtocolException(e.getMessage());
                }
            }
            builder.append(key).append("=").append(value);
        }
        return builder.toString();
    }
}

