/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.alipay.util;

import com.xunlei.alipay.util.CloseTradeException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class CloseTradeUtil {
    private static final String CLOSE_TRADE_URL = "http://proxy.pay.xunlei.com/alipayCloseTrade";
    private static final String urlParamsCharset = "UTF-8";

    public static String getCloseTradeUrl(Map<String, String> paramsMap) throws CloseTradeException {
        if (paramsMap == null || paramsMap.isEmpty()) {
            throw new CloseTradeException("the paramsMap is null or empty!!!");
        }
        String xlpayproxyUrl = CLOSE_TRADE_URL + "?" + CloseTradeUtil.getReqEntity(paramsMap, urlParamsCharset);
        return xlpayproxyUrl;
    }

    private static String getReqEntity(Map<String, String> paramsMap, String charset) throws CloseTradeException {
        if (paramsMap == null || paramsMap.isEmpty()) {
            return null;
        }
        ArrayList<String> keysList = new ArrayList<String>(paramsMap.keySet());
        Collections.sort(keysList);
        StringBuilder builder = new StringBuilder();
        Iterator itor = keysList.iterator();
        boolean first = true;
        while (itor.hasNext()) {
            String key = (String)itor.next();
            String value = paramsMap.get(key);
            if (value == null || value.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                builder.append("&");
            }
            if (charset != null) {
                try {
                    value = URLEncoder.encode(value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new CloseTradeException(e.getMessage());
                }
            }
            builder.append(key).append("=").append(value);
        }
        return builder.toString();
    }
}

