/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.alipay.util;

import com.xunlei.encrypt.util.EncryptProxy;
import com.xunlei.encrypt.util.Md5Encrypt;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlipayHelper {
    private static Logger logger = LoggerFactory.getLogger(AlipayHelper.class);

    public static void putNotEmpty2Map(String key, Object value, Map<String, Object> params) {
        if (key == null || key.isEmpty() || value == null || params == null) {
            return;
        }
        String tValue = value.toString();
        if (tValue.isEmpty()) {
            return;
        }
        params.put(key, value);
    }

    public static StringBuilder sortParams(Map<String, Object> params) {
        ArrayList<String> noSignParamList = new ArrayList<String>(params.keySet());
        Collections.sort(noSignParamList);
        Iterator itor = noSignParamList.iterator();
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        while (itor.hasNext()) {
            String name = (String)itor.next();
            Object value = params.get(name);
            if (!first) {
                builder.append("&");
            } else {
                first = false;
            }
            builder.append(name).append("=").append(value);
        }
        return builder;
    }

    public static void main(String[] args) {
        Object pageCharset = null;
        String billId = "101226334604402306";
        String bizNo = "000001026";
        String oldorderId = "20101225122326325100645";
        String orderTime = "20101226144724";
        String royalty = "kangpan2756@sina.com^1^\u670d\u52a1\u5546003,\u5e94\u7528003";
        String version = "v1.0";
        HashMap<String, Object> params = new HashMap<String, Object>();
        AlipayHelper.putNotEmpty2Map("version", version, params);
        AlipayHelper.putNotEmpty2Map("pageCharset", pageCharset, params);
        AlipayHelper.putNotEmpty2Map("bizNo", bizNo, params);
        AlipayHelper.putNotEmpty2Map("billId", billId, params);
        AlipayHelper.putNotEmpty2Map("oldorderId", oldorderId, params);
        AlipayHelper.putNotEmpty2Map("orderTime", orderTime, params);
        AlipayHelper.putNotEmpty2Map("royalty", royalty, params);
        StringBuilder builder = AlipayHelper.sortParams(params);
        builder.append("abcdabcdabcd0000");
        String input = builder.toString();
        String payproxysign = EncryptProxy.md5(input, "UTF-8");
        System.out.println(payproxysign);
        String signMsg = "";
        logger.debug("signMsg:{}, payproxysign:{}", new Object[]{signMsg, payproxysign});
    }

    public static String paramUrlEncode(String param, String charset) {
        if (param != null && !param.isEmpty()) {
            try {
                return URLEncoder.encode(param, charset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static String paramUrlDecode(String param, String charset) {
        if (param != null && !param.isEmpty()) {
            try {
                return URLDecoder.decode(param, charset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static StringBuilder appendParams(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (!first) {
                builder.append("&");
            } else {
                first = false;
            }
            builder.append(key).append("=").append(value);
        }
        return builder;
    }

    public static String creatSign(String input, String signType, String charset) {
        if (signType == null || signType.isEmpty()) {
            signType = "MD5";
        }
        if (signType.equals("MD5")) {
            return Md5Encrypt.md5(input, charset);
        }
        return null;
    }

    public static String createBatchNo() {
        return CreateBatchNo.createBatchNo();
    }

    public static String createBillNoId() {
        return CreateBillId.createBillNoId();
    }

    private static class CreateBatchNo {
        private static String batchNoPrex = null;
        private static AtomicLong atomicBatchNo = new AtomicLong();
        private static long nextDateTimeMillis = 0L;
        private static long BillNoMaxSeqIndex = 999999999999999999L;

        private CreateBatchNo() {
        }

        public static String createBatchNo() {
            long seq = atomicBatchNo.getAndIncrement();
            if (batchNoPrex == null || System.currentTimeMillis() > nextDateTimeMillis || seq > BillNoMaxSeqIndex) {
                CreateBatchNo.refresh();
                seq = atomicBatchNo.getAndIncrement();
            }
            return String.valueOf(batchNoPrex) + seq;
        }

        private static synchronized void refresh() {
            if (System.currentTimeMillis() > nextDateTimeMillis) {
                Calendar c = Calendar.getInstance();
                if (nextDateTimeMillis == 0L) {
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                } else {
                    c.setTimeInMillis(nextDateTimeMillis);
                }
                c.add(5, 1);
                nextDateTimeMillis = c.getTimeInMillis();
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                batchNoPrex = format.format(new Date());
            }
            if (atomicBatchNo.get() > BillNoMaxSeqIndex) {
                atomicBatchNo.set(0L);
            }
        }
    }

    private static class CreateBillId {
        private static String billNoIdPrex = null;
        private static AtomicInteger atomicBillNoId = new AtomicInteger();
        private static long nextDateTimeMillis = 0L;
        private static int BillNoMaxSeqIndex = 9999;

        private CreateBillId() {
        }

        public static String createBillNoId() {
            int seq = atomicBillNoId.getAndIncrement();
            if (billNoIdPrex == null || System.currentTimeMillis() > nextDateTimeMillis || seq > BillNoMaxSeqIndex) {
                CreateBillId.refresh();
                seq = atomicBillNoId.getAndIncrement();
            }
            return String.valueOf(billNoIdPrex) + seq;
        }

        private static synchronized void refresh() {
            if (System.currentTimeMillis() > nextDateTimeMillis) {
                Calendar c = Calendar.getInstance();
                if (nextDateTimeMillis == 0L) {
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                } else {
                    c.setTimeInMillis(nextDateTimeMillis);
                }
                c.add(5, 1);
                nextDateTimeMillis = c.getTimeInMillis();
                SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
                billNoIdPrex = format.format(new Date());
            }
            if (atomicBillNoId.get() > BillNoMaxSeqIndex) {
                atomicBillNoId.set(0);
            }
        }
    }
}

