/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.util;

import com.xunlei.card.util.Arith;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.util.ApplicationConfigUtil;
import com.xunlei.payproxy.util.ProxyHelper;
import com.xunlei.payproxy.vo.Areaidinfo;
import com.xunlei.payproxy.vo.Copartners;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.vo.Libclassm;
import com.xunlei.payproxy.vo.Libconfig;
import com.xunlei.thundercore.client.proxy.ClientProxy;
import com.xunlei.thundercore.client.request.AbstractRequest;
import com.xunlei.thundercore.client.request.ConsumeRequest;
import com.xunlei.thundercore.client.request.ConsumeWithIpRequest;
import com.xunlei.thundercore.client.request.QryrechargeRequest;
import com.xunlei.thundercore.client.request.QryuserinfRequest;
import com.xunlei.thundercore.client.request.RechargeRequest;
import com.xunlei.thundercore.client.response.ConsumeResponse;
import com.xunlei.thundercore.client.response.QryrechargeResponse;
import com.xunlei.thundercore.client.response.QryuserinfResponse;
import com.xunlei.thundercore.client.response.RechargeResponse;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utility {
    private static final Log log = LogFactory.getLog(Utility.class);
    private static final String thundercoreBizNoLM;
    private static final String thundercoreBizKeyLM;
    private static final DecimalFormat amtFormat;
    private static ClientProxy client;
    private static final Pattern digiRegx;
    private static int se;
    private static AtomicInteger atomicOrderIdx;
    private static int maxIdx;
    private static Object orderIdxLock;

    public static String FomatDate(String src) {
        String[] temp = src.split("-");
        if (temp[1].length() == 1) {
            temp[1] = "0" + temp[1];
        }
        if (temp[2].length() == 1) {
            temp[2] = "0" + temp[2];
        }
        return temp[0] + "-" + temp[1] + "-" + temp[2];
    }

    public static String FomatTime(String src) {
        String[] temp = src.split(":");
        if (temp[0].length() == 1) {
            temp[0] = "0" + temp[0];
        }
        if (temp[1].length() == 1) {
            temp[1] = "0" + temp[1];
        }
        if (temp[2].length() == 1) {
            temp[2] = "0" + temp[2];
        }
        return temp[0] + ":" + temp[1] + ":" + temp[2];
    }

    public static String createSerial(String src, int len) {
        String dest = "";
        dest = src.length() >= len ? src.substring(0, len) : Utility.createSameChar("0", len - src.length()) + src;
        return dest;
    }

    public static String createSameChar(String src, int len) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append(src);
        }
        return sb.toString();
    }

    public static String getLeftFixedLengthString(String src, String c, int len) {
        if (src.length() >= len) {
            return src.substring(0, len);
        }
        StringBuffer ext = new StringBuffer();
        for (int i = src.length(); i < len; ++i) {
            ext.append(c);
        }
        return ext.toString() + src;
    }

    public static void copyProperties(Object dest, Object src) {
        try {
            BeanUtils.copyProperties((Object)dest, (Object)src);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int createRandomNum(int max) {
        Random random = new Random();
        return Math.abs(random.nextInt()) % max;
    }

    public static String moveChar(String pwd, int s, int e) {
        if (s > e) {
            int p = e;
            e = s;
            s = p;
        }
        if (s == e || s > 19) {
            return pwd;
        }
        String befor = pwd.substring(0, s);
        String s1 = pwd.substring(s, s + 1);
        String middle = pwd.substring(s + 1, e);
        String s2 = pwd.substring(e, e + 1);
        String after = pwd.substring(e + 1);
        return befor + s2 + middle + s1 + after;
    }

    public static String otherdateofnow() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(new Date());
    }

    public static String timeofnow() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar curcal = Calendar.getInstance();
        return sdf.format(curcal.getTime());
    }

    public static String addTime(String time1, String addpart, int num) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String now = sdf.format(new Date());
            String string = time1 = time1 == null ? now : time1;
            if (time1.length() < 19) {
                time1 = time1 + " 00:00:00";
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(sdf.parse(time1));
            if (addpart.equalsIgnoreCase("Y")) {
                cal.add(1, num);
            } else if (addpart.equalsIgnoreCase("M")) {
                cal.add(2, num);
            } else if (addpart.equalsIgnoreCase("D")) {
                cal.add(5, num);
            } else if (addpart.equalsIgnoreCase("H")) {
                cal.add(10, num);
            } else if (addpart.equalsIgnoreCase("F")) {
                cal.add(12, num);
            } else if (addpart.equalsIgnoreCase("S")) {
                cal.add(13, num);
            }
            return sdf.format(cal.getTime());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String addDate(String date1, String addpart, int num) {
        return Utility.addTime(date1, addpart, num).substring(0, 10);
    }

    public static String ConvertCN2(String is) {
        if (is == null || is.compareTo("") == 0) {
            return "";
        }
        int l = is.length();
        for (int q = 0; q < l; ++q) {
            char t = is.charAt(q);
            if (t <= '\u00ff') continue;
            return is;
        }
        try {
            String os = new String(is.getBytes("ISO-8859-1"), "GBK");
            return os;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getTradeSn() {
        return "" + new Date().getTime();
    }

    public static String getTimeByTradeSn(long sn) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(sn));
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getFixedLengthString(String src, String c, int len) {
        if (src.length() >= len) {
            return src.substring(0, len);
        }
        StringBuffer ext = new StringBuffer();
        for (int i = src.length(); i < len; ++i) {
            ext.append(c);
        }
        return src + ext.toString();
    }

    public static String getXunleiIdHash(String xunleiid, int flag) throws Exception {
        String src = null;
        String rtn = null;
        String xunleiid2 = xunleiid.toLowerCase();
        int sum = 0;
        int mod = 0;
        if (flag == 0) {
            src = xunleiid2.substring(0, 2);
        } else if (flag == 1) {
            src = xunleiid2.substring(2, 4);
        } else {
            throw new Exception("getXunleiIdHash error");
        }
        byte[] bytesrc = src.getBytes();
        for (int i = 0; i < bytesrc.length; ++i) {
            sum += bytesrc[i];
        }
        mod = sum % 100;
        rtn = mod < 10 ? "0" + mod : "" + mod;
        return rtn;
    }

    public static boolean sendHtmlMail(Map<String, String> params) {
        String host = "mail.xunlei.com";
        String username = "xlpay";
        String password = "xlpayabc";
        if (params.get("ccaddress") == null) {
            params.put("ccaddress", "");
        }
        if (params.get("bccaddress") == null) {
            params.put("bccaddress", "");
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.auth", "true");
        Session session = Session.getDefaultInstance((Properties)props);
        session.setDebug(true);
        try {
            String[] bccAddresses;
            String[] ccAddresses;
            String[] toAddresses;
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(params.get("fromaddress")));
            for (String address : toAddresses = params.get("toaddress").split(";")) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(address));
            }
            for (String address : ccAddresses = params.get("ccaddress").split(";")) {
                if (address.trim().length() <= 0) continue;
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(address));
            }
            for (String address : bccAddresses = params.get("bccaddress").split(";")) {
                if (address.trim().length() <= 0) continue;
                message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(address));
            }
            MimeMultipart content = new MimeMultipart();
            if (content == null) {
                return false;
            }
            MimeBodyPart part = new MimeBodyPart();
            part.setText(params.get("body"));
            part.setHeader("Content-Type", "text/html;charset=GBK");
            content.addBodyPart((BodyPart)part);
            message.setSubject(params.get("subject"));
            message.setContent((Multipart)content);
            message.saveChanges();
            Transport transport = session.getTransport("smtp");
            transport.connect(host, username, password);
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static DecimalFormat getNumberFormat() {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance();
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        String s = "###,##0.00";
        df.applyPattern(s);
        return df;
    }

    public static String getFormatedOrderTime(String slimtime) {
        try {
            Matcher m = digiRegx.matcher(slimtime);
            if (!m.matches()) {
                return null;
            }
            Date d = new SimpleDateFormat("yyyyMMddHHmmss").parse(slimtime);
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(d);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String generateApplyId() {
        String applyId = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String nextOrderId = "";
        Random r = new Random();
        int se = r.nextInt(100);
        nextOrderId = applyId.substring(2, 8) + Utility.getTradeSn().substring(3, 13) + Utility.createSerial("" + se, 2);
        if (nextOrderId.length() != 18) {
            throw new XLRuntimeException("\u8ba2\u5355\u53f7\u957f\u5ea6\u9519\u8bef[" + nextOrderId + "]");
        }
        return nextOrderId;
    }

    public static QryuserinfResponse qryuserinf(String userShow) {
        QryuserinfResponse qr = new QryuserinfResponse();
        try {
            String userId = UserUtility.getUserIdByUserName((String)userShow);
            QryuserinfRequest req = new QryuserinfRequest(thundercoreBizNoLM, thundercoreBizKeyLM, Utility.generateApplyId(), userShow, userId);
            qr = (QryuserinfResponse)client.request((AbstractRequest)req);
            log.info((Object)("code=" + qr.getRtnCode()));
            log.info((Object)("userStatus=" + qr.getUserStatus() + ",balance=" + qr.getBalance() + ",froze=" + qr.getFroze() + ",RechargeSum=" + qr.getRechargeSum() + ",ConsumeSum=" + qr.getConsumeSum() + ",lastRechargeTime=" + qr.getLastRechargeTime() + ",lastConsumeTime=" + qr.getLastConsumeTime()));
        }
        catch (Exception e) {
            log.error((Object)e);
            qr.setRtnCode("99");
        }
        return qr;
    }

    public static boolean consume(String userId, double point, String remark) {
        String applyId = Utility.generateApplyId();
        return Utility.consume(applyId, userId, point, remark);
    }

    public static boolean consume(String applyId, String userShow, double point, String remark) {
        boolean rst = false;
        try {
            log.info((Object)("\u7528\u6237\u540d\uff1a" + userShow + ",\u7528\u4e8e\u652f\u4ed8\u7684\u96f7\u70b9\u6570\uff1a" + point + "\uff0c\u5907\u6ce8\uff1a" + remark));
            String userId = UserUtility.getUserIdByUserName((String)userShow);
            ConsumeRequest req = new ConsumeRequest(thundercoreBizNoLM, thundercoreBizKeyLM, applyId, userShow, userId, String.valueOf(point), remark);
            ConsumeResponse resp = (ConsumeResponse)client.request((AbstractRequest)req);
            String rsStr = resp.getRtnCode();
            log.info((Object)("\u96f7\u70b9\u6838\u5fc3\u6d88\u8d39\u8fd4\u56de\u503c:" + rsStr));
            rst = "00".equals(rsStr);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return rst;
    }

    public static ConsumeResponse insureconsume(String orderid, String userShow, String remark, double point) {
        try {
            String userId = UserUtility.getUserIdByUserName((String)userShow);
            QryrechargeRequest qryRechageReq = new QryrechargeRequest(thundercoreBizNoLM, thundercoreBizKeyLM, Utility.generateApplyId(), userShow, userId, orderid, thundercoreBizNoLM);
            QryrechargeResponse qryRes = (QryrechargeResponse)client.request((AbstractRequest)qryRechageReq);
            log.info((Object)("qryrecharge proxy return code=" + qryRes.getRtnCode()));
            if (qryRes.getRtnCode().equals("00") && qryRes.getQueryResult().equals("Y")) {
                log.info((Object)("\u8ba2\u5355" + orderid + "\u5df2\u7ecf\u6d88\u8d39\u6210\u529f\uff0c\u4e0d\u518d\u6d88\u8d39"));
                ConsumeResponse cRes = new ConsumeResponse();
                cRes.setRtnCode(qryRes.getRtnCode());
                cRes.setBalanceDate(qryRes.getBalanceDate());
                cRes.setMac(qryRes.getMac());
                cRes.setApplyId(qryRes.getApplyId());
                cRes.setCharset(qryRes.getCharset());
                return cRes;
            }
            log.info((Object)("\u7528\u6237\u540d\uff1a" + userShow + ",\u7528\u4e8e\u652f\u4ed8\u7684\u96f7\u70b9\u6570\uff1a" + point + "\uff0c\u5907\u6ce8\uff1a" + remark));
            ConsumeRequest consumReq = new ConsumeRequest(thundercoreBizNoLM, thundercoreBizKeyLM, Utility.generateApplyId(), userShow, userId, String.valueOf(point), remark);
            ConsumeResponse consumeRes = (ConsumeResponse)client.request((AbstractRequest)consumReq);
            log.info((Object)("\u96f7\u70b9\u6838\u5fc3\u6d88\u8d39\u8fd4\u56de\u503c:" + consumeRes.getRtnCode()));
            return consumeRes;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public static ConsumeResponse insureconsume(String orderid, String userShow, String remark, double point, String host, int port, String bizNo, String key) {
        try {
            log.info((Object)("host:" + host + ",port:" + port + ",bizNo:" + bizNo));
            ClientProxy client = ClientProxy.create();
            String userId = UserUtility.getUserIdByUserName((String)userShow);
            QryrechargeRequest req = new QryrechargeRequest(thundercoreBizNoLM, thundercoreBizKeyLM, Utility.generateApplyId(), userShow, userId, orderid, thundercoreBizNoLM);
            QryrechargeResponse qryRes = (QryrechargeResponse)client.request((AbstractRequest)req);
            log.info((Object)("qryrecharge proxy return code=" + qryRes.getRtnCode()));
            if (qryRes.getRtnCode().equals("00") && qryRes.getQueryResult().equals("Y")) {
                log.info((Object)("\u8ba2\u5355" + orderid + "\u5df2\u7ecf\u6d88\u8d39\u6210\u529f\uff0c\u4e0d\u518d\u6d88\u8d39"));
                ConsumeResponse cRes = new ConsumeResponse();
                cRes.setRtnCode(qryRes.getRtnCode());
                cRes.setBalanceDate(qryRes.getBalanceDate());
                cRes.setMac(qryRes.getMac());
                cRes.setApplyId(qryRes.getApplyId());
                cRes.setCharset(qryRes.getCharset());
                return cRes;
            }
            log.info((Object)("\u7528\u6237\u540d\uff1a" + userShow + ",\u7528\u4e8e\u652f\u4ed8\u7684\u96f7\u70b9\u6570\uff1a" + point + "\uff0c\u5907\u6ce8\uff1a" + remark));
            ConsumeRequest consumReq = new ConsumeRequest(thundercoreBizNoLM, thundercoreBizKeyLM, orderid, userShow, userId, String.valueOf(point), remark);
            ConsumeResponse consumeRes = (ConsumeResponse)client.request((AbstractRequest)consumReq);
            log.info((Object)("\u96f7\u70b9\u6838\u5fc3\u6d88\u8d39\u8fd4\u56de\u503c:" + consumeRes.getRtnCode()));
            return consumeRes;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public static ConsumeResponse consume(String userId, String remark, double point) {
        String applyId = Utility.generateApplyId();
        return Utility.consume(applyId, userId, remark, point);
    }

    public static ConsumeResponse consume(String applyId, String userShow, String remark, double point) {
        ConsumeResponse consumeRes = new ConsumeResponse();
        try {
            log.info((Object)("\u7528\u6237\u540d\uff1a" + userShow + ",\u7528\u4e8e\u652f\u4ed8\u7684\u96f7\u70b9\u6570\uff1a" + point + "\uff0c\u5907\u6ce8\uff1a" + remark));
            String userId = UserUtility.getUserIdByUserName((String)userShow);
            ConsumeRequest req = new ConsumeRequest(thundercoreBizNoLM, thundercoreBizKeyLM, applyId, userShow, userId, String.valueOf(point), remark);
            consumeRes = (ConsumeResponse)client.request((AbstractRequest)req);
            log.info((Object)("\u96f7\u70b9\u6838\u5fc3\u6d88\u8d39\u8fd4\u56de\u503c:" + consumeRes.getRtnCode()));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return consumeRes;
    }

    public static ConsumeResponse consumeWithIp(String applyId, String userShow, String remark, double point, String realClientIp, String isAutoPay) {
        ConsumeResponse consumeRes = new ConsumeResponse();
        try {
            log.info((Object)("\u7528\u6237\u540d\uff1a" + userShow + ",\u7528\u4e8e\u652f\u4ed8\u7684\u96f7\u70b9\u6570\uff1a" + point + "\uff0c\u5907\u6ce8\uff1a" + remark));
            String userId = UserUtility.getUserIdByUserName((String)userShow);
            ConsumeWithIpRequest req = new ConsumeWithIpRequest(thundercoreBizNoLM, thundercoreBizKeyLM, applyId, userShow, userId, String.valueOf(point), remark, realClientIp, isAutoPay);
            consumeRes = (ConsumeResponse)client.request((AbstractRequest)req);
            log.info((Object)("\u96f7\u70b9\u6838\u5fc3\u6d88\u8d39\u8fd4\u56de\u503c:" + consumeRes.getRtnCode()));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return consumeRes;
    }

    public static boolean recharge(String applyId, String userShow, double point, String remark) {
        boolean rst = false;
        try {
            log.info((Object)("\u7528\u6237\u540d\uff1a" + userShow + ",\u7528\u4e8e\u652f\u4ed8\u7684\u96f7\u70b9\u6570\uff1a" + point + "\uff0c\u5907\u6ce8\uff1a" + remark));
            String userId = UserUtility.getUserIdByUserName((String)userShow);
            RechargeRequest req = new RechargeRequest(thundercoreBizNoLM, thundercoreBizKeyLM, applyId, userShow, userId, String.valueOf(point), remark);
            RechargeResponse resp = (RechargeResponse)client.request((AbstractRequest)req);
            String rsStr = resp.getRtnCode();
            log.info((Object)("\u96f7\u70b9\u6838\u5fc3\u5145\u503c\u8fd4\u56de\u503c:" + rsStr));
            rst = "00".equals(rsStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
        }
        return rst;
    }

    public static ClientProxy getClientProxy() {
        return client;
    }

    public static String formatAmt(double amt) {
        return amtFormat.format(amt);
    }

    public static boolean isContainsString(String str, String[] array) {
        if (array == null) {
            return false;
        }
        for (String s : array) {
            if (!s.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumberVerify(String libconfig, String premobile) {
        String allownums = Libconfig.getValue(libconfig);
        log.info((Object)("allownums=" + allownums));
        String[] allownumsArray = allownums.toLowerCase().split("\\|");
        return Utility.isContainsString(premobile, allownumsArray);
    }

    public static Areaidinfo isAreaidVerify(String libclassm, String areaid) {
        Areaidinfo info = new Areaidinfo();
        boolean flag = false;
        String key = "";
        String url = "";
        List<Object> areaides = new ArrayList();
        areaides = Libclassm.getLibclassdValues(libclassm);
        for (Libclassd libclassd : areaides) {
            if (libclassd == null || !areaid.equals(libclassd.getItemno().trim())) continue;
            flag = true;
            url = libclassd.getRemark().trim();
            key = libclassd.getItemvalue().trim();
        }
        info.setFlag(flag);
        info.setKey(key);
        info.setUrl(url);
        return info;
    }

    public static boolean isTestUsername(String libconfig, String username) {
        String allowUsernames = Libconfig.getValue(libconfig);
        log.info((Object)("allowUsernames=" + allowUsernames));
        String[] allownumsArray = allowUsernames.toLowerCase().split("\\|");
        return Utility.isContainsString(username, allownumsArray);
    }

    public static String getFilterSrc(String str) {
        if (str == null) {
            return "";
        }
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(str);
        String after = m.replaceAll("");
        return after;
    }

    public static void writefilefromhttpreturn(String urlName, String filepath) {
        StringBuffer sb = new StringBuffer();
        try {
            URL U = new URL(urlName);
            URLConnection connection = U.openConnection();
            connection.connect();
            String str = null;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((str = in.readLine()) != null) {
                sb.append(str + "\n");
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filepath), "GBK"));
            bw.write(sb.toString());
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized String createExt99billOrderId() throws Exception {
        String nextOrderId = "";
        if (se > 99) {
            se = 0;
        }
        nextOrderId = Utility.otherdateofnow().substring(2, 8) + Utility.getTradeSn().substring(3, 13) + Utility.createSerial("" + se, 2);
        ++se;
        if (nextOrderId.length() != 18) {
            throw new Exception("\u8ba2\u5355\u53f7\u957f\u5ea6\u9519\u8bef[" + nextOrderId + "]");
        }
        return nextOrderId;
    }

    public static double getAlipayFareamt(double payedamt) {
        double i = Arith.mul((double)payedamt, (double)0.0045);
        double r = Arith.round((double)i, (int)2);
        return r;
    }

    public static double get99BillFareamt(double orderAmt) {
        int i = (int)Arith.mul((double)orderAmt, (double)0.6);
        if (Arith.mul((double)orderAmt, (double)0.6) > (double)i) {
            ++i;
        }
        double r = (double)i / 100.0;
        return r;
    }

    public static double getYeepayFareamt(double orderAmt) {
        double i = Arith.mul((double)orderAmt, (double)0.005);
        double r = 0.0;
        r = i < 0.01 ? 0.0 : (i > 0.0 ? Arith.round((double)i, (int)2) : 0.0);
        return r;
    }

    public static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createOrderId() throws Exception {
        int idx = atomicOrderIdx.getAndIncrement();
        if (idx > maxIdx) {
            Object object = orderIdxLock;
            synchronized (object) {
                if (atomicOrderIdx.get() > maxIdx) {
                    atomicOrderIdx.set(0);
                }
            }
        }
        if (idx > 99) {
            idx %= 100;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(Utility.otherdateofnow().substring(2, 8)).append(Utility.getTradeSn().substring(3, 13)).append(Utility.createSerial("" + idx, 2));
        String orderId = builder.toString();
        if (orderId.length() != 18) {
            throw new Exception("\u8ba2\u5355\u53f7\u957f\u5ea6\u9519\u8bef[" + orderId + "]");
        }
        return orderId;
    }

    public static String queryCopartnerBizKey(String bizNo) {
        IFacade payproxyfacade = IFacade.INSTANCE;
        String copartnerNo = ProxyHelper.getCopartnerNoFromBizNo(bizNo);
        Copartners copartnersForQuery = new Copartners();
        copartnersForQuery.setCopartnerno(copartnerNo);
        Copartners copartners = payproxyfacade.findCopartners(copartnersForQuery);
        if (copartners == null) {
            return null;
        }
        if (copartners.getInuse() == 0) {
            return null;
        }
        Copbizinfo copbizinfoForQuery = new Copbizinfo();
        copbizinfoForQuery.setBizno(bizNo);
        Copbizinfo copbizinfo = payproxyfacade.findCopbizinfo(copbizinfoForQuery);
        if (copbizinfo == null) {
            return null;
        }
        if (copbizinfo.getBizstatus().equals("C")) {
            return null;
        }
        return copbizinfo.getBizkey();
    }

    public static String toStringCommon(Object obj) {
        if (obj == null) {
            return "";
        }
        Class<?> clazz = obj.getClass();
        String clazz_fullname = clazz.getName();
        String clazz_name = clazz_fullname.substring(clazz_fullname.lastIndexOf(".") + 1);
        StringBuffer buffer = new StringBuffer();
        buffer.append(clazz_name);
        buffer.append(":[");
        AccessibleObject[] fields = clazz.getDeclaredFields();
        Field.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            try {
                buffer.append(((Field)field).getName());
                buffer.append("=");
                buffer.append(((Field)field).get(obj));
                buffer.append(", ");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        buffer.setLength(buffer.length() - 2);
        buffer.append("]");
        return buffer.toString();
    }

    public static void main(String[] args) {
        System.out.println(Utility.addDate("2012-10-11", "D", -7));
    }

    static {
        amtFormat = new DecimalFormat(",##0.00");
        thundercoreBizNoLM = ApplicationConfigUtil.getThundercoreBizNoLM();
        thundercoreBizKeyLM = ApplicationConfigUtil.getThundercoreBizKeyLM();
        log.debug((Object)"\u8fc5\u96f7\u652f\u4ed8\u4e0b\u96f7\u70b9\u6838\u5fc3\u5145\u503c\u670d\u52a1\u5668\u76f8\u5173\u53c2\u6570\uff1a");
        log.debug((Object)("thundercoreBizNoLM:" + thundercoreBizNoLM));
        log.debug((Object)("thundercoreBizKeyLM:" + thundercoreBizKeyLM));
        client = ClientProxy.create();
        digiRegx = Pattern.compile("^[\\d]{14}$");
        se = 0;
        atomicOrderIdx = new AtomicInteger(0);
        maxIdx = 0x3FFFFFFF;
        orderIdxLock = new Object();
    }
}

