/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.util;

import com.xunlei.common.util.base64.BASE64Decoder;
import com.xunlei.common.util.base64.BASE64Encoder;
import com.xunlei.payproxy.util.UmpaySignEncException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;

public class UmpaySignEnc {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sign(String resourcePath, String dataString) throws UmpaySignEncException {
        InputStream fis = null;
        if (dataString == null) {
            throw new UmpaySignEncException("the data string to be signed cannot be null");
        }
        byte[] kb = null;
        try {
            File file = new File(UmpaySignEnc.class.getResource(resourcePath).toURI());
            kb = new byte[(int)file.length()];
            fis = new FileInputStream(file);
            fis.read(kb);
        }
        catch (Exception e) {
            throw new UmpaySignEncException("load the primary key failed");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception localException1) {
                }
                finally {
                    fis = null;
                }
            }
        }
        PKCS8EncodedKeySpec peks = null;
        KeyFactory kf = null;
        PrivateKey pk = null;
        try {
            peks = new PKCS8EncodedKeySpec(kb);
            kf = KeyFactory.getInstance("RSA");
            pk = kf.generatePrivate(peks);
        }
        catch (Exception e) {
            throw new UmpaySignEncException("invalid primary key format");
        }
        Signature sig = null;
        byte[] sb = null;
        try {
            sig = Signature.getInstance("SHA1withRSA");
            sig.initSign(pk);
            sig.update(dataString.getBytes("gb2312"));
            sb = sig.sign();
        }
        catch (Exception e) {
            throw new UmpaySignEncException("sign procedure failed");
        }
        String b64Str = null;
        try {
            BASE64Encoder base64 = new BASE64Encoder();
            b64Str = base64.encode(sb);
        }
        catch (Exception e) {
            throw new UmpaySignEncException("base64 generation failed");
        }
        try {
            BufferedReader br = new BufferedReader(new StringReader(b64Str));
            String tmpStr = "";
            String tmpStr1 = "";
            while ((tmpStr = br.readLine()) != null) {
                tmpStr1 = tmpStr1 + tmpStr;
            }
            b64Str = tmpStr1;
            return b64Str;
        }
        catch (Exception br) {
            throw new UmpaySignEncException("base64 generation failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verify(String resourcePath, String dataString, String signString) throws UmpaySignEncException {
        if (dataString == null) {
            throw new UmpaySignEncException("the data string to be signed cannot be null");
        }
        FileInputStream fis = null;
        byte[] cb = null;
        try {
            File f = new File(UmpaySignEnc.class.getResource(resourcePath).toURI());
            cb = new byte[(int)f.length()];
            fis = new FileInputStream(f);
            fis.read(cb);
        }
        catch (Exception e) {
            throw new UmpaySignEncException("load the cert failed");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception localException1) {
                }
                finally {
                    fis = null;
                }
            }
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(cb);
        CertificateFactory cf = null;
        X509Certificate cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(bais);
        }
        catch (Exception e) {
            throw new UmpaySignEncException("load the cert failed");
        }
        try {
            BASE64Decoder base64 = new BASE64Decoder();
            byte[] signed = base64.decodeBuffer(signString);
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initVerify(cert);
            sig.update(dataString.getBytes());
            return sig.verify(signed);
        }
        catch (Exception base64) {
            throw new UmpaySignEncException("verify procedure failed");
        }
    }

    public static void main(String[] args) throws UmpaySignEncException {
        System.out.println(UmpaySignEnc.sign("/META-INF/3060_XunLei.key.p8", "merId=7740&goodsId=&orderId=090827135973392001&merDate=20090827&payDate=20090827&amount=200&amtType=01&bankType=5&mobileId=13424040903&transType=0&settleDate=20090827&merPriv=&retCode=0000&version=3.0"));
        System.out.println(UmpaySignEnc.verify("/META-INF/cert_2d59.crt", "merId=7740&goodsId=&orderId=090827135510963600&merDate=20090827&payDate=&amount=200&amtType=01&bankType=5&mobileId=13424040903&transType=0&settleDate=&merPriv=&retCode=0000&version=3.0", "oRs5JQpAwHYDACoT78MzzlbBUcVIUlao6SXXbB1MlrYsDd9+6tOkP+69ocD+/mI084df6itmU+WWEIBMo/cO/hH97hyIhO5OfYk/TdsZNTGiv8gAOG9mRgFTrZB8hdxBsIH0JcOR55ANzNkzuk3ijc/U5E5dFYIox9gajFq43Cg="));
    }
}

