/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.util;

import com.xunlei.payproxy.util.Utility;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeUtil {
    private static final Logger logger = Logger.getLogger(TimeUtil.class);

    public static int befSixMonth(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar sixMonth = Calendar.getInstance();
        sixMonth.add(5, -180);
        Calendar dateCal = Calendar.getInstance();
        try {
            dateCal.setTime(format.parse(date));
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage());
        }
        int ret = dateCal.compareTo(sixMonth);
        return ret;
    }

    public static int befTwoMonth(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar sixMonth = Calendar.getInstance();
        sixMonth.add(5, -60);
        Calendar dateCal = Calendar.getInstance();
        try {
            dateCal.setTime(format.parse(date));
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage());
        }
        int ret = dateCal.compareTo(sixMonth);
        return ret;
    }

    public static String balancedate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String balance = simpleDateFormat.format(new Date());
        logger.info((Object)("balancedate=" + balance));
        return balance;
    }

    public static String now() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Calendar calendar = Calendar.getInstance();
        String nowString = simpleDateFormat.format(calendar.getTime());
        logger.info((Object)("now=" + nowString));
        return nowString;
    }

    public static String getQuarterTable(String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(format.parse(date));
        int year = calendar.get(1);
        int month = calendar.get(2);
        if (month >= 0 && month <= 2) {
            return year + "Q1";
        }
        if (month >= 3 && month <= 5) {
            return year + "Q2";
        }
        if (month >= 6 && month <= 8) {
            return year + "Q3";
        }
        if (month >= 9 && month <= 11) {
            return year + "Q4";
        }
        return "";
    }

    public static String getTable(String date) {
        if (null == date || "".equals(date)) {
            return null;
        }
        String before7Date = Utility.addDate(null, "D", -7);
        if (date.compareTo(before7Date) >= 0) {
            return "bizorderok";
        }
        try {
            return "bizorderok_" + TimeUtil.getQuarterTable(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> getTables4Bizorder(String fromDate, String toDate) throws ParseException {
        String[] table = new String[]{"bizorder_2012Q3", "bizorder_2012Q4", "bizorder_2013Q1", "bizorder_2013Q2", "bizorder_2013Q3", "bizorder_2013Q4", "bizorder_2014Q1", "bizorder_2014Q2", "bizorder_2014Q3", "bizorder_2014Q4"};
        table = TimeUtil.getTable(table, toDate, "bizorder");
        String before7Date = Utility.addDate(null, "D", -30);
        ArrayList<String> tables = new ArrayList<String>();
        if (fromDate.compareTo(before7Date) >= 0) {
            tables.add("bizorder");
            return tables;
        }
        if (toDate.compareTo(before7Date) >= 0) {
            tables.add("bizorder");
        }
        int start = TimeUtil.indexOfTable(table, fromDate);
        int end = TimeUtil.indexOfTable(table, toDate);
        for (int index = start; index <= end; ++index) {
            tables.add(table[index]);
        }
        return tables;
    }

    public static List<String> getTables4BizorderOk(String fromDate, String toDate) throws ParseException {
        String[] table = new String[]{"bizorderokhis_2009", "bizorderokhis_2010", "bizorderokhis_2011", "bizorderok_2012Q1", "bizorderok_2012Q2", "bizorderok_2012Q3", "bizorderok_2012Q4", "bizorderok_2013Q1", "bizorderok_2013Q2", "bizorderok_2013Q3", "bizorderok_2013Q4", "bizorderok_2014Q1", "bizorderok_2014Q2", "bizorderok_2014Q3", "bizorderok_2014Q4"};
        table = TimeUtil.getTable(table, toDate, "bizorderok");
        System.out.println("fromdate-->" + fromDate);
        String before7Date = Utility.addDate(null, "D", -7);
        ArrayList<String> tables = new ArrayList<String>();
        if (fromDate.compareTo(before7Date) >= 0) {
            tables.add("bizorderok");
            return tables;
        }
        if (toDate.compareTo(before7Date) >= 0) {
            tables.add("bizorderok");
        }
        int start = TimeUtil.indexOfTable4bizorderok(table, fromDate);
        int end = TimeUtil.indexOfTable4bizorderok(table, toDate);
        for (int index = start; index <= end; ++index) {
            tables.add(table[index]);
        }
        return tables;
    }

    private static int indexOfTable(String[] table, String date) throws ParseException {
        String quarter = TimeUtil.getQuarterTable(date);
        if ("2012Q3".compareTo(quarter) > 0) {
            quarter = "2012Q3";
        }
        int index = 0;
        String tableName = "bizorder_" + quarter;
        for (String tb : table) {
            if (tableName.equals(tb)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static String[] getTable(String[] table, String date, String name) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        String[] newTable = null;
        try {
            calendar.setTime(format.parse(date));
            int year = calendar.get(1);
            int length = table.length;
            int i = year - 2014;
            newTable = new String[length + i * 4];
            for (int k = 0; k < length; ++k) {
                newTable[k] = table[k];
            }
            int index = length;
            String tableName = null;
            for (int z = 1; z <= i; ++z) {
                for (int j = 1; j <= 4; ++j) {
                    newTable[index] = tableName = name + "_" + (2014 + z) + "Q" + j;
                    ++index;
                }
            }
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage());
        }
        return newTable;
    }

    private static int indexOfTable4bizorderok(String[] table, String date) throws ParseException {
        String tableName = "";
        tableName = "2012-01-01".compareTo(date) > 0 ? "bizorderokhis_" + date.substring(0, 4) : "bizorderok_" + TimeUtil.getQuarterTable(date);
        int index = 0;
        for (String tb : table) {
            if (tableName.equals(tb)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static void main(String[] args) {
        String[] table = new String[]{"bizorder_2012Q3", "bizorder_2012Q4", "bizorder_2013Q1", "bizorder_2013Q2", "bizorder_2013Q3", "bizorder_2013Q4", "bizorder_2014Q1", "bizorder_2014Q2", "bizorder_2014Q3", "bizorder_2014Q4"};
        table = TimeUtil.getTable(table, "2019-01-05", "bizorder");
        for (int i = 0; i < table.length; ++i) {
            System.out.println(table[i]);
        }
    }
}

