/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.util;

import com.xunlei.payproxy.util.HttpConnectionUtil;
import com.xunlei.payproxy.util.Md5Encrypt;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmsSender {
    private static final String VERSION = "v1.0";
    private static final String PAGECHARSET = "GBK";
    private static final String SEND_SMS_URL = "http://sms.pay.xunlei.com/sendsms";
    private static Logger logger = Logger.getLogger(SmsSender.class);

    public static boolean send(String mobile, String content, String bizNo, String key) {
        logger.info((Object)Arrays.toString(new Object[]{bizNo, key, mobile, content}));
        return SmsSender.send0(bizNo, key, mobile, content);
    }

    public static boolean send0(String bizNo, String bizKey, String mobile, String content) {
        String signMsg = SmsSender.sign(VERSION, PAGECHARSET, bizNo, mobile, content, bizKey);
        String resp = null;
        try {
            String data = new StringBuffer("version=").append(VERSION).append("&pageCharset=").append(PAGECHARSET).append("&bizNo=").append(bizNo).append("&mobile=").append(mobile).append("&content=").append(URLEncoder.encode(content, "UTF-8")).append("&signMsg=").append(signMsg).toString();
            logger.info((Object)("===========request: http://sms.pay.xunlei.com/sendsms?" + data));
            resp = HttpConnectionUtil.doGet2("http://sms.pay.xunlei.com/sendsms?" + data, 6000, 6000);
            logger.info((Object)("===========resp: " + resp));
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
        if (resp == null) {
            return false;
        }
        return resp.contains("<sendresult>00</sendresult>");
    }

    private static String sign(String version, String pageCharset, String bizno, String mobile, String content, String bizKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", version);
        params.put("pageCharset", pageCharset);
        params.put("bizNo", bizno);
        params.put("mobile", mobile);
        params.put("content", content);
        String sign = SmsSender.sign(params, bizKey);
        return sign;
    }

    public static String sign(Map<String, String> param, String privateKey) {
        String content = SmsSender.getSignatureContent(param);
        return SmsSender.sign(content, privateKey);
    }

    public static String getSignatureContent(Map<String, String> param) {
        return SmsSender.getSignatureContent(param, null);
    }

    public static String getSignatureContent(Map<String, String> param, String encodeCharset) {
        Properties prop = new Properties();
        for (String key : param.keySet()) {
            String value;
            if (key.equals("signMsg") || SmsSender.isEmpty(value = param.get(key))) continue;
            prop.setProperty(key, value);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> keys = new ArrayList<Object>(prop.keySet());
        Collections.sort((List)keys);
        for (int i = 0; i < ((List)keys).size(); ++i) {
            String key = (String)((List)keys).get(i);
            String value = prop.getProperty(key);
            if (!SmsSender.isEmpty(encodeCharset)) {
                try {
                    value = URLEncoder.encode(prop.getProperty(key), encodeCharset);
                }
                catch (Exception localException) {
                    // empty catch block
                }
            }
            sb.append(i == 0 ? "" : "&");
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String value) {
        return value == null || "".equals(value.trim());
    }

    public static String sign(String content, String privateKey) {
        if (content == null) {
            return null;
        }
        return Md5Encrypt.md5(content + privateKey);
    }

    public static void main(String[] args) {
        String mobile = "#######";
        String content = "\u6d4b\u8bd5\u63a5\u53e3" + System.currentTimeMillis();
        boolean sendResult = false;
        System.out.println("sendResult: " + sendResult);
    }
}

