/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.util;

import com.xunlei.payproxy.util.Md5Encrypt;
import com.xunlei.payproxy.util.Utility;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureHelper2 {
    private static final Logger log = LoggerFactory.getLogger(SignatureHelper2.class);

    public static boolean checkSign(Map param, String privateKey) {
        if (Utility.isEmpty(privateKey) || param == null) {
            return false;
        }
        String signMsg = (String)param.get("signMsg");
        if (Utility.isEmpty(signMsg)) {
            return false;
        }
        String signed = SignatureHelper2.sign(param, privateKey);
        boolean result = signMsg.equals(signed);
        log.info("\u4f20\u8fc7\u6765\u7684\u7b7e\u540d:{},\u62ff\u53c2\u6570\u52a0\u5bc6\u540e\u7684\u7b7e\u540d:{}[\u7ed3\u679c\uff1a{}]", new Object[]{signMsg, signed, result});
        return result;
    }

    public static String sign(Map param, String privateKey) {
        String content = SignatureHelper2.getSignatureContent(param);
        log.info("\u9700\u8981\u52a0\u5bc6\u7684url:{}", (Object)content);
        return SignatureHelper2.sign(content, privateKey);
    }

    private static String sign(String content, String privateKey) {
        if (content == null) {
            return null;
        }
        return Md5Encrypt.md5(content + privateKey);
    }

    private static String getSignatureContent(Map param) {
        return SignatureHelper2.getSignatureContent(param, null);
    }

    private static String getSignatureContent(Map param, String encodeCharset) {
        Properties prop = new Properties();
        for (String key : param.keySet()) {
            String value;
            if (key.equals("signMsg") || Utility.isEmpty(value = (String)param.get(key))) continue;
            prop.setProperty(key, value);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> keys = new ArrayList<Object>(prop.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = prop.getProperty(key);
            if (!Utility.isEmpty(encodeCharset)) {
                try {
                    value = URLEncoder.encode(prop.getProperty(key), encodeCharset);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sb.append(i != 0 ? "&" : "");
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }
}

