/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.util;

import com.xunlei.payproxy.util.Md5Encrypt;
import com.xunlei.payproxy.util.Utility;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureHelper {
    private static final Log log = LogFactory.getLog(SignatureHelper.class);

    public static boolean checkSign(Map param, String privateKey) {
        if (Utility.isEmpty(privateKey) || param == null) {
            return false;
        }
        String signMsg = (String)param.get("signMsg");
        if (Utility.isEmpty(signMsg)) {
            return false;
        }
        String signed = SignatureHelper.sign(param, privateKey);
        log.debug((Object)("signMsg = " + signMsg + ",signed = " + signed));
        return signMsg.equals(signed);
    }

    public static String sign(Map<String, String> param, String privateKey) {
        String content = SignatureHelper.getSignatureContent(param);
        log.debug((Object)("\u9700\u8981\u7b7e\u540d\u5904\u7406\u7684URL\uff1a" + content));
        return SignatureHelper.sign(content, privateKey);
    }

    public static String sign(String content, String privateKey) {
        if (content == null) {
            return null;
        }
        System.out.println("content final:" + content + privateKey);
        return Md5Encrypt.md5(content + privateKey);
    }

    public static String getSignatureContent(Map<String, String> param) {
        return SignatureHelper.getSignatureContent(param, null);
    }

    public static String getSignatureContent(Map<String, String> param, String encodeCharset) {
        Properties prop = new Properties();
        for (String key : param.keySet()) {
            String value;
            if (key.equals("signMsg") || Utility.isEmpty(value = param.get(key))) continue;
            prop.setProperty(key, value);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> keys = new ArrayList<Object>(prop.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = prop.getProperty(key);
            if (!Utility.isEmpty(encodeCharset)) {
                try {
                    value = URLEncoder.encode(prop.getProperty(key), encodeCharset);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            sb.append(i == 0 ? "" : "&");
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        HashMap<String, String> signMap = new HashMap<String, String>();
        signMap.put("bindId", "13123084099440220846");
        signMap.put("xunleiId", "69551120");
        signMap.put("signMsg", "111");
        signMap.put("bizNo", "000001001");
        System.out.println(SignatureHelper.sign(signMap, "dic73dlv0o3jv0k3"));
        System.out.println(Md5Encrypt.md5("bgUrl=http://proxy.pay.xunlei.com/jmsresult.html&bizNo=000001001&orderAmt=1&orderDetail=0^18688701869^\u5c39\u4f26\u7434^69551120^1^try&orderId=20140403dingdan_005&orderNum=1&orderTime=20140403134720&pageCharset=1&type=0abcdabcdabcd0000"));
    }
}

