/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.util;

import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.util.ApplicationConfigUtil;
import com.xunlei.payproxy.util.Arith;
import com.xunlei.payproxy.util.Md5Encrypt;
import com.xunlei.payproxy.util.PayProxyFunctionConstant;
import com.xunlei.payproxy.util.SignatureHelper;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Bizorder;
import com.xunlei.payproxy.vo.Bizorderok;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.Extmycardok;
import com.xunlei.payproxy.vo.Mobilevipquit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProxyHelper {
    private static final SimpleDateFormat shortdf = new SimpleDateFormat("yyyyMMdd");
    private static final Logger logger = Logger.getLogger(ProxyHelper.class);
    private static String macid = "01";
    public static String cmbMacid = "1";
    private static final String vipQuitUrl = "http://dynamic.vip.xunlei.com/script/vip/tuiding.php?userid=$userid&phone=$phone&xlpayid=$xlpayid&isnow=$isnow";
    private static final String bluegemQuitUrl = "http://dynamic.vip.xunlei.com/script/vip/tuiding.php?userid=$userid&phone=$phone&xlpayid=$xlpayid&isnow=$isnow";
    private static final String kankanQuitUrl = "http://busi.vip.kankan.com/pay/clearMobileVip?userid=$userid&phone=$phone&signMsg=$signMsg";
    private static final String berilQuitUrl = "http://svr.shop.xunlei.com/admin/clearMobileBeryl?userid=%1$s&mobile=%2$s&xlpayid=%3$s&isuser=0&sign=%4$s";
    private static final String batchBerilQuitUrl = "http://svr.shop.xunlei.com/admin/clearMobileBeryl?userid=%1$s&mobile=%2$s&xlpayid=%3$s&isuser=1&sign=%4$s";
    private static final String umpayVipUrl = "http://dypay.vip.xunlei.com/channel/cmccpre_deduct?orderid=$orignal_orderid&day=$days&new_orderid=$new_orderid";
    private static final SimpleDateFormat SimpleDF;
    private static int se;

    private static void init() {
        try {
            ResourceBundle resource = ResourceBundle.getBundle("macinfo");
            String fileName = resource.getString("fileName");
            if (null != fileName && !"".equals(fileName)) {
                File file = new File(fileName);
                Properties prop = new Properties();
                FileInputStream is = new FileInputStream(file);
                prop.load(is);
                if (null != is) {
                    ((InputStream)is).close();
                    file = null;
                }
                macid = prop.getProperty("macid");
            }
        }
        catch (Exception ex) {
            logger.info((Object)("parse macinfo with exception:" + ex.getMessage()));
        }
        cmbMacid = macid.substring(1, 2);
    }

    public static String buildRedirectUrl(String xunleipayid) {
        String code = "";
        String redirectUrl = "";
        String xunleiId = "";
        String orderId = "";
        String productName = "";
        String orderAmt = "";
        Bizorder bizorderQuery = new Bizorder();
        bizorderQuery.setXunleipayid(xunleipayid);
        IFacade payproxyfacade = IFacade.INSTANCE;
        Bizorder bizorder = payproxyfacade.findBizorder(bizorderQuery);
        if (bizorder != null) {
            code = "01";
        } else {
            Bizorderok bizorderokForQuery = new Bizorderok();
            bizorderokForQuery.setXunleipayid(xunleipayid);
            Bizorderok bizorderok = payproxyfacade.findBizorderok(bizorderokForQuery);
            if (bizorderok != null) {
                Copbizinfo copbizinfoForQuery = new Copbizinfo();
                copbizinfoForQuery.setBizno(bizorderok.getBizno());
                Copbizinfo copbizinfo = IFacade.INSTANCE.findCopbizinfo(copbizinfoForQuery);
                if (copbizinfo == null) {
                    code = "03";
                } else {
                    code = "00";
                    orderAmt = Utility.formatAmt(bizorderok.getOrderamt());
                    if (!Utility.isEmpty(bizorderok.getFgurl())) {
                        redirectUrl = ProxyHelper.buildNotifyUrl(bizorderok.getPagecharset(), bizorderok.getFgurl(), bizorderok.getVersion(), bizorderok.getBizorderid(), new Double(Arith.mul(bizorderok.getOrderamt(), 100.0)).intValue() + "", bizorderok.getOrdertime(), bizorderok.getXunleipayid(), bizorderok.getSuccesstime(), bizorderok.getExt1(), bizorderok.getExt2(), "00", "", copbizinfo.getBizkey(), bizorderok.getFareamt());
                    }
                    xunleiId = bizorderok.getUsershow();
                    orderId = bizorderok.getBizorderid();
                    productName = bizorderok.getProductname();
                }
            } else {
                code = "02";
            }
        }
        String rUrl = ApplicationConfigUtil.getRedirectUrl();
        String urlJoin = "?";
        if (rUrl.indexOf("?") >= 0) {
            urlJoin = "&";
        }
        return rUrl + urlJoin + "code=" + code + "&xunleiId=" + ProxyHelper.encodeUrl(xunleiId, "UTF-8") + "&orderId=" + ProxyHelper.encodeUrl(orderId, "UTF-8") + "&productName=" + ProxyHelper.encodeUrl(productName, "UTF-8") + "&orderAmt=" + ProxyHelper.encodeUrl(orderAmt, "UTF-8") + "&rUrl=" + ProxyHelper.encodeUrl(redirectUrl, "UTF-8");
    }

    public static String buildNotifyUrl(String xunleipayid, String payResult) {
        return ProxyHelper.buildNotifyUrl(xunleipayid, payResult, "");
    }

    public static String buildNotifyUrl(String pageCharset, String url, String version, String orderId, String orderAmt, String orderTime, String xlpayId, String xlpayTime, String ext1, String ext2, String payResult, String errCode, String bizKey) {
        String charset = "UTF-8";
        if ("2".equals(pageCharset)) {
            charset = "GBK";
        } else if ("3".equals(pageCharset)) {
            charset = "GB2312";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("version", version);
        map.put("orderId", orderId);
        map.put("orderAmt", orderAmt);
        map.put("orderTime", ProxyHelper.formatOrderTime(orderTime));
        map.put("xlpayId", xlpayId);
        map.put("xlpayTime", ProxyHelper.formatOrderTime(xlpayTime));
        map.put("ext1", ext1);
        map.put("ext2", ext2);
        map.put("errCode", errCode);
        map.put("payResult", payResult);
        String urlJoin = "?";
        if (url.indexOf("?") >= 0) {
            urlJoin = "&";
        }
        return url + urlJoin + ProxyHelper.buildUrlParams(map, charset) + "&signMsg=" + SignatureHelper.sign(map, bizKey);
    }

    public static String buildNotifyUrl(String pageCharset, String url, String version, String orderId, String orderAmt, String orderTime, String xlpayId, String xlpayTime, String ext1, String ext2, String payResult, String errCode, String bizKey, Double fareamt) {
        String charset = "UTF-8";
        if ("2".equals(pageCharset)) {
            charset = "GBK";
        } else if ("3".equals(pageCharset)) {
            charset = "GB2312";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("version", version);
        map.put("orderId", orderId);
        map.put("orderAmt", orderAmt);
        map.put("orderTime", ProxyHelper.formatOrderTime(orderTime));
        map.put("xlpayId", xlpayId);
        map.put("xlpayTime", ProxyHelper.formatOrderTime(xlpayTime));
        map.put("ext1", ext1);
        map.put("ext2", ext2);
        map.put("errCode", errCode);
        map.put("payResult", payResult);
        String fareamtstr = "" + new Double(Arith.mul(fareamt, 100.0)).intValue();
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("version", version);
        map2.put("orderId", orderId);
        map2.put("orderAmt", orderAmt);
        map2.put("orderTime", ProxyHelper.formatOrderTime(orderTime));
        map2.put("xlpayId", xlpayId);
        map2.put("xlpayTime", ProxyHelper.formatOrderTime(xlpayTime));
        map2.put("ext1", ext1);
        map2.put("ext2", ext2);
        map2.put("errCode", errCode);
        map2.put("payResult", payResult);
        map2.put("fareamt", fareamtstr + "");
        String urlJoin = "?";
        if (url.indexOf("?") >= 0) {
            urlJoin = "&";
        }
        return url + urlJoin + ProxyHelper.buildUrlParams(map2, charset) + "&signMsg=" + SignatureHelper.sign(map, bizKey);
    }

    public static boolean verifyRedirectUrl(String rUrl) {
        String params = rUrl.substring(rUrl.indexOf("?") + 1);
        String[] paramkv = params.split("&");
        if (paramkv == null || paramkv.length == 0) {
            return false;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String kv : paramkv) {
            String[] kva = kv.split("=");
            map.put(kva[0], kva.length > 1 ? ProxyHelper.decodeUrl(kva[1], "UTF-8") : null);
        }
        if (StringTools.isEmpty((String)((String)map.get("xlpayId")))) {
            return false;
        }
        Bizorderok bizorderokForQuery = new Bizorderok();
        bizorderokForQuery.setXunleipayid((String)map.get("xlpayId"));
        IFacade payproxyfacade = IFacade.INSTANCE;
        Bizorderok bizorderok = payproxyfacade.findBizorderok(bizorderokForQuery);
        if (bizorderok != null) {
            return !StringTools.isEmpty((String)bizorderok.getFgurl()) && rUrl.startsWith(bizorderok.getFgurl());
        }
        return false;
    }

    public static String buildNotifyUrl(String xunleipayid, String payResult, String errCode) {
        return ProxyHelper.buildNotifyUrl(xunleipayid, payResult, errCode, true);
    }

    public static String buildNotifyUrl(String xunleipayid, String payResult, String errCode, boolean isBgUrl) {
        Bizorderok bizorderokForQuery = new Bizorderok();
        bizorderokForQuery.setXunleipayid(xunleipayid);
        Bizorderok bizorderok = IFacade.INSTANCE.findBizorderok(bizorderokForQuery);
        if (bizorderok == null) {
            throw new XLRuntimeException("\u4e0d\u5b58\u5728\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e3a" + xunleipayid + "\u7684\u4e1a\u52a1\u8ba2\u5355\u6210\u529f\u8868");
        }
        String charset = "UTF-8";
        if ("2".equals(bizorderok.getPagecharset())) {
            charset = "GBK";
        } else if ("3".equals(bizorderok.getPagecharset())) {
            charset = "GB2312";
        }
        Copbizinfo copbizinfoForQuery = new Copbizinfo();
        copbizinfoForQuery.setBizno(bizorderok.getBizno());
        Copbizinfo copbizinfo = IFacade.INSTANCE.findCopbizinfo(copbizinfoForQuery);
        if (copbizinfo == null) {
            throw new XLRuntimeException("\u4e0d\u5b58\u5728" + bizorderok.getBizno() + "\u8fd9\u4e2a\u4e1a\u52a1");
        }
        String orderAmt = new Double(Arith.mul(bizorderok.getOrderamt(), 100.0)).intValue() + "";
        String fareAmt = new Double(Arith.mul(bizorderok.getFareamt(), 100.0)).intValue() + "";
        if (bizorderok.getPaytype().equals("Q2") || bizorderok.getPaytype().equals("Q3")) {
            Extmycardok extmycardokQry = new Extmycardok();
            extmycardokQry.setOrderid(xunleipayid);
            Extmycardok extmycardok = IFacade.INSTANCE.findExtmycardok(extmycardokQry);
            if (extmycardok != null) {
                orderAmt = new Double(Arith.mul(extmycardok.getOrderamttwd(), 100.0)).intValue() + "";
                fareAmt = new Double(Arith.mul(extmycardok.getFareamt(), 100.0)).intValue() + "";
            } else {
                throw new XLRuntimeException("\u4e0d\u5b58\u5728orderid = " + xunleipayid + "\u7684extmycardok\u8bb0\u5f55");
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("version", bizorderok.getVersion());
        map.put("orderId", bizorderok.getBizorderid());
        map.put("orderAmt", orderAmt);
        map.put("orderTime", ProxyHelper.formatOrderTime(bizorderok.getOrdertime()));
        map.put("xlpayId", bizorderok.getXunleipayid());
        map.put("xlpayTime", ProxyHelper.formatOrderTime(bizorderok.getSuccesstime()));
        map.put("ext1", bizorderok.getExt1());
        map.put("ext2", bizorderok.getExt2());
        map.put("errCode", errCode);
        map.put("payResult", payResult);
        String url = bizorderok.getBgurl();
        if (!isBgUrl) {
            url = bizorderok.getFgurl();
        }
        String urlJoin = "?";
        if (url.indexOf("?") >= 0) {
            urlJoin = "&";
        }
        return url + urlJoin + ProxyHelper.buildUrlParams(map, charset) + "&fareamt=" + fareAmt + "&signMsg=" + SignatureHelper.sign(map, copbizinfo.getBizkey());
    }

    public static String buildUmpayVipUrl(String orignal_orderid, String new_orderid, String days) {
        return ProxyHelper.getUmpayVipUrl(orignal_orderid, new_orderid, days);
    }

    public static String buildVipQuitNotifyUrl(String xunleipayid) {
        return ProxyHelper.getMobileQuitUrl(xunleipayid, "http://dynamic.vip.xunlei.com/script/vip/tuiding.php?userid=$userid&phone=$phone&xlpayid=$xlpayid&isnow=$isnow", "1");
    }

    public static String buildVipBatchQuitNotifyUrl(String xunleipayid) {
        return ProxyHelper.getMobileQuitUrl(xunleipayid, "http://dynamic.vip.xunlei.com/script/vip/tuiding.php?userid=$userid&phone=$phone&xlpayid=$xlpayid&isnow=$isnow", "2");
    }

    public static String buildBluegemQuitNotifyUrl(String xunleipayid) {
        return ProxyHelper.getMobileQuitUrl(xunleipayid, "http://dynamic.vip.xunlei.com/script/vip/tuiding.php?userid=$userid&phone=$phone&xlpayid=$xlpayid&isnow=$isnow", "1");
    }

    public static String buildKanKanQuitNotifyUrl(String xunleipayid) {
        return ProxyHelper.getKanKanQuitUrl(xunleipayid, kankanQuitUrl);
    }

    public static String buildKanKanBatchQuitNotifyUrl(String xunleipayid) {
        return ProxyHelper.getKanKanQuitUrl(xunleipayid, kankanQuitUrl);
    }

    private static String getKanKanQuitUrl(String xunleipayid, String quitUrl) {
        Mobilevipquit mobilevipquit = ProxyHelper.getMobilevipquit(xunleipayid, PayProxyFunctionConstant.SP_KONGZHONG);
        if (mobilevipquit == null) {
            throw new XLRuntimeException("\u4e0d\u5b58\u5728\u8ba2\u5355\u53f7\u4e3a" + xunleipayid + "\u7684\u624b\u673a\u5305\u6708\u9000\u8ba2\u8bb0\u5f55");
        }
        String user_id = "";
        String phone = "";
        user_id = mobilevipquit.getXunleiid();
        phone = mobilevipquit.getMobile();
        Copbizinfo copbizinfoForQuery = new Copbizinfo();
        copbizinfoForQuery.setBizno("000001043");
        Copbizinfo copbizinfo = IFacade.INSTANCE.findCopbizinfo(copbizinfoForQuery);
        if (copbizinfo == null) {
            throw new XLRuntimeException("\u4e0d\u5b58\u5728000001043\u8fd9\u4e2a\u4e1a\u52a1");
        }
        StringBuffer msg4sign = new StringBuffer();
        msg4sign.append("userid=").append(user_id).append("&phone=").append(phone).append(copbizinfo.getBizkey());
        logger.info((Object)("before sign-->" + msg4sign.toString()));
        String signMsg = Md5Encrypt.md5(msg4sign.toString());
        logger.info((Object)("after sign-->" + signMsg));
        String url = quitUrl.replace("$userid", user_id).replace("$phone", phone).replace("$signMsg", signMsg);
        logger.info((Object)("url = " + url));
        return url;
    }

    public static String buildBluegemBatchQuitNotifyUrl(String xunleipayid) {
        return ProxyHelper.getMobileQuitUrl(xunleipayid, "http://dynamic.vip.xunlei.com/script/vip/tuiding.php?userid=$userid&phone=$phone&xlpayid=$xlpayid&isnow=$isnow", "2");
    }

    private static String getUmpayVipUrl(String orignal_orderid, String new_orderid, String days) {
        String url = umpayVipUrl.replace("$orignal_orderid", orignal_orderid).replace("$new_orderid", new_orderid).replace("$days", days);
        logger.info((Object)("umpayVipUrl==" + url));
        return url;
    }

    private static String getMobileQuitUrl(String xunleipayid, String quitUrl, String isnow) {
        Mobilevipquit mobilevipquit = ProxyHelper.getMobilevipquit(xunleipayid, PayProxyFunctionConstant.SP_KONGZHONG);
        if (mobilevipquit == null) {
            throw new XLRuntimeException("\u4e0d\u5b58\u5728\u8ba2\u5355\u53f7\u4e3a" + xunleipayid + "\u7684\u624b\u673a\u5305\u6708\u9000\u8ba2\u8bb0\u5f55");
        }
        String user_id = "";
        String phone = "";
        user_id = mobilevipquit.getXunleiid();
        phone = mobilevipquit.getMobile();
        String url = quitUrl.replace("$userid", user_id).replace("$phone", phone).replace("$xlpayid", xunleipayid).replace("$isnow", isnow);
        logger.info((Object)("url = " + url));
        return url;
    }

    private static String getBerilQuitUrl(String xunleipayid, String quiturl) {
        Mobilevipquit mobilevipquit = ProxyHelper.getMobilevipquit(xunleipayid, PayProxyFunctionConstant.SP_PHOENIX);
        if (mobilevipquit == null) {
            throw new XLRuntimeException("\u4e0d\u5b58\u5728\u8ba2\u5355\u53f7\u4e3a" + xunleipayid + "\u7684\u624b\u673a\u5305\u6708\u9000\u8ba2\u8bb0\u5f55");
        }
        String user_id = mobilevipquit.getXunleiid();
        String mobile = mobilevipquit.getMobile();
        String sign = Md5Encrypt.md5(user_id + mobile + xunleipayid + "AK82HG03J7");
        String url = String.format(quiturl, user_id, mobile, xunleipayid, sign);
        logger.info((Object)url);
        return url;
    }

    public static String buildBerilQuitUrl(String xunleipayid) {
        return ProxyHelper.getBerilQuitUrl(xunleipayid, berilQuitUrl);
    }

    public static String buildBerilBatchQuitUrl(String xunleipayid) {
        return ProxyHelper.getBerilQuitUrl(xunleipayid, batchBerilQuitUrl);
    }

    private static Mobilevipquit getMobilevipquit(String xunleipayid, String sp) {
        logger.info((Object)("xunleipayid = " + xunleipayid));
        Mobilevipquit mobilevipquitQry = new Mobilevipquit();
        mobilevipquitQry.setOrderid(xunleipayid);
        Mobilevipquit mobilevipquit = IFacade.INSTANCE.findMobilevipquit(mobilevipquitQry);
        return mobilevipquit;
    }

    public static String buildUrlParams(Map<String, String> map, String charset) {
        if (map == null) {
            return "";
        }
        StringBuilder url = new StringBuilder();
        int i = 0;
        for (String key : map.keySet()) {
            url.append(i == 0 ? "" : "&");
            url.append(key).append("=").append(ProxyHelper.encodeUrl(map.get(key), charset));
            ++i;
        }
        return url.toString();
    }

    public static String decodeUrl(String content, String charset) {
        try {
            return URLDecoder.decode(content, charset);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String encodeUrl(String content, String charset) {
        try {
            return URLEncoder.encode(content, charset);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String formatOrderTime(String orderTime) {
        if (Utility.isEmpty(orderTime)) {
            return "";
        }
        return orderTime.replace("-", "").replace(":", "").replace(" ", "");
    }

    public static String getCopartnerNoFromBizNo(String bizNo) {
        return bizNo.substring(0, 6);
    }

    public static String getYYYYMMDDFromOrderId(String orderId) {
        String yyxx = orderId.substring(0, 8);
        try {
            SimpleDF.parseObject(yyxx);
        }
        catch (ParseException ex) {
            throw new XLRuntimeException("\u4e1a\u52a1\u53f7\u7684\u524d\u516b\u4f4d\u4e0d\u6b63\u786e\uff01");
        }
        return yyxx;
    }

    public static synchronized String getXunleiPayIdOld() {
        String yyyymmdd;
        String nextOrderId = "";
        if (se > 99) {
            se = 0;
        }
        if ((nextOrderId = (yyyymmdd = shortdf.format(new Date())).substring(2, 8) + Utility.getTradeSn().substring(3, 13) + Utility.createSerial("" + se, 2)).length() != 18) {
            throw new XLRuntimeException("\u8ba2\u5355\u53f7\u957f\u5ea6\u9519\u8bef[" + nextOrderId + "]");
        }
        ++se;
        return nextOrderId;
    }

    public static synchronized String getXunleiPayId() {
        if (se > 99) {
            se = 0;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyMMdd");
        String yyyymmdd = format.format(new Date());
        String theSe = "0" + se;
        String nextOrderId = yyyymmdd + Utility.getTradeSn().substring(3, 13) + macid + theSe.substring(theSe.length() - 2);
        if (nextOrderId.length() != 20) {
            throw new XLRuntimeException("\u8ba2\u5355\u53f7\u957f\u5ea6\u9519\u8bef[" + nextOrderId + "]");
        }
        ++se;
        return nextOrderId;
    }

    public static synchronized String getUniontelOrderId() {
        String nextOrderId = "";
        nextOrderId = Utility.getTradeSn().substring(0, 12);
        if (nextOrderId.length() != 12) {
            throw new XLRuntimeException("\u8ba2\u5355\u53f7\u957f\u5ea6\u9519\u8bef[" + nextOrderId + "]");
        }
        return nextOrderId;
    }

    public static void main(String[] args) throws IOException {
        File file = new File("E:\\newWorkSpace\\XLPayProxy4\\properties\\alipay.properties");
        Properties prop = new Properties();
        FileInputStream is = new FileInputStream(file);
        prop.load(is);
        if (null != is) {
            ((InputStream)is).close();
            file = null;
        }
        String paygateway = prop.getProperty("paygateway");
        System.out.println(paygateway);
        System.out.println("002".substring(2, 3));
    }

    static {
        ProxyHelper.init();
        SimpleDF = new SimpleDateFormat("yyyyMMDD");
        se = 0;
    }
}

