/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.payproxy.util.HttpConnectionUtil;
import com.xunlei.payproxy.util.SmsSender;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayCenterUtil {
    private static final String MAP_URL = "http://m.pay.xunlei.com/login/mapUrl";
    private static Logger logger = Logger.getLogger(PayCenterUtil.class);
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getMapUrl(String xunleiId, String bizNo, String bizKey, String mref) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("v", String.valueOf(System.currentTimeMillis()).substring(0, 10));
        paramsMap.put("userid", xunleiId);
        paramsMap.put("bizNo", bizNo);
        paramsMap.put("mref", mref);
        String paycenterUrl = PayCenterUtil.doPayCenterGet(MAP_URL, paramsMap, bizKey);
        return paycenterUrl;
    }

    public static String doPayCenterGet(String url, Map<String, String> paramsMap, String bizKey) {
        String signMsg = PayCenterUtil.generateSign(paramsMap, bizKey);
        paramsMap.put("signMsg", signMsg);
        String data = PayCenterUtil.mapToString(paramsMap, false);
        logger.info((Object)("-------------" + url + "?" + data));
        String response = HttpConnectionUtil.doGet(url + "?" + data, 6000, 6000);
        logger.info((Object)("-------------" + response));
        if (response == null || "".equals(response.trim())) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        String ret = responseObj.getString("ret");
        if (ret == null || !"200".equals(ret.trim())) {
            String msg = responseObj.getString("msg");
            System.out.println("msg: " + msg);
            return null;
        }
        JSONObject dataObj = responseObj.getJSONObject("data");
        String code = dataObj.getString("code");
        if (code == null || !"200".equals(code.trim())) {
            System.out.println("code: " + code);
            return null;
        }
        String fullUrl = dataObj.getString("url");
        String shortUrl = dataObj.getString("shortUrl");
        return shortUrl;
    }

    public static String generateSign(Map<String, String> paraMap, String key) {
        String middle = PayCenterUtil.mapToString(paraMap, true);
        StringBuilder builder = new StringBuilder();
        builder.append(middle).append(key);
        return PayCenterUtil.md5(builder.toString(), "UTF-8");
    }

    public static String mapToString(Map<String, String> params, boolean isSort) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        if (isSort) {
            Collections.sort(keys);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (SmsSender.isEmpty(value) || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("sign_type")) continue;
            if (i == keys.size() - 1) {
                builder.append(key).append("=").append(value);
                continue;
            }
            builder.append(key).append("=").append(value).append("&");
        }
        return builder.toString();
    }

    public static String md5(String text, String charset) {
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("System doesn't support MD5 algorithm.");
        }
        try {
            msgDigest.update(text.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("System doesn't support your  EncodingException.");
        }
        byte[] bytes = msgDigest.digest();
        String md5Str = new String(PayCenterUtil.encodeHex(bytes));
        return md5Str;
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }

    public static void main(String[] args) {
        String xunleiId = "111";
    }
}

