/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.util;

import com.xunlei.payproxy.util.MobileQueryResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MobileLocator {
    private static Logger logger = Logger.getLogger(MobileLocator.class);
    private static MobileQueryResponse response = new MobileQueryResponse();
    private static String apiUrl = "http://api.showji.com/Locating/default.aspx";

    public static String getQueryResult(String mobileno) {
        if (response != null && response.getMobile().equals(mobileno)) {
            return response.getQueryResult();
        }
        return MobileLocator.locateMobile(mobileno).getQueryResult();
    }

    public static String getProvince(String mobileno) {
        if (response != null && response.getMobile().equals(mobileno)) {
            return response.getProvince();
        }
        return MobileLocator.locateMobile(mobileno).getProvince();
    }

    public static String getCity(String mobileno) {
        if (response != null && response.getMobile().equals(mobileno)) {
            return response.getCity();
        }
        return MobileLocator.locateMobile(mobileno).getCity();
    }

    public static String getCorp(String mobileno) {
        if (response != null && response.getMobile().equals(mobileno)) {
            return response.getCorp();
        }
        return MobileLocator.locateMobile(mobileno).getCorp();
    }

    public static String getCard(String mobileno) {
        if (response != null && response.getMobile().equals(mobileno)) {
            return response.getCard();
        }
        return MobileLocator.locateMobile(mobileno).getCard();
    }

    private static MobileQueryResponse locateMobile(String mobileno) {
        if (mobileno == null || mobileno.isEmpty()) {
            return response;
        }
        StringBuilder urlBuilder = new StringBuilder(apiUrl);
        urlBuilder.append("?m=").append(mobileno).append("&output=xml");
        try {
            URL url = new URL(urlBuilder.toString());
            URLConnection connection = url.openConnection();
            connection.setReadTimeout(5000);
            connection.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String responseXML = "";
            String line = "";
            while ((line = reader.readLine()) != null) {
                responseXML = responseXML + line;
            }
            Document document = DocumentHelper.parseText((String)responseXML);
            Element root = document.getRootElement();
            String mobile = root.elementText("Mobile");
            String queryResult = root.elementText("QueryResult");
            response.setMobile(mobile);
            response.setQueryResult(queryResult);
            if (queryResult.equals("True")) {
                String province = root.elementText("Province");
                String city = root.elementText("City");
                String corp = root.elementText("Corp");
                String card = root.elementText("Card");
                response.setProvince(province);
                response.setCity(city);
                response.setCorp(corp);
                response.setCard(card);
            }
            return response;
        }
        catch (MalformedURLException e) {
            logger.error((Object)("MalformedURLException \uff1a" + e.getMessage()));
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)("IOException : " + e.getMessage()));
            e.printStackTrace();
        }
        catch (DocumentException e) {
            logger.error((Object)("DocumentException : " + e.getMessage()));
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(MobileLocator.getProvince("13266890103"));
        System.out.println(MobileLocator.getQueryResult("13266890103"));
        System.out.println(MobileLocator.getProvince("13266890103"));
        System.out.println(MobileLocator.getCity("13266890103"));
        System.out.println(MobileLocator.getCard("13266890103"));
        System.out.println(MobileLocator.getCorp("13266890103"));
    }
}

