/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.util;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtmmarketPayUtil {
    private static final Logger log = LoggerFactory.getLogger(ExtmmarketPayUtil.class);
    public static Map<String, Integer> validServiceInfoMap = new HashMap<String, Integer>();

    public static String add(String date, int num) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        GregorianCalendar cal = new GregorianCalendar();
        try {
            cal.setTime(sdf.parse(date));
            cal.add(5, num);
            return sdf.format(cal.getTime());
        }
        catch (ParseException e) {
            log.info("", (Throwable)e);
            return null;
        }
    }

    static {
        Document document = null;
        try {
            File configFile = new File(ExtmmarketPayUtil.class.getClassLoader().getResource("mmarketpay_serviceinfo.xml").getFile());
            SAXReader reader = new SAXReader();
            document = reader.read(configFile);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        Element root = document.getRootElement();
        List serviceList = root.element("services").elements("service");
        Iterator iter = serviceList.iterator();
        while (iter.hasNext()) {
            try {
                Element data = (Element)iter.next();
                String serviceId = data.attributeValue("serviceid").trim();
                int days = Integer.parseInt(data.attributeValue("days").trim());
                validServiceInfoMap.put(serviceId, days);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        log.debug("validServiceInfoMap:" + validServiceInfoMap);
    }
}

