/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.dao.BaseDao;
import com.xunlei.payproxy.dao.IVerifyMobileDao;
import com.xunlei.payproxy.vo.Vmobilenoinfo;
import com.xunlei.payproxy.vo.Vmobileuserid;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyMobileDaoImpl
extends BaseDao
implements IVerifyMobileDao {
    @Override
    public Vmobilenoinfo getVmobileinfo(String mobileno) {
        String sql = "select * from vmobilenoinfo where mobileno=?";
        final Vmobilenoinfo vmobilenoinfo = new Vmobilenoinfo();
        this.getJdbcTemplate().query(sql, new Object[]{mobileno}, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                vmobilenoinfo.setMobileno(resultSet.getString("mobileno"));
                vmobilenoinfo.setAmount(resultSet.getInt("amount"));
                vmobilenoinfo.setUsercount(resultSet.getInt("usercount"));
            }
        });
        return vmobilenoinfo;
    }

    @Override
    public List<Vmobileuserid> queryVmobileuseridByMobileno(String mobileno) {
        final ArrayList<Vmobileuserid> list = new ArrayList<Vmobileuserid>();
        String sql = "select * from vmobileuserid where mobileno=?";
        this.getJdbcTemplate().query(sql, new Object[]{mobileno}, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                Vmobileuserid v = new Vmobileuserid();
                v.setMobileno(resultSet.getString("mobileno"));
                v.setUserid(resultSet.getString("userid"));
                list.add(v);
            }
        });
        return list;
    }

    @Override
    public List<Vmobileuserid> queryVmobileuserid(String userid) {
        final ArrayList<Vmobileuserid> list = new ArrayList<Vmobileuserid>();
        String sql = "select * from vmobileuserid where userid=?";
        this.getJdbcTemplate().query(sql, new Object[]{userid}, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                Vmobileuserid v = new Vmobileuserid();
                v.setMobileno(resultSet.getString("mobileno"));
                v.setUserid(resultSet.getString("userid"));
                list.add(v);
            }
        });
        return list;
    }

    @Override
    public void updateVmobileinfo(Vmobilenoinfo vmobilenoinfo) {
        String updatesql = "update vmobilenoinfo set amount=?,usercount=? where mobileno=?";
        int e = this.getJdbcTemplate().update(updatesql, new Object[]{vmobilenoinfo.getAmount(), vmobilenoinfo.getUsercount(), vmobilenoinfo.getMobileno()});
        if (e == 0) {
            String insertSql = "insert into vmobilenoinfo(mobileno,amount,usercount) values(?,?,?)";
            this.getJdbcTemplate().update(insertSql, new Object[]{vmobilenoinfo.getMobileno(), vmobilenoinfo.getAmount(), vmobilenoinfo.getUsercount()});
        }
    }

    @Override
    public void insertVMobileuserid(Vmobileuserid vmobileuserid) {
        String insertSql = "insert into vmobileuserid(mobileno,userid) values(?,?)";
        this.getJdbcTemplate().update(insertSql, new Object[]{vmobileuserid.getMobileno(), vmobileuserid.getUserid()});
    }

    @Override
    public void emptyVmobileinfo() {
        String sql = "delete from vmobilenoinfo";
        this.getJdbcTemplate().execute(sql);
    }

    @Override
    public void emptyVmobileuserid() {
        String sql = "delete from vmobileuserid";
        this.getJdbcTemplate().execute(sql);
    }

    @Override
    public void deleteVmobileinfo(String mobileno) {
        String sql = "delete from vmobilenoinfo where mobileno='" + StringTools.escapeSql((String)mobileno) + "'";
        this.getJdbcTemplate().execute(sql);
    }

    @Override
    public void deleteVmobileuserid(Vmobileuserid data) {
        String sql = "delete from vmobileuserid where 1=1 ";
        if (StringTools.isNotEmpty((String)data.getMobileno())) {
            sql = sql + " and mobileno='" + StringTools.escapeSql((String)data.getMobileno()) + "' ";
        }
        if (StringTools.isNotEmpty((String)data.getUserid())) {
            sql = sql + " and userid='" + StringTools.escapeSql((String)data.getUserid()) + "' ";
        }
        this.getJdbcTemplate().execute(sql);
    }
}

