/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.dao.BaseDao;
import com.xunlei.payproxy.dao.IPaydayendDao;
import com.xunlei.payproxy.vo.Paydayend;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaydayendDaoImpl
extends BaseDao
implements IPaydayendDao {
    @Override
    public Paydayend findPaydayend(Paydayend data) {
        String sql = "select * from paydayend";
        String countsql = "select count(1) from paydayend";
        StringBuilder where = new StringBuilder(" where 1=1");
        if (null != data) {
            if (data.getSeqid() > 0L) {
                return this.getPaydayendById(data.getSeqid());
            }
            countsql = countsql + where.toString();
            sql = sql + where.toString();
            if (this.getSingleInt(countsql) == 1) {
                return (Paydayend)this.queryOne(Paydayend.class, sql, new String[0]);
            }
        }
        return null;
    }

    @Override
    public Paydayend queryPaydayendSum(Paydayend data) {
        final Paydayend result = new Paydayend();
        StringBuilder where = new StringBuilder("select sum(failnum) as failnum,sum(successnum) as successnum,sum(successamt) as successamt,sum(royaltyfailnum) as royaltyfailnum,sum(royaltysuccessnum) as royaltysuccessnum,sum(royaltysuccessamt) as royaltysuccessamt,sum(rrefundfailnum) as rrefundfailnum,sum(rrefundsuccessnum) as rrefundsuccessnum,sum(rrefundsuccessamt) as rrefundsuccessamt,sum(payrefundfailnum) as payrefundfailnum,sum(payrefundsuccessnum) as payrefundsuccessnum,sum(payrefundsuccessamt) as payrefundsuccessamt,sum(royaltysuccessamt+rrefundsuccessamt+payrefundsuccessamt+successamt) as factsuccessamt,sum(successusernum) as successusernum,sum(failusernum) as failusernum from paydayend where 1=1 ");
        if (null != data) {
            String[] arr;
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>='").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<='").append(data.getTodate()).append("' ");
            }
            if (this.isNotEmpty(data.getPaytype())) {
                where.append(" and paytype='").append(data.getPaytype()).append("' ");
            } else if (this.isNotEmpty(data.getPaytypeArr())) {
                String paytypes = data.getPaytypeArr();
                if (paytypes.endsWith(";")) {
                    paytypes = paytypes.substring(0, paytypes.length() - 1);
                }
                if ((arr = paytypes.split(";")).length > 0) {
                    where.append(" and paytype in").append(PaydayendDaoImpl.uniteForIn((String[])arr));
                }
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and bizno='").append(data.getBizno()).append("' ");
            } else if (this.isNotEmpty(data.getBiznoArr())) {
                String biznos = data.getBiznoArr();
                if (biznos.endsWith(";")) {
                    biznos = biznos.substring(0, biznos.length() - 1);
                }
                if ((arr = biznos.split(";")).length > 0) {
                    where.append(" and bizno in").append(PaydayendDaoImpl.uniteForIn((String[])arr));
                }
            } else if (data.getBiznos() != null) {
                if (data.getBiznos().length == 0) {
                    return result;
                }
                where.append(" and bizno in").append(PaydayendDaoImpl.uniteForIn((String[])data.getBiznos()));
            }
        }
        this.getJdbcTemplate().query(where.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                result.setFailnum(resultSet.getInt(1));
                result.setSuccessnum(resultSet.getInt(2));
                result.setSuccessamt(resultSet.getDouble(3));
                result.setRoyaltyfailnum(resultSet.getInt("royaltyfailnum"));
                result.setRoyaltysuccessamt(resultSet.getDouble("royaltysuccessamt"));
                result.setRoyaltysuccessnum(resultSet.getInt("royaltysuccessnum"));
                result.setRrefundfailnum(resultSet.getInt("rrefundfailnum"));
                result.setRrefundsuccessamt(resultSet.getDouble("rrefundsuccessamt"));
                result.setRrefundsuccessnum(resultSet.getInt("rrefundsuccessnum"));
                result.setPayrefundfailnum(resultSet.getInt("payrefundfailnum"));
                result.setPayrefundsuccessamt(resultSet.getDouble("payrefundsuccessamt"));
                result.setPayrefundsuccessnum(resultSet.getInt("payrefundsuccessnum"));
                result.setFactsuccessamt(resultSet.getDouble("factsuccessamt"));
                result.setSuccessusernum(resultSet.getInt("successusernum"));
                result.setFailusernum(resultSet.getInt("failusernum"));
            }
        });
        return result;
    }

    @Override
    public Map<String, Double> queryPaySuccessRate(Paydayend data) {
        System.out.println("begin to queryPaySuccessRate");
        final HashMap<String, Double> resultMap = new HashMap<String, Double>();
        StringBuilder where = new StringBuilder("select paytype,SUM(successnum)/(SUM(failnum)+SUM(successnum)) AS successrate from paydayend where 1=1 ");
        if (null != data) {
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>='").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<='").append(data.getTodate()).append("' ");
            }
        }
        where.append(" GROUP BY paytype");
        logger.info((Object)("querysql-->" + where.toString()));
        this.getJdbcTemplate().query(where.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                System.out.println("paytype-->" + resultSet.getString(1));
                System.out.println("successrate-->" + resultSet.getDouble(2));
                resultMap.put(resultSet.getString("paytype"), resultSet.getDouble(2));
            }
        });
        return resultMap;
    }

    @Override
    public Map<String, Double> queryPaySuccessRateGroupByBizno(Paydayend data) {
        final HashMap<String, Double> resultMap = new HashMap<String, Double>();
        StringBuilder where = new StringBuilder("select bizno,SUM(successnum)/(SUM(failnum)+SUM(successnum)) AS successrate from paydayend where 1=1 ");
        if (null != data) {
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>='").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<='").append(data.getTodate()).append("' ");
            }
        }
        where.append(" GROUP BY bizno");
        logger.info((Object)("querysql-->" + where.toString()));
        this.getJdbcTemplate().query(where.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                System.out.println("paytype-->" + resultSet.getString(1));
                System.out.println("successrate-->" + resultSet.getDouble(2));
                resultMap.put(resultSet.getString("bizno"), resultSet.getDouble(2));
            }
        });
        return resultMap;
    }

    @Override
    public Double queryPaySuccessRateAllDatas(Paydayend data) {
        final HashMap resultMap = new HashMap();
        StringBuilder where = new StringBuilder("select SUM(successnum)/(SUM(failnum)+SUM(successnum)) AS successrate from paydayend where 1=1 ");
        if (null != data) {
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>='").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<='").append(data.getTodate()).append("' ");
            }
        }
        logger.info((Object)("querysql-->" + where.toString()));
        this.getJdbcTemplate().query(where.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                resultMap.put("successrate", resultSet.getDouble(1));
            }
        });
        return (Double)resultMap.get("successrate");
    }

    @Override
    public Sheet<Paydayend> queryPaydayend(Paydayend data, PagedFliper fliper) {
        String sql = "select * from paydayend";
        String countsql = "select count(1) from paydayend";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (null != data) {
            String[] arr;
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>='").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<='").append(data.getTodate()).append("' ");
            }
            if (this.isNotEmpty(data.getPaytype())) {
                where.append(" and paytype='").append(data.getPaytype()).append("' ");
            } else if (this.isNotEmpty(data.getPaytypeArr())) {
                String paytypes = data.getPaytypeArr();
                if (paytypes.endsWith(";")) {
                    paytypes = paytypes.substring(0, paytypes.length() - 1);
                }
                if ((arr = paytypes.split(";")).length > 0) {
                    where.append(" and paytype in").append(PaydayendDaoImpl.uniteForIn((String[])arr));
                }
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and bizno='").append(data.getBizno()).append("' ");
            } else if (this.isNotEmpty(data.getBiznoArr())) {
                String biznos = data.getBiznoArr();
                if (biznos.endsWith(";")) {
                    biznos = biznos.substring(0, biznos.length() - 1);
                }
                if ((arr = biznos.split(";")).length > 0) {
                    where.append(" and bizno in").append(PaydayendDaoImpl.uniteForIn((String[])arr));
                }
            } else if (data.getBiznos() != null) {
                if (data.getBiznos().length == 0) {
                    return Sheet.EMPTY;
                }
                where.append(" and bizno in").append(PaydayendDaoImpl.uniteForIn((String[])data.getBiznos()));
            }
        }
        countsql = countsql + where.toString();
        StringBuilder sb = new StringBuilder();
        for (String str : data.getBiznos()) {
            sb.append(str).append(",");
        }
        logger.debug((Object)("paydayenddao data.getBiznos()=" + sb.toString() + " data.getBiznoArr()=" + data.getBiznoArr() + "   countsql=" + countsql));
        int rowcount = this.getSingleInt(countsql);
        if (rowcount <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet(rowcount, (Collection)this.query(Paydayend.class, sql, new String[0]));
    }

    @Override
    public void deletePaydayend(Paydayend data) {
        if (null != data && data.getSeqid() > 0L) {
            this.deletePaydayendById(data.getSeqid());
        }
    }

    @Override
    public List<Paydayend> queryPaytypedayend(Paydayend data) {
        String sql = "SELECT b.producttype AS producttype, SUM(failnum) AS failnum,SUM(successnum) AS successnum,SUM(failusernum) AS failusernum,SUM(successusernum) AS successusernum,SUM(successamt) AS successamt,SUM(royaltyfailnum) AS royaltyfailnum,SUM(royaltysuccessnum) AS royaltysuccessnum,SUM(royaltysuccessamt) AS royaltysuccessamt,SUM(rrefundfailnum) AS rrefundfailnum,SUM(rrefundsuccessnum) AS rrefundsuccessnum,SUM(rrefundsuccessamt) AS rrefundsuccessamt,SUM(payrefundfailnum) AS payrefundfailnum,SUM(payrefundsuccessnum) AS payrefundsuccessnum,SUM(payrefundsuccessamt) AS payrefundsuccessamt, SUM(royaltysuccessamt+rrefundsuccessamt+payrefundsuccessamt+successamt) AS factsuccessamt,paytype,a.bizno,a.copartnerno,1 AS seqid,'' AS balancedate,'' AS remark,'' AS editby,'' AS edittime FROM paydayend a, copbizinfo b WHERE 1=1 AND a.BizNo=b.BizNo";
        if (data != null) {
            if (this.isNotEmpty(data.getFromdate())) {
                sql = sql + " and balancedate>='" + data.getFromdate() + "' ";
            }
            if (this.isNotEmpty(data.getTodate())) {
                sql = sql + " and balancedate<='" + data.getTodate() + "' ";
            }
            if (data.getBiznos() != null) {
                if (data.getBiznos().length == 0) {
                    return new ArrayList<Paydayend>();
                }
                sql = sql + " and a.bizno in" + PaydayendDaoImpl.uniteForIn((String[])data.getBiznos());
            }
        }
        sql = sql + " group by paytype,a.bizno order by a.bizno,paytype,a.copartnerno ";
        logger.debug((Object)("sql:" + sql));
        return this.query(Paydayend.class, sql, new String[]{"producttype"});
    }

    @Override
    public List<Paydayend> queryPaytypedayendIgnoreBizno(Paydayend data) {
        String sql = "SELECT b.producttype AS producttype, SUM(failnum) AS failnum,SUM(successnum) AS successnum,SUM(successamt) AS successamt,SUM(royaltyfailnum) AS royaltyfailnum,SUM(royaltysuccessnum) AS royaltysuccessnum,SUM(royaltysuccessamt) AS royaltysuccessamt,SUM(rrefundfailnum) AS rrefundfailnum,SUM(rrefundsuccessnum) AS rrefundsuccessnum,SUM(rrefundsuccessamt) AS rrefundsuccessamt,SUM(payrefundfailnum) AS payrefundfailnum,SUM(payrefundsuccessnum) AS payrefundsuccessnum,SUM(payrefundsuccessamt) AS payrefundsuccessamt, SUM(royaltysuccessamt+rrefundsuccessamt+payrefundsuccessamt+successamt) AS factsuccessamt,paytype,'' AS bizno,a.copartnerno,1 AS seqid,'' AS balancedate,'' AS remark,'' AS editby,'' AS edittime FROM paydayend a, copbizinfo b WHERE 1=1 AND a.BizNo=b.BizNo";
        if (data != null) {
            if (this.isNotEmpty(data.getFromdate())) {
                sql = sql + " and balancedate>='" + data.getFromdate() + "' ";
            }
            if (this.isNotEmpty(data.getTodate())) {
                sql = sql + " and balancedate<='" + data.getTodate() + "' ";
            }
            if (data.getBiznos() != null) {
                if (data.getBiznos().length == 0) {
                    return new ArrayList<Paydayend>();
                }
                sql = sql + " and a.bizno in" + PaydayendDaoImpl.uniteForIn((String[])data.getBiznos());
            }
        }
        sql = sql + " group by paytype order by paytype,a.copartnerno ";
        logger.debug((Object)("sql:" + sql));
        return this.query(Paydayend.class, sql, new String[]{"producttype"});
    }

    @Override
    public Paydayend getPaydayendById(long seqid) {
        return (Paydayend)this.findObject(Paydayend.class, seqid);
    }

    @Override
    public void insertPaydayend(Paydayend data) {
        this.insertObject(data);
    }

    @Override
    public void updatePaydayend(Paydayend data) {
        this.updateObject(data);
    }

    @Override
    public void deletePaydayendById(long ... seqids) {
        this.deleteObject("paydayend", seqids);
    }
}

