/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.dao.BaseDao;
import com.xunlei.payproxy.dao.IMobilevipquitDao;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Mobilevipquit;
import java.sql.SQLException;
import java.util.Collection;
import org.springframework.jdbc.CannotGetJdbcConnectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobilevipquitDaoImpl
extends BaseDao
implements IMobilevipquitDao {
    private final String DEADLINEYEAR = "2013";

    @Override
    public Mobilevipquit findMobilevipquit(Mobilevipquit data) {
        String sql = this.getSql(data);
        String countsql = this.getCountsql(data);
        data = this.getQueryMobilevipquitData(data);
        StringBuilder where = new StringBuilder(" where 1=1");
        if (null != data) {
            if (data.getSeqid() > 0L) {
                return this.getMobilevipquitById(data.getSeqid());
            }
            if (this.isNotEmpty(data.getMobile())) {
                where.append(" and mobile='").append(data.getMobile()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderid())) {
                where.append(" and orderid='").append(data.getOrderid()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and gettime<='").append(data.getTodate()).append(" 23:59:59' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and gettime>='").append(data.getFromdate()).append(" 00:00:00'");
            }
            if (this.isNotEmpty(data.getSp())) {
                where.append(" and sp='").append(data.getSp()).append("' ");
            }
            countsql = countsql + where.toString();
            sql = sql + where.toString();
            logger.info((Object)("countSql-->" + countsql));
            logger.info((Object)("sql-->" + sql));
            if (this.getSingleInt(countsql) == 1) {
                return (Mobilevipquit)this.queryOne(Mobilevipquit.class, sql, new String[0]);
            }
        }
        return null;
    }

    @Override
    public Mobilevipquit queryMobilevipquitByMobile(Mobilevipquit data) {
        String[] tables;
        for (String table : tables = new String[]{"mobilevipquit", "mobilevipquit_2012", "mobilevipquit_2011", "mobilevipquit_2010", "mobilevipquit_2009"}) {
            StringBuffer sql = new StringBuffer("select * from ");
            sql.append(table).append(" ");
            sql.append("where mobile='").append(data.getMobile()).append("' ");
            sql.append("and sp='").append(data.getSp()).append("' ");
            if (!Utility.isEmpty(data.getSerivetype())) {
                sql.append("and serivetype='").append(data.getSerivetype()).append("' ");
            }
            sql.append("order by quittime desc limit 0,1");
            logger.info((Object)("queryMobilevipquitByMobile-->sql:" + sql.toString()));
            Mobilevipquit mobilevipquit = (Mobilevipquit)this.queryOne(Mobilevipquit.class, sql.toString(), new String[0]);
            if (null == mobilevipquit) continue;
            return mobilevipquit;
        }
        return null;
    }

    @Override
    public Sheet<Mobilevipquit> queryMobilevipquit(Mobilevipquit data, PagedFliper fliper) {
        int rowcount;
        String sql = this.getSql(data);
        logger.info((Object)("queryMobilevipquit-----sql---not where : " + sql));
        String countsql = this.getCountsql(data);
        data = this.getQueryMobilevipquitData(data);
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (null != data) {
            if (this.isNotEmpty(data.getOrderid())) {
                where.append(" and orderid='").append(data.getOrderid()).append("' ");
            }
            if (this.isNotEmpty(data.getMobile())) {
                where.append(" and mobile='").append(data.getMobile()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiid())) {
                where.append(" and xunleiid='").append(data.getXunleiid()).append("' ");
            }
            if (this.isNotEmpty(data.getUsershow())) {
                where.append(" and usershow='").append(data.getUsershow()).append("' ");
            }
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate='").append(data.getBalancedate()).append("' ");
            } else {
                if (this.isNotEmpty(data.getTodate())) {
                    where.append(" and balancedate<='").append(data.getTodate()).append("' ");
                }
                if (this.isNotEmpty(data.getFromdate())) {
                    where.append(" and balancedate>='").append(data.getFromdate()).append("'");
                }
            }
            if (this.isNotEmpty(data.getChargetime())) {
                where.append(" and quittime<='").append(data.getChargetime()).append("'");
            }
            if (this.isNotEmpty(data.getChargemonth())) {
                where.append(" and quittime>='").append(data.getChargemonth()).append("-01 00:00:00'");
            }
            if (this.isNotEmpty(data.getCarrier())) {
                where.append(" and carrier='").append(data.getCarrier()).append("' ");
            }
            if (this.isNotEmpty(data.getQuitnoticestatus())) {
                where.append(" and quitnoticestatus='").append(data.getQuitnoticestatus()).append("' ");
            }
            if (this.isNotEmpty(data.getQuitfrom())) {
                where.append(" and quitfrom='").append(data.getQuitfrom()).append("' ");
            }
            if (this.isNotEmpty(data.getSerivetype())) {
                where.append(" and serivetype='").append(data.getSerivetype()).append("' ");
            }
            if (this.isNotEmpty(data.getSp())) {
                where.append(" and sp='").append(data.getSp()).append("' ");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = countsql + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        logger.info((Object)("queryMobilevipquit-----sql=" + sql));
        return new Sheet(rowcount, (Collection)this.query(Mobilevipquit.class, sql, new String[0]));
    }

    @Override
    public void deleteMobilevipquit(Mobilevipquit data) {
        if (null != data && data.getSeqid() > 0L) {
            this.deleteMobilevipquitById(data.getSeqid());
        }
    }

    @Override
    public Mobilevipquit getMobilevipquitById(long seqid) {
        return (Mobilevipquit)this.findObject(Mobilevipquit.class, seqid);
    }

    @Override
    public void insertMobilevipquit(Mobilevipquit data) {
        this.insertObject(data);
    }

    @Override
    public void updateMobilevipquit(Mobilevipquit data) {
        this.updateObject(data);
    }

    @Override
    public void deleteMobilevipquitById(long ... seqids) {
        this.deleteObject("mobilevipquit", seqids);
    }

    @Override
    public int getMobilevipquitCount(Mobilevipquit data) {
        String sql = this.getSql(data);
        data = this.getQueryMobilevipquitData(data);
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (data != null) {
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getSerivetype())) {
                where.append(" and serivetype='").append(data.getSerivetype()).append("' ");
            }
            if (this.isNotEmpty(data.getSp())) {
                where.append(" and sp='").append(data.getSp()).append("' ");
            }
        }
        return this.getSingleInt(sql + where.toString());
    }

    private String getSql(Mobilevipquit data) {
        String sql = "select * from mobilevipquit";
        String fromYear = data.getFromdate().split("-")[0];
        if (data.getIsPast() == 1) {
            sql = String.format("select * from mobilevipquit_%s", data.getPastYear());
        } else if (fromYear.compareTo("2013") < 0) {
            sql = String.format("select * from mobilevipquit_%s", fromYear);
        }
        if (fromYear == null || fromYear.equals("")) {
            sql = "select * from mobilevipquit ";
        }
        return sql;
    }

    private String getCountsql(Mobilevipquit data) {
        String countsql = "select count(1) from mobilevipquit";
        String fromYear = data.getFromdate().split("-")[0];
        if (data.getIsPast() == 1) {
            countsql = String.format("select count(1) from mobilevipquit_%s", data.getPastYear());
        } else if (fromYear.compareTo("2013") < 0) {
            countsql = String.format("select count(1) from mobilevipquit_%s", fromYear);
        }
        if (fromYear == null || fromYear.equals("")) {
            countsql = "select * from mobilevipquit ";
        }
        return countsql;
    }

    private Mobilevipquit getQueryMobilevipquitData(Mobilevipquit data) {
        if (data.getIsPast() == 1) {
            data.setFromdate(String.format("%s-01-01", data.getPastYear()));
            data.setTodate(String.format("%s-12-31", data.getPastYear()));
        }
        return data;
    }

    @Override
    public String queryMobileByUid(String table, String uid) {
        StringBuffer sql = new StringBuffer();
        sql.append("select mobile from ").append(table);
        sql.append(" where xunleiid='").append(uid).append("'");
        sql.append(" and serivetype in('A','C')");
        sql.append(" order by quittime desc limit 0,1");
        String mobile = this.getSingleString(sql.toString());
        try {
            this.getConnection().close();
        }
        catch (CannotGetJdbcConnectionException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return mobile;
    }

    @Override
    public Sheet<Mobilevipquit> queryMobilevipQuitByMobile(String mobile, PagedFliper fliper) {
        String sql = "select * from mobilevipquit";
        String countsql = "select count(1) from mobilevipquit";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (this.isEmpty(mobile)) {
            return Sheet.EMPTY;
        }
        where.append(" and mobile='").append(mobile).append("'");
        countsql = countsql + where.toString();
        int rowcount = this.getSingleInt(countsql);
        if (rowcount <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet(rowcount, (Collection)this.query(Mobilevipquit.class, sql, new String[0]));
    }
}

