/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.dao.IExtumpayokinfoDao;
import com.xunlei.payproxy.vo.Extumpayokinfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtumpayokinfoDaoImpl
extends JdbcBaseDao
implements IExtumpayokinfoDao {
    @Override
    public Extumpayokinfo getExtumpayokinfoById(long seqid) {
        Extumpayokinfo query = new Extumpayokinfo();
        query.setSeqid(seqid);
        return (Extumpayokinfo)this.findObject(query);
    }

    @Override
    public Extumpayokinfo findExtumpayokinfo(Extumpayokinfo data) {
        return (Extumpayokinfo)this.findObjectByCondition(data);
    }

    @Override
    public void insertExtumpayokinfo(Extumpayokinfo data) {
        this.saveObject(data);
    }

    @Override
    public void updateExtumpayokinfo(Extumpayokinfo data) {
        this.updateObject(data);
    }

    @Override
    public void updateExtumpayokinfo(Extumpayokinfo data, String[] includeFields) {
        this.updateObject(data, null, includeFields);
    }

    @Override
    public void deleteExtumpayokinfoById(long ... seqids) {
        this.deleteObject("extumpayokinfo", seqids);
    }

    @Override
    public void deleteExtumpayokinfo(Extumpayokinfo data) {
        this.deleteObject(data);
    }

    @Override
    public Extumpayokinfo queryExtumpayokinfoSum(Extumpayokinfo data) {
        final Extumpayokinfo result = new Extumpayokinfo();
        StringBuilder sql = new StringBuilder("select sum(amount) as amount from extumpayokinfo where 1=1 ");
        if (this.isNotEmpty(data.getFromdate())) {
            sql.append(" and successtime>='").append(StringTools.escapeSql((String)data.getFromdate())).append(" 00:00:00' ");
        }
        if (this.isNotEmpty(data.getTodate())) {
            sql.append(" and successtime<='").append(StringTools.escapeSql((String)data.getTodate())).append(" 23:59:59' ");
        }
        if (this.isNotEmpty(data.getOrderid())) {
            sql.append(" and orderid='").append(StringTools.isNotEmpty((String)data.getOrderid())).append("' ");
        }
        if (this.isNotEmpty(data.getUsershow())) {
            sql.append(" and usershow='").append(StringTools.isNotEmpty((String)data.getUsershow())).append("' ");
        }
        this.getJdbcTemplate().query(sql.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                result.setAmount(resultSet.getInt(1));
            }
        });
        return result;
    }

    @Override
    public Sheet<Extumpayokinfo> queryExtumpayokinfo(Extumpayokinfo data, PagedFliper fliper) {
        StringBuilder where = new StringBuilder();
        if (this.isNotEmpty(data.getFromdate())) {
            where.append(" and successtime>='").append(StringTools.escapeSql((String)data.getFromdate())).append(" 00:00:00' ");
        }
        if (this.isNotEmpty(data.getTodate())) {
            where.append(" and successtime<='").append(StringTools.escapeSql((String)data.getTodate())).append(" 23:59:59' ");
        }
        return this.findPagedObjects(data, where.toString(), fliper);
    }

    @Override
    public Sheet<Extumpayokinfo> queryExtumpayokinfoByMonthlyEndedTime(Extumpayokinfo data, PagedFliper fliper) {
        StringBuilder where = new StringBuilder();
        if (this.isNotEmpty(data.getFromdate())) {
            where.append(" and MonthlyEndedTime>='").append(StringTools.escapeSql((String)data.getFromdate())).append("' ");
        }
        if (this.isNotEmpty(data.getTodate())) {
            where.append(" and MonthlyEndedTime<='").append(StringTools.escapeSql((String)data.getTodate())).append("' ");
        }
        where.append(" and OrderId = MonthlyOrderId ");
        return this.findPagedObjects(data, where.toString(), fliper);
    }

    @Override
    public void moveExtumpayokinfoToHis(Extumpayokinfo extumpayokinfo) {
        String sql = "insert into extumpayokinfohis(orderid,amount,mobileno,xunleiid,usershow,inputtime,successtime,balancedate,transtype,remark,bizorderstatus,umpaytype) select orderid,amount,mobileno,xunleiid,usershow,inputtime,successtime,balancedate,transtype,remark,bizorderstatus,umpaytype from extumpayokinfo ";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        String delSql = "delete from extumpayokinfo ";
        if (extumpayokinfo != null) {
            if (this.isNotEmpty(extumpayokinfo.getFromdate())) {
                where.append(" and SuccessTime>='").append(extumpayokinfo.getFromdate()).append(" 00:00:00' ");
            }
            if (this.isNotEmpty(extumpayokinfo.getTodate())) {
                where.append(" and SuccessTime<='").append(extumpayokinfo.getTodate()).append(" 23:59:59' ");
            }
        }
        this.execute(sql + where.toString());
        this.execute(delSql + where.toString());
    }

    @Override
    public Sheet<Extumpayokinfo> queryCustomization(Extumpayokinfo data, PagedFliper fliper) {
        StringBuilder where = new StringBuilder();
        if (this.isNotEmpty(data.getXunleiid())) {
            where.append("and Xunleiid = '").append(data.getXunleiid()).append("'");
        }
        if (this.isNotEmpty(data.getUsershow())) {
            where.append("and UserShow = '").append(data.getUsershow()).append("'");
        }
        if (this.isNotEmpty(data.getMobileno())) {
            where.append("and MobileNo = '").append(data.getMobileno()).append("'");
        }
        if (this.isNotEmpty(data.getOrderid())) {
            where.append("and Orderid = '").append(data.getOrderid()).append("'");
        }
        if (this.isNotEmpty(data.getFromdate())) {
            where.append(" and MonthlyEndedTime>='").append(StringTools.escapeSql((String)this.format2YYYYmmdd(data.getFromdate()))).append("' ");
        }
        if (this.isNotEmpty(data.getTodate())) {
            where.append(" and MonthlyEndedTime<='").append(StringTools.escapeSql((String)this.format2YYYYmmdd(data.getTodate()))).append("' ");
        }
        return this.findPagedObjects(data, where.toString(), fliper);
    }

    public String format2YYYYmmdd(String str) {
        StringBuilder sb = new StringBuilder();
        String[] strArray = str.split("-");
        for (int i = 0; i < strArray.length; ++i) {
            sb.append(strArray[i]);
        }
        return sb.toString();
    }

    private Extumpayokinfo findExtumpayInfoByOrderId(Extumpayokinfo data) {
        final Extumpayokinfo result = new Extumpayokinfo();
        StringBuilder sql = new StringBuilder("select seqid,orderid,monthlyorderid from extumpayokinfo where 1=1 ");
        if (this.isNotEmpty(data.getOrderid())) {
            sql.append(" and orderid='").append(data.getOrderid()).append("' ");
        }
        logger.info((Object)("extumpayokinfo.sql==" + sql.toString()));
        this.getJdbcTemplate().query(sql.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                result.setSeqid(resultSet.getInt(1));
                result.setOrderid(resultSet.getString(2));
                result.setMonthlyOrderId(resultSet.getString(3));
            }
        });
        return result;
    }
}

