/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.dao.IExtumpaySettleInfoDao;
import com.xunlei.payproxy.vo.ExtumpaySettleInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowCountCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtumpaySettleInfoDaoImpl
extends JdbcBaseDao
implements IExtumpaySettleInfoDao {
    @Override
    public void deleteExtumpaySettleInfo(ExtumpaySettleInfo data) {
        this.deleteObject(data);
    }

    @Override
    public void deleteExtumpaySettleInfoByIds(long ... ids) {
        this.deleteObject("extumpaysettleinfo", ids);
    }

    @Override
    public ExtumpaySettleInfo findExtumpaySettleInfo(ExtumpaySettleInfo data) {
        return (ExtumpaySettleInfo)this.findObjectByCondition(data);
    }

    @Override
    public ExtumpaySettleInfo findExtumpaySettleInfoById(long id) {
        ExtumpaySettleInfo extumpaySettleInfo = new ExtumpaySettleInfo();
        extumpaySettleInfo.setSeqid(id);
        return (ExtumpaySettleInfo)this.findObject(extumpaySettleInfo);
    }

    @Override
    public void insertExtumpaySettleInfo(ExtumpaySettleInfo data) {
        this.insertObject(data);
    }

    @Override
    public Sheet<ExtumpaySettleInfo> queryExtumpaySettleInfo(ExtumpaySettleInfo data, PagedFliper fliper) {
        StringBuilder where = new StringBuilder();
        if (this.isNotEmpty(data.getFromdate())) {
            where.append(" and settledate>='").append(data.getFromdate() + "'");
        }
        if (this.isNotEmpty(data.getTodate())) {
            where.append(" and settledate<='").append(data.getTodate() + "'");
        }
        return this.findPagedObjects(data, where.toString(), fliper);
    }

    @Override
    public void updateExtumpaySettleInfo(ExtumpaySettleInfo data) {
        this.updateObject(data);
    }

    @Override
    public List<ExtumpaySettleInfo> queryExtumpaySettleInfoByMonth(ExtumpaySettleInfo data) {
        StringBuilder sql = new StringBuilder("select goodsid,SUBSTRING(settledate,1,6) AS settledate,sum(IncreasedSuccessUser) as IncreasedSuccessUser,sum(IncreasedFailUser) as IncreasedFailUser, sum(DepositSuccessUser) as DepositSuccessUser,sum(DepositFailUser) as DepositFailUser,sum(IncreasedQuitUser) as IncreasedQuitUser,sum(ExceptionUser) as ExceptionUser,sum(SuccessAmount) as SuccessAmount from extumpaysettleinfo where 1=1 ");
        final ArrayList<ExtumpaySettleInfo> result = new ArrayList<ExtumpaySettleInfo>();
        if (this.isNotEmpty(data.getFromdate())) {
            sql.append(" and settledate>='").append(data.getFromdate() + "'");
        }
        if (this.isNotEmpty(data.getTodate())) {
            sql.append(" and settledate<='").append(data.getTodate() + "'");
        }
        sql.append(" group by goodsid");
        logger.info((Object)("Extumpaysettleinfo sql==" + sql.toString()));
        this.getJdbcTemplate().query(sql.toString(), (RowCallbackHandler)new RowCountCallbackHandler(){

            protected void processRow(ResultSet rs, int rowNum) throws SQLException {
                while (rs.next()) {
                    ExtumpaySettleInfo info = new ExtumpaySettleInfo();
                    info.setGoodsid(rs.getString("goodsid"));
                    info.setSettleDate(rs.getString("settledate"));
                    info.setIncreasedSuccessUser(rs.getInt("IncreasedSuccessUser"));
                    info.setIncreasedFailUser(rs.getInt("IncreasedFailUser"));
                    info.setDepositSuccessUser(rs.getInt("DepositSuccessUser"));
                    info.setDepositFailUser(rs.getInt("DepositFailUser"));
                    info.setIncreasedQuitUser(rs.getInt("IncreasedQuitUser"));
                    info.setExceptionUser(rs.getInt("ExceptionUser"));
                    info.setSuccessAmount(rs.getInt("SuccessAmount"));
                    info.setIncreasedUser(info.getIncreasedSuccessUser() + info.getIncreasedFailUser());
                    info.setDepositUser(info.getDepositSuccessUser() + info.getDepositFailUser());
                    info.setTotalUser(info.getIncreasedUser() + info.getDepositUser());
                    result.add(info);
                }
            }
        });
        logger.info((Object)("result.size()==" + result.size()));
        return result;
    }

    @Override
    public int queryTotalSuccessUser(ExtumpaySettleInfo data) {
        String sql = "select sum(IncreasedSuccessUser) as IncreasedSuccessUser,sum(IncreasedQuitUser) as IncreasedQuitUser from extumpaysettleinfo ";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (null != data && this.isNotEmpty(data.getTodate())) {
            where.append(" and settledate<='").append(data.getTodate()).append("' ");
        }
        where.append(" group by goodsid");
        sql = sql + where.toString();
        final ExtumpaySettleInfo result = new ExtumpaySettleInfo();
        this.getJdbcTemplate().query(sql, (RowCallbackHandler)new RowCountCallbackHandler(){

            protected void processRow(ResultSet rs, int rowNum) throws SQLException {
                while (rs.next()) {
                    int increasedQuitUser;
                    int increasedSuccessUser = rs.getInt("IncreasedSuccessUser");
                    result.setTotalSuccessUser(increasedSuccessUser - (increasedQuitUser = rs.getInt("IncreasedQuitUser")) < 0 ? 0 : increasedSuccessUser - increasedQuitUser);
                }
            }
        });
        return result.getTotalSuccessUser();
    }

    @Override
    public int deleteSettleInfoBySettleDate(String settledate) {
        String sql = "delete from extumpaysettleinfo where settledate='" + settledate + "'";
        return this.executeUpdate(sql);
    }
}

