/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.dao.IExtumpayDao;
import com.xunlei.payproxy.vo.Extumpay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtumpayDaoImpl
extends JdbcBaseDao
implements IExtumpayDao {
    @Override
    public Extumpay getExtumpayById(long seqid) {
        Extumpay query = new Extumpay();
        query.setSeqid(seqid);
        return (Extumpay)this.findObject(query);
    }

    @Override
    public Extumpay findExtumpay(Extumpay data) {
        return (Extumpay)this.findObjectByCondition(data);
    }

    @Override
    public void insertExtumpay(Extumpay data) {
        this.saveObject(data);
    }

    @Override
    public void updateExtumpay(Extumpay data) {
        this.updateObject(data);
    }

    @Override
    public void updateExtumpay(Extumpay data, String[] includeFields) {
        this.updateObject(data, null, includeFields);
    }

    @Override
    public void deleteExtumpayById(long ... seqids) {
        this.deleteObject("extumpay", seqids);
    }

    @Override
    public void deleteExtumpay(Extumpay data) {
        this.deleteObject(data);
    }

    @Override
    public Sheet<Extumpay> queryExtumpay(Extumpay data, PagedFliper fliper) {
        StringBuilder where = new StringBuilder();
        if (this.isNotEmpty(data.getFromdate())) {
            where.append(" and inputtime>='").append(data.getFromdate()).append(" 00:00:00' ");
        }
        if (this.isNotEmpty(data.getTodate())) {
            where.append(" and inputtime<='").append(data.getTodate()).append(" 23:59:59' ");
        }
        if (this.isNotEmpty(data.getFromFullDate())) {
            where.append(" and inputtime>='").append(data.getFromFullDate()).append("' ");
        }
        if (this.isNotEmpty(data.getToFullDate())) {
            where.append(" and inputtime<='").append(data.getToFullDate()).append("' ");
        }
        return this.findPagedObjects(data, where.toString(), fliper);
    }

    @Override
    public int deleteExtumpayTodate(String todate) {
        if (this.isNotEmpty(todate)) {
            String sql = "delete from extumpay where inputtime<='" + todate + " 23:59:59'";
            return this.executeUpdate(sql);
        }
        return 0;
    }

    @Override
    public int countExtumpayByUmpaytype(String userId, String fromDate, String toDate, String mobileNo) {
        if (this.isNotEmpty(fromDate) && this.isNotEmpty(toDate)) {
            StringBuilder builder = new StringBuilder("select count(1) from extumpay where inputtime>=? and inputtime<=? and ");
            Object[] params = new Object[3];
            params[0] = fromDate;
            params[1] = toDate;
            if (userId != null) {
                builder.append(" xunleiId=?");
                params[2] = userId;
            }
            if (mobileNo != null) {
                builder.append(" mobileNo=?");
                params[2] = mobileNo;
            }
            return this.getJdbcTemplate().queryForInt(builder.toString(), params);
        }
        return 0;
    }
}

