/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.dao.BaseDao;
import com.xunlei.payproxy.dao.IExtalipayDao;
import com.xunlei.payproxy.vo.Extalipay;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtalipayDaoImpl
extends BaseDao
implements IExtalipayDao {
    @Override
    public void deleteExtalipay(Extalipay data) {
        if (data == null || data.getSeqId() <= 0L) {
            return;
        }
        this.deleteExtalipayById(data.getSeqId());
    }

    @Override
    public void deleteExtalipayById(long ... seqids) {
        this.deleteObject("extalipay", seqids);
    }

    @Override
    public Extalipay findExtalipay(Extalipay data) {
        String sql = "select * from extalipay";
        String countsql = "select count(1) from extalipay";
        StringBuilder where = new StringBuilder(" where 1=1");
        if (data != null) {
            if (data.getSeqId() > 0L) {
                return this.getExtalipayById(data.getSeqId());
            }
            if (this.isNotEmpty(data.getOrderId())) {
                where.append(" and orderid = '").append(data.getOrderId()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiPayId())) {
                where.append(" and XunleiPayId = '").append(data.getXunleiPayId()).append("' ");
            }
            if (this.isNotEmpty(data.getBankNo())) {
                where.append(" and BankNo = '").append(data.getBankNo()).append("' ");
            }
            if (data.getOrderAmt() != 0.0) {
                where.append(" and OrderAmt = '").append(data.getOrderAmt()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiId())) {
                where.append(" and XunleiId = '").append(data.getXunleiId()).append("' ");
            }
            if (this.isNotEmpty(data.getUserShow())) {
                where.append(" and Usershow = '").append(data.getUserShow()).append("' ");
            }
            if (this.isNotEmpty(data.getRoyalty())) {
                where.append(" and royalty = '").append(data.getRoyalty()).append("' ");
            }
            if (this.isNotEmpty(data.getExt1())) {
                where.append(" and Ext1 = '").append(data.getExt1()).append("' ");
            }
            if (this.isNotEmpty(data.getExt2())) {
                where.append(" and Ext2 = '").append(data.getExt2()).append("' ");
            }
            if (this.isNotEmpty(data.getInputTime())) {
                where.append(" and InputTime = '").append(data.getInputTime()).append("' ");
            }
            if (this.isNotEmpty(data.getInputIp())) {
                where.append(" and InputIp = '").append(data.getInputIp()).append("' ");
            }
            if (this.isNotEmpty(data.getExtalipayStatus())) {
                where.append(" and ExtalipayStatus = '").append(data.getExtalipayStatus()).append("' ");
            }
            if (this.isNotEmpty(data.getErrcode())) {
                where.append(" and Errcode = '").append(data.getErrcode()).append("' ");
            }
            if (this.isNotEmpty(data.getTradeNo())) {
                where.append(" and TradeNo = '").append(data.getTradeNo()).append("' ");
            }
            if (this.isNotEmpty(data.getDealTime())) {
                where.append(" and dealTime = '").append(data.getDealTime()).append("' ");
            }
            if (this.isNotEmpty(data.getRemark())) {
                where.append(" and Remark = '").append(data.getRemark()).append("' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and inputtime >= '").append(data.getFromdate()).append(" 00:00:00' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and inputtime <= '").append(data.getTodate()).append(" 23:59:59' ");
            }
            if (this.isNotEmpty(data.getErrcode())) {
                where.append(" and errcode='").append(data.getErrcode()).append("' ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            countsql = countsql + where.toString();
            sql = sql + where.toString();
            if (this.getSingleInt(countsql) == 1) {
                return (Extalipay)this.queryOne(Extalipay.class, sql, new String[0]);
            }
        }
        return null;
    }

    @Override
    public Extalipay getExtalipayById(long seqid) {
        return (Extalipay)this.findObject(Extalipay.class, seqid);
    }

    @Override
    public List<Extalipay> getExtalipaysByOrderId(String orderId) {
        String sql = "select p from Extalipay as p where p.orderid = ?";
        return this.getHibernateTemplate().find(sql, (Object)orderId);
    }

    @Override
    public List<Extalipay> getLastExtalipay(Extalipay data) {
        String sql = "select p from Extalipay as p where p.usershow=? and p.extalipaystatus=? order by inputtime desc";
        Object[] o = new Object[]{data.getUserShow(), data.getExtalipayStatus()};
        return this.getHibernateTemplate().find(sql, o);
    }

    @Override
    public void insertExtalipay(Extalipay data) {
        this.insertObject(data);
    }

    @Override
    public Sheet<Extalipay> queryExtalipay(Extalipay data, PagedFliper fliper) {
        int rowcount;
        String sql = "select * from extalipay";
        String countsql = "select count(1) from extalipay";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (data != null) {
            if (data.getSeqId() != 0L) {
                where.append(" and seqId = '").append(data.getSeqId()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderId())) {
                where.append(" and orderId = '").append(data.getOrderId()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiPayId())) {
                where.append(" and XunleiPayId = '").append(data.getXunleiPayId()).append("' ");
            }
            if (data.getBankNo() != null && !data.getBankNo().equals("-1")) {
                where.append(" and BankNo = '").append(data.getBankNo()).append("' ");
            }
            if (data.getOrderAmt() != 0.0) {
                where.append(" and OrderAmt = '").append(data.getOrderAmt()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiId())) {
                where.append(" and XunleiId = '").append(data.getXunleiId()).append("' ");
            }
            if (this.isNotEmpty(data.getUserShow())) {
                where.append(" and Usershow = '").append(data.getUserShow()).append("' ");
            }
            if (this.isNotEmpty(data.getRoyalty())) {
                where.append(" and royalty = '").append(data.getRoyalty()).append("' ");
            }
            if (this.isNotEmpty(data.getExt1())) {
                where.append(" and Ext1 = '").append(data.getExt1()).append("' ");
            }
            if (this.isNotEmpty(data.getExt2())) {
                where.append(" and Ext2 = '").append(data.getExt2()).append("' ");
            }
            if (this.isNotEmpty(data.getInputTime())) {
                where.append(" and InputTime = '").append(data.getInputTime()).append("' ");
            }
            if (this.isNotEmpty(data.getInputIp())) {
                where.append(" and InputIp = '").append(data.getInputIp()).append("' ");
            }
            if (this.isNotEmpty(data.getExtalipayStatus())) {
                where.append(" and ExtalipayStatus = '").append(data.getExtalipayStatus()).append("' ");
            }
            if (this.isNotEmpty(data.getErrcode())) {
                where.append(" and Errcode = '").append(data.getErrcode()).append("' ");
            }
            if (this.isNotEmpty(data.getTradeNo())) {
                where.append(" and TradeNo = '").append(data.getTradeNo()).append("' ");
            }
            if (this.isNotEmpty(data.getDealTime())) {
                where.append(" and dealTime = '").append(data.getDealTime()).append("' ");
            }
            if (this.isNotEmpty(data.getRemark())) {
                where.append(" and Remark = '").append(data.getRemark()).append("' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and inputtime >= '").append(data.getFromdate()).append(" 00:00:00' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and inputtime <= '").append(data.getTodate()).append(" 23:59:59' ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = countsql + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet(rowcount, (Collection)this.query(Extalipay.class, sql, new String[0]));
    }

    @Override
    public void updateExtalipay(Extalipay data) {
        this.updateObject(data);
    }

    @Override
    public Extalipay getExtalipayByOrderId(String orderId) {
        if (orderId == null) {
            return null;
        }
        String sql = "select * from extalipay where 1=1 and orderid='" + orderId + "'";
        return (Extalipay)this.queryOne(Extalipay.class, sql, new String[0]);
    }

    @Override
    public int deleteExtalipayTodate(String todate, String extalipayStatus) {
        if (this.isNotEmpty(todate) && this.isNotEmpty(extalipayStatus)) {
            String sql = "delete from extalipay where inputtime<='" + todate + " 23:59:59' and ExtalipayStatus='" + extalipayStatus + "' ";
            return this.executeUpdate(sql);
        }
        return 0;
    }

    @Override
    public Extalipay queryExtalipaySum(Extalipay data) {
        StringBuilder where = new StringBuilder("select sum(orderamt) as orderamt from extalipay where 1=1 ");
        if (data != null) {
            if (data.getSeqId() != 0L) {
                where.append(" and SeqId = '").append(data.getSeqId()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderId())) {
                where.append(" and OrderId = '").append(data.getOrderId()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiPayId())) {
                where.append(" and XunleiPayId = '").append(data.getXunleiPayId()).append("' ");
            }
            if (data.getBankNo() != null && !data.getBankNo().equals("-1")) {
                where.append(" and BankNo = '").append(data.getBankNo()).append("' ");
            }
            if (data.getOrderAmt() != 0.0) {
                where.append(" and OrderAmt = '").append(data.getOrderAmt()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiId())) {
                where.append(" and XunleiId = '").append(data.getXunleiId()).append("' ");
            }
            if (this.isNotEmpty(data.getUserShow())) {
                where.append(" and Usershow = '").append(data.getUserShow()).append("' ");
            }
            if (this.isNotEmpty(data.getRoyalty())) {
                where.append(" and royalty = '").append(data.getRoyalty()).append("' ");
            }
            if (this.isNotEmpty(data.getExt1())) {
                where.append(" and Ext1 = '").append(data.getExt1()).append("' ");
            }
            if (this.isNotEmpty(data.getExt2())) {
                where.append(" and Ext2 = '").append(data.getExt2()).append("' ");
            }
            if (this.isNotEmpty(data.getInputTime())) {
                where.append(" and InputTime = '").append(data.getInputTime()).append("' ");
            }
            if (this.isNotEmpty(data.getInputIp())) {
                where.append(" and InputIp = '").append(data.getInputIp()).append("' ");
            }
            if (this.isNotEmpty(data.getExtalipayStatus())) {
                where.append(" and ExtalipayStatus='").append(data.getExtalipayStatus()).append("' ");
            }
            if (this.isNotEmpty(data.getErrcode())) {
                where.append(" and Errcode='").append(data.getErrcode()).append("' ");
            }
            if (this.isNotEmpty(data.getTradeNo())) {
                where.append(" and TradeNo = '").append(data.getTradeNo()).append("' ");
            }
            if (this.isNotEmpty(data.getDealTime())) {
                where.append(" and dealTime = '").append(data.getDealTime()).append("' ");
            }
            if (this.isNotEmpty(data.getRemark())) {
                where.append(" and Remark = '").append(data.getRemark()).append("' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and InputTime >= '").append(data.getFromdate()).append(" ' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and InputTime <= '").append(data.getTodate()).append(" ' ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            if (this.isNotEmpty(data.getSelleremail())) {
                where.append(" and sellerEmail='").append(data.getSelleremail()).append("' ");
            }
        }
        final Extalipay result = new Extalipay();
        this.getJdbcTemplate().query(where.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                result.setOrderAmt(resultSet.getDouble(1));
            }
        });
        return result;
    }
}

