/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.dao.IExtWechatMonthSignReqDao;
import com.xunlei.payproxy.vo.ExtWechatMonthSignReq;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtWechatMonthSignReqDaoImpl
extends JdbcBaseDao
implements IExtWechatMonthSignReqDao {
    private static final Logger logger = LoggerFactory.getLogger(ExtWechatMonthSignReqDaoImpl.class);

    @Override
    public ExtWechatMonthSignReq findExtWechatMonthSignReq(ExtWechatMonthSignReq data) {
        return (ExtWechatMonthSignReq)this.findObjectByCondition(data);
    }

    @Override
    public ExtWechatMonthSignReq findExtWechatMonthSignReqById(long id) {
        logger.debug("findExtWechatMonthSignReqById...id:{}", (Object)id);
        ExtWechatMonthSignReq data = new ExtWechatMonthSignReq();
        data.setSeqId(id);
        return this.findExtWechatMonthSignReq(data);
    }

    @Override
    public Sheet<ExtWechatMonthSignReq> queryExtWechatMonthSignReq(ExtWechatMonthSignReq data, PagedFliper fliper) {
        String sql = "SELECT * FROM";
        String sqlcount = "SELECT COUNT(1) FROM";
        StringBuffer wheresql = new StringBuffer(" extwechatmonthsignreq req WHERE req.signStatus = 'FAIL' ");
        if (this.isNotEmpty(data.getExternalSignNo())) {
            wheresql.append(" AND req.externalSignNo = '").append(data.getExternalSignNo()).append("'");
        }
        if (this.isNotEmpty(data.getXunleiId())) {
            wheresql.append(" AND req.xunleiId = '").append(data.getXunleiId()).append("'");
        }
        if (this.isNotEmpty(data.getUserShow())) {
            wheresql.append(" AND req.userShow = '").append(data.getUserShow()).append("'");
        }
        if (this.isNotEmpty(data.getBeginDate())) {
            wheresql.append(" AND req.requestTime >= '").append(data.getBeginDate().trim()).append(" 00:00:00").append("'");
        }
        if (this.isNotEmpty(data.getEndDate())) {
            wheresql.append(" AND req.requestTime <= '").append(data.getEndDate().trim()).append(" 23:59:59").append("'");
        }
        sqlcount = sqlcount + wheresql.toString();
        int counts = this.getSingleInt(sqlcount);
        logger.info("sql count: {}", (Object)sqlcount);
        if (counts <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + wheresql.toString();
        logger.info("sql: {}", (Object)sql);
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " ORDER BY " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(counts);
        }
        return new Sheet(counts, (Collection)this.query(ExtWechatMonthSignReq.class, sql, new String[0]));
    }

    @Override
    public void updateExtWechatMonthSignReq(ExtWechatMonthSignReq data) {
        this.updateObject(data);
    }

    @Override
    public void deleteExtWechatMonthSignReqById(long id) {
        logger.info("deleteExtWechatMonthSignReqById...id:{}", (Object)id);
        this.deleteObject("extwechatmonthsignreq", new long[]{id});
    }

    @Override
    public void insertExtWechatMonthSignReq(ExtWechatMonthSignReq extWechatMonthSignReq) {
        this.insertObject(extWechatMonthSignReq);
    }

    @Override
    public synchronized String updateWechatMonthSignReqSuccessTimes(String xunleiId, String bizNo) {
        ExtWechatMonthSignReq query = new ExtWechatMonthSignReq();
        query.setXunleiId(xunleiId);
        query.setBizNo(bizNo);
        ExtWechatMonthSignReq result = (ExtWechatMonthSignReq)this.findObjectByCondition(query);
        if (null != result) {
            result.setSuccessTimes(result.getSuccessTimes() + 1);
            this.updateExtWechatMonthSignReq(result);
            return "SUCCESS";
        }
        return "FAIL";
    }

    public String addOneMonth(String inputTime) {
        try {
            SimpleDateFormat formatYMD = new SimpleDateFormat("yyyy-MM-dd");
            Date inputDate = formatYMD.parse(inputTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(inputDate);
            calendar.add(5, 31);
            return formatYMD.format(calendar.getTime());
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff0c\u53c2\u6570inputTime: {} \u4e0d\u6b63\u786e\uff01", (Object)inputTime);
            return null;
        }
    }

    @Override
    public synchronized String updateWechatMonthSignReqFailTimes(String xunleiId, String bizNo) {
        ExtWechatMonthSignReq query = new ExtWechatMonthSignReq();
        query.setXunleiId(xunleiId);
        query.setBizNo(bizNo);
        ExtWechatMonthSignReq result = (ExtWechatMonthSignReq)this.findObjectByCondition(query);
        if (null != result) {
            result.setFailedTimes(result.getFailedTimes() + 1);
            this.updateExtWechatMonthSignReq(result);
            return "SUCCESS";
        }
        return "FAIL";
    }
}

