/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.dao.IExtWechatMonthOkDao;
import com.xunlei.payproxy.vo.ExtWechatMonthPayOk;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtWechatMonthOkDaoImpl
extends JdbcBaseDao
implements IExtWechatMonthOkDao {
    private Logger logger = LoggerFactory.getLogger(ExtWechatMonthOkDaoImpl.class);

    @Override
    public ExtWechatMonthPayOk findExtWechatMonthOk(ExtWechatMonthPayOk data) {
        return (ExtWechatMonthPayOk)this.findObjectByCondition(data);
    }

    @Override
    public ExtWechatMonthPayOk findExtWechatMonthOkById(long id) {
        this.logger.debug("findExtWechatMonthOkById...id:{}", (Object)id);
        ExtWechatMonthPayOk data = new ExtWechatMonthPayOk();
        data.setSeqId(id);
        return this.findExtWechatMonthOk(data);
    }

    @Override
    public Sheet<ExtWechatMonthPayOk> queryExtWechatMonthOk(ExtWechatMonthPayOk data, PagedFliper fliper) {
        String sql = "SELECT * FROM";
        String sqlcount = "SELECT COUNT(1) FROM";
        String sqlsum = "SELECT IFNULL(SUM(amount),0) AS orderAmt, IFNULL(SUM(factAmount),0) AS factAmt, IFNULL(SUM(fareAmount),0) AS fareAmt FROM";
        StringBuffer wheresql = new StringBuffer(" extwechatmonthpayok where 1=1 ");
        if (this.isNotEmpty(data.getOrderId())) {
            wheresql.append(" AND orderId='").append(data.getOrderId()).append("'");
        }
        if (this.isNotEmpty(data.getXunleiId())) {
            wheresql.append(" AND xunleiId='").append(data.getXunleiId()).append("'");
        }
        if (this.isNotEmpty(data.getUserShow())) {
            wheresql.append(" AND userShow='").append(data.getUserShow()).append("'");
        }
        if (this.isNotEmpty(data.getBeginDate())) {
            wheresql.append(" AND successTime >= '").append(data.getBeginDate()).append(" 00:00:00'");
        }
        if (this.isNotEmpty(data.getEndDate())) {
            wheresql.append(" AND successTime <= '").append(data.getEndDate()).append(" 23:59:59'");
        }
        sqlcount = sqlcount + wheresql.toString();
        int counts = this.getSingleInt(sqlcount);
        this.logger.info("sql count: {}", (Object)sqlcount);
        if (counts <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + wheresql.toString();
        this.logger.info("sql: {}", (Object)sql);
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(counts);
        }
        List list = this.query(ExtWechatMonthPayOk.class, sql, new String[0]);
        sqlsum = sqlsum + wheresql.toString();
        final ExtWechatMonthPayOk result = new ExtWechatMonthPayOk();
        this.getJdbcTemplate().query(sqlsum, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                result.setOrderId("\u603b\u8ba1");
                result.setAmount(resultSet.getDouble(1));
                result.setFactAmount(resultSet.getDouble(2));
                result.setFareAmount(resultSet.getDouble(3));
            }
        });
        list.add(result);
        return new Sheet(counts, (Collection)list);
    }

    @Override
    public void updateExtWechatMonthOk(ExtWechatMonthPayOk data) {
        this.updateObject(data);
    }

    @Override
    public void deleteExtWechatMonthOkById(long id) {
        this.logger.info("deleteExtWechatMonthOkById...id:{}", (Object)id);
        this.deleteObject("extwechatmonthpayok", new long[]{id});
    }

    @Override
    public void insertExtWechatMonthOk(ExtWechatMonthPayOk extWechatMonthOk) {
        this.insertObject(extWechatMonthOk);
    }
}

