/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.dao.IExtWechatHongbaoRecordDao;
import com.xunlei.payproxy.vo.ExtWechatHongbaoRecord;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtWechatHongbaoRecordDaoImpl
extends JdbcBaseDao
implements IExtWechatHongbaoRecordDao {
    private Logger logger = LoggerFactory.getLogger(ExtWechatHongbaoRecordDaoImpl.class);

    @Override
    public ExtWechatHongbaoRecord findExtWechatHongbaoRecord(ExtWechatHongbaoRecord data) {
        return (ExtWechatHongbaoRecord)this.findObjectByCondition(data);
    }

    @Override
    public ExtWechatHongbaoRecord findExtWechatHongbaoRecordById(long id) {
        this.logger.debug("findExtWechatHongbaoRecordById...id:{}", (Object)id);
        ExtWechatHongbaoRecord data = new ExtWechatHongbaoRecord();
        data.setSeqId(id);
        return this.findExtWechatHongbaoRecord(data);
    }

    @Override
    public Sheet<ExtWechatHongbaoRecord> queryExtWechatHongbaoRecord(ExtWechatHongbaoRecord data, PagedFliper fliper) {
        String sql = "SELECT * FROM";
        String sqlcount = "SELECT COUNT(1) FROM";
        String sqlReceivedAmountSum = "SELECT IFNULL(SUM(receivedAmount),0) AS receivedAmount, IFNULL(SUM(receivedCount),0) AS receivedCount FROM";
        String sqlHongbaoAmountSum = "SELECT DISTINCT xunleiPayId,hongbaoAmount,hongbaoCount FROM";
        StringBuffer whereSql = new StringBuffer(" extwechathongbaorecord WHERE 1=1 ");
        if (this.isNotEmpty(data.getBizNo())) {
            whereSql.append(" AND bizNo = '").append(data.getBizNo()).append("'");
        }
        if (this.isNotEmpty(data.getOrderId())) {
            whereSql.append(" AND orderId = '").append(data.getOrderId()).append("'");
        }
        if (this.isNotEmpty(data.getType())) {
            whereSql.append(" AND type = '").append(data.getType()).append("'");
        }
        if (this.isNotEmpty(data.getMchId())) {
            whereSql.append(" AND mchId = '").append(data.getMchId()).append("'");
        }
        if (this.isNotEmpty(data.getWxappId())) {
            whereSql.append(" AND wxappId = '").append(data.getWxappId()).append("'");
        }
        if (this.isNotEmpty(data.getBeginDate())) {
            whereSql.append(" AND receivedTime >= '").append(data.getBeginDate()).append(" 00:00:00'");
        }
        if (this.isNotEmpty(data.getEndDate())) {
            whereSql.append(" AND receivedTime <= '").append(data.getEndDate()).append(" 23:59:59'");
        }
        sqlcount = sqlcount + whereSql.toString();
        int counts = this.getSingleInt(sqlcount);
        this.logger.info("sql count: {}", (Object)sqlcount);
        if (counts <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + whereSql.toString();
        this.logger.info("sql: {}", (Object)sql);
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " ORDER BY " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(counts);
        }
        List list = this.query(ExtWechatHongbaoRecord.class, sql, new String[0]);
        sqlReceivedAmountSum = sqlReceivedAmountSum + whereSql.toString();
        sqlHongbaoAmountSum = sqlHongbaoAmountSum + whereSql.toString();
        StringBuilder builder = new StringBuilder("SELECT IFNULL(SUM(t.hongbaoAmount),0) AS hongbaoAmt,IFNULL(SUM(t.hongbaoCount),0) AS hongbaoCnt FROM ( ");
        builder.append(sqlHongbaoAmountSum).append(" ) AS t");
        this.logger.info("builder: {}", (Object)builder.toString());
        final ExtWechatHongbaoRecord result = new ExtWechatHongbaoRecord();
        this.getJdbcTemplate().query(sqlReceivedAmountSum, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                result.setOrderId("\u603b\u8ba1");
                result.setReceivedAmount(resultSet.getInt(1));
                result.setReceivedCount(resultSet.getInt(2));
            }
        });
        this.getJdbcTemplate().query(builder.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                result.setHongbaoAmount(resultSet.getInt(1));
                result.setHongbaoCount(resultSet.getInt(2));
            }
        });
        list.add(result);
        return new Sheet(counts, (Collection)list);
    }

    @Override
    public void updateExtWechatHongbaoRecord(ExtWechatHongbaoRecord data) {
        this.updateObject(data);
    }

    @Override
    public void deleteExtWechatHongbaoRecordById(long id) {
        this.logger.info("deleteExtWechatHongbaoRecordById...id:{}", (Object)id);
        this.deleteObject("extwechathongbaorecord", new long[]{id});
    }

    @Override
    public void insertExtWechatHongbaoRecord(ExtWechatHongbaoRecord data) {
        this.insertObject(data);
    }
}

