/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.dao.IExtWechatHongbaoDao;
import com.xunlei.payproxy.vo.ExtWechatHongbao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtWechatHongbaoDaoImpl
extends JdbcBaseDao
implements IExtWechatHongbaoDao {
    private Logger logger = LoggerFactory.getLogger(ExtWechatHongbaoDaoImpl.class);

    @Override
    public ExtWechatHongbao findExtWechatHongbao(ExtWechatHongbao data) {
        return (ExtWechatHongbao)this.findObjectByCondition(data);
    }

    @Override
    public ExtWechatHongbao findExtWechatHongbaoById(long id) {
        this.logger.debug("findExtWechatHongbaoById...id:{}", (Object)id);
        ExtWechatHongbao data = new ExtWechatHongbao();
        data.setSeqId(id);
        return this.findExtWechatHongbao(data);
    }

    @Override
    public Sheet<ExtWechatHongbao> queryExtWechatHongbao(ExtWechatHongbao data, PagedFliper fliper) {
        String sql = "SELECT * FROM";
        String sqlcount = "SELECT COUNT(1) FROM";
        String sqlsum = "SELECT IFNULL(SUM(hongbaoAmount),0) AS hongbaoAmount, IFNULL(SUM(hongbaoCount),0) AS hongbaoCount FROM";
        StringBuffer wheresql = new StringBuffer(" extwechathongbao WHERE hongbaoStatus <> 'SUCCESS' AND hongbaoStatus <> 'NONEXIST' ");
        if (this.isNotEmpty(data.getBizNo())) {
            wheresql.append(" AND bizNo = '").append(data.getBizNo()).append("'");
        }
        if (this.isNotEmpty(data.getOrderId())) {
            wheresql.append(" AND orderId = '").append(data.getOrderId()).append("'");
        }
        if (this.isNotEmpty(data.getType())) {
            wheresql.append(" AND type = '").append(data.getType()).append("'");
        }
        if (this.isNotEmpty(data.getMchId())) {
            wheresql.append(" AND mchId = '").append(data.getMchId()).append("'");
        }
        if (this.isNotEmpty(data.getWxappId())) {
            wheresql.append(" AND wxappId = '").append(data.getWxappId()).append("'");
        }
        if (this.isNotEmpty(data.getBeginDate())) {
            wheresql.append(" AND createTime >= '").append(data.getBeginDate()).append(" 00:00:00'");
        }
        if (this.isNotEmpty(data.getEndDate())) {
            wheresql.append(" AND createTime <= '").append(data.getEndDate()).append(" 23:59:59'");
        }
        sqlcount = sqlcount + wheresql.toString();
        int counts = this.getSingleInt(sqlcount);
        this.logger.info("sql count: {}", (Object)sqlcount);
        if (counts <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + wheresql.toString();
        this.logger.info("sql: {}", (Object)sql);
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " ORDER BY " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(counts);
        }
        List list = this.query(ExtWechatHongbao.class, sql, new String[0]);
        sqlsum = sqlsum + wheresql.toString();
        final ExtWechatHongbao result = new ExtWechatHongbao();
        this.getJdbcTemplate().query(sqlsum, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                result.setOrderId("\u603b\u8ba1");
                result.setHongbaoAmount(resultSet.getInt(1));
                result.setHongbaoCount(resultSet.getInt(2));
            }
        });
        list.add(result);
        return new Sheet(counts, (Collection)list);
    }

    @Override
    public void updateExtWechatHongbao(ExtWechatHongbao data) {
        this.updateObject(data);
    }

    @Override
    public void deleteExtWechatHongbaoById(long id) {
        this.logger.info("deleteExtWechatHongbaoById...id:{}", (Object)id);
        this.deleteObject("extwechathongbao", new long[]{id});
    }

    @Override
    public void insertExtWechatHongbao(ExtWechatHongbao data) {
        this.insertObject(data);
    }

    @Override
    public int findExtWechatHongbaoCount() {
        String sqlcount = "SELECT COUNT(1) FROM extwechathongbao WHERE hongbaoStatus <> 'SUCCESS' AND hongbaoStatus <> 'NONEXIST'";
        this.logger.info("findExtWechatHongbaoCount#sqlcount: {}", (Object)sqlcount);
        return this.getSingleInt(sqlcount);
    }

    @Override
    public List<ExtWechatHongbao> findExtWechatHongbaoList(int start, int length) {
        final ArrayList<ExtWechatHongbao> reqList = new ArrayList<ExtWechatHongbao>();
        String sql = "SELECT mchId,wxappId,orderId,sendName,clientIp,ext1,ext2,other1,other2,other3,bizNo,xunleiPayId FROM extwechathongbao WHERE hongbaoStatus <> 'SUCCESS' AND hongbaoStatus <> 'NONEXIST' LIMIT " + start + ", " + length;
        this.logger.info("findExtWechatHongbaoList#sql: {}", (Object)sql);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                ExtWechatHongbao item = new ExtWechatHongbao();
                item.setMchId(resultSet.getString("mchId"));
                item.setWxappId(resultSet.getString("wxappId"));
                item.setOrderId(resultSet.getString("orderId"));
                item.setSendName(resultSet.getString("sendName"));
                item.setClientIp(resultSet.getString("clientIp"));
                item.setExt1(resultSet.getString("ext1"));
                item.setExt2(resultSet.getString("ext2"));
                item.setOther1(resultSet.getString("other1"));
                item.setOther2(resultSet.getString("other2"));
                item.setOther3(resultSet.getString("other3"));
                item.setBizNo(resultSet.getString("bizNo"));
                item.setXunleiPayId(resultSet.getString("xunleiPayId"));
                reqList.add(item);
            }
        });
        return reqList;
    }

    @Override
    public int findExtWechatHongbaoYesterdayCount(String yesterday) {
        String begin = yesterday + " 00:00:00";
        String end = yesterday + " 23:59:59";
        String sqlcount = "SELECT COUNT(1) FROM extwechathongbao WHERE hongbaoStatus <> 'SUCCESS' AND hongbaoStatus <> 'NONEXIST' AND createTime BETWEEN '" + begin + "' AND '" + end + "'";
        this.logger.info("findExtWechatHongbaoYesterdayCount#sqlcount: {}", (Object)sqlcount);
        return this.getSingleInt(sqlcount);
    }

    @Override
    public List<ExtWechatHongbao> findExtWechatHongbaoYesterdayList(int start, int length, String yesterday) {
        String begin = yesterday + " 00:00:00";
        String end = yesterday + " 23:59:59";
        final ArrayList<ExtWechatHongbao> reqList = new ArrayList<ExtWechatHongbao>();
        String sql = "SELECT mchId,wxappId,orderId,sendName,clientIp,ext1,ext2,other1,other2,other3,bizNo,xunleiPayId FROM extwechathongbao WHERE hongbaoStatus <> 'SUCCESS' AND hongbaoStatus <> 'NONEXIST' AND createTime BETWEEN '" + begin + "' AND '" + end + "' LIMIT " + start + ", " + length;
        this.logger.info("findExtWechatHongbaoYesterdayList#sql: {}", (Object)sql);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                ExtWechatHongbao item = new ExtWechatHongbao();
                item.setMchId(resultSet.getString("mchId"));
                item.setWxappId(resultSet.getString("wxappId"));
                item.setOrderId(resultSet.getString("orderId"));
                item.setSendName(resultSet.getString("sendName"));
                item.setClientIp(resultSet.getString("clientIp"));
                item.setExt1(resultSet.getString("ext1"));
                item.setExt2(resultSet.getString("ext2"));
                item.setOther1(resultSet.getString("other1"));
                item.setOther2(resultSet.getString("other2"));
                item.setOther3(resultSet.getString("other3"));
                item.setBizNo(resultSet.getString("bizNo"));
                item.setXunleiPayId(resultSet.getString("xunleiPayId"));
                reqList.add(item);
            }
        });
        return reqList;
    }
}

