/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.payproxy.dao.IExtJingdongPayDao;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.util.Arith;
import com.xunlei.payproxy.util.XLPayProxyRuntimeException;
import com.xunlei.payproxy.vo.Bizorderok;
import com.xunlei.payproxy.vo.ExtJingdongPay;
import com.xunlei.payproxy.vo.ExtJingdongPayOk;
import java.math.BigDecimal;

public class ExtJingdongPayDaoImpl
extends JdbcBaseDao
implements IExtJingdongPayDao {
    public void deleteExtJingdongPayById(long id) {
        this.deleteObject("extjingdongpay", new long[]{id});
    }

    public void insertExtJingdongPay(ExtJingdongPay extJingdongPay) {
        this.insertObject(extJingdongPay);
    }

    public ExtJingdongPay findExtJingdongPay(ExtJingdongPay extJingdongPay) {
        return (ExtJingdongPay)this.findObjectByCondition(extJingdongPay);
    }

    public ExtJingdongPay findExtJingdongPayByXunleiPayId(String xunleiPayId) {
        ExtJingdongPay extJingdongPay = new ExtJingdongPay();
        extJingdongPay.setXunleiPayId(xunleiPayId);
        return (ExtJingdongPay)this.findObjectByCondition(extJingdongPay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveExtJingdongPayToSuccess(ExtJingdongPayOk extJingdongPayOk) {
        String xunleiPayId = extJingdongPayOk.getXunleiPayId();
        logger.info((Object)("moveExtJingdongPayToSuccess start...xunleiPayId: " + xunleiPayId));
        String string = xunleiPayId.intern();
        synchronized (string) {
            try {
                ExtJingdongPay query = new ExtJingdongPay();
                query.setXunleiPayId(xunleiPayId);
                ExtJingdongPay extJingdongPay = this.findExtJingdongPay(query);
                if (extJingdongPay == null) {
                    logger.info((Object)("cannot find extJingdongPay by xunleiPayId: " + extJingdongPay.getXunleiPayId()));
                    throw new XLPayProxyRuntimeException("\u8ba2\u5355\u53f7[" + extJingdongPay.getXunleiPayId() + "]\u4e0d\u5b58\u5728");
                }
                double sub = Arith.sub(extJingdongPayOk.getOrderAmt(), extJingdongPay.getOrderAmt());
                logger.info((Object)("extJingdongPay...account receivable:" + extJingdongPay.getOrderAmt() + ",real_income:" + extJingdongPayOk.getOrderAmt() + ",sub=" + sub));
                if (Math.abs(sub) >= 0.01) {
                    logger.info((Object)("extJingdongPay...money mismatch...xunleiPayId: " + xunleiPayId));
                    throw new XLPayProxyRuntimeException("payedamt is not correct");
                }
                IFacade payproxyfacade = IFacade.INSTANCE;
                payproxyfacade.moveBizorderToSuccess(extJingdongPayOk.getXunleiPayId());
                logger.info((Object)("save extJingdongPayOk...xunleiPayId: " + extJingdongPayOk.getXunleiPayId()));
                payproxyfacade.insertExtJingdongPayOk(extJingdongPayOk);
                logger.debug((Object)("delete extJingdongPay by seqid: " + extJingdongPay.getSeqid()));
                payproxyfacade.deleteExtJingdongPayById(extJingdongPay.getSeqid());
                Bizorderok bizorderokForQuery = new Bizorderok();
                bizorderokForQuery.setXunleipayid(extJingdongPayOk.getXunleiPayId());
                Bizorderok bizorderok = IFacade.INSTANCE.findBizorderok(bizorderokForQuery);
                if (bizorderok != null) {
                    BigDecimal channelAmt = new BigDecimal(extJingdongPayOk.getOrderAmt());
                    BigDecimal generalAmt = channelAmt.divide(new BigDecimal(100));
                    bizorderok.setFareamt(generalAmt.doubleValue());
                    IFacade.INSTANCE.updateBizorderok(bizorderok);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new XLPayProxyRuntimeException(e);
            }
            finally {
                logger.info((Object)"moveExtJingdongPayToSuccess end");
            }
        }
    }
}

