/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.dao.IExtBaiduWalletOkDao;
import com.xunlei.payproxy.vo.ExtBaiduWalletOk;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtBaiduWalletOkDaoImpl
extends JdbcBaseDao
implements IExtBaiduWalletOkDao {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void save(ExtBaiduWalletOk data) {
        this.saveObject(data);
    }

    @Override
    public Sheet<ExtBaiduWalletOk> queryExtBaiduWalletOk(ExtBaiduWalletOk data, PagedFliper fliper) {
        String sql = "select * from extbaiduwalletok";
        String sqlCount = "select count(1) from extbaiduwalletok";
        String whereSql = this.generateWhereSql(data);
        sqlCount = sqlCount + whereSql;
        this.logger.debug("query...count_sql:{}", (Object)sqlCount);
        int counts = this.getSingleInt(sqlCount);
        if (counts <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + whereSql;
        this.logger.debug("query...sql:{}", (Object)sql);
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(counts);
        }
        return new Sheet(counts, (Collection)this.query(ExtBaiduWalletOk.class, sql, new String[0]));
    }

    private String generateWhereSql(ExtBaiduWalletOk data) {
        StringBuilder wheresql = new StringBuilder(" where 1=1");
        if (data.getSeqid() != 0L) {
            wheresql.append(" And SeqId=").append(data.getSeqid());
        }
        if (this.isNotEmpty(data.getOrderId())) {
            wheresql.append(" And OrderId='").append(data.getOrderId()).append("'");
        }
        if (this.isNotEmpty(data.getBankCode())) {
            wheresql.append(" And BankCode='").append(data.getBankCode()).append("'");
        }
        if (this.isNotEmpty(data.getXunleiId())) {
            wheresql.append(" And XunleiId='").append(data.getXunleiId()).append("'");
        }
        if (this.isNotEmpty(data.getUserShow())) {
            wheresql.append(" And UserShow='").append(data.getUserShow()).append("'");
        }
        if (data.getOrderAmt() > 0.0) {
            wheresql.append(" And OrderAmt=").append(data.getOrderAmt());
        }
        if (data.getFactAmt() > 0.0) {
            wheresql.append(" And factamt=").append(data.getFactAmt());
        }
        if (data.getFareAmt() > 0.0) {
            wheresql.append(" And fareamt=").append(data.getFareAmt());
        }
        if (this.isNotEmpty(data.getBaiduOrderNo())) {
            wheresql.append(" And baiduOrderNo='").append(data.getBaiduOrderNo()).append("'");
        }
        if (this.isNotEmpty(data.getBizOrderStatus())) {
            wheresql.append(" And BizOrderStatus='").append(data.getBizOrderStatus()).append("'");
        }
        if (this.isNotEmpty(data.getExt1())) {
            wheresql.append(" And Ext1='").append(data.getExt1()).append("'");
        }
        if (this.isNotEmpty(data.getExt2())) {
            wheresql.append(" And Ext2='").append(data.getExt2()).append("'");
        }
        if (this.isNotEmpty(data.getStartdate())) {
            wheresql.append(" And InputTime>='").append(data.getStartdate()).append(" 00:00:00'");
        }
        if (this.isNotEmpty(data.getEnddate())) {
            wheresql.append(" And InputTime<='").append(data.getEnddate()).append(" 23:59:59'");
        }
        if (this.isNotEmpty(data.getSuccessTime())) {
            wheresql.append(" And successtime='").append(data.getSuccessTime()).append("'");
        }
        if (this.isNotEmpty(data.getPaytype())) {
            wheresql.append(" And paytype='").append(data.getPaytype()).append("'");
        }
        if (this.isNotEmpty(data.getRemark())) {
            wheresql.append(" And Remark='").append(data.getRemark()).append("'");
        }
        if (this.isNotEmpty(data.getSpNo())) {
            wheresql.append(" And spNo='").append(data.getSpNo()).append("'");
        }
        return wheresql.toString();
    }

    @Override
    public ExtBaiduWalletOk queryExtBaiduWalletOkSum(ExtBaiduWalletOk data) {
        final ExtBaiduWalletOk result = new ExtBaiduWalletOk();
        String sql = "select sum(orderamt) as orderamt,sum(factamt) as factamt,sum(fareamt) as feeamt from extbaiduwalletok";
        String wheresql = this.generateWhereSql(data);
        sql = sql + wheresql;
        this.logger.debug("querysum...sql:{}", (Object)sql);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                result.setOrderAmt(resultSet.getDouble("orderamt"));
                result.setFactAmt(resultSet.getDouble("factamt"));
                result.setFareAmt(resultSet.getDouble("feeamt"));
            }
        });
        return result;
    }
}

