/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.dao.IExtBaiduWalletDao;
import com.xunlei.payproxy.vo.ExtBaiduWallet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtBaiduWalletDaoImpl
extends JdbcBaseDao
implements IExtBaiduWalletDao {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public ExtBaiduWallet findExtBaiduWallet(ExtBaiduWallet data) {
        return (ExtBaiduWallet)this.findObjectByCondition(data);
    }

    @Override
    public ExtBaiduWallet findExtBaiduWalletById(long id) {
        this.logger.debug("findExtBaiduWalletById...id:{}", (Object)id);
        ExtBaiduWallet data = new ExtBaiduWallet();
        data.setSeqid(id);
        return this.findExtBaiduWallet(data);
    }

    @Override
    public void update(ExtBaiduWallet data) {
        this.updateObject(data);
    }

    @Override
    public void deleteExtBaiduWalletByIds(long[] ids) {
        this.logger.info("deleteExtBaiduWalletByIds...ids:{}", (Object)ids);
        this.deleteObject("extbaiduwallet", ids);
    }

    @Override
    public void save(ExtBaiduWallet extBaiduWallet) {
        this.saveObject(extBaiduWallet);
    }

    @Override
    public Sheet<ExtBaiduWallet> queryExtBaiduWallet(ExtBaiduWallet data, PagedFliper fliper) {
        StringBuilder sql = new StringBuilder("select * from extbaiduwallet");
        String sqlcount = "select count(1) from extbaiduwallet";
        String whereSql = this.generateWhereSql(data);
        sqlcount = sqlcount + whereSql;
        this.logger.debug("count_sql:{}", (Object)sqlcount);
        int counts = this.getSingleInt(sqlcount);
        if (counts <= 0) {
            return Sheet.EMPTY;
        }
        sql.append(whereSql);
        this.logger.debug("sql:{}", (Object)sql.toString());
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql.append(" order by ").append(fliper.getSortColumn());
            }
            sql.append(fliper.limitsql(counts));
        }
        return new Sheet(counts, (Collection)this.query(ExtBaiduWallet.class, sql.toString(), new String[0]));
    }

    private String generateWhereSql(ExtBaiduWallet data) {
        StringBuilder whereSql = new StringBuilder(" where 1=1");
        if (data.getSeqid() != 0L) {
            whereSql.append(" And SeqId=").append(data.getSeqid());
        }
        if (this.isNotEmpty(data.getOrderId())) {
            whereSql.append(" And OrderId='").append(data.getOrderId()).append("'");
        }
        if (this.isNotEmpty(data.getBankCode())) {
            whereSql.append(" And BankCode='").append(data.getBankCode()).append("'");
        }
        if (this.isNotEmpty(data.getXunleiId())) {
            whereSql.append(" And XunleiId='").append(data.getXunleiId()).append("'");
        }
        if (this.isNotEmpty(data.getUserShow())) {
            whereSql.append(" And UserShow='").append(data.getUserShow()).append("'");
        }
        if (data.getOrderAmt() > 0.0) {
            whereSql.append(" And OrderAmt=").append(data.getOrderAmt());
        }
        if (this.isNotEmpty(data.getExtPayStatus())) {
            whereSql.append(" And ExtpayStatus='").append(data.getExtPayStatus()).append("'");
        }
        if (this.isNotEmpty(data.getExt1())) {
            whereSql.append(" And Ext1='").append(data.getExt1()).append("'");
        }
        if (this.isNotEmpty(data.getExt2())) {
            whereSql.append(" And Ext2='").append(data.getExt2()).append("'");
        }
        if (this.isNotEmpty(data.getStartdate())) {
            whereSql.append(" And InputTime>='").append(data.getStartdate()).append(" 00:00:00'");
        }
        if (this.isNotEmpty(data.getEnddate())) {
            whereSql.append(" And InputTime<='").append(data.getEnddate()).append(" 23:59:59'");
        }
        if (this.isNotEmpty(data.getErrCode())) {
            whereSql.append(" And ErrCode='").append(data.getErrCode()).append("'");
        }
        if (this.isNotEmpty(data.getRemark())) {
            whereSql.append(" And Remark='").append(data.getRemark()).append("'");
        }
        if (this.isNotEmpty(data.getPayType())) {
            whereSql.append(" And paytype='").append(data.getPayType()).append("'");
        }
        if (this.isNotEmpty(data.getSpNo())) {
            whereSql.append(" And spNo='").append(data.getSpNo()).append("'");
        }
        return whereSql.toString();
    }

    @Override
    public ExtBaiduWallet queryExtBaiduWalletSum(ExtBaiduWallet data) {
        final ExtBaiduWallet result = new ExtBaiduWallet();
        String sql = "select sum(orderamt) as orderamt from extbaiduwallet" + this.generateWhereSql(data);
        this.logger.debug("queryExtBaiduWalletSum...sql:{}", (Object)sql);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                result.setOrderAmt(resultSet.getDouble(1));
            }
        });
        return result;
    }
}

