/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.dao.IExtAlipayMonthBindDao;
import com.xunlei.payproxy.vo.ExtAlipayMonthBind;
import com.xunlei.payproxy.vo.ExtAlipayMonthBindReq;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtAlipayMonthBindDaoImpl
extends JdbcBaseDao
implements IExtAlipayMonthBindDao {
    private static final Logger logger = LoggerFactory.getLogger(ExtAlipayMonthBindDaoImpl.class);

    @Override
    public ExtAlipayMonthBind findExtAlipayMonthBind(ExtAlipayMonthBind data) {
        return (ExtAlipayMonthBind)this.findObjectByCondition(data);
    }

    @Override
    public ExtAlipayMonthBind findExtAlipayMonthBindById(long id) {
        logger.debug("findExtAlipayMonthBindById...id:{}", (Object)id);
        ExtAlipayMonthBind data = new ExtAlipayMonthBind();
        data.setSeqId(id);
        return this.findExtAlipayMonthBind(data);
    }

    @Override
    public void updateExtAlipayMonthBind(ExtAlipayMonthBind data) {
        this.updateObject(data);
    }

    @Override
    public void deleteExtAlipayMonthBindById(long id) {
        logger.info("deleteExtAlipayMonthBindById...id:{}", (Object)id);
        this.deleteObject("extalipaymonthbind", new long[]{id});
    }

    @Override
    public void insertExtAlipayMonthBind(ExtAlipayMonthBind extAlipayMonthBind) {
        this.insertObject(extAlipayMonthBind);
    }

    @Override
    public List<Map<String, String>> findExtAlipayMonthBindList(int offset, int length, String now) {
        final ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        String sql = "SELECT xunleiId,bizNo,productName,orderAmt,bgUrl,pageCharset,fgUrl,productDesc,ext1,ext2,other1,other2,clientIp,payerName,payerContact FROM extalipaymonthbind  WHERE length(bindId) > 0 AND DATE_FORMAT(expireDate,'%Y-%m-%d') < DATE_FORMAT('" + now + "','%Y-%m-%d') LIMIT " + offset + ", " + length;
        logger.debug("findExtAlipayMonthBindList sql: {}", (Object)sql);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("xunleiId", rs.getString("xunleiId"));
                result.put("bizNo", rs.getString("bizNo"));
                result.put("productName", rs.getString("productName"));
                result.put("orderAmt", rs.getString("orderAmt"));
                result.put("bgUrl", rs.getString("bgUrl"));
                result.put("pageCharset", rs.getString("pageCharset"));
                result.put("fgUrl", rs.getString("fgUrl"));
                result.put("productDesc", rs.getString("productDesc"));
                result.put("ext1", rs.getString("ext1"));
                result.put("ext2", rs.getString("ext2"));
                result.put("other1", rs.getString("other1"));
                result.put("other2", rs.getString("other2"));
                result.put("clientIp", rs.getString("clientIp"));
                result.put("payerName", rs.getString("payerName"));
                result.put("payerContact", rs.getString("payerContact"));
                list.add(result);
            }
        });
        return list;
    }

    @Override
    public int findExtAlipayMonthBindListCount(String now) {
        String sql = "SELECT COUNT(1) FROM extalipaymonthbind WHERE length(bindId) > 0 AND DATE_FORMAT(expireDate,'%Y-%m-%d') < DATE_FORMAT('" + now + "','%Y-%m-%d')";
        logger.debug("findExtAlipayMonthBindListCount sql: {}", (Object)sql);
        return this.getJdbcTemplate().queryForInt(sql);
    }

    @Override
    public synchronized String updateSuccessTimesAndDeductTime(String xunleiId, String bizNo) {
        SimpleDateFormat formatFull = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat formatYMD = new SimpleDateFormat("yyyy-MM-dd");
        ExtAlipayMonthBind query = new ExtAlipayMonthBind();
        query.setXunleiId(xunleiId);
        query.setBizNo(bizNo);
        ExtAlipayMonthBind result = (ExtAlipayMonthBind)this.findObjectByCondition(query);
        if (null != result) {
            result.setSuccessTimes(result.getSuccessTimes() + 1);
            result.setIsDeducted("T");
            if (result.getBeginDate() == null || "".equals(result.getBeginDate())) {
                result.setFirstDeductTime(formatFull.format(new Date()));
                result.setBeginDate(formatYMD.format(new Date()));
                result.setExpireDate(this.addOneMonth(result.getBeginDate()));
            } else {
                result.setBeginDate(this.addOneMonth(result.getBeginDate()));
                result.setExpireDate(this.addOneMonth(result.getExpireDate()));
            }
            this.updateExtAlipayMonthBind(result);
            return "SUCCESS";
        }
        return "FAIL";
    }

    public String addOneMonth(String inputTime) {
        try {
            SimpleDateFormat formatYMD = new SimpleDateFormat("yyyy-MM-dd");
            Date inputDate = formatYMD.parse(inputTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(inputDate);
            calendar.add(5, 31);
            return formatYMD.format(calendar.getTime());
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff0c\u53c2\u6570inputTime: {} \u4e0d\u6b63\u786e\uff01", (Object)inputTime);
            return null;
        }
    }

    @Override
    public synchronized String updateFailTimes(String xunleiId, String bizNo) {
        ExtAlipayMonthBind query = new ExtAlipayMonthBind();
        query.setXunleiId(xunleiId);
        query.setBizNo(bizNo);
        ExtAlipayMonthBind result = (ExtAlipayMonthBind)this.findObjectByCondition(query);
        if (null != result) {
            result.setFailedTimes(result.getFailedTimes() + 1);
            this.updateExtAlipayMonthBind(result);
            return "SUCCESS";
        }
        return "FAIL";
    }

    @Override
    public Sheet<ExtAlipayMonthBind> queryExtAlipayMonthBind(ExtAlipayMonthBind data, PagedFliper fliper) {
        String sql = "SELECT * FROM";
        String sqlcount = "SELECT COUNT(1) FROM";
        StringBuffer wheresql = new StringBuffer(" extalipaymonthbind WHERE length(bindId) > 0 ");
        if (this.isNotEmpty(data.getBindId())) {
            wheresql.append(" AND bindId = '").append(data.getBindId()).append("'");
        }
        if (this.isNotEmpty(data.getBizNo())) {
            wheresql.append(" AND bizNo = '").append(data.getBizNo()).append("'");
        }
        if (this.isNotEmpty(data.getXunleiId())) {
            wheresql.append(" AND xunleiId = '").append(data.getXunleiId()).append("'");
        }
        if (this.isNotEmpty(data.getUserShow())) {
            wheresql.append(" AND userShow = '").append(data.getUserShow()).append("'");
        }
        if (this.isNotEmpty(data.getStatus())) {
            wheresql.append(" AND status = '").append(data.getStatus()).append("'");
        }
        if (this.isNotEmpty(data.getStartDate())) {
            wheresql.append(" AND signTime >= '").append(data.getStartDate()).append("'");
        }
        if (this.isNotEmpty(data.getEndDate())) {
            wheresql.append(" AND signTime <= '").append(data.getEndDate()).append("'");
        }
        sqlcount = sqlcount + wheresql.toString();
        int counts = this.getSingleInt(sqlcount);
        logger.info("sql count: {}", (Object)sqlcount);
        if (counts <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + wheresql.toString();
        logger.info("sql: {}", (Object)sql);
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " ORDER BY " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(counts);
        }
        return new Sheet(counts, (Collection)this.query(ExtAlipayMonthBind.class, sql, new String[0]));
    }

    @Override
    public Sheet<ExtAlipayMonthBindReq> queryExtAlipayMonthBindReq(ExtAlipayMonthBindReq data, PagedFliper fliper) {
        String sql = "SELECT seqId,userShow,xunleiId,bizNo,ext1,ext2,productName,orderAmt,bgUrl,fgUrl,pageCharset,other1,other2,other3,productDesc,clientIp,payerName,payerContact,externalSignNo,orderId FROM";
        String sqlcount = "SELECT COUNT(1) FROM";
        StringBuffer wheresql = new StringBuffer(" extalipaymonthbind WHERE length(bindId) = 0 ");
        if (this.isNotEmpty(data.getExternalSignNo())) {
            wheresql.append(" AND externalSignNo = '").append(data.getExternalSignNo()).append("'");
        }
        if (this.isNotEmpty(data.getBizNo())) {
            wheresql.append(" AND bizNo = '").append(data.getBizNo()).append("'");
        }
        if (this.isNotEmpty(data.getXunleiId())) {
            wheresql.append(" AND xunleiId = '").append(data.getXunleiId()).append("'");
        }
        if (this.isNotEmpty(data.getUserShow())) {
            wheresql.append(" AND userShow = '").append(data.getUserShow()).append("'");
        }
        sqlcount = sqlcount + wheresql.toString();
        int counts = this.getSingleInt(sqlcount);
        logger.info("sql count: {}", (Object)sqlcount);
        if (counts <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + wheresql.toString();
        logger.info("sql: {}", (Object)sql);
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " ORDER BY " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(counts);
        }
        return new Sheet(counts, (Collection)this.query(ExtAlipayMonthBindReq.class, sql, new String[0]));
    }
}

