/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.dao.IConfigChannelDao;
import com.xunlei.payproxy.vo.ConfigChannel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigChannelDaoImpl
extends JdbcBaseDao
implements IConfigChannelDao {
    private Logger logger = LoggerFactory.getLogger(ConfigChannelDaoImpl.class);

    @Override
    public void addConfigChannel(ConfigChannel item) {
        this.saveObject(item);
    }

    @Override
    public void updateConfigChannel(ConfigChannel item) {
        this.updateObject(item);
    }

    @Override
    public void deleteConfigChannel(long seqid) {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u4ed8\u7269\u7406\u5220\u9664!");
    }

    @Override
    public ConfigChannel queryConfigChannel(long seqid) {
        ConfigChannel item = new ConfigChannel();
        item.setSeqid(seqid);
        return (ConfigChannel)this.findObjectByCondition(item);
    }

    @Override
    public Sheet<ConfigChannel> queryConfigChannelList(ConfigChannel data, PagedFliper fliper) {
        String sql = "SELECT * FROM configchannel WHERE isDelete = 'N' ";
        String sqlcount = "SELECT COUNT(1) FROM configchannel WHERE isDelete = 'N' ";
        int counts = this.getSingleInt(sqlcount);
        this.logger.info("sql count: {}", (Object)sqlcount);
        if (counts <= 0) {
            return Sheet.EMPTY;
        }
        this.logger.info("sql: {}", (Object)sql);
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(counts);
        }
        return new Sheet(counts, (Collection)this.query(ConfigChannel.class, sql, new String[0]));
    }

    @Override
    public boolean findConfigChannelExists(String sourcePayType) {
        String sql = "SELECT COUNT(1) FROM configchannel WHERE sourcePayType = '" + sourcePayType + "' ";
        return this.getJdbcTemplate().queryForInt(sql) > 0;
    }

    @Override
    public boolean findConfigChannelExists(String sourcePayType, long seqId) {
        String sql = "SELECT COUNT(1) FROM configchannel WHERE sourcePayType = '" + sourcePayType + "' AND seqid != " + seqId;
        return this.getJdbcTemplate().queryForInt(sql) > 0;
    }

    @Override
    public String findConfigChannelByPayType(String payType) {
        String sqlCount = "SELECT COUNT(1) FROM configchannel WHERE sourcePayType = '" + payType + "' ";
        int count = this.getJdbcTemplate().queryForInt(sqlCount);
        if (count != 1) {
            this.logger.error("\u6570\u636e\u5e93\u8868configchannel\u4e2d\uff0c\u5bf9: {} \u7684\u914d\u7f6e\u884c\u591a\u4f59\u4e00\u884c\u6216\u6ca1\u6709\u914d\u7f6e\uff01", (Object)payType);
            return null;
        }
        String sql = "SELECT destinationPayType FROM configchannel WHERE sourcePayType = '" + payType + "' ";
        final ArrayList destinationPayTypeList = new ArrayList();
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                destinationPayTypeList.add(rs.getString("destinationPayType"));
            }
        });
        return (String)destinationPayTypeList.get(0);
    }

    @Override
    public Map<String, String> loadAllConfigChannel() {
        final HashMap<String, String> resultMap = new HashMap<String, String>();
        String sql = "SELECT sourcePayType,destinationPayType FROM configchannel WHERE isDelete = 'N'";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String key = rs.getString("sourcePayType");
                String value = rs.getString("destinationPayType");
                resultMap.put(key, value);
            }
        });
        return resultMap;
    }
}

