/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.card.util.Utility;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.dao.BaseDao;
import com.xunlei.payproxy.dao.IBizorderokDao;
import com.xunlei.payproxy.util.TimeUtil;
import com.xunlei.payproxy.vo.Bizorderok;
import com.xunlei.payproxy.vo.UserBonusInfoPayproxy;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BizorderokDaoImpl
extends BaseDao
implements IBizorderokDao {
    @Override
    public void moveDataToDayForKuai(String balancedate, String exWhere) {
        DatabaseMetaData metaData = null;
        try {
            metaData = this.getConnection().getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet set = metaData.getTables(null, null, "bizorderok_kuai_%", types);
            Calendar cal = Calendar.getInstance();
            cal.add(5, -7);
            String time_suffix = new SimpleDateFormat("yyMMdd").format(cal.getTime());
            logger.debug((Object)("time_suffix = " + time_suffix));
            String fiveAgoTB = "bizorderok_kuai_" + time_suffix;
            String p = "bizorderok_kuai_[0-9]{6}";
            Pattern pattern = Pattern.compile(p);
            while (set.next()) {
                String tableName = set.getString(3);
                Matcher matcher = pattern.matcher(tableName);
                if (!matcher.find()) continue;
                logger.debug((Object)("tableName = " + tableName));
                String sql = "select '" + fiveAgoTB + "' > '" + tableName + "'";
                logger.debug((Object)("sql = " + sql));
                Statement time_stat = this.getConnection().createStatement();
                ResultSet time_resultSet = time_stat.executeQuery(sql);
                time_resultSet.next();
                int time_result = time_resultSet.getInt(1);
                if (time_result != 1) continue;
                this.execute("drop table if exists " + tableName);
            }
        }
        catch (CannotGetJdbcConnectionException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String dropsql = "drop table if exists bizorderok_kuai_" + balancedate;
        this.execute(dropsql);
        String createTableSql = "CREATE TABLE `bizorderok_kuai_" + balancedate + "` (\n" + "   `SeqId` bigint(20) NOT NULL auto_increment,\n" + "   `Version` varchar(10) NOT NULL default '',\n" + "   `PageCharset` varchar(2) NOT NULL default '',\n" + "   `BgUrl` varchar(255) NOT NULL default '',\n" + "   `FgUrl` varchar(255) NOT NULL default '',\n" + "   `XunleiPayId` varchar(19) NOT NULL default '',\n" + "   `BizNo` varchar(20) NOT NULL default '',\n" + "   `BizOrderId` varchar(60) NOT NULL default '',\n" + "   `PayType` varchar(2) NOT NULL default '',\n" + "   `ExtPayCompany` varchar(2) NOT NULL default '',\n" + "   `ExtPayOrderId` varchar(20) NOT NULL default '',\n" + "   `OrderAmt` decimal(14,2) NOT NULL default '0.00',\n" + "   `OrderTime` varchar(19) NOT NULL default '',\n" + "   `BankNo` varchar(20) NOT NULL default '',\n" + "   `UserShow` varchar(30) NOT NULL default '',\n" + "   `ProductName` varchar(50) NOT NULL default '',\n" + "   `ProductDesc` varchar(255) NOT NULL default '',\n" + "   `PayerName` varchar(30) NOT NULL default '',\n" + "   `PayerContact` varchar(50) NOT NULL default '',\n" + "   `Ext1` varchar(255) NOT NULL default '',\n" + "   `Ext2` varchar(255) NOT NULL default '',\n" + "   `OrderIp` varchar(15) NOT NULL default '',\n" + "   `SuccessTime` varchar(19) NOT NULL default '',\n" + "   `XunleiId` varchar(30) NOT NULL default '',\n" + "   `BalanceDate` varchar(10) NOT NULL default '',\n" + "   `SendNoticeStatus` varchar(2) NOT NULL default '',\n" + "   `ThunderStatus` varchar(2) NOT NULL default '',\n" + "   `ApplyRechargeId` varchar(18) NOT NULL default '',\n" + "   `ApplyConsumeId` varchar(18) NOT NULL default '',\n" + "   `BalanceDateRecharge` varchar(10) NOT NULL default '',\n" + "   `BalanceDateConsume` varchar(10) NOT NULL default '',\n" + "   `Remark` varchar(255) NOT NULL default '',\n" + "   `PeerId` varchar(32) NOT NULL default '',\n" + "   `other1` text NOT NULL default '',\n" + "   `other2` varchar(255) NOT NULL default '',\n" + "   `other3` varchar(255) NOT NULL default '',\n" + "   `fareamt` decimal(14,2) NOT NULL default '',\n" + "   `divideamt` decimal(14,2) NOT NULL default '',\n" + "   `type` varchar(2) NOT NULL default '',\n" + "   `ordergroup` varchar(30) NOT NULL default '',\n" + "   PRIMARY KEY  (`SeqId`)" + " ) ENGINE=MyISAM DEFAULT CHARSET=utf8";
        this.execute(createTableSql);
        StringBuilder sql = new StringBuilder();
        sql.append("insert into bizorderok_kuai_").append(balancedate).append("(version,pagecharset,bgurl,fgurl,XunleiPayId,bizno,bizorderid,paytype,extpaycompany,");
        sql.append("extpayorderid,orderamt,ordertime,bankno,usershow,productname,productdesc,payername,payercontact,ext1,ext2,orderip,");
        sql.append("successtime,xunleiid,balancedate,sendnoticestatus,thunderstatus,applyrechargeid,applyconsumeid,");
        sql.append("balancedaterecharge,balancedateconsume,remark,peerid,other1,other2,other3,fareamt,divideamt,type,ordergroup) ");
        sql.append(" select version,pagecharset,bgurl,fgurl,XunleiPayId,bizno,bizorderid,paytype,extpaycompany,");
        sql.append("extpayorderid,orderamt,ordertime,bankno,usershow,productname,productdesc,payername,payercontact,ext1,ext2,orderip,");
        sql.append("successtime,xunleiid,balancedate,sendnoticestatus,thunderstatus,applyrechargeid,applyconsumeid,");
        sql.append("balancedaterecharge,balancedateconsume,remark,peerid,other1,other2,other3,fareamt,divideamt,type,ordergroup");
        sql.append(" from bizorderok ");
        this.execute(sql.toString() + " where 1=1 " + exWhere);
    }

    @Override
    public void moveDataToDayForCommon(String balancedate, String tablename, String exWhere) {
        DatabaseMetaData metaData = null;
        try {
            metaData = this.getConnection().getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet set = metaData.getTables(null, null, tablename + "_%", types);
            Calendar cal = Calendar.getInstance();
            cal.add(5, -7);
            String time_suffix = new SimpleDateFormat("yyMMdd").format(cal.getTime());
            logger.debug((Object)("time_suffix = " + time_suffix));
            String fiveAgoTB = tablename + "_" + time_suffix;
            String p = tablename + "_[0-9]{6}";
            Pattern pattern = Pattern.compile(p);
            while (set.next()) {
                String tableName = set.getString(3);
                Matcher matcher = pattern.matcher(tableName);
                if (!matcher.find()) continue;
                logger.debug((Object)("tableName = " + tableName));
                String sql = "select '" + fiveAgoTB + "' > '" + tableName + "'";
                logger.debug((Object)("sql = " + sql));
                Statement time_stat = this.getConnection().createStatement();
                ResultSet time_resultSet = time_stat.executeQuery(sql);
                time_resultSet.next();
                int time_result = time_resultSet.getInt(1);
                if (time_result != 1) continue;
                this.execute("drop table if exists " + tableName);
            }
        }
        catch (CannotGetJdbcConnectionException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String dropsql = "drop table if exists " + tablename + "_" + balancedate;
        this.execute(dropsql);
        String createTableSql = "CREATE TABLE `" + tablename + "_" + balancedate + "` (\n" + "   `SeqId` bigint(20) NOT NULL auto_increment,\n" + "   `Version` varchar(10) NOT NULL default '',\n" + "   `PageCharset` varchar(2) NOT NULL default '',\n" + "   `BgUrl` varchar(255) NOT NULL default '',\n" + "   `FgUrl` varchar(255) NOT NULL default '',\n" + "   `XunleiPayId` varchar(19) NOT NULL default '',\n" + "   `BizNo` varchar(20) NOT NULL default '',\n" + "   `BizOrderId` varchar(60) NOT NULL default '',\n" + "   `PayType` varchar(2) NOT NULL default '',\n" + "   `ExtPayCompany` varchar(2) NOT NULL default '',\n" + "   `ExtPayOrderId` varchar(20) NOT NULL default '',\n" + "   `OrderAmt` decimal(14,2) NOT NULL default '0.00',\n" + "   `OrderTime` varchar(19) NOT NULL default '',\n" + "   `BankNo` varchar(20) NOT NULL default '',\n" + "   `UserShow` varchar(30) NOT NULL default '',\n" + "   `ProductName` varchar(50) NOT NULL default '',\n" + "   `ProductDesc` varchar(255) NOT NULL default '',\n" + "   `PayerName` varchar(30) NOT NULL default '',\n" + "   `PayerContact` varchar(50) NOT NULL default '',\n" + "   `Ext1` varchar(255) NOT NULL default '',\n" + "   `Ext2` varchar(255) NOT NULL default '',\n" + "   `OrderIp` varchar(15) NOT NULL default '',\n" + "   `SuccessTime` varchar(19) NOT NULL default '',\n" + "   `XunleiId` varchar(30) NOT NULL default '',\n" + "   `BalanceDate` varchar(10) NOT NULL default '',\n" + "   `SendNoticeStatus` varchar(2) NOT NULL default '',\n" + "   `ThunderStatus` varchar(2) NOT NULL default '',\n" + "   `ApplyRechargeId` varchar(18) NOT NULL default '',\n" + "   `ApplyConsumeId` varchar(18) NOT NULL default '',\n" + "   `BalanceDateRecharge` varchar(10) NOT NULL default '',\n" + "   `BalanceDateConsume` varchar(10) NOT NULL default '',\n" + "   `Remark` varchar(255) NOT NULL default '',\n" + "   `PeerId` varchar(32) NOT NULL default '',\n" + "   `other1` text NOT NULL default '',\n" + "   `other2` varchar(255) NOT NULL default '',\n" + "   `other3` varchar(255) NOT NULL default '',\n" + "   `fareamt` decimal(14,2) NOT NULL default '',\n" + "   `divideamt` decimal(14,2) NOT NULL default '',\n" + "   `type` varchar(2) NOT NULL default '',\n" + "   `ordergroup` varchar(30) NOT NULL default '',\n" + "   PRIMARY KEY  (`SeqId`)" + " ) ENGINE=MyISAM DEFAULT CHARSET=utf8";
        this.execute(createTableSql);
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(tablename).append("_").append(balancedate).append("(version,pagecharset,bgurl,fgurl,XunleiPayId,bizno,bizorderid,paytype,extpaycompany,");
        sql.append("extpayorderid,orderamt,ordertime,bankno,usershow,productname,productdesc,payername,payercontact,ext1,ext2,orderip,");
        sql.append("successtime,xunleiid,balancedate,sendnoticestatus,thunderstatus,applyrechargeid,applyconsumeid,");
        sql.append("balancedaterecharge,balancedateconsume,remark,peerid,other1,other2,other3,fareamt,divideamt,type,ordergroup) ");
        sql.append(" select version,pagecharset,bgurl,fgurl,XunleiPayId,bizno,bizorderid,paytype,extpaycompany,");
        sql.append("extpayorderid,orderamt,ordertime,bankno,usershow,productname,productdesc,payername,payercontact,ext1,ext2,orderip,");
        sql.append("successtime,xunleiid,balancedate,sendnoticestatus,thunderstatus,applyrechargeid,applyconsumeid,");
        sql.append("balancedaterecharge,balancedateconsume,remark,peerid,other1,other2,other3,fareamt,divideamt,type,ordergroup");
        sql.append(" from bizorderok ");
        this.execute(sql.toString() + " where 1=1 " + exWhere);
    }

    @Override
    public Bizorderok findBizorderok(Bizorderok data) {
        String sql = "select * from bizorderok";
        String countsql = "select count(1) from bizorderok";
        StringBuilder where = new StringBuilder(" where 1=1");
        if (null != data) {
            if (data.getSeqid() > 0L) {
                return this.getBizorderokById(data.getSeqid());
            }
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and bizno='").append(data.getBizno()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpayorderid())) {
                where.append(" and extpayorderid='").append(data.getExtpayorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpaycompany())) {
                where.append(" and extpaycompany='").append(data.getExtpaycompany()).append("' ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            countsql = countsql + where.toString();
            sql = sql + where.toString();
            sql = sql + " limit 1 ";
            logger.debug((Object)("find bizorderok sql:" + sql));
            if (this.getSingleInt(countsql) >= 1) {
                return (Bizorderok)this.queryOne(Bizorderok.class, sql, new String[0]);
            }
        }
        return null;
    }

    @Override
    public Bizorderok findBizorderokByTable(Bizorderok data, String table) {
        String sql = "select * from " + table;
        String countsql = "select count(1) from " + table;
        StringBuilder where = new StringBuilder(" where 1=1");
        if (null != data) {
            if (data.getSeqid() > 0L) {
                where.append(" and seqid=").append(data.getSeqid());
            }
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and bizno='").append(data.getBizno()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpayorderid())) {
                where.append(" and extpayorderid='").append(data.getExtpayorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpaycompany())) {
                where.append(" and extpaycompany='").append(data.getExtpaycompany()).append("' ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            countsql = countsql + where.toString();
            sql = sql + where.toString();
            sql = sql + " limit 1 ";
            logger.debug((Object)("find table: " + table + ", sql:" + sql));
            if (this.getSingleInt(countsql) >= 1) {
                return (Bizorderok)this.queryOne(Bizorderok.class, sql, new String[0]);
            }
        }
        return null;
    }

    @Override
    public Bizorderok queryBizorderokSum(Bizorderok data) {
        final Bizorderok result = new Bizorderok();
        StringBuilder where = new StringBuilder("select sum(orderamt) as orderamt from bizorderok where 1=1 ");
        if (null != data) {
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and bizno='").append(data.getBizno()).append("' ");
            } else if (data.getBiznos() != null) {
                if (data.getBiznos().length == 0) {
                    return result;
                }
                where.append(" and bizno in").append(BizorderokDaoImpl.uniteForIn((String[])data.getBiznos()));
            }
            if (this.isNotEmpty(data.getThunderstatus())) {
                where.append(" and thunderstatus='").append(data.getThunderstatus()).append("' ");
            }
            if (this.isNotEmpty(data.getUsershow())) {
                where.append(" and usershow='").append(data.getUsershow()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<='").append(data.getTodate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>='").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromtime())) {
                where.append(" and successtime>='").append(StringTools.escapeSql((String)data.getFromtime())).append(" 00:00:00' ");
            }
            if (this.isNotEmpty(data.getTotime())) {
                where.append(" and successtime<='").append(StringTools.escapeSql((String)data.getTotime())).append(" 23:59:59' ");
            }
            if (this.isNotEmpty(data.getMonitortime())) {
                where.append(" and successtime<='").append(data.getMonitortime()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and bizno='").append(data.getBizno()).append("' ");
            }
            if (this.isNotEmpty(data.getPaytype())) {
                where.append(" and paytype='").append(data.getPaytype()).append("' ");
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpayorderid())) {
                where.append(" and extpayorderid='").append(data.getExtpayorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getSendnoticestatus())) {
                where.append(" and sendnoticestatus='").append(data.getSendnoticestatus()).append("' ");
            }
            if (this.isNotEmpty(data.getBankno())) {
                where.append(" and bankno='").append(data.getBankno()).append("' ");
            }
            if (data.getOrderamt() > 0.0) {
                where.append(" and orderamt=").append(data.getOrderamt()).append(" ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            if (this.isNotEmpty(data.getSendnoticestatus())) {
                where.append(" and sendnoticestatus='").append(data.getSendnoticestatus()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiid())) {
                where.append(" and xunleiid='").append(data.getXunleiid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderip())) {
                where.append(" and orderip='").append(data.getOrderip()).append("' ");
            }
        }
        logger.info((Object)("querybizorderoksum-----sql=" + where.toString()));
        this.getJdbcTemplate().query(where.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                result.setOrderamt(resultSet.getDouble("orderamt"));
            }
        });
        return result;
    }

    @Override
    @Deprecated
    public Sheet<Bizorderok> queryBizorderok(Bizorderok data, PagedFliper fliper) {
        String sql = "select b.* from bizorderok b ";
        String countsql = "select count(1) from bizorderok b ";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (null != data) {
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and b.bizno='").append(data.getBizno()).append("' ");
            } else if (data.getBiznos() != null) {
                if (data.getBiznos().length == 0) {
                    return Sheet.EMPTY;
                }
                where.append(" and b.bizno in").append(BizorderokDaoImpl.uniteForIn((String[])data.getBiznos()));
            }
            if (this.isNotEmpty(data.getThunderstatus())) {
                where.append(" and thunderstatus='").append(data.getThunderstatus()).append("' ");
            }
            if (this.isNotEmpty(data.getUsershow())) {
                where.append(" and usershow='").append(data.getUsershow()).append("' ");
            }
            if (this.isNotEmpty(data.getPeerid())) {
                where.append(" and peerid='").append(data.getPeerid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiid())) {
                where.append(" and xunleiid='").append(data.getXunleiid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<='").append(data.getTodate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>='").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromtime())) {
                where.append(" and successtime>='").append(StringTools.escapeSql((String)data.getFromtime())).append(" 00:00:00' ");
            }
            if (this.isNotEmpty(data.getTotime())) {
                where.append(" and successtime<='").append(StringTools.escapeSql((String)data.getTotime())).append(" 23:59:59' ");
            }
            if (this.isNotEmpty(data.getMonitortime())) {
                where.append(" and successtime<='").append(data.getMonitortime()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and b.bizno='").append(data.getBizno()).append("' ");
            }
            if (this.isNotEmpty(data.getPaytype())) {
                where.append(" and paytype='").append(data.getPaytype()).append("' ");
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpayorderid())) {
                where.append(" and extpayorderid='").append(data.getExtpayorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getSendnoticestatus())) {
                where.append(" and sendnoticestatus='").append(data.getSendnoticestatus()).append("' ");
            }
            if (this.isNotEmpty(data.getBankno())) {
                where.append(" and bankno='").append(data.getBankno()).append("' ");
            }
            if (data.getOrderamt() > 0.0) {
                where.append(" and orderamt=").append(data.getOrderamt()).append(" ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderip())) {
                where.append(" and orderip='").append(data.getOrderip()).append("' ");
            }
        }
        countsql = countsql + where.toString();
        int rowcount = this.getSingleInt(countsql);
        logger.info((Object)("querybizorderok-----countsql=" + countsql));
        if (rowcount <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        logger.info((Object)("querybizorderok-----sql=" + sql));
        return new Sheet(rowcount, (Collection)this.query(Bizorderok.class, sql, new String[]{"bizname"}));
    }

    @Override
    public List<UserBonusInfoPayproxy> queryAccountValueGroupByPaytype(UserBonusInfoPayproxy data) {
        StringBuilder sql = new StringBuilder("select xunleiid,usershow,sum(orderamt) as orderamt");
        sql.append(",paytype ");
        sql.append("from bizorderok  where 1=1 and bizno!='000001027' ");
        if (data != null) {
            if (!this.isEmpty(data.getPaytype())) {
                sql.append(" and paytype in(").append(data.getPaytype()).append(") ");
            }
            if (!this.isEmpty(data.getFromtime())) {
                sql.append(" and successtime>='").append(data.getFromtime()).append("' ");
            }
            if (!this.isEmpty(data.getTotime())) {
                sql.append(" and successtime<='").append(data.getTotime()).append("' ");
            }
        }
        sql.append(" group by ");
        sql.append("paytype,");
        sql.append("xunleiid");
        return this.query(UserBonusInfoPayproxy.class, sql.toString(), new String[0]);
    }

    @Override
    public List<UserBonusInfoPayproxy> queryUserBonusInfoFromOkAndHisGroupByPay(UserBonusInfoPayproxy data) {
        String table;
        String fromDate;
        StringBuilder sqlTemplate = new StringBuilder("(select xunleiid, usershow, sum(orderamt) as orderamt, paytype  from #table# where 1=1 and bizno!='000001027' ");
        if (data != null) {
            if (!this.isEmpty(data.getPaytype())) {
                sqlTemplate.append(" and paytype in(").append(data.getPaytype()).append(") ");
            }
            if (!this.isEmpty(data.getFromtime())) {
                sqlTemplate.append(" and successtime>='").append(data.getFromtime()).append("' ");
            }
            if (!this.isEmpty(data.getTotime())) {
                sqlTemplate.append(" and successtime<='").append(data.getTotime()).append("' ");
            }
            sqlTemplate.append(" and type in ('A','D')");
        }
        sqlTemplate.append(" group by paytype, xunleiid)");
        StringBuilder sql = new StringBuilder(sqlTemplate.toString().replace("#table#", "bizorderok"));
        String string = fromDate = data.getFromtime() == null ? null : data.getFromtime().substring(0, 10);
        if (null != fromDate && fromDate.length() >= 10 && null != (table = TimeUtil.getTable(fromDate)) && !"bizorderok".equals(table)) {
            sql.append(" union all ").append(sqlTemplate.toString().replace("#table#", table)).toString();
        }
        logger.info((Object)("sql:" + sql.toString()));
        return this.query(UserBonusInfoPayproxy.class, sql.toString(), new String[0]);
    }

    @Override
    public Sheet<Bizorderok> queryBizorderokRightJoinPaynoticeok(Bizorderok data, PagedFliper fliper) {
        int rowcount;
        String sql = "select pnok.seqid,pnok.xunleipayid,version,pagecharset,fgurl,bgurl,bizno,bizorderid,paytype,extpaycompany,extpayorderid,orderamt,ordertime,bankno,productname,productdesc,payername,payercontact,ext1,ext2,orderip,successtime,balancedate,xunleiid,sendnoticestatus,thunderstatus,applyrechargeid,applyconsumeid,balancedaterecharge,balancedateconsume,pnok.remark as remark,failtimes,noticetime,usershow  from bizorderok book  ,paynoticeok pnok where pnok.xunleipayid=book.xunleipayid ";
        String countsql = "select count(1)  from bizorderok book,paynoticeok pnok where pnok.xunleipayid=book.xunleipayid ";
        StringBuilder where = new StringBuilder("");
        if (null != data) {
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and book.balancedate='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and book.bizno='").append(data.getBizno()).append("' ");
            }
            if (this.isNotEmpty(data.getThunderstatus())) {
                where.append(" and book.thunderstatus='").append(data.getThunderstatus()).append("' ");
            }
            if (this.isNotEmpty(data.getUsershow())) {
                where.append(" and book.usershow='").append(data.getUsershow()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and pnok.noticetime<='").append(data.getTodate()).append(" 23:59:59' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and pnok.noticetime>='").append(data.getFromdate()).append(" 00:00:00'");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and book.bizno='").append(data.getBizno()).append("' ");
            }
            if (this.isNotEmpty(data.getPaytype())) {
                where.append(" and book.paytype='").append(data.getPaytype()).append("' ");
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and book.bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and book.xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = countsql + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        logger.debug((Object)sql);
        return new Sheet(rowcount, (Collection)this.query(Bizorderok.class, sql, new String[]{"failtimes", "noticetime"}));
    }

    @Override
    public Sheet<Bizorderok> queryBizorderokRightJoinPaynoticefail(Bizorderok data, PagedFliper fliper) {
        int rowcount;
        String sql = "select pnf.seqid,pnf.xunleipayid,version,pagecharset,fgurl,bgurl,bizno,bizorderid,paytype,extpaycompany,extpayorderid,orderamt,ordertime,bankno,productname,productdesc,payername,payercontact,ext1,ext2,orderip,successtime,balancedate,xunleiid,sendnoticestatus,thunderstatus,applyrechargeid,applyconsumeid,balancedaterecharge,balancedateconsume,pnf.remark as remark,failtimes,noticetime,usershow  from bizorderok book,paynoticefail pnf where pnf.xunleipayid=book.xunleipayid ";
        String countsql = "select count(1)  from bizorderok book,paynoticefail pnf where pnf.xunleipayid=book.xunleipayid ";
        StringBuilder where = new StringBuilder("");
        if (null != data) {
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and book.balancedate='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and book.bizno='").append(data.getBizno()).append("' ");
            }
            if (this.isNotEmpty(data.getThunderstatus())) {
                where.append(" and book.thunderstatus='").append(data.getThunderstatus()).append("' ");
            }
            if (this.isNotEmpty(data.getUsershow())) {
                where.append(" and book.usershow='").append(data.getUsershow()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and pnf.noticetime<='").append(data.getTodate()).append(" 23:59:59' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and pnf.noticetime>='").append(data.getFromdate()).append(" 00:00:00'");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and book.bizno='").append(data.getBizno()).append("' ");
            }
            if (this.isNotEmpty(data.getPaytype())) {
                where.append(" and book.paytype='").append(data.getPaytype()).append("' ");
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and book.bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and book.xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = countsql + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        logger.debug((Object)sql);
        return new Sheet(rowcount, (Collection)this.query(Bizorderok.class, sql, new String[]{"failtimes", "noticetime"}));
    }

    @Override
    public void deleteBizorderok(Bizorderok data) {
        if (null != data && data.getSeqid() > 0L) {
            this.deleteBizorderokById(data.getSeqid());
        }
    }

    @Override
    public Bizorderok getBizorderokById(long seqid) {
        return (Bizorderok)this.findObject(Bizorderok.class, seqid);
    }

    @Override
    public Bizorderok getBizorderokByOrderId(String orderId) {
        Bizorderok data = new Bizorderok();
        data.setBizorderid(orderId);
        return (Bizorderok)this.findObject(data);
    }

    @Override
    public void insertBizorderok(Bizorderok data) {
        this.insertObject(data);
    }

    @Override
    public void updateBizorderok(Bizorderok data) {
        super.getHibernateTemplate().merge((Object)data);
    }

    @Override
    public void deleteBizorderokById(long ... seqids) {
        this.deleteObject("bizorderok", seqids);
    }

    @Override
    public void moveBizorderokToHis(Bizorderok data) {
        StringBuilder sql = new StringBuilder();
        StringBuilder where = new StringBuilder();
        String deleteSql = "delete from bizorderok ";
        sql.append("insert into bizorderokhis(xunleipayid,version,pagecharset,bgurl,bizno,bizorderid,paytype,extpaycompany,");
        sql.append("extpayorderid,orderamt,ordertime,bankno,productname,productdesc,payername,payercontact,ext1,ext2,orderip,");
        sql.append("successtime,xunleiid,balancedate,sendnoticestatus,thunderstatus,applyrechargeid,applyconsumeid,");
        sql.append("balancedaterecharge,balancedateconsume,remark,usershow,peerid,other1,other2,other3,fareamt,DivideAmt,type,ordergroup) ");
        sql.append(" select xunleipayid,version,pagecharset,bgurl,bizno,bizorderid,paytype,extpaycompany,");
        sql.append("extpayorderid,orderamt,ordertime,bankno,productname,productdesc,payername,payercontact,ext1,ext2,orderip,");
        sql.append("successtime,xunleiid,balancedate,sendnoticestatus,thunderstatus,applyrechargeid,applyconsumeid,");
        sql.append("balancedaterecharge,balancedateconsume,remark,usershow,peerid,other1,other2,other3,fareamt,DivideAmt,type,ordergroup");
        sql.append(" from bizorderok ");
        where.append(" where 1=1 ");
        if (data != null) {
            if (data.getSeqid() > 0L) {
                where.append(" and seqid=").append(data.getSeqid());
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<='").append(data.getTodate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>='").append(data.getFromdate()).append("' ");
            }
        }
        this.execute(sql.toString() + where.toString());
        this.execute(deleteSql + where.toString());
    }

    @Override
    public void moveBizorderokToTQ(String time) throws ParseException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append("bizorderok_").append(TimeUtil.getQuarterTable(time)).append(" ");
        sql.append("select * from bizorderok ");
        sql.append(" where 1=1 and balancedate='").append(time).append("'");
        logger.info((Object)("bizorderok-->sql-->" + sql.toString()));
        this.execute(sql.toString());
        logger.info((Object)("bizorder:begin to delete data from bizorderok where balancedate equals " + time));
        String deleteSql = "delete from bizorderok where balancedate='" + time + "'";
        this.execute(deleteSql);
        logger.info((Object)"delete bizorderok data over.....");
    }

    @Override
    public void moveDataToDay(String balancedate, String exWhere) {
        DatabaseMetaData metaData = null;
        try {
            metaData = this.getConnection().getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet set = metaData.getTables(null, null, "bizorderok%", types);
            Calendar cal = Calendar.getInstance();
            cal.add(5, -7);
            String time_suffix = new SimpleDateFormat("yyMMdd").format(cal.getTime());
            logger.debug((Object)("time_suffix = " + time_suffix));
            String fiveAgoTB = "bizorderok" + time_suffix;
            String p = "bizorderok[0-9]{6}";
            Pattern pattern = Pattern.compile(p);
            while (set.next()) {
                String tableName = set.getString(3);
                Matcher matcher = pattern.matcher(tableName);
                if (!matcher.find()) continue;
                logger.debug((Object)("tableName = " + tableName));
                String sql = "select '" + fiveAgoTB + "' > '" + tableName + "'";
                logger.debug((Object)("sql = " + sql));
                Statement time_stat = this.getConnection().createStatement();
                ResultSet time_resultSet = time_stat.executeQuery(sql);
                time_resultSet.next();
                int time_result = time_resultSet.getInt(1);
                if (time_result != 1) continue;
                this.execute("drop table if exists " + tableName);
            }
        }
        catch (CannotGetJdbcConnectionException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String dropsql = "drop table if exists bizorderok" + balancedate;
        this.execute(dropsql);
        String createTableSql = "CREATE TABLE `bizorderok" + balancedate + "` (\n" + "   `SeqId` bigint(20) NOT NULL auto_increment,\n" + "   `Version` varchar(10) NOT NULL default '',\n" + "   `PageCharset` varchar(2) NOT NULL default '',\n" + "   `BgUrl` varchar(255) NOT NULL default '',\n" + "   `FgUrl` varchar(255) NOT NULL default '',\n" + "   `XunleiPayId` varchar(19) NOT NULL default '',\n" + "   `BizNo` varchar(20) NOT NULL default '',\n" + "   `BizOrderId` varchar(60) NOT NULL default '',\n" + "   `PayType` varchar(2) NOT NULL default '',\n" + "   `ExtPayCompany` varchar(2) NOT NULL default '',\n" + "   `ExtPayOrderId` varchar(20) NOT NULL default '',\n" + "   `OrderAmt` decimal(14,2) NOT NULL default '0.00',\n" + "   `OrderTime` varchar(19) NOT NULL default '',\n" + "   `BankNo` varchar(20) NOT NULL default '',\n" + "   `UserShow` varchar(30) NOT NULL default '',\n" + "   `ProductName` varchar(50) NOT NULL default '',\n" + "   `ProductDesc` varchar(255) NOT NULL default '',\n" + "   `PayerName` varchar(30) NOT NULL default '',\n" + "   `PayerContact` varchar(50) NOT NULL default '',\n" + "   `Ext1` varchar(255) NOT NULL default '',\n" + "   `Ext2` varchar(255) NOT NULL default '',\n" + "   `OrderIp` varchar(15) NOT NULL default '',\n" + "   `SuccessTime` varchar(19) NOT NULL default '',\n" + "   `XunleiId` varchar(30) NOT NULL default '',\n" + "   `BalanceDate` varchar(10) NOT NULL default '',\n" + "   `SendNoticeStatus` varchar(2) NOT NULL default '',\n" + "   `ThunderStatus` varchar(2) NOT NULL default '',\n" + "   `ApplyRechargeId` varchar(18) NOT NULL default '',\n" + "   `ApplyConsumeId` varchar(18) NOT NULL default '',\n" + "   `BalanceDateRecharge` varchar(10) NOT NULL default '',\n" + "   `BalanceDateConsume` varchar(10) NOT NULL default '',\n" + "   `Remark` varchar(255) NOT NULL default '',\n" + "   `PeerId` varchar(32) NOT NULL default '',\n" + "   `other1` text NOT NULL default '',\n" + "   `other2` varchar(255) NOT NULL default '',\n" + "   `other3` varchar(255) NOT NULL default '',\n" + "   `fareamt` decimal(14,2) NOT NULL default '',\n" + "   `divideamt` decimal(14,2) NOT NULL default '',\n" + "   `type` varchar(2) NOT NULL default '',\n" + "   `ordergroup` varchar(30) NOT NULL default '',\n" + "   PRIMARY KEY  (`SeqId`)" + " ) ENGINE=MyISAM DEFAULT CHARSET=utf8";
        this.execute(createTableSql);
        StringBuilder sql = new StringBuilder();
        sql.append("insert into bizorderok").append(balancedate).append("(version,pagecharset,bgurl,fgurl,XunleiPayId,bizno,bizorderid,paytype,extpaycompany,");
        sql.append("extpayorderid,orderamt,ordertime,bankno,usershow,productname,productdesc,payername,payercontact,ext1,ext2,orderip,");
        sql.append("successtime,xunleiid,balancedate,sendnoticestatus,thunderstatus,applyrechargeid,applyconsumeid,");
        sql.append("balancedaterecharge,balancedateconsume,remark,peerid,other1,other2,other3,fareamt,divideamt,type,ordergroup) ");
        sql.append(" select version,pagecharset,bgurl,fgurl,XunleiPayId,bizno,bizorderid,paytype,extpaycompany,");
        sql.append("extpayorderid,orderamt,ordertime,bankno,usershow,productname,productdesc,payername,payercontact,ext1,ext2,orderip,");
        sql.append("successtime,xunleiid,balancedate,sendnoticestatus,thunderstatus,applyrechargeid,applyconsumeid,");
        sql.append("balancedaterecharge,balancedateconsume,remark,peerid,other1,other2,other3,fareamt,divideamt,type,ordergroup");
        sql.append(" from bizorderok ");
        this.execute(sql.toString() + " where 1=1 " + exWhere);
    }

    @Override
    public List<Bizorderok> queryBizorderokSendnoticeYButNoInPaynotice(String startTime, String endTime, Set<String> exPayTypeSet) {
        StringBuilder builder = new StringBuilder("select * FROM bizorderok where 1=1 and SendNoticeStatus='Y' ");
        if (exPayTypeSet != null && !exPayTypeSet.isEmpty()) {
            builder.append("and PayType not in(");
            boolean first = true;
            for (String one : exPayTypeSet) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append("'").append(one).append("'");
            }
            builder.append(") ");
        }
        builder.append(" and SuccessTime>'").append(startTime).append("' and SuccessTime<'").append(endTime).append("' and xunleipayid not in (select xunleipayid from paynoticefail where NoticeTime>'").append(startTime).append("' union all select xunleipayid from paynoticeok where NoticeTime>'").append(startTime).append("')");
        logger.info((Object)("queryBizorderokNotice.sql-->" + builder.toString()));
        return this.query(Bizorderok.class, builder.toString(), new String[0]);
    }

    @Override
    public Sheet<Bizorderok> queryBizorderokInPayTypes(Bizorderok data, PagedFliper fliper) {
        int rowcount;
        String sql = "select b.*,c.bizname from bizorderok b, copbizinfo c ";
        String countsql = "select count(1) from bizorderok b, copbizinfo c ";
        StringBuilder where = new StringBuilder(" where 1=1 and b.bizno=c.bizno ");
        if (null != data) {
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and b.bizno='").append(data.getBizno()).append("' ");
            } else if (data.getBiznos() != null) {
                if (data.getBiznos().length == 0) {
                    return Sheet.EMPTY;
                }
                where.append(" and b.bizno in").append(BizorderokDaoImpl.uniteForIn((String[])data.getBiznos()));
            }
            if (this.isNotEmpty(data.getThunderstatus())) {
                where.append(" and thunderstatus='").append(data.getThunderstatus()).append("' ");
            }
            if (this.isNotEmpty(data.getUsershow())) {
                where.append(" and usershow='").append(data.getUsershow()).append("' ");
            }
            if (this.isNotEmpty(data.getPeerid())) {
                where.append(" and peerid='").append(data.getPeerid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiid())) {
                where.append(" and xunleiid='").append(data.getXunleiid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<='").append(data.getTodate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>='").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromtime())) {
                where.append(" and successtime>='").append(StringTools.escapeSql((String)data.getFromtime())).append(" 00:00:00' ");
            }
            if (this.isNotEmpty(data.getTotime())) {
                where.append(" and successtime<='").append(StringTools.escapeSql((String)data.getTotime())).append(" 23:59:59' ");
            }
            if (this.isNotEmpty(data.getMonitortime())) {
                where.append(" and successtime<='").append(data.getMonitortime()).append("' ");
            }
            if (this.isNotEmpty(data.getPaytype())) {
                where.append(" and paytype in (").append(data.getPaytype()).append(")");
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpayorderid())) {
                where.append(" and extpayorderid='").append(data.getExtpayorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getSendnoticestatus())) {
                where.append(" and sendnoticestatus='").append(data.getSendnoticestatus()).append("' ");
            }
            if (this.isNotEmpty(data.getBankno())) {
                where.append(" and bankno='").append(data.getBankno()).append("' ");
            }
            if (data.getOrderamt() > 0.0) {
                where.append(" and orderamt=").append(data.getOrderamt()).append(" ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderip())) {
                where.append(" and orderip='").append(data.getOrderip()).append("' ");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = countsql + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet(rowcount, (Collection)this.query(Bizorderok.class, sql, new String[]{"bizname"}));
    }

    @Override
    public Sheet<Bizorderok> queryBizorderokInPayTypesUnionHis(Bizorderok data, PagedFliper fliper, List<String> tableList) {
        if (tableList == null || tableList.isEmpty()) {
            return this.queryBizorderokInPayTypes(data, fliper);
        }
        StringBuilder where = new StringBuilder(" where 1=1 and b.bizno=c.bizno ");
        if (null != data) {
            if (data.getBiznos() != null && data.getBiznos().length == 0) {
                return Sheet.EMPTY;
            }
            this.createBizorderOkPaytypesInWhere(data, where);
        }
        StringBuilder countbuilder = new StringBuilder("select sum(t.c) from (");
        StringBuilder querybuilder = new StringBuilder();
        String singleCount = "select count(1) as c from ";
        String singleQuery = "select b.*,c.bizname from ";
        boolean first = true;
        for (String table : tableList) {
            if (first) {
                first = false;
            } else {
                countbuilder.append(" UNION ALL ");
                querybuilder.append(" UNION ALL ");
            }
            countbuilder.append("(").append(singleCount).append(table).append(" b, copbizinfo c ").append((CharSequence)where).append(")");
            querybuilder.append("(").append(singleQuery).append(table).append(" b, copbizinfo c ").append((CharSequence)where).append(")");
        }
        countbuilder.append(") t");
        int rowcount = this.getSingleInt(countbuilder.toString());
        if (rowcount <= 0) {
            return Sheet.EMPTY;
        }
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                querybuilder.append(" order by ").append(fliper.getSortColumn());
            }
            querybuilder.append(fliper.limitsql(rowcount));
        }
        return new Sheet(rowcount, (Collection)this.query(Bizorderok.class, querybuilder.toString(), new String[]{"bizname"}));
    }

    public Bizorderok findBizorderokUnionHis(Bizorderok data) {
        String sql = "select * from bizorderok";
        String countsql = "select count(1) from bizorderok";
        StringBuilder where = new StringBuilder(" where 1=1");
        if (null != data) {
            if (data.getSeqid() > 0L) {
                return this.getBizorderokById(data.getSeqid());
            }
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and bizno='").append(data.getBizno()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpayorderid())) {
                where.append(" and extpayorderid='").append(data.getExtpayorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpaycompany())) {
                where.append(" and extpaycompany='").append(data.getExtpaycompany()).append("' ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderip())) {
                where.append(" and orderip='").append(data.getOrderip()).append("' ");
            }
            countsql = countsql + where.toString();
            sql = sql + where.toString();
            sql = sql + " limit 1 ";
            logger.debug((Object)("find bizorderok sql:" + sql));
            if (this.getSingleInt(countsql) >= 1) {
                return (Bizorderok)this.queryOne(Bizorderok.class, sql, new String[0]);
            }
        }
        return null;
    }

    private void createBizorderOkPaytypesInWhere(Bizorderok data, StringBuilder where) {
        if (this.isNotEmpty(data.getBalancedate())) {
            where.append(" and balancedate='").append(data.getBalancedate()).append("' ");
        }
        if (this.isNotEmpty(data.getBizno())) {
            where.append(" and b.bizno='").append(data.getBizno()).append("' ");
        } else if (data.getBiznos() != null && data.getBiznos().length > 0) {
            where.append(" and b.bizno in").append(BizorderokDaoImpl.uniteForIn((String[])data.getBiznos()));
        }
        if (this.isNotEmpty(data.getThunderstatus())) {
            where.append(" and thunderstatus='").append(data.getThunderstatus()).append("' ");
        }
        if (this.isNotEmpty(data.getUsershow())) {
            where.append(" and usershow='").append(data.getUsershow()).append("' ");
        }
        if (this.isNotEmpty(data.getPeerid())) {
            where.append(" and peerid='").append(data.getPeerid().toLowerCase()).append("' ");
        }
        if (this.isNotEmpty(data.getXunleiid())) {
            where.append(" and xunleiid='").append(data.getXunleiid().toLowerCase()).append("' ");
        }
        if (this.isNotEmpty(data.getTodate())) {
            where.append(" and balancedate<='").append(data.getTodate()).append("' ");
        }
        if (this.isNotEmpty(data.getFromdate())) {
            where.append(" and balancedate>='").append(data.getFromdate()).append("' ");
        }
        if (this.isNotEmpty(data.getFromtime())) {
            where.append(" and successtime>='").append(StringTools.escapeSql((String)data.getFromtime())).append(" 00:00:00' ");
        }
        if (this.isNotEmpty(data.getTotime())) {
            where.append(" and successtime<='").append(StringTools.escapeSql((String)data.getTotime())).append(" 23:59:59' ");
        }
        if (this.isNotEmpty(data.getMonitortime())) {
            where.append(" and successtime<='").append(data.getMonitortime()).append("' ");
        }
        if (this.isNotEmpty(data.getPaytype())) {
            where.append(" and paytype in (").append(data.getPaytype()).append(")");
        }
        if (this.isNotEmpty(data.getBizorderid())) {
            where.append(" and bizorderid='").append(data.getBizorderid()).append("' ");
        }
        if (this.isNotEmpty(data.getXunleipayid())) {
            where.append(" and xunleipayid='").append(data.getXunleipayid()).append("' ");
        }
        if (this.isNotEmpty(data.getExtpayorderid())) {
            where.append(" and extpayorderid='").append(data.getExtpayorderid()).append("' ");
        }
        if (this.isNotEmpty(data.getSendnoticestatus())) {
            where.append(" and sendnoticestatus='").append(data.getSendnoticestatus()).append("' ");
        }
        if (this.isNotEmpty(data.getBankno())) {
            where.append(" and bankno='").append(data.getBankno()).append("' ");
        }
        if (data.getOrderamt() > 0.0) {
            where.append(" and orderamt=").append(data.getOrderamt()).append(" ");
        }
        if (this.isNotEmpty(data.getType())) {
            where.append(" and type='").append(data.getType().toLowerCase()).append("' ");
        }
        if (this.isNotEmpty(data.getOrdergroup())) {
            where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
        }
        if (this.isNotEmpty(data.getOrderip())) {
            where.append(" and orderip='").append(data.getOrderip()).append("' ");
        }
    }

    @Override
    public List<String> queryBizorderoksByOrderip(Bizorderok bizorderok) {
        StringBuilder builder = new StringBuilder("select distinct(xunleiid) FROM bizorderok where 1=1 and paytype='A'");
        builder.append(" and orderip='").append(bizorderok.getOrderip()).append("' and SuccessTime>'").append(bizorderok.getFromtime()).append("' and SuccessTime<'").append(bizorderok.getTotime()).append("'");
        logger.info((Object)("checking sql:" + builder.toString()));
        return this.queryToList(builder.toString());
    }

    @Override
    public List<Bizorderok> queryBizorderok4Game(Bizorderok data, Set<String> exGameIdSet) {
        StringBuilder builder = new StringBuilder("select * FROM bizorderok where 1=1 and bizno='000001021' ");
        if (null != data) {
            if (0L != data.getSeqid()) {
                builder.append(" and seqid>'").append(data.getSeqid()).append("'");
            }
            if (null != data.getFromtime() && !"".equals(data.getFromtime())) {
                builder.append(" and SuccessTime>'").append(data.getFromtime()).append("'");
            }
            if (0.0 != data.getOrderamt()) {
                builder.append(" and orderamt>='").append(data.getOrderamt()).append("'");
            }
        }
        if (exGameIdSet != null && !exGameIdSet.isEmpty()) {
            builder.append(" and ext1 not in(");
            boolean first = true;
            for (String one : exGameIdSet) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append("'").append(one).append("'");
            }
            builder.append(") ");
        }
        builder.append(" order by successtime asc limit 0,100");
        logger.info((Object)("querybizorderok4game sql-->" + builder.toString()));
        return this.query(Bizorderok.class, builder.toString(), new String[0]);
    }

    @Override
    public Map<String, Integer> queryBizorderoksUserNum(String bizNo, String payType, String fromDate, String toDate) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        StringBuilder sb = new StringBuilder();
        sb.append("select count(distinct XunleiId) from bizorderok where BizNo='").append(bizNo).append("'").append(" and PayType='").append(payType).append("'").append(" and successtime>= '").append(StringTools.escapeSql((String)fromDate)).append(" 00:00:00'").append(" and successtime<= '").append(StringTools.escapeSql((String)toDate)).append(" 23:59:59'");
        map.put("successPayNum", this.getSingleInt(sb.toString()));
        StringBuilder sb2 = new StringBuilder();
        sb2.append("select count(distinct XunleiId) from (( select XunleiId from bizorderok where BizNo='").append(bizNo).append("'").append(" and PayType='").append(payType).append("'").append(" and successtime>= '").append(StringTools.escapeSql((String)fromDate)).append(" 00:00:00'").append(" and successtime<= '").append(StringTools.escapeSql((String)toDate)).append(" 23:59:59'").append(") union all (").append("select XunleiId from bizorder where BizNo='").append(bizNo).append("'").append(" and PayType='").append(payType).append("'").append(" and InputTime>= '").append(StringTools.escapeSql((String)fromDate)).append(" 00:00:00'").append(" and InputTime<= '").append(StringTools.escapeSql((String)toDate)).append(" 23:59:59'").append(")) bo");
        map.put("payNum", this.getSingleInt(sb2.toString()));
        return map;
    }

    @Override
    public int queryPayCountsByID(String xunleiid, String balancedate) {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(1) from bizorderok where 1=1 and ");
        sql.append("bizno in ('000001002','000001037','000001048','000001021','000001050') and ");
        sql.append("xunleiid='").append(xunleiid).append("' and balancedate>='").append(balancedate).append("'");
        logger.info((Object)("sql-->" + sql.toString()));
        return this.getSingleInt(sql.toString());
    }

    @Override
    public Sheet<Bizorderok> queryBizorderokhisInTypesAndNotInBiznosNew(Bizorderok data, PagedFliper fliper, List<String> tables, String[] types, String[] excludeBiznos) {
        if (tables.size() == 0) {
            return this.queryBizorderok(data, fliper);
        }
        String sql = "";
        String countSql = "SELECT SUM(cou) FROM ( ";
        StringBuilder where = this.buildQueryWhereStat(data, false);
        if (null != data) {
            if (this.isEmpty(data.getBizno()) && data.getBiznos() != null) {
                if (data.getBiznos().length == 0) {
                    return Sheet.EMPTY;
                }
                where.append(" and b.bizno in ").append(BizorderokDaoImpl.uniteForIn((String[])data.getBiznos()));
            }
            if (types.length != 0 && this.isEmpty(data.getType())) {
                where.append(" and b.type in ").append(BizorderokDaoImpl.uniteForIn((String[])types));
            }
            if (excludeBiznos.length != 0 && this.isEmpty(data.getBizno())) {
                where.append(" and b.bizno not in ").append(BizorderokDaoImpl.uniteForIn((String[])excludeBiznos));
            }
        }
        int i = 0;
        for (String table : tables) {
            ++i;
            if (!this.isNotEmpty(table)) continue;
            String sqlTmp = "select b.* from " + table + " b " + where.toString();
            String countsqlTmp = "select count(1) as cou from " + table + " b " + where.toString();
            if (i == tables.size()) {
                sql = sql + "(" + sqlTmp + ") ";
                countSql = countSql + "(" + countsqlTmp + ") ) t";
                continue;
            }
            sql = sql + "(" + sqlTmp + ") union all ";
            countSql = countSql + "(" + countsqlTmp + ") union all ";
        }
        int rowcount = this.getSingleInt(countSql);
        if (rowcount <= 0) {
            return Sheet.EMPTY;
        }
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        logger.info((Object)("sql-->" + sql));
        logger.info((Object)("countsql-->" + countSql));
        return new Sheet(rowcount, (Collection)this.query(Bizorderok.class, sql, new String[0]));
    }

    private StringBuilder buildQueryWhereStat(Bizorderok data, boolean hasCop) {
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (hasCop) {
            where.append(" and b.bizno=c.bizno ");
        }
        if (null != data) {
            if (data.getSeqid() > 0L) {
                where.append(" and seqid=").append(data.getSeqid());
            }
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getThunderstatus())) {
                where.append(" and thunderstatus='").append(data.getThunderstatus()).append("' ");
            }
            if (this.isNotEmpty(data.getUsershow())) {
                where.append(" and usershow='").append(data.getUsershow()).append("' ");
            }
            if (this.isNotEmpty(data.getPeerid())) {
                where.append(" and peerid='").append(data.getPeerid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiid())) {
                where.append(" and xunleiid='").append(data.getXunleiid()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<='").append(data.getTodate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>='").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and b.bizno='").append(data.getBizno()).append("' ");
            }
            if (this.isNotEmpty(data.getFromtime())) {
                where.append(" and successtime>='").append(StringTools.escapeSql((String)data.getFromtime())).append(" 00:00:00' ");
            }
            if (this.isNotEmpty(data.getTotime())) {
                where.append(" and successtime<='").append(StringTools.escapeSql((String)data.getTotime())).append(" 23:59:59' ");
            }
            if (this.isNotEmpty(data.getPaytype())) {
                where.append(" and paytype='").append(data.getPaytype()).append("' ");
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpayorderid())) {
                where.append(" and extpayorderid='").append(data.getExtpayorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getBankno())) {
                where.append(" and bankno='").append(data.getBankno()).append("' ");
            }
            if (data.getOrderamt() > 0.0) {
                where.append(" and orderamt=").append(data.getOrderamt()).append(" ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            if (this.isNotEmpty(data.getSendnoticestatus())) {
                where.append(" and sendnoticestatus='").append(data.getSendnoticestatus()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderip())) {
                where.append(" and orderip='").append(data.getOrderip()).append("' ");
            }
            if (this.isNotEmpty(data.getRemark())) {
                where.append(" and remark='").append(data.getRemark()).append("' ");
            }
        }
        return where;
    }

    @Override
    public boolean hasPayed(String userid) {
        String start = "2009-01-01";
        String end = Utility.dateofnow();
        try {
            logger.info((Object)"begin to getTables");
            List<String> tables = TimeUtil.getTables4BizorderOk(start, end);
            if (null == tables || tables.size() == 0) {
                logger.info((Object)"no given tables....");
                return false;
            }
            for (String table : tables) {
                StringBuffer sql = new StringBuffer();
                sql.append("select count(1) from ").append(table);
                sql.append(" where xunleiid='").append(userid).append("'");
                logger.info((Object)("query for haspayed :" + sql.toString()));
                int result = this.getSingleInt(sql.toString());
                if (result <= 0) continue;
                return true;
            }
        }
        catch (ParseException e) {
            logger.info((Object)("check payrecords for " + userid + "\twith exception:" + e.getMessage()));
        }
        return false;
    }

    @Override
    public Sheet<Bizorderok> queryBizorderokList(Bizorderok data, PagedFliper fliper, List<String> tables) {
        int hasQueryNum;
        logger.info((Object)("queryBizorderokList-----start at time(long) : " + new Date().getTime()));
        logger.info((Object)("queryBizorderokList-----table list is : " + tables));
        if (tables.isEmpty()) {
            return Sheet.EMPTY;
        }
        if (fliper == null || fliper.getPageNo() == 0) {
            return Sheet.EMPTY;
        }
        final Bizorderok sumAmount = new Bizorderok();
        final HashMap eachTableMap = new HashMap();
        int startQuery = (fliper.getPageNo() - 1) * fliper.getPageSize();
        int endQuery = fliper.getPageNo() * fliper.getPageSize();
        ArrayList<Bizorderok> resultList = new ArrayList<Bizorderok>();
        Collections.sort(tables);
        logger.info((Object)("sorted tables: " + tables));
        Iterator<String> iterator = tables.iterator();
        while (iterator.hasNext()) {
            String countsql = "select count(*) as remark,sum(orderamt) as orderamt from ";
            final String table = iterator.next();
            countsql = countsql + table + " b ";
            countsql = countsql + this.buildQueryWhereStat(data, false).toString();
            logger.info((Object)("countsql: " + countsql));
            this.getJdbcTemplate().query(countsql, new RowCallbackHandler(){

                public void processRow(ResultSet resultSet) throws SQLException {
                    double oldamount = sumAmount.getOrderamt();
                    sumAmount.setOrderamt(oldamount + resultSet.getDouble("orderamt"));
                    int count = Integer.parseInt(resultSet.getString("remark"));
                    eachTableMap.put(table, count);
                    int oldTotalCount = 0;
                    if (eachTableMap.get("totalCount") != null) {
                        oldTotalCount = (Integer)eachTableMap.get("totalCount");
                    }
                    eachTableMap.put("totalCount", oldTotalCount + count);
                }
            });
        }
        logger.info((Object)("\u6bcf\u5f20\u8868\u5bf9\u5e94\u7684\u6570\u636e\u91cf\u4e3a\uff1a" + eachTableMap));
        logger.info((Object)("\u9700\u8981\u67e5\u8be2\u7684\u6570\u636e\u4e3a\uff1a\u7b2c " + fliper.getPageNo() + " \u4e2a " + fliper.getPageSize() + " \u6761"));
        int totalCount = (Integer)eachTableMap.get("totalCount");
        if (!fliper.getSortColumn().toUpperCase().contains("DESC")) {
            resultList = new ArrayList();
            hasQueryNum = 0;
            int havedShow = 0;
            for (int i = tables.size() - 1; i >= 0; --i) {
                Sheet sheetdata;
                String sql;
                String table = tables.get(i);
                hasQueryNum += ((Integer)eachTableMap.get(table)).intValue();
                if (totalCount > fliper.getPageSize() && i < tables.size() - 1) {
                    startQuery -= hasQueryNum - (Integer)eachTableMap.get(table);
                }
                logger.info((Object)("startquery is " + startQuery));
                if (hasQueryNum >= endQuery) {
                    sql = "select * from " + table + " b ";
                    if (havedShow > 0) {
                        startQuery = 0;
                    }
                    if (startQuery < 0) {
                        startQuery = 0;
                    }
                    sql = sql + this.buildQueryWhereStat(data, false).toString() + " order by " + fliper.getSortColumn() + " limit " + startQuery + "," + (fliper.getPageSize() - havedShow);
                    sheetdata = new Sheet(0, (Collection)this.query(Bizorderok.class, sql, new String[]{""}));
                    resultList.addAll(sheetdata.getDatas());
                    break;
                }
                if (hasQueryNum < startQuery) continue;
                sql = "select * from " + table + " b ";
                havedShow = hasQueryNum - startQuery;
                if (startQuery < 0) {
                    startQuery = 0;
                }
                sql = sql + this.buildQueryWhereStat(data, false).toString() + " order by " + fliper.getSortColumn() + " limit " + startQuery + "," + havedShow;
                sheetdata = new Sheet(0, (Collection)this.query(Bizorderok.class, sql, new String[]{""}));
                resultList.addAll(sheetdata.getDatas());
            }
        } else {
            resultList = new ArrayList();
            hasQueryNum = 0;
            int havedShow = 0;
            for (int i = 0; i < tables.size(); ++i) {
                Sheet sheetdata;
                String sql;
                String table = tables.get(i);
                hasQueryNum += ((Integer)eachTableMap.get(table)).intValue();
                if (totalCount > fliper.getPageSize() && i >= 1) {
                    startQuery -= hasQueryNum - (Integer)eachTableMap.get(table);
                }
                logger.info((Object)("startquery is " + startQuery));
                if (hasQueryNum >= endQuery) {
                    sql = "select * from " + table + " b ";
                    if (havedShow > 0) {
                        startQuery = 0;
                    }
                    if (startQuery < 0) {
                        startQuery = 0;
                    }
                    sql = sql + this.buildQueryWhereStat(data, false).toString() + " order by " + fliper.getSortColumn() + " limit " + startQuery + "," + (fliper.getPageSize() - havedShow);
                    sheetdata = new Sheet(0, (Collection)this.query(Bizorderok.class, sql, new String[]{""}));
                    resultList.addAll(sheetdata.getDatas());
                    break;
                }
                if (hasQueryNum < startQuery) continue;
                sql = "select * from " + table + " b ";
                havedShow = hasQueryNum - startQuery;
                if (startQuery < 0) {
                    startQuery = 0;
                }
                sql = sql + this.buildQueryWhereStat(data, false).toString() + " order by " + fliper.getSortColumn() + " limit " + startQuery + "," + havedShow;
                sheetdata = new Sheet(0, (Collection)this.query(Bizorderok.class, sql, new String[]{""}));
                resultList.addAll(sheetdata.getDatas());
            }
        }
        Sheet sheet = new Sheet();
        sheet.setRowcount(((Integer)eachTableMap.get("totalCount")).intValue());
        resultList.add(sumAmount);
        sheet.setDatas(resultList);
        return sheet;
    }

    @Override
    public Sheet<Bizorderok> queryBizorderokListByChangeSeqid(Bizorderok data, PagedFliper fliper, List<String> tables) {
        int hasQueryNum;
        logger.info((Object)("queryBizorderokListByChangeSeqid-----start at time(long) : " + new Date().getTime()));
        logger.info((Object)("queryBizorderokListByChangeSeqid-----table list is : " + tables));
        if (tables.isEmpty()) {
            return Sheet.EMPTY;
        }
        if (fliper == null || fliper.getPageNo() == 0) {
            return Sheet.EMPTY;
        }
        final Bizorderok sumAmount = new Bizorderok();
        final HashMap eachTableMap = new HashMap();
        int startQuery = (fliper.getPageNo() - 1) * fliper.getPageSize();
        int endQuery = fliper.getPageNo() * fliper.getPageSize();
        ArrayList<Bizorderok> resultList = new ArrayList<Bizorderok>();
        if (tables.contains("bizorderok")) {
            Collections.sort(tables);
            tables.remove(0);
            Collections.reverse(tables);
            tables.add(0, "bizorderok");
        } else {
            Collections.sort(tables);
            Collections.reverse(tables);
        }
        logger.info((Object)("sorted tables: " + tables));
        Iterator<String> iterator = tables.iterator();
        while (iterator.hasNext()) {
            String countsql = "select count(*) as remark,sum(orderamt) as orderamt from ";
            final String table = iterator.next();
            countsql = countsql + table + " b ";
            countsql = countsql + this.buildQueryWhereStat(data, false).toString();
            logger.info((Object)("countsql: " + countsql));
            this.getJdbcTemplate().query(countsql, new RowCallbackHandler(){

                public void processRow(ResultSet resultSet) throws SQLException {
                    double oldamount = sumAmount.getOrderamt();
                    sumAmount.setOrderamt(oldamount + resultSet.getDouble("orderamt"));
                    int count = Integer.parseInt(resultSet.getString("remark"));
                    eachTableMap.put(table, count);
                    int oldTotalCount = 0;
                    if (eachTableMap.get("totalCount") != null) {
                        oldTotalCount = (Integer)eachTableMap.get("totalCount");
                    }
                    eachTableMap.put("totalCount", oldTotalCount + count);
                }
            });
        }
        logger.info((Object)("\u6bcf\u5f20\u8868\u5bf9\u5e94\u7684\u6570\u636e\u91cf\u4e3a\uff1a" + eachTableMap));
        logger.info((Object)("\u9700\u8981\u67e5\u8be2\u7684\u6570\u636e\u4e3a\uff1a\u7b2c " + fliper.getPageNo() + " \u4e2a " + fliper.getPageSize() + " \u6761"));
        int totalCount = (Integer)eachTableMap.get("totalCount");
        if (!fliper.getSortColumn().toUpperCase().contains("DESC")) {
            resultList = new ArrayList();
            hasQueryNum = 0;
            int havedShow = 0;
            for (int i = tables.size() - 1; i >= 0; --i) {
                String sql;
                String table = tables.get(i);
                hasQueryNum += ((Integer)eachTableMap.get(table)).intValue();
                if (totalCount > fliper.getPageSize() && i < tables.size() - 1) {
                    startQuery -= hasQueryNum - (Integer)eachTableMap.get(table);
                }
                logger.info((Object)("startquery is " + startQuery));
                if (startQuery < 0) {
                    startQuery = 0;
                } else if (startQuery > (Integer)eachTableMap.get(table)) {
                    startQuery += hasQueryNum - (Integer)eachTableMap.get(table);
                    continue;
                }
                if (hasQueryNum >= endQuery) {
                    logger.info((Object)("hasQueryNum[" + hasQueryNum + "]\u5c0f\u4e8eendQuery[" + endQuery + "]"));
                    sql = "select * from " + table + " b ";
                    if (havedShow > 0) {
                        startQuery = 0;
                    }
                    logger.info((Object)("havedShow\u7684\u503c\u4e3a\uff1a" + havedShow));
                    if (havedShow > fliper.getPageSize()) {
                        havedShow = 0;
                    }
                    if (startQuery < 0) {
                        startQuery = 0;
                    }
                    sql = sql + this.buildQueryWhereStat(data, false).toString() + " order by " + fliper.getSortColumn() + " limit " + startQuery + "," + (fliper.getPageSize() - havedShow);
                    Sheet sheetdata = new Sheet(0, (Collection)this.query(Bizorderok.class, sql, new String[]{""}));
                    resultList.addAll(sheetdata.getDatas());
                    for (int tt = 0; tt < resultList.size(); ++tt) {
                        long modifySeqid;
                        logger.info((Object)("\u4fee\u6539seqid\uff0ctable\u4e3a\uff1a" + table));
                        Bizorderok modifyBizorderok = (Bizorderok)resultList.get(tt);
                        String seqidString = String.valueOf(modifyBizorderok.getSeqid());
                        if (seqidString.endsWith("00000") || seqidString.endsWith("11111") || seqidString.endsWith("22222") || seqidString.endsWith("33333") || seqidString.endsWith("44444")) {
                            logger.info((Object)("seqid:" + seqidString + "\u5df2\u7ecf\u4fee\u6539\u8fc7"));
                            continue;
                        }
                        if (table.endsWith("Q1")) {
                            modifySeqid = modifyBizorderok.getSeqid();
                            modifyBizorderok.setSeqid(modifySeqid * 100000L + 11111L);
                        } else if (table.endsWith("Q2")) {
                            modifySeqid = modifyBizorderok.getSeqid();
                            modifyBizorderok.setSeqid(modifySeqid * 100000L + 22222L);
                        } else if (table.endsWith("Q3")) {
                            modifySeqid = modifyBizorderok.getSeqid();
                            modifyBizorderok.setSeqid(modifySeqid * 100000L + 33333L);
                        } else if (table.endsWith("Q4")) {
                            modifySeqid = modifyBizorderok.getSeqid();
                            modifyBizorderok.setSeqid(modifySeqid * 100000L + 44444L);
                        } else {
                            modifySeqid = modifyBizorderok.getSeqid();
                            modifyBizorderok.setSeqid(modifySeqid * 100000L + 0L);
                        }
                        resultList.remove(tt);
                        resultList.add(tt, modifyBizorderok);
                    }
                    break;
                }
                if (hasQueryNum < startQuery) continue;
                logger.info((Object)("hasQueryNum[" + hasQueryNum + "]\u5927\u4e8estartQuery[" + startQuery + "]"));
                sql = "select * from " + table + " b ";
                int oldHavedShow = havedShow;
                havedShow = hasQueryNum - startQuery;
                logger.info((Object)("havedShow\u7684\u503c\u4e3a\uff1a" + havedShow));
                if (havedShow > fliper.getPageSize()) {
                    havedShow = oldHavedShow + (Integer)eachTableMap.get(table);
                }
                if (startQuery < 0) {
                    startQuery = 0;
                }
                sql = sql + this.buildQueryWhereStat(data, false).toString() + " order by " + fliper.getSortColumn() + " limit " + startQuery + "," + havedShow;
                Sheet sheetdata = new Sheet(0, (Collection)this.query(Bizorderok.class, sql, new String[]{""}));
                resultList.addAll(sheetdata.getDatas());
                for (int tt = 0; tt < resultList.size(); ++tt) {
                    long modifySeqid;
                    logger.info((Object)("\u4fee\u6539seqid\uff0ctable\u4e3a\uff1a" + table));
                    Bizorderok modifyBizorderok = (Bizorderok)resultList.get(tt);
                    String seqidString = String.valueOf(modifyBizorderok.getSeqid());
                    if (seqidString.endsWith("00000") || seqidString.endsWith("11111") || seqidString.endsWith("22222") || seqidString.endsWith("33333") || seqidString.endsWith("44444")) {
                        logger.info((Object)("seqid:" + seqidString + "\u5df2\u7ecf\u4fee\u6539\u8fc7"));
                        continue;
                    }
                    if (table.endsWith("Q1")) {
                        modifySeqid = modifyBizorderok.getSeqid();
                        modifyBizorderok.setSeqid(modifySeqid * 100000L + 11111L);
                    } else if (table.endsWith("Q2")) {
                        modifySeqid = modifyBizorderok.getSeqid();
                        modifyBizorderok.setSeqid(modifySeqid * 100000L + 22222L);
                    } else if (table.endsWith("Q3")) {
                        modifySeqid = modifyBizorderok.getSeqid();
                        modifyBizorderok.setSeqid(modifySeqid * 100000L + 33333L);
                    } else if (table.endsWith("Q4")) {
                        modifySeqid = modifyBizorderok.getSeqid();
                        modifyBizorderok.setSeqid(modifySeqid * 100000L + 44444L);
                    } else {
                        modifySeqid = modifyBizorderok.getSeqid();
                        modifyBizorderok.setSeqid(modifySeqid * 100000L + 0L);
                    }
                    resultList.remove(tt);
                    resultList.add(tt, modifyBizorderok);
                }
            }
        } else {
            resultList = new ArrayList();
            hasQueryNum = 0;
            int havedShow = 0;
            for (int i = 0; i < tables.size(); ++i) {
                String sql;
                String table = tables.get(i);
                hasQueryNum += ((Integer)eachTableMap.get(table)).intValue();
                if (totalCount > fliper.getPageSize() && i >= 1) {
                    startQuery -= hasQueryNum - (Integer)eachTableMap.get(table);
                }
                logger.info((Object)("startquery is " + startQuery));
                if (startQuery < 0) {
                    startQuery = 0;
                } else if (startQuery > (Integer)eachTableMap.get(table)) {
                    startQuery += hasQueryNum - (Integer)eachTableMap.get(table);
                    continue;
                }
                if (hasQueryNum >= endQuery) {
                    logger.info((Object)("hasQueryNum[" + hasQueryNum + "]\u5c0f\u4e8eendQuery[" + endQuery + "]"));
                    sql = "select * from " + table + " b ";
                    if (havedShow > 0) {
                        startQuery = 0;
                    }
                    logger.info((Object)("havedShow\u7684\u503c\u4e3a\uff1a" + havedShow));
                    if (havedShow > fliper.getPageSize()) {
                        havedShow = 0;
                    }
                    if (startQuery < 0) {
                        startQuery = 0;
                    }
                    sql = sql + this.buildQueryWhereStat(data, false).toString() + " order by " + fliper.getSortColumn() + " limit " + startQuery + "," + (fliper.getPageSize() - havedShow);
                    Sheet sheetdata = new Sheet(0, (Collection)this.query(Bizorderok.class, sql, new String[]{""}));
                    resultList.addAll(sheetdata.getDatas());
                    for (int tt = 0; tt < resultList.size(); ++tt) {
                        long modifySeqid;
                        logger.info((Object)("\u4fee\u6539seqid\uff0ctable\u4e3a\uff1a" + table));
                        Bizorderok modifyBizorderok = (Bizorderok)resultList.get(tt);
                        String seqidString = String.valueOf(modifyBizorderok.getSeqid());
                        if (seqidString.endsWith("00000") || seqidString.endsWith("11111") || seqidString.endsWith("22222") || seqidString.endsWith("33333") || seqidString.endsWith("44444")) {
                            logger.info((Object)("seqid:" + seqidString + "\u5df2\u7ecf\u4fee\u6539\u8fc7"));
                            continue;
                        }
                        if (table.endsWith("Q1")) {
                            modifySeqid = modifyBizorderok.getSeqid();
                            modifyBizorderok.setSeqid(modifySeqid * 100000L + 11111L);
                        } else if (table.endsWith("Q2")) {
                            modifySeqid = modifyBizorderok.getSeqid();
                            modifyBizorderok.setSeqid(modifySeqid * 100000L + 22222L);
                        } else if (table.endsWith("Q3")) {
                            modifySeqid = modifyBizorderok.getSeqid();
                            modifyBizorderok.setSeqid(modifySeqid * 100000L + 33333L);
                        } else if (table.endsWith("Q4")) {
                            modifySeqid = modifyBizorderok.getSeqid();
                            modifyBizorderok.setSeqid(modifySeqid * 100000L + 44444L);
                        } else {
                            modifySeqid = modifyBizorderok.getSeqid();
                            modifyBizorderok.setSeqid(modifySeqid * 100000L + 0L);
                        }
                        resultList.remove(tt);
                        resultList.add(tt, modifyBizorderok);
                    }
                    break;
                }
                if (hasQueryNum < startQuery) continue;
                logger.info((Object)("hasQueryNum[" + hasQueryNum + "]\u5927\u4e8estartQuery[" + startQuery + "]"));
                sql = "select * from " + table + " b ";
                int oldHavedShow = havedShow;
                havedShow = hasQueryNum - startQuery;
                logger.info((Object)("havedShow\u7684\u503c\u4e3a\uff1a" + havedShow));
                if (havedShow > fliper.getPageSize()) {
                    havedShow = oldHavedShow + (Integer)eachTableMap.get(table);
                }
                if (startQuery < 0) {
                    startQuery = 0;
                }
                sql = sql + this.buildQueryWhereStat(data, false).toString() + " order by " + fliper.getSortColumn() + " limit " + startQuery + "," + havedShow;
                Sheet sheetdata = new Sheet(0, (Collection)this.query(Bizorderok.class, sql, new String[]{""}));
                resultList.addAll(sheetdata.getDatas());
                for (int tt = 0; tt < resultList.size(); ++tt) {
                    long modifySeqid;
                    logger.info((Object)("\u4fee\u6539seqid\uff0ctable\u4e3a\uff1a" + table));
                    Bizorderok modifyBizorderok = (Bizorderok)resultList.get(tt);
                    String seqidString = String.valueOf(modifyBizorderok.getSeqid());
                    if (seqidString.endsWith("00000") || seqidString.endsWith("11111") || seqidString.endsWith("22222") || seqidString.endsWith("33333") || seqidString.endsWith("44444")) {
                        logger.info((Object)("seqid:" + seqidString + "\u5df2\u7ecf\u4fee\u6539\u8fc7"));
                        continue;
                    }
                    if (table.endsWith("Q1")) {
                        modifySeqid = modifyBizorderok.getSeqid();
                        modifyBizorderok.setSeqid(modifySeqid * 100000L + 11111L);
                    } else if (table.endsWith("Q2")) {
                        modifySeqid = modifyBizorderok.getSeqid();
                        modifyBizorderok.setSeqid(modifySeqid * 100000L + 22222L);
                    } else if (table.endsWith("Q3")) {
                        modifySeqid = modifyBizorderok.getSeqid();
                        modifyBizorderok.setSeqid(modifySeqid * 100000L + 33333L);
                    } else if (table.endsWith("Q4")) {
                        modifySeqid = modifyBizorderok.getSeqid();
                        modifyBizorderok.setSeqid(modifySeqid * 100000L + 44444L);
                    } else {
                        modifySeqid = modifyBizorderok.getSeqid();
                        modifyBizorderok.setSeqid(modifySeqid * 100000L + 0L);
                    }
                    resultList.remove(tt);
                    resultList.add(tt, modifyBizorderok);
                }
            }
        }
        Sheet sheet = new Sheet();
        sheet.setRowcount(((Integer)eachTableMap.get("totalCount")).intValue());
        resultList.add(sumAmount);
        sheet.setDatas(resultList);
        return sheet;
    }

    @Override
    public Sheet<Bizorderok> querySheetByXunleipayid(String xunleipayid, List<String> tables, PagedFliper fliper) {
        logger.info((Object)("\u9700\u8981\u67e5\u8be2\u7684tables\u6709\uff1a " + tables + ", xunleipayid\u4e3a\uff1a" + xunleipayid));
        StringBuilder querySqlBuilder = new StringBuilder();
        if (tables.size() == 1) {
            querySqlBuilder.append("select * from ").append(tables.get(0)).append(" where xunleipayid='").append(xunleipayid).append("'");
        } else {
            int index = 0;
            for (String talbe : tables) {
                querySqlBuilder.append("select * from ").append(talbe).append(" where xunleipayid='").append(xunleipayid).append("'");
                if (++index >= tables.size()) continue;
                querySqlBuilder.append(" union all ");
            }
        }
        String sql = querySqlBuilder.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(1);
        }
        logger.info((Object)("querybizorderok-----sql=" + sql));
        return new Sheet(1, (Collection)this.query(Bizorderok.class, sql, new String[]{""}));
    }

    @Override
    public int queryVipOrderCount(String xunleiId, String balanceDate, String ... bizNos) {
        StringBuffer sb = new StringBuffer("select count(1) from bizorderok where xunleiid='").append(xunleiId).append("' and balancedate>='").append(balanceDate).append("' ");
        if (bizNos != null && bizNos.length > 0) {
            sb.append(" and bizno in ('").append(bizNos[0]).append("'");
            for (int i = 1; i < bizNos.length; ++i) {
                if (!StringTools.isNotEmpty((String)bizNos[i])) continue;
                sb.append(",'").append(bizNos[i]).append("'");
            }
            sb.append(")");
        }
        String sql = sb.toString();
        logger.info((Object)("queryVipOrderCount sql:" + sql));
        return this.getSingleInt(sql);
    }

    @Override
    public Sheet<Bizorderok> queryBizorderokForNotice(Bizorderok data, PagedFliper fliper) {
        String sql = "select b.* from bizorderok b ";
        String countsql = "select count(1) from bizorderok b ";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (null != data) {
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and b.bizno='").append(data.getBizno()).append("' ");
            } else if (data.getBiznos() != null) {
                if (data.getBiznos().length == 0) {
                    return Sheet.EMPTY;
                }
                where.append(" and b.bizno in").append(BizorderokDaoImpl.uniteForIn((String[])data.getBiznos()));
            }
            if (this.isNotEmpty(data.getThunderstatus())) {
                where.append(" and thunderstatus='").append(data.getThunderstatus()).append("' ");
            }
            if (this.isNotEmpty(data.getUsershow())) {
                where.append(" and usershow='").append(data.getUsershow()).append("' ");
            }
            if (this.isNotEmpty(data.getPeerid())) {
                where.append(" and peerid='").append(data.getPeerid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiid())) {
                where.append(" and xunleiid='").append(data.getXunleiid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<='").append(data.getTodate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>='").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromtime())) {
                where.append(" and successtime>='").append(StringTools.escapeSql((String)data.getFromtime())).append("' ");
            }
            if (this.isNotEmpty(data.getTotime())) {
                where.append(" and successtime<='").append(StringTools.escapeSql((String)data.getTotime())).append("' ");
            }
            if (this.isNotEmpty(data.getMonitortime())) {
                where.append(" and successtime<='").append(data.getMonitortime()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and b.bizno='").append(data.getBizno()).append("' ");
            }
            if (this.isNotEmpty(data.getPaytype())) {
                where.append(" and paytype='").append(data.getPaytype()).append("' ");
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpayorderid())) {
                where.append(" and extpayorderid='").append(data.getExtpayorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getSendnoticestatus())) {
                where.append(" and sendnoticestatus='").append(data.getSendnoticestatus()).append("' ");
            }
            if (this.isNotEmpty(data.getBankno())) {
                where.append(" and bankno='").append(data.getBankno()).append("' ");
            }
            if (data.getOrderamt() > 0.0) {
                where.append(" and orderamt=").append(data.getOrderamt()).append(" ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderip())) {
                where.append(" and orderip='").append(data.getOrderip()).append("' ");
            }
        }
        countsql = countsql + where.toString();
        int rowcount = this.getSingleInt(countsql);
        logger.info((Object)("querybizorderok-----countsql=" + countsql));
        if (rowcount <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        logger.info((Object)("querybizorderok-----sql=" + sql));
        return new Sheet(rowcount, (Collection)this.query(Bizorderok.class, sql, new String[0]));
    }

    @Override
    public Sheet<Bizorderok> queryBizorderokForRefund(Bizorderok data, PagedFliper fliper, String orderDay) {
        String tableName = "";
        try {
            tableName = this.getBizorderokTb(orderDay);
            logger.info((Object)("get tablename:" + tableName));
        }
        catch (ParseException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
        String sql = "select b.* from " + tableName + " b ";
        String countsql = "select count(1) from " + tableName + " b ";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (null != data) {
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and b.bizno='").append(data.getBizno()).append("' ");
            } else if (data.getBiznos() != null) {
                if (data.getBiznos().length == 0) {
                    return Sheet.EMPTY;
                }
                where.append(" and b.bizno in").append(BizorderokDaoImpl.uniteForIn((String[])data.getBiznos()));
            }
            if (this.isNotEmpty(data.getThunderstatus())) {
                where.append(" and thunderstatus='").append(data.getThunderstatus()).append("' ");
            }
            if (this.isNotEmpty(data.getUsershow())) {
                where.append(" and usershow='").append(data.getUsershow()).append("' ");
            }
            if (this.isNotEmpty(data.getPeerid())) {
                where.append(" and peerid='").append(data.getPeerid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiid())) {
                where.append(" and xunleiid='").append(data.getXunleiid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<='").append(data.getTodate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>='").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromtime())) {
                where.append(" and successtime>='").append(StringTools.escapeSql((String)data.getFromtime())).append("' ");
            }
            if (this.isNotEmpty(data.getTotime())) {
                where.append(" and successtime<='").append(StringTools.escapeSql((String)data.getTotime())).append("' ");
            }
            if (this.isNotEmpty(data.getMonitortime())) {
                where.append(" and successtime<='").append(data.getMonitortime()).append("' ");
            }
            if (this.isNotEmpty(data.getPaytype())) {
                where.append(" and paytype='").append(data.getPaytype()).append("' ");
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpayorderid())) {
                where.append(" and extpayorderid='").append(data.getExtpayorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getSendnoticestatus())) {
                where.append(" and sendnoticestatus='").append(data.getSendnoticestatus()).append("' ");
            }
            if (this.isNotEmpty(data.getBankno())) {
                where.append(" and bankno='").append(data.getBankno()).append("' ");
            }
            if (data.getOrderamt() > 0.0) {
                where.append(" and orderamt=").append(data.getOrderamt()).append(" ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderip())) {
                where.append(" and orderip='").append(data.getOrderip()).append("' ");
            }
        }
        countsql = countsql + where.toString();
        int rowcount = this.getSingleInt(countsql);
        logger.info((Object)("querybizorderok-----countsql=" + countsql));
        if (rowcount <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        logger.info((Object)("querybizorderok-----sql=" + sql));
        return new Sheet(rowcount, (Collection)this.query(Bizorderok.class, sql, new String[0]));
    }

    public String getBizorderokTb(String orderTime) throws ParseException {
        SimpleDateFormat sp1 = new SimpleDateFormat("yyyyMMdd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(sp1.parse(orderTime));
        Calendar time7daysBefore = Calendar.getInstance();
        time7daysBefore.add(5, -7);
        if (cal.after(time7daysBefore)) {
            return "bizorderok";
        }
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        if (month == 1 || month == 2 || month == 3) {
            return "bizorderok_" + year + "Q1";
        }
        if (month == 4 || month == 5 || month == 6) {
            return "bizorderok_" + year + "Q2";
        }
        if (month == 7 || month == 8 || month == 9) {
            return "bizorderok_" + year + "Q3";
        }
        return "bizorderok_" + year + "Q4";
    }
}

