/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.dao;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.dao.BaseDao;
import com.xunlei.payproxy.dao.IBizorderDao;
import com.xunlei.payproxy.util.TimeUtil;
import com.xunlei.payproxy.vo.Bizorder;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BizorderDaoImpl
extends BaseDao
implements IBizorderDao {
    @Override
    public Bizorder findBizorder(Bizorder data) {
        String sql = "select * from bizorder";
        String countsql = "select count(1) from bizorder";
        StringBuilder where = new StringBuilder(" where 1=1");
        if (null != data) {
            if (data.getSeqid() > 0L) {
                return this.getBizorderById(data.getSeqid());
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and bizno='").append(data.getBizno()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpayorderid())) {
                where.append(" and extpayorderid='").append(data.getExtpayorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpaycompany())) {
                where.append(" and extpaycompany='").append(data.getExtpaycompany()).append("' ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderstatus())) {
                where.append(" and orderstatus='").append(data.getOrderstatus()).append("' ");
            }
            if (this.isNotEmpty(data.getErrcode())) {
                where.append(" and errcode='").append(data.getErrcode()).append("' ");
            }
            if (this.isNotEmpty(data.getSendnoticestatus())) {
                where.append(" and sendnoticestatus='").append(data.getSendnoticestatus()).append("' ");
            }
            countsql = countsql + where.toString();
            sql = sql + where.toString();
            logger.debug((Object)sql);
            if (this.getSingleInt(countsql) == 1) {
                return (Bizorder)this.queryOne(Bizorder.class, sql, new String[0]);
            }
        }
        return null;
    }

    @Override
    public Sheet<Bizorder> queryBizorder(Bizorder data, PagedFliper fliper) {
        int rowcount;
        String sql = "select * from bizorder";
        String countsql = "select count(1) from bizorder";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (null != data) {
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and inputtime<='").append(StringTools.escapeSql((String)data.getTodate())).append(" 23:59:59' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and inputtime>='").append(StringTools.escapeSql((String)data.getFromdate())).append(" 00:00:00'");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and bizno='").append(StringTools.escapeSql((String)data.getBizno())).append("' ");
            } else if (data.getBiznos() != null) {
                if (data.getBiznos().length == 0) {
                    return Sheet.EMPTY;
                }
                where.append(" and bizno in").append(BizorderDaoImpl.uniteForIn((String[])data.getBiznos()));
            }
            if (this.isNotEmpty(data.getPaytype())) {
                where.append(" and paytype='").append(data.getPaytype()).append("' ");
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
            if (this.isNotEmpty(data.getUsershow())) {
                where.append(" and usershow='").append(data.getUsershow()).append("' ");
            }
            if (this.isNotEmpty(data.getPeerid())) {
                where.append(" and peerid='").append(data.getPeerid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiid())) {
                where.append(" and xunleiid='").append(data.getXunleiid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpayorderid())) {
                where.append(" and extpayorderid='").append(data.getExtpayorderid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getBankno())) {
                where.append(" and bankno='").append(data.getBankno().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderstatus())) {
                where.append(" and orderstatus='").append(data.getOrderstatus()).append("' ");
            }
            if (this.isNotEmpty(data.getErrcode())) {
                where.append(" and errcode='").append(data.getErrcode()).append("' ");
            }
            if (this.isNotEmpty(data.getSendnoticestatus())) {
                where.append(" and sendnoticestatus='").append(data.getSendnoticestatus()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderip())) {
                where.append(" and orderip='").append(data.getOrderip()).append("' ");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = countsql + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet(rowcount, (Collection)this.query(Bizorder.class, sql, new String[0]));
    }

    @Override
    public void deleteBizorder(Bizorder data) {
        if (null != data && data.getSeqid() > 0L) {
            this.deleteBizorderById(data.getSeqid());
        }
    }

    @Override
    public int deleteBizorderTodate(String todate) {
        if (this.isNotEmpty(todate)) {
            String sql = "delete from  bizorder where inputtime<='" + todate + " 23:59:59' and type='A'";
            String sql2 = "delete from bizorder where inputtime<='" + todate + " 23:59:59' and type in ('B','C','D') and orderstatus='W'";
            return this.executeUpdate(sql) + this.executeUpdate(sql2);
        }
        return 0;
    }

    @Override
    public void moveBizorderToFail(Bizorder data) {
        StringBuilder sql = new StringBuilder();
        StringBuilder where = new StringBuilder();
        String deleteSql = "delete from bizorder ";
        sql.append("insert into bizorderfail(version,pagecharset,bgurl,xunleipayid,bizno,bizorderid,paytype,extpaycompany,");
        sql.append("extpayorderid,orderamt,ordertime,bankno,productname,productdesc,payername,payercontact,");
        sql.append("ext1,ext2,orderip,remark,xunleiid,usershow,peerid,inputtime,fgurl,other1,other2,other3,");
        sql.append("divideAmt,type,ordergroup,orderstatus,errcode,sendnoticestatus) ");
        sql.append("select version,pagecharset,bgurl,xunleipayid,bizno,bizorderid,paytype,extpaycompany,");
        sql.append("extpayorderid,orderamt,ordertime,bankno,productname,productdesc,payername,payercontact,");
        sql.append("ext1,ext2,orderip,remark,xunleiid,usershow,peerid,inputtime,fgurl,other1,other2,other3,");
        sql.append("divideAmt,type,ordergroup,orderstatus,errcode,sendnoticestatus from bizorder");
        where.append(" where 1=1 ");
        if (data != null) {
            if (data.getSeqid() > 0L) {
                where.append(" and seqid=").append(data.getSeqid());
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and inputtime<='").append(data.getTodate()).append(" 23:59:59'");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and inputtime>='").append(data.getFromdate()).append(" 00:00:00'");
            }
            where.append(" and type in ('B','C','D') and orderstatus='N'");
        }
        this.execute(sql.toString() + where.toString());
        this.execute(deleteSql + where.toString());
    }

    @Override
    public void moveBizorderToHis(String time) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into bizorderhis(version,pagecharset,bgurl,xunleipayid,bizno,bizorderid,paytype,extpaycompany,");
        sql.append("extpayorderid,orderamt,ordertime,bankno,productname,productdesc,payername,payercontact,");
        sql.append("ext1,ext2,orderip,remark,xunleiid,usershow,peerid,inputtime,fgurl,other1,other2,other3,");
        sql.append("divideAmt,type,ordergroup,orderstatus,errcode,sendnoticestatus) ");
        sql.append("select version,pagecharset,bgurl,xunleipayid,bizno,bizorderid,paytype,extpaycompany,");
        sql.append("extpayorderid,orderamt,ordertime,bankno,productname,productdesc,payername,payercontact,");
        sql.append("ext1,ext2,orderip,remark,xunleiid,usershow,peerid,inputtime,fgurl,other1,other2,other3,");
        sql.append("divideAmt,type,ordergroup,orderstatus,errcode,sendnoticestatus from bizorder ");
        sql.append(" where 1=1 and inputtime>='").append(time).append(" 00:00:00' and inputtime<='").append(time).append(" 23:59:59'");
        logger.info((Object)("bizorderhis-->sql-->" + sql.toString()));
        this.execute(sql.toString());
    }

    @Override
    public void moveBizorderToTQ(String time) throws ParseException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append("bizorder_").append(TimeUtil.getQuarterTable(time)).append(" ");
        sql.append("select * from bizorder ");
        sql.append(" where 1=1 and inputtime>='").append(time).append(" 00:00:00' and inputtime<='").append(time).append(" 23:59:59'");
        logger.info((Object)("bizorder-->sql-->" + sql.toString()));
        this.execute(sql.toString());
        logger.info((Object)("bizorder:begin to delete data from bizorder where inputtime before " + time));
        this.deleteBizorderTodate(time);
    }

    @Override
    public Bizorder getBizorderById(long seqid) {
        return (Bizorder)this.findObject(Bizorder.class, seqid);
    }

    @Override
    public void insertBizorder(Bizorder data) {
        this.insertObject(data);
    }

    @Override
    public void updateBizorder(Bizorder data) {
        this.updateObject(data);
    }

    @Override
    public void deleteBizorderById(long ... seqids) {
        this.deleteObject("bizorder", seqids);
    }

    @Override
    public List<Bizorder> queryRefundBizorderSendNotice() {
        StringBuilder builder = new StringBuilder("select * from bizorder where 1=1 and sendnoticestatus='N' and orderstatus='N' ");
        builder.append(" and type in ('C','D') ");
        return this.query(Bizorder.class, builder.toString(), new String[0]);
    }

    @Override
    public List<Bizorder> queryBizorderSendnoticeYButNoInPaynotice(String startTime, String endTime) {
        StringBuilder builder = new StringBuilder("select * FROM bizorder where 1=1 and SendNoticeStatus='Y' and orderstatus='N' ");
        builder.append(" and type in ('C','D') ");
        builder.append(" and inputtime>'").append(startTime).append("' and inputtime<'").append(endTime).append("' and xunleipayid not in (select xunleipayid from paynoticefail where NoticeTime>'").append(startTime).append("' union all select xunleipayid from paynoticeok where NoticeTime>'").append(startTime).append("')");
        return this.query(Bizorder.class, builder.toString(), new String[0]);
    }

    @Override
    public Sheet<Bizorder> queryBizorderGreaterThanSeqid(Bizorder data, PagedFliper fliper) {
        int rowcount;
        String sql = "select * from bizorder";
        String countsql = "select count(1) from bizorder";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (null != data) {
            if (data.getSeqid() != 0L && Long.valueOf(data.getSeqid()) != null) {
                where.append(" and seqid > '").append(data.getSeqid()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and reqtime<='").append(data.getTodate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and reqtime>='").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getPaytype())) {
                where.append(" and paytype='").append(data.getPaytype()).append("' ");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = countsql + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet(rowcount, (Collection)this.query(Bizorder.class, sql, new String[0]));
    }

    @Override
    public Sheet<Bizorder> queryBizorderhis(Bizorder data, PagedFliper fliper, List<String> tables) {
        if (null == tables || tables.size() <= 0) {
            return this.queryBizorder(data, fliper);
        }
        String sql = "";
        String countSql = "SELECT SUM(cou) FROM ( ";
        StringBuilder where = this.buildQueryWhereStat(data, false);
        if (null != data && this.isEmpty(data.getBizno()) && data.getBiznos() != null) {
            if (data.getBiznos().length == 0) {
                return Sheet.EMPTY;
            }
            where.append(" and b.bizno in ").append(BizorderDaoImpl.uniteForIn((String[])data.getBiznos()));
        }
        int i = 0;
        for (String table : tables) {
            ++i;
            if (!this.isNotEmpty(table)) continue;
            String sqlTmp = "select b.* from " + table + " b " + where.toString();
            String countsqlTmp = "select count(1) as cou from " + table + " b " + where.toString();
            if (i == tables.size()) {
                sql = sql + "(" + sqlTmp + ") ";
                countSql = countSql + "(" + countsqlTmp + ") ) t";
                continue;
            }
            sql = sql + "(" + sqlTmp + ") union all ";
            countSql = countSql + "(" + countsqlTmp + ") union all ";
        }
        int rowcount = this.getSingleInt(countSql);
        if (rowcount <= 0) {
            return Sheet.EMPTY;
        }
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        logger.info((Object)("query bizorderhis sql-->" + sql));
        return new Sheet(rowcount, (Collection)this.query(Bizorder.class, sql, new String[]{"bizname"}));
    }

    private StringBuilder buildQueryWhereStat(Bizorder data, boolean hasCop) {
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (hasCop) {
            where.append(" and b.bizno=c.bizno ");
        }
        if (null != data) {
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and b.inputtime<='").append(StringTools.escapeSql((String)data.getTodate())).append(" 23:59:59' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and b.inputtime>='").append(StringTools.escapeSql((String)data.getFromdate())).append(" 00:00:00'");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and b.bizno='").append(StringTools.escapeSql((String)data.getBizno())).append("' ");
            }
            if (this.isNotEmpty(data.getPaytype())) {
                where.append(" and paytype='").append(data.getPaytype()).append("' ");
            }
            if (this.isNotEmpty(data.getBizorderid())) {
                where.append(" and bizorderid='").append(data.getBizorderid()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleipayid())) {
                where.append(" and xunleipayid='").append(data.getXunleipayid()).append("' ");
            }
            if (this.isNotEmpty(data.getUsershow())) {
                where.append(" and usershow='").append(data.getUsershow()).append("' ");
            }
            if (this.isNotEmpty(data.getPeerid())) {
                where.append(" and peerid='").append(data.getPeerid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getXunleiid())) {
                where.append(" and xunleiid='").append(data.getXunleiid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getExtpayorderid())) {
                where.append(" and extpayorderid='").append(data.getExtpayorderid().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getBankno())) {
                where.append(" and bankno='").append(data.getBankno().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getType())) {
                where.append(" and type='").append(data.getType().toLowerCase()).append("' ");
            }
            if (this.isNotEmpty(data.getOrdergroup())) {
                where.append(" and ordergroup='").append(data.getOrdergroup()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderstatus())) {
                where.append(" and orderstatus='").append(data.getOrderstatus()).append("' ");
            }
            if (this.isNotEmpty(data.getErrcode())) {
                where.append(" and errcode='").append(data.getErrcode()).append("' ");
            }
            if (this.isNotEmpty(data.getSendnoticestatus())) {
                where.append(" and sendnoticestatus='").append(data.getSendnoticestatus()).append("' ");
            }
            if (this.isNotEmpty(data.getOrderip())) {
                where.append(" and orderip='").append(data.getOrderip()).append("' ");
            }
        }
        return where;
    }
}

