/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.bo;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FileUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.encrypt.util.Md5Encrypt;
import com.xunlei.payproxy.bo.BaseBo;
import com.xunlei.payproxy.bo.IMobilevipbillBo;
import com.xunlei.payproxy.dao.IMobilevipbillDao;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.util.FileCommonUtils;
import com.xunlei.payproxy.util.HttpRecall;
import com.xunlei.payproxy.util.PayProxyFunctionConstant;
import com.xunlei.payproxy.util.ProxyHelper;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.util.VOCopier;
import com.xunlei.payproxy.vo.Bizorderok;
import com.xunlei.payproxy.vo.Bizorderokhis;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.Excptionmobile;
import com.xunlei.payproxy.vo.Mobilevipbill;
import com.xunlei.payproxy.vo.Mobilevipok;
import com.xunlei.payproxy.vo.Mobilevipquit;
import com.xunlei.payproxy.vo.Mobilevipreq;
import com.xunlei.payproxy.vo.Paynoticeok;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobilevipbillBoImpl
extends BaseBo
implements IMobilevipbillBo {
    private IMobilevipbillDao mobilevipbillDao;
    private static Logger logger = Logger.getLogger(MobilevipbillBoImpl.class);
    private static int reopenVip = 0;
    private static int reopenKKVip = 0;
    private String vipReopenInterface = "http://dypay.vip.xunlei.com/channel/mobile_open?userid=%1$s&phone=%2$s&orderid=%3$s&billmonth=%4$s";
    private String retFilePath = "/usr/local/zeus/htdocsnew/XLPayProxyMobileTask/data/choosebill/";
    private List<String> retAStrList = new ArrayList<String>();
    private List<String> retCStrList = new ArrayList<String>();
    private String kkvipReopenInterface = "http://busi.vip.kankan.com/admin/renewMobileVip?onlyjson=1&userid=%1$s&phone=%2$s&signMsg=%3$s";
    private String kkVipBizKey = "";

    @Override
    public void deleteMobilevipbillById(long ... seqids) {
        this.getMobilevipbillDao().deleteMobilevipbillById(seqids);
    }

    @Override
    public void deleteMobilevipbill(Mobilevipbill data) {
        this.getMobilevipbillDao().deleteMobilevipbill(data);
    }

    @Override
    public Mobilevipbill findMobilevipbill(Mobilevipbill data) {
        return this.getMobilevipbillDao().findMobilevipbill(data);
    }

    @Override
    public Mobilevipbill getMobilevipbillById(long seqid) {
        return this.getMobilevipbillDao().getMobilevipbillById(seqid);
    }

    @Override
    public void insertMobilevipbill(Mobilevipbill data) {
        this.getMobilevipbillDao().insertMobilevipbill(data);
    }

    @Override
    public Sheet<Mobilevipbill> queryMobilevipbill(Mobilevipbill data, PagedFliper fliper) {
        return this.getMobilevipbillDao().queryMobilevipbill(data, fliper);
    }

    @Override
    public void updateMobilevipbill(Mobilevipbill data) {
        this.getMobilevipbillDao().updateMobilevipbill(data);
    }

    public IMobilevipbillDao getMobilevipbillDao() {
        return this.mobilevipbillDao;
    }

    public void setMobilevipbillDao(IMobilevipbillDao mobilevipbillDao) {
        this.mobilevipbillDao = mobilevipbillDao;
    }

    @Override
    public int deleteMonthChargebill(String billmonth, String sp, String carrier, String serivetype) {
        return this.getMobilevipbillDao().deleteMonthChargebill(billmonth, sp, carrier, serivetype);
    }

    @Override
    public int deleteMonthQuitbill(String billmonth, String sp, String serivetype) {
        return this.getMobilevipbillDao().deleteMonthQuitbill(billmonth, sp, serivetype);
    }

    @Override
    public String importOneSuccSyncLog(String sp, String mobile, String carrier, String usertype, String chargetime, double orderamt, String billmonth, String servicetype, String province) {
        IFacade facade = IFacade.INSTANCE;
        Mobilevipbill mobilevipbill = new Mobilevipbill();
        mobilevipbill.setMobile(mobile);
        mobilevipbill.setBillmonth(billmonth);
        mobilevipbill.setCarrier(carrier);
        mobilevipbill.setSerivetype(servicetype);
        mobilevipbill.setOrderamt(orderamt);
        mobilevipbill.setSp(sp);
        mobilevipbill.setProvince(province);
        Mobilevipok mobilevipokQry = new Mobilevipok();
        mobilevipokQry.setMobile(mobile);
        mobilevipokQry.setSerivetype(servicetype);
        mobilevipokQry.setSp(sp);
        Mobilevipok mobilevipok = IFacade.INSTANCE.findMobilevipok(mobilevipokQry);
        if (mobilevipok != null) {
            mobilevipbill.setMobile(mobile);
            mobilevipbill.setXunleiid(mobilevipok.getXunleiid());
            mobilevipbill.setUsershow(mobilevipok.getUsershow());
            mobilevipbill.setUsertype(usertype.equals("\u65b0\u589e") ? "NEW" : "OLD");
            mobilevipbill.setChargestate("Y");
            mobilevipbill.setChargetime(chargetime);
            mobilevipbill.setDatastate("N");
            mobilevipbill.setDealtype("A");
            mobilevipbill.setEditby("xlpayproxy");
            mobilevipbill.setEdittime(DatetimeUtil.now());
            facade.insertMobilevipbill(mobilevipbill);
            mobilevipok.setBillmonth(billmonth);
            mobilevipok.setBillingtime(chargetime);
            facade.updateMobilevipok(mobilevipok);
            return mobilevipok.getXunleiid();
        }
        Mobilevipquit mobilevipquitQry = new Mobilevipquit();
        mobilevipquitQry.setMobile(mobile);
        mobilevipquitQry.setChargetime(chargetime);
        mobilevipquitQry.setSerivetype(servicetype);
        mobilevipquitQry.setSp(sp);
        Mobilevipquit mobilevipquit = facade.queryMobilevipquitByMobile(mobilevipquitQry);
        if (null != mobilevipquit) {
            mobilevipbill.setMobile(mobile);
            mobilevipbill.setXunleiid(mobilevipquit.getXunleiid());
            mobilevipbill.setUsershow(mobilevipquit.getUsershow());
            mobilevipbill.setUsertype(usertype.equals("\u65b0\u589e") ? "NEW" : "OLD");
            mobilevipbill.setChargestate("Y");
            mobilevipbill.setChargetime(chargetime);
            mobilevipbill.setDatastate("N");
            mobilevipbill.setDealtype("A");
            mobilevipbill.setEditby("xlpayproxy");
            mobilevipbill.setEdittime(DatetimeUtil.now());
            facade.insertMobilevipbill(mobilevipbill);
            return mobilevipquit.getXunleiid();
        }
        Mobilevipreq mobilevipreqQry = new Mobilevipreq();
        mobilevipreqQry.setMobile(mobile);
        mobilevipquitQry.setSerivetype(servicetype);
        mobilevipquitQry.setSp(sp);
        Mobilevipreq mobilevipreq = facade.findMobilevipreq(mobilevipreqQry);
        if (mobilevipreq != null) {
            mobilevipbill.setMobile(mobile);
            mobilevipbill.setXunleiid(mobilevipreq.getXunleiid());
            mobilevipbill.setUsershow(mobilevipreq.getUsershow());
            mobilevipbill.setUsertype(usertype.equals("\u65b0\u589e") ? "NEW" : "OLD");
            mobilevipbill.setChargestate("Y");
            mobilevipbill.setChargetime(chargetime);
            mobilevipbill.setDatastate("E");
            mobilevipbill.setDealtype("B");
            mobilevipbill.setEditby("xlpayproxy");
            mobilevipbill.setEdittime(DatetimeUtil.now());
            mobilevipbill.setRemark("\u6263\u8d39\u6210\u529f\u4e14\u5728\u8bf7\u6c42\u8868\u4e2d");
            mobilevipbill.setExceptiondatatype("1");
            facade.insertMobilevipbill(mobilevipbill);
            return mobilevipbill.getXunleiid();
        }
        mobilevipbill.setMobile(mobile);
        mobilevipbill.setUsertype(usertype.equals("\u65b0\u589e") ? "NEW" : "OLD");
        mobilevipbill.setChargestate("Y");
        mobilevipbill.setChargetime(chargetime);
        mobilevipbill.setDatastate("E");
        mobilevipbill.setDealtype("B");
        mobilevipbill.setEditby("xlpayproxy");
        mobilevipbill.setEdittime(DatetimeUtil.now());
        mobilevipbill.setRemark("\u6263\u8d39\u6210\u529f\u8bb0\u5f55\u4e0d\u5b58\u5728");
        mobilevipbill.setExceptiondatatype("2");
        facade.insertMobilevipbill(mobilevipbill);
        return null;
    }

    @Override
    public void importOneFailSyncLog(String sp, String mobile, String carrier, String usertype, double orderamt, String billmonth, String servicetype, String dealtype, String province, int mtcount, int successmtcount) {
        IFacade facade = IFacade.INSTANCE;
        Mobilevipbill mb = new Mobilevipbill();
        mb.setMobile(mobile);
        mb.setBillmonth(billmonth);
        mb.setCarrier(carrier);
        mb.setSerivetype(servicetype);
        mb.setOrderamt(orderamt);
        mb.setSp(sp);
        mb.setProvince(province);
        mb.setMtcount(mtcount);
        mb.setSuccessmtcount(successmtcount);
        Mobilevipok qmobilevipok = new Mobilevipok();
        qmobilevipok.setMobile(mobile);
        qmobilevipok.setSerivetype(servicetype);
        qmobilevipok.setSp(sp);
        Mobilevipok mobilevipok = IFacade.INSTANCE.findMobilevipok(qmobilevipok);
        if (mobilevipok != null) {
            mb.setMobile(mobile);
            mb.setXunleiid(mobilevipok.getXunleiid());
            mb.setUsershow(mobilevipok.getUsershow());
            mb.setUsertype(usertype.equals("\u65b0\u589e") ? "NEW" : "OLD");
            mb.setChargestate("N");
            mb.setDatastate("E");
            String deal = "B";
            if (dealtype.equals("\u672c\u6708\u4e0d\u6210\u529f") || dealtype.equals("\u672c\u6708\u8ba1\u8d39\u4e0d\u6210\u529f")) {
                deal = "E";
            }
            mb.setDealtype(deal);
            mb.setEditby("xlpayproxy");
            mb.setEdittime(DatetimeUtil.now());
            mb.setRemark("\u6263\u8d39\u4e0d\u6210\u529f\u4e14\u5728\u5305\u6708\u8868\u4e2d");
            mb.setExceptiondatatype("3");
            IFacade.INSTANCE.insertMobilevipbill(mb);
            mobilevipok.setBillmonth(billmonth);
            facade.updateMobilevipok(mobilevipok);
        } else {
            Mobilevipquit qmobilevipquit = new Mobilevipquit();
            qmobilevipquit.setMobile(mobile);
            qmobilevipquit.setChargemonth(billmonth);
            qmobilevipquit.setSerivetype(servicetype);
            qmobilevipquit.setSp(sp);
            Sheet<Mobilevipquit> sheet = IFacade.INSTANCE.queryMobilevipquit(qmobilevipquit, null);
            if (sheet != null && sheet.getRowcount() > 0) {
                List list = (List)sheet.getDatas();
                Mobilevipquit mobilevipquit = (Mobilevipquit)list.get(0);
                mb.setMobile(mobile);
                mb.setXunleiid(mobilevipquit.getXunleiid());
                mb.setUsershow(mobilevipquit.getUsershow());
                mb.setUsertype(usertype.equals("\u65b0\u589e") ? "NEW" : "OLD");
                mb.setChargestate("N");
                mb.setOrderamt(orderamt);
                mb.setDatastate("E");
                mb.setDealtype("E");
                mb.setEditby("xlpayproxy");
                mb.setEdittime(DatetimeUtil.now());
                mb.setRemark("\u6263\u8d39\u4e0d\u6210\u529f\u4e14\u5728\u9000\u8ba2\u8868\u4e2d");
                mb.setExceptiondatatype("4");
                IFacade.INSTANCE.insertMobilevipbill(mb);
            } else {
                Mobilevipreq moreqForQuery = new Mobilevipreq();
                moreqForQuery.setMobile(mobile);
                moreqForQuery.setSerivetype(servicetype);
                moreqForQuery.setSp(sp);
                Mobilevipreq mobilevipreq = IFacade.INSTANCE.findMobilevipreq(moreqForQuery);
                if (mobilevipreq != null) {
                    mb.setMobile(mobile);
                    mb.setXunleiid(mobilevipreq.getXunleiid());
                    mb.setUsershow(mobilevipreq.getUsershow());
                    mb.setUsertype(usertype.equals("\u65b0\u589e") ? "NEW" : "OLD");
                    mb.setChargestate("N");
                    mb.setDatastate("E");
                    mb.setDealtype("E");
                    mb.setEditby("xlpayproxy");
                    mb.setEdittime(DatetimeUtil.now());
                    mb.setRemark("\u6263\u8d39\u4e0d\u6210\u529f\u4e14\u5728\u8bf7\u6c42\u8868\u4e2d");
                    mb.setExceptiondatatype("5");
                    IFacade.INSTANCE.insertMobilevipbill(mb);
                } else {
                    mb.setMobile(mobile);
                    mb.setUsertype(usertype.equals("\u65b0\u589e") ? "NEW" : "OLD");
                    mb.setChargestate("N");
                    mb.setDatastate("E");
                    mb.setDealtype("E");
                    mb.setEditby("xlpayproxy");
                    mb.setEdittime(DatetimeUtil.now());
                    mb.setRemark("\u6263\u8d39\u4e0d\u6210\u529f\u8bb0\u5f55\u4e0d\u5b58\u5728");
                    mb.setExceptiondatatype("6");
                    IFacade.INSTANCE.insertMobilevipbill(mb);
                }
            }
        }
    }

    @Override
    public void importOneChargeBill(String billmonth, String carrier, String data, String serivetype, Double orderamt) {
        logger.info((Object)("data=" + data));
        String[] notes = data.split("\t");
        Mobilevipbill mb = new Mobilevipbill();
        mb.setSeqid(0L);
        mb.setBillmonth(billmonth);
        mb.setCarrier(carrier);
        mb.setSerivetype(serivetype);
        mb.setOrderamt(orderamt);
        mb.setSp(PayProxyFunctionConstant.SP_KONGZHONG);
        IFacade facade = IFacade.INSTANCE;
        if (notes[4].equals("\u6210\u529f")) {
            Mobilevipok qmobilevipok = new Mobilevipok();
            qmobilevipok.setMobile(notes[0]);
            qmobilevipok.setSerivetype(serivetype);
            qmobilevipok.setSp(PayProxyFunctionConstant.SP_KONGZHONG);
            Mobilevipok mobilevipok = facade.findMobilevipok(qmobilevipok);
            if (mobilevipok != null) {
                mb.setMobile(notes[0]);
                mb.setXunleiid(mobilevipok.getXunleiid());
                mb.setUsershow(mobilevipok.getUsershow());
                mb.setUsertype(notes[2].equals("\u65b0\u589e") ? "NEW" : "OLD");
                mb.setChargestate(notes[4].equals("\u6210\u529f") ? "Y" : "N");
                mb.setChargetime(notes[3]);
                mb.setDatastate("N");
                mb.setDealtype("A");
                mb.setEditby("xlpayproxy");
                mb.setEdittime(DatetimeUtil.now());
                IFacade.INSTANCE.insertMobilevipbill(mb);
                mobilevipok.setBillmonth(billmonth);
                mobilevipok.setBillingtime(mb.getChargetime());
                facade.updateMobilevipok(mobilevipok);
            } else {
                Mobilevipquit qmobilevipquit = new Mobilevipquit();
                qmobilevipquit.setMobile(notes[0]);
                qmobilevipquit.setChargetime(notes[3]);
                qmobilevipquit.setSerivetype(serivetype);
                qmobilevipquit.setSp(PayProxyFunctionConstant.SP_KONGZHONG);
                Sheet<Mobilevipquit> sheet = IFacade.INSTANCE.queryMobilevipquit(qmobilevipquit, null);
                if (sheet != null && sheet.getRowcount() > 0) {
                    List list = (List)sheet.getDatas();
                    Mobilevipquit mobilevipquit = (Mobilevipquit)list.get(0);
                    mb.setMobile(notes[0]);
                    mb.setXunleiid(mobilevipquit.getXunleiid());
                    mb.setUsershow(mobilevipquit.getUsershow());
                    mb.setUsertype(notes[2].equals("\u65b0\u589e") ? "NEW" : "OLD");
                    mb.setChargestate(notes[4].equals("\u6210\u529f") ? "Y" : "N");
                    mb.setChargetime(notes[3]);
                    mb.setDatastate("N");
                    mb.setDealtype("A");
                    mb.setEditby("xlpayproxy");
                    mb.setEdittime(DatetimeUtil.now());
                    IFacade.INSTANCE.insertMobilevipbill(mb);
                } else {
                    Mobilevipreq moreqForQuery = new Mobilevipreq();
                    moreqForQuery.setMobile(notes[0]);
                    moreqForQuery.setSerivetype(serivetype);
                    moreqForQuery.setSp(PayProxyFunctionConstant.SP_KONGZHONG);
                    Mobilevipreq mobilevipreq = IFacade.INSTANCE.findMobilevipreq(moreqForQuery);
                    if (mobilevipreq != null) {
                        mb.setMobile(notes[0]);
                        mb.setXunleiid(mobilevipreq.getXunleiid());
                        mb.setUsershow(mobilevipreq.getUsershow());
                        mb.setUsertype(notes[2].equals("\u65b0\u589e") ? "NEW" : "OLD");
                        mb.setChargestate(notes[4].equals("\u6210\u529f") ? "Y" : "N");
                        mb.setChargetime(notes[3]);
                        mb.setDatastate("E");
                        mb.setDealtype("B");
                        mb.setEditby("xlpayproxy");
                        mb.setEdittime(DatetimeUtil.now());
                        mb.setRemark("\u6263\u8d39\u6210\u529f\u4e14\u5728\u8bf7\u6c42\u8868\u4e2d");
                        mb.setExceptiondatatype("1");
                        IFacade.INSTANCE.insertMobilevipbill(mb);
                    } else {
                        mb.setMobile(notes[0]);
                        mb.setUsertype(notes[2].equals("\u65b0\u589e") ? "NEW" : "OLD");
                        mb.setChargestate(notes[4].equals("\u6210\u529f") ? "Y" : "N");
                        mb.setChargetime(notes[3]);
                        mb.setDatastate("E");
                        mb.setDealtype("B");
                        mb.setEditby("xlpayproxy");
                        mb.setEdittime(DatetimeUtil.now());
                        mb.setRemark("\u6263\u8d39\u6210\u529f\u8bb0\u5f55\u4e0d\u5b58\u5728");
                        mb.setExceptiondatatype("2");
                        IFacade.INSTANCE.insertMobilevipbill(mb);
                    }
                }
            }
        } else {
            Mobilevipok qmobilevipok = new Mobilevipok();
            qmobilevipok.setMobile(notes[0]);
            qmobilevipok.setSerivetype(serivetype);
            qmobilevipok.setSp(PayProxyFunctionConstant.SP_KONGZHONG);
            Mobilevipok mobilevipok = IFacade.INSTANCE.findMobilevipok(qmobilevipok);
            if (mobilevipok != null) {
                mb.setMobile(notes[0]);
                mb.setXunleiid(mobilevipok.getXunleiid());
                mb.setUsershow(mobilevipok.getUsershow());
                mb.setUsertype(notes[2].equals("\u65b0\u589e") ? "NEW" : "OLD");
                mb.setChargestate(notes[4].equals("\u6210\u529f") ? "Y" : "N");
                mb.setChargetime(notes[3]);
                mb.setDatastate("E");
                String dealtype = "B";
                if (notes[4].equals("\u672c\u6708\u4e0d\u6210\u529f") || notes[4].equals("\u672c\u6708\u8ba1\u8d39\u4e0d\u6210\u529f")) {
                    dealtype = "E";
                }
                mb.setDealtype(dealtype);
                mb.setEditby("xlpayproxy");
                mb.setEdittime(DatetimeUtil.now());
                mb.setRemark("\u6263\u8d39\u4e0d\u6210\u529f\u4e14\u5728\u5305\u6708\u8868\u4e2d");
                mb.setExceptiondatatype("3");
                IFacade.INSTANCE.insertMobilevipbill(mb);
                mobilevipok.setBillmonth(billmonth);
                facade.updateMobilevipok(mobilevipok);
            } else {
                Mobilevipquit qmobilevipquit = new Mobilevipquit();
                qmobilevipquit.setMobile(notes[0]);
                qmobilevipquit.setChargemonth(billmonth);
                qmobilevipquit.setSerivetype(serivetype);
                qmobilevipquit.setSp(PayProxyFunctionConstant.SP_KONGZHONG);
                Sheet<Mobilevipquit> sheet = IFacade.INSTANCE.queryMobilevipquit(qmobilevipquit, null);
                if (sheet != null && sheet.getRowcount() > 0) {
                    List list = (List)sheet.getDatas();
                    Mobilevipquit mobilevipquit = (Mobilevipquit)list.get(0);
                    mb.setMobile(notes[0]);
                    mb.setXunleiid(mobilevipquit.getXunleiid());
                    mb.setUsershow(mobilevipquit.getUsershow());
                    mb.setUsertype(notes[2].equals("\u65b0\u589e") ? "NEW" : "OLD");
                    mb.setChargestate(notes[4].equals("\u6210\u529f") ? "Y" : "N");
                    mb.setChargetime(notes[3]);
                    mb.setDatastate("E");
                    mb.setDealtype("E");
                    mb.setEditby("xlpayproxy");
                    mb.setEdittime(DatetimeUtil.now());
                    mb.setRemark("\u6263\u8d39\u4e0d\u6210\u529f\u4e14\u5728\u9000\u8ba2\u8868\u4e2d");
                    mb.setExceptiondatatype("4");
                    IFacade.INSTANCE.insertMobilevipbill(mb);
                } else {
                    Mobilevipreq moreqForQuery = new Mobilevipreq();
                    moreqForQuery.setMobile(notes[0]);
                    moreqForQuery.setSerivetype(serivetype);
                    moreqForQuery.setSp(PayProxyFunctionConstant.SP_KONGZHONG);
                    Mobilevipreq mobilevipreq = IFacade.INSTANCE.findMobilevipreq(moreqForQuery);
                    if (mobilevipreq != null) {
                        mb.setMobile(notes[0]);
                        mb.setXunleiid(mobilevipreq.getXunleiid());
                        mb.setUsershow(mobilevipreq.getUsershow());
                        mb.setUsertype(notes[2].equals("\u65b0\u589e") ? "NEW" : "OLD");
                        mb.setChargestate(notes[4].equals("\u6210\u529f") ? "Y" : "N");
                        mb.setChargetime(notes[3]);
                        mb.setDatastate("E");
                        mb.setDealtype("E");
                        mb.setEditby("xlpayproxy");
                        mb.setEdittime(DatetimeUtil.now());
                        mb.setRemark("\u6263\u8d39\u4e0d\u6210\u529f\u4e14\u5728\u8bf7\u6c42\u8868\u4e2d");
                        mb.setExceptiondatatype("5");
                        IFacade.INSTANCE.insertMobilevipbill(mb);
                    } else {
                        mb.setMobile(notes[0]);
                        mb.setUsertype(notes[2].equals("\u65b0\u589e") ? "NEW" : "OLD");
                        mb.setChargestate(notes[4].equals("\u6210\u529f") ? "Y" : "N");
                        mb.setChargetime(notes[3]);
                        mb.setDatastate("E");
                        mb.setDealtype("E");
                        mb.setEditby("xlpayproxy");
                        mb.setEdittime(DatetimeUtil.now());
                        mb.setRemark("\u6263\u8d39\u4e0d\u6210\u529f\u8bb0\u5f55\u4e0d\u5b58\u5728");
                        mb.setExceptiondatatype("6");
                        IFacade.INSTANCE.insertMobilevipbill(mb);
                    }
                }
            }
        }
    }

    @Override
    public void importOneQuitBill(String billmonth, String data, String serivetype, Double orderamt) {
        logger.info((Object)("data=" + data));
        String[] notes = data.split(" ");
        Mobilevipbill mb = new Mobilevipbill();
        mb.setSeqid(0L);
        mb.setBillmonth(billmonth);
        mb.setSerivetype(serivetype);
        mb.setOrderamt(orderamt);
        mb.setSp(PayProxyFunctionConstant.SP_KONGZHONG);
        String ordertime = "";
        String ordertimep1 = "";
        String ordertimep2 = "";
        ordertimep1 = notes[3].length() == 10 ? notes[3] : Utility.FomatDate(notes[3]);
        ordertimep2 = notes[4].length() == 8 ? notes[4] : Utility.FomatTime(notes[4]);
        ordertime = ordertimep1 + " " + ordertimep2;
        String quittime = "";
        String quittimep1 = "";
        String quittimep2 = "";
        quittimep1 = notes[5].length() == 10 ? notes[5] : Utility.FomatDate(notes[5]);
        quittimep2 = notes[6].length() == 8 ? notes[6] : Utility.FomatTime(notes[6]);
        quittime = quittimep1 + " " + quittimep2;
        Mobilevipok qmobilevipok = new Mobilevipok();
        qmobilevipok.setMobile(notes[1]);
        qmobilevipok.setSerivetype(serivetype);
        qmobilevipok.setSp(PayProxyFunctionConstant.SP_KONGZHONG);
        Mobilevipok mobilevipok = IFacade.INSTANCE.findMobilevipok(qmobilevipok);
        if (mobilevipok != null) {
            String getTime = mobilevipok.getGettime();
            String getDate = "";
            if (this.isNotEmpty(getTime) && getTime.length() >= 10) {
                getDate = getTime.substring(0, 10);
            }
            mb.setMobile(notes[1]);
            mb.setXunleiid(mobilevipok.getXunleiid());
            mb.setUsershow(mobilevipok.getUsershow());
            mb.setUsertype("QUIT");
            mb.setCarrier(mobilevipok.getCarrier());
            mb.setOrdertime(ordertime);
            mb.setQuittime(quittime);
            if (getDate.compareTo(notes[5]) > 0) {
                mb.setDatastate("N");
                mb.setDealtype("A");
                mb.setRemark("\u91cd\u65b0\u8ba2\u5236");
            } else {
                mb.setDatastate("E");
                mb.setDealtype("B");
                mb.setRemark("\u9000\u8ba2\u53f7\u7801\u5728\u5305\u6708\u8868\u4e2d");
            }
            mb.setEditby("xlpayproxy");
            mb.setEdittime(DatetimeUtil.now());
            mb.setExceptiondatatype("7");
            IFacade.INSTANCE.insertMobilevipbill(mb);
        } else {
            Mobilevipquit qmobilevipquit = new Mobilevipquit();
            qmobilevipquit.setMobile(notes[1]);
            qmobilevipquit.setChargetime(quittime);
            qmobilevipquit.setSerivetype(serivetype);
            qmobilevipquit.setSp(PayProxyFunctionConstant.SP_KONGZHONG);
            Sheet<Mobilevipquit> sheet = IFacade.INSTANCE.queryMobilevipquit(qmobilevipquit, null);
            if (sheet != null && sheet.getRowcount() > 0) {
                List list = (List)sheet.getDatas();
                Mobilevipquit mobilevipquit = (Mobilevipquit)list.get(0);
                mb.setMobile(notes[1]);
                mb.setXunleiid(mobilevipquit.getXunleiid());
                mb.setUsershow(mobilevipquit.getUsershow());
                mb.setUsertype("QUIT");
                mb.setCarrier(mobilevipquit.getCarrier());
                mb.setOrdertime(ordertime);
                mb.setQuittime(quittime);
                mb.setDatastate("N");
                mb.setDealtype("A");
                mb.setEditby("xlpayproxy");
                mb.setEdittime(DatetimeUtil.now());
                IFacade.INSTANCE.insertMobilevipbill(mb);
            } else {
                Mobilevipreq moreqForQuery = new Mobilevipreq();
                moreqForQuery.setMobile(notes[1]);
                moreqForQuery.setSerivetype(serivetype);
                moreqForQuery.setSp(PayProxyFunctionConstant.SP_KONGZHONG);
                Mobilevipreq mobilevipreq = IFacade.INSTANCE.findMobilevipreq(moreqForQuery);
                if (mobilevipreq != null) {
                    mb.setMobile(notes[1]);
                    mb.setXunleiid(mobilevipreq.getXunleiid());
                    mb.setUsershow(mobilevipreq.getUsershow());
                    mb.setUsertype("QUIT");
                    mb.setCarrier(mobilevipreq.getCarrier());
                    mb.setOrdertime(ordertime);
                    mb.setQuittime(quittime);
                    mb.setDatastate("E");
                    mb.setDealtype("E");
                    mb.setEditby("xlpayproxy");
                    mb.setEdittime(DatetimeUtil.now());
                    mb.setRemark("\u9000\u8ba2\u53f7\u7801\u5728\u8bf7\u6c42\u8868\u4e2d");
                    mb.setExceptiondatatype("8");
                    IFacade.INSTANCE.insertMobilevipbill(mb);
                } else {
                    mb.setMobile(notes[1]);
                    mb.setUsertype("QUIT");
                    mb.setOrdertime(ordertime);
                    mb.setQuittime(quittime);
                    mb.setDatastate("E");
                    mb.setDealtype("E");
                    mb.setEditby("xlpayproxy");
                    mb.setEdittime(DatetimeUtil.now());
                    mb.setRemark("\u9000\u8ba2\u53f7\u7801\u4e0d\u5b58\u5728");
                    mb.setExceptiondatatype("9");
                    IFacade.INSTANCE.insertMobilevipbill(mb);
                }
            }
        }
    }

    @Override
    public int deleteMonthChargebill(String billmonth, String sp, String carrier, String serivetype, Double orderamt) {
        return this.mobilevipbillDao.deleteMonthChargebill(billmonth, sp, carrier, serivetype, orderamt);
    }

    @Override
    public int deleteMonthQuitbill(String billmonth, String sp, String serivetype, Double orderamt) {
        return this.mobilevipbillDao.deleteMonthQuitbill(billmonth, sp, serivetype, orderamt);
    }

    @Override
    public int deleteMobilevipbillByChargeday(String sp, String chargeday, String carrier, String serivetype) {
        return this.mobilevipbillDao.deleteMobilevipbillByChargeday(sp, chargeday, carrier, serivetype);
    }

    @Override
    public List<Mobilevipbill> queryMobilevipbillByChargeday(String sp, String chargeday) {
        return this.mobilevipbillDao.queryMobilevipbillByChargeday(sp, chargeday);
    }

    @Override
    public int deleteMobilevipbill(String billmonth, String sp, String chargestate, String carrier, String serivetype) {
        return this.mobilevipbillDao.deleteMobilevipbill(billmonth, sp, chargestate, carrier, serivetype);
    }

    @Override
    public int reopenvip(String balancedate, String sp, String servicetype) {
        reopenVip = 0;
        try {
            Mobilevipbill mobilevipbillQry = new Mobilevipbill();
            mobilevipbillQry.setFromdate(balancedate);
            mobilevipbillQry.setTodate(balancedate);
            mobilevipbillQry.setChargestate("Y");
            mobilevipbillQry.setSerivetype(servicetype);
            mobilevipbillQry.setSp(sp);
            List lists = (List)IFacade.INSTANCE.queryMobilevipbill(mobilevipbillQry, null).getDatas();
            for (Mobilevipbill mobilevipbill : lists) {
                String mobile = mobilevipbill.getMobile();
                Mobilevipquit mobilevipquitQry = new Mobilevipquit();
                mobilevipquitQry.setMobile(mobile);
                mobilevipquitQry.setSp(sp);
                mobilevipquitQry.setSerivetype(servicetype);
                Mobilevipquit mobilevipquit = IFacade.INSTANCE.queryMobilevipquitByMobile(mobilevipquitQry);
                logger.info((Object)("mobile-->" + mobile + "\tmobilevipquit is " + (mobilevipquit == null)));
                if (null != mobilevipquit) {
                    String quitfrom = mobilevipquit.getQuitfrom();
                    if (quitfrom.equals("B")) {
                        String userid = mobilevipquit.getXunleiid();
                        String xunleipayid = mobilevipquit.getRemark().split("\uff1a")[1];
                        String carrier = mobilevipquit.getCarrier();
                        Mobilevipok mobilevipokQry = new Mobilevipok();
                        mobilevipokQry.setMobile(mobile);
                        mobilevipokQry.setSp(sp);
                        mobilevipokQry.setSerivetype(servicetype);
                        List mobilevipoks = (List)IFacade.INSTANCE.queryMobilevipok(mobilevipokQry, null).getDatas();
                        Mobilevipok qMobilevipok = new Mobilevipok();
                        qMobilevipok.setXunleiid(userid);
                        qMobilevipok.setSp(sp);
                        qMobilevipok.setSerivetype(servicetype);
                        List oMobileList = (List)IFacade.INSTANCE.queryMobilevipok(qMobilevipok, null).getDatas();
                        if (!(mobilevipoks != null && mobilevipoks.size() != 0 || oMobileList != null && oMobileList.size() != 0)) {
                            if ("F".equals(servicetype)) continue;
                            logger.info((Object)("mobile:" + mobile + ", userid:" + userid + "\u5728\u5305\u6708\u6210\u529f\u8868\u4e2d\u4e0d\u5b58\u5728\uff0c\u7ee7\u7eed\u91cd\u65b0\u5f00\u901a\u4f1a\u5458\u903b\u8f91\uff01"));
                            this.reopenVip(balancedate, mobile, servicetype, carrier, sp, userid, xunleipayid);
                            continue;
                        }
                        logger.info((Object)"mobilevipok found for mobile or userid,nothing to do");
                        continue;
                    }
                    logger.error((Object)("found mobilevipquit for mobile:" + mobile + ",but its quitform:" + quitfrom + " is not 'B',cannot to reopen"));
                    continue;
                }
                logger.info((Object)("no mobilevipquit found for mobile:" + mobile + ",nothing to do"));
            }
            if (servicetype.equals("A")) {
                this.createFile(servicetype, this.retAStrList);
            } else if (servicetype.equals("C")) {
                this.createFile(servicetype, this.retCStrList);
            }
            return reopenVip;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return reopenVip;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void reopenVip(String balancedate, String mobile, String servicetype, String carrier, String sp, String userid, String xunleipayid) {
        try {
            Bizorderokhis bizorderokhisQry = new Bizorderokhis();
            bizorderokhisQry.setXunleipayid(xunleipayid);
            List<String> tableList = this.getXunleiPayIdTables(xunleipayid);
            List bizorderokhiss = (List)IFacade.INSTANCE.queryBizorderokhis(bizorderokhisQry, null, tableList).getDatas();
            boolean exist = bizorderokhiss != null && bizorderokhiss.size() > 0;
            logger.info((Object)("mobile " + mobile + " in bizorderok and bizorderokhis : " + exist));
            if (bizorderokhiss != null && bizorderokhiss.size() > 0) {
                Bizorderokhis bizorderokhis = (Bizorderokhis)bizorderokhiss.get(0);
                String bizOrderId = bizorderokhis.getBizorderid();
                logger.info((Object)("mobile:" + mobile + ",bizOrderId:" + bizOrderId));
                String billMonth = balancedate.substring(0, 7);
                String reopenResult = this.callReopenVipInterface(userid, mobile, bizOrderId, billMonth);
                logger.info((Object)("reopenvip...mobile:" + mobile + ",result:" + reopenResult));
                String[] results = reopenResult.split("&");
                if (results[0].split("=")[1].equals("2") && bizOrderId.contains("_")) {
                    String newOrderid = bizOrderId.substring(0, bizOrderId.indexOf("_"));
                    logger.info((Object)("newOrderid:" + newOrderid));
                    reopenResult = this.callReopenVipInterface(userid, mobile, newOrderid, billMonth);
                    logger.info((Object)("reopenvip...mobile:" + mobile + ",result:" + reopenResult));
                    results = reopenResult.split("&");
                }
                if (results[0].split("=")[1].equals("2")) {
                    if (servicetype.equals("A")) {
                        this.retAStrList.add(mobile + "," + bizOrderId);
                    } else if (servicetype.equals("C")) {
                        this.retCStrList.add(mobile + "," + bizOrderId);
                    }
                }
                if (!results[0].split("=")[1].equals("0")) throw new Exception("reopen vip failed, mobile = " + mobile + ", userid = " + userid + "," + reopenResult);
                String neworderid = results[1].split("=")[1];
                String newXunleiPayId = ProxyHelper.getXunleiPayId();
                Bizorderok bizorderok = new Bizorderok();
                VOCopier.copy(bizorderokhis, bizorderok);
                bizorderok.setBizorderid(neworderid);
                bizorderok.setXunleipayid(newXunleiPayId);
                bizorderok.setBalancedate(DatetimeUtil.today());
                bizorderok.setSuccesstime(DatetimeUtil.now());
                bizorderok.setSendnoticestatus("Y");
                Mobilevipok mobilevipokToInsert = new Mobilevipok();
                mobilevipokToInsert.setSp(sp);
                mobilevipokToInsert.setMobile(mobile);
                mobilevipokToInsert.setGettime(bizorderok.getSuccesstime());
                mobilevipokToInsert.setBalancedate(bizorderok.getBalancedate());
                mobilevipokToInsert.setOrderid(newXunleiPayId);
                mobilevipokToInsert.setBillingtime(bizorderok.getSuccesstime());
                mobilevipokToInsert.setBizorderstatus("Y");
                mobilevipokToInsert.setReqtime(bizorderok.getOrdertime());
                mobilevipokToInsert.setSerivetype(servicetype);
                mobilevipokToInsert.setXunleiid(userid);
                mobilevipokToInsert.setCarrier(carrier);
                mobilevipokToInsert.setUsershow(bizorderok.getUsershow());
                mobilevipokToInsert.setBillmonth(balancedate.substring(0, 7));
                mobilevipokToInsert.setRemark(balancedate + "\u6263\u8d39\u6210\u529f,\u540e\u53f0\u91cd\u65b0\u5f00\u901a\u4f1a\u5458");
                Paynoticeok paynoticeok = new Paynoticeok();
                paynoticeok.setRemark("reopen vip");
                paynoticeok.setXunleipayid(newXunleiPayId);
                paynoticeok.setNoticetime(DatetimeUtil.now());
                paynoticeok.setFailtimes(0);
                IFacade.INSTANCE.insertBizorderok(bizorderok);
                IFacade.INSTANCE.insertMobilevipok(mobilevipokToInsert);
                IFacade.INSTANCE.insertPaynoticeok(paynoticeok);
                ++reopenVip;
            } else {
                logger.error((Object)("no bizorderokhis found for xunleiPayId:" + xunleipayid));
            }
            logger.info((Object)("reopend vip count " + reopenVip));
            return;
        }
        catch (Exception e) {
            logger.info((Object)("reopend vip count " + reopenVip));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private List<String> getXunleiPayIdTables(String xunleiPayId) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("bizorderok");
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyMMdd");
            Date date = format.parse(xunleiPayId.substring(0, 6));
            Calendar ca = Calendar.getInstance();
            ca.setTime(date);
            list.add("bizorderok_" + ca.get(1) + "Q" + (ca.get(2) / 3 + 1));
            return list;
        }
        catch (ParseException e) {
            logger.error((Object)("invalid to parse xunleiPayId:" + xunleiPayId));
            return list;
        }
    }

    @Override
    public void reopenKanKanVip(String balancedate, String mobile, String servicetype, String carrier, String sp, String userid, String xunleipayid) {
        try {
            Bizorderokhis bizorderokhisQry = new Bizorderokhis();
            bizorderokhisQry.setXunleipayid(xunleipayid);
            ArrayList<String> tables = new ArrayList<String>();
            tables.add("bizorderok");
            tables.add("bizorderok_2014Q4");
            tables.add("bizorderok_2014Q3");
            tables.add("bizorderok_2014Q2");
            tables.add("bizorderok_2014Q1");
            tables.add("bizorderok_2013Q4");
            tables.add("bizorderok_2013Q3");
            tables.add("bizorderok_2013Q2");
            tables.add("bizorderok_2013Q1");
            tables.add("bizorderok_2012Q4");
            tables.add("bizorderok_2012Q3");
            tables.add("bizorderok_2012Q2");
            tables.add("bizorderok_2012Q1");
            tables.add("bizorderokhis_2011");
            tables.add("bizorderokhis_2010");
            tables.add("bizorderokhis_2009");
            List bizorderokhiss = (List)IFacade.INSTANCE.queryBizorderokhis(bizorderokhisQry, null, tables).getDatas();
            boolean exist = bizorderokhiss != null && bizorderokhiss.size() > 0;
            logger.info((Object)("kk mobile " + mobile + " in bizorderok and bizorderokhis : " + exist));
            if (bizorderokhiss != null && bizorderokhiss.size() > 0) {
                Bizorderokhis bizorderokhis = (Bizorderokhis)bizorderokhiss.get(0);
                String orderid = bizorderokhis.getBizorderid();
                logger.info((Object)("kk mobile " + mobile + " orderid " + orderid));
                String reopen_result = this.callReopenKKVipInterface(userid, mobile);
                logger.info((Object)("reopen kkvip mobile " + mobile + " return : " + reopen_result));
                String[] results = reopen_result.split("&");
                if (results[0].split("=")[1].equals("0")) {
                    String neworderid = results[1].split("=")[1];
                    String newxunleipayid = Utility.createOrderId();
                    Bizorderok bizorderok = new Bizorderok();
                    VOCopier.copy(bizorderokhis, bizorderok);
                    bizorderok.setBizorderid(neworderid);
                    bizorderok.setXunleipayid(newxunleipayid);
                    bizorderok.setBalancedate(DatetimeUtil.today());
                    bizorderok.setSuccesstime(DatetimeUtil.now());
                    bizorderok.setSendnoticestatus("Y");
                    Mobilevipok mobilevipokToInsert = new Mobilevipok();
                    mobilevipokToInsert.setSp(sp);
                    mobilevipokToInsert.setMobile(mobile);
                    mobilevipokToInsert.setGettime(bizorderok.getSuccesstime());
                    mobilevipokToInsert.setBalancedate(DatetimeUtil.today());
                    mobilevipokToInsert.setOrderid(newxunleipayid);
                    mobilevipokToInsert.setBillingtime(DatetimeUtil.now());
                    mobilevipokToInsert.setBizorderstatus("Y");
                    mobilevipokToInsert.setReqtime(bizorderok.getOrdertime());
                    mobilevipokToInsert.setSerivetype(servicetype);
                    mobilevipokToInsert.setXunleiid(userid);
                    mobilevipokToInsert.setCarrier(carrier);
                    mobilevipokToInsert.setUsershow(bizorderok.getUsershow());
                    mobilevipokToInsert.setBillmonth(balancedate.substring(0, 7));
                    mobilevipokToInsert.setRemark(balancedate + "\u6263\u8d39\u6210\u529f,\u540e\u53f0\u91cd\u65b0\u5f00\u901a\u4f1a\u5458");
                    Paynoticeok paynoticeok = new Paynoticeok();
                    paynoticeok.setRemark("reopen vip");
                    paynoticeok.setXunleipayid(newxunleipayid);
                    paynoticeok.setNoticetime(DatetimeUtil.now());
                    paynoticeok.setFailtimes(0);
                    IFacade.INSTANCE.insertBizorderok(bizorderok);
                    IFacade.INSTANCE.insertMobilevipok(mobilevipokToInsert);
                    IFacade.INSTANCE.insertPaynoticeok(paynoticeok);
                    ++reopenKKVip;
                } else {
                    throw new Exception("reopen vip failed, mobile = " + mobile + ", userid = " + userid + "," + reopen_result);
                }
            }
            logger.info((Object)("reopend KKvip count " + reopenKKVip));
        }
        catch (Exception e) {
            logger.info((Object)("reopend KKvip count " + reopenKKVip));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int reopenvipFromExceptionMobile(String balancedate, String sp, String servicetype) {
        int count = 0;
        try {
            Excptionmobile cExcptionmobile = new Excptionmobile();
            cExcptionmobile.setFromdate(balancedate);
            cExcptionmobile.setTodate(balancedate);
            cExcptionmobile.setExceptiontype("1");
            cExcptionmobile.setIsdeal("N");
            cExcptionmobile.setSerivetype(servicetype);
            cExcptionmobile.setSp(sp);
            List oExcptionmobile = (List)IFacade.INSTANCE.queryExcptionmobile(cExcptionmobile, null).getDatas();
            for (Excptionmobile e : oExcptionmobile) {
                String state;
                Excptionmobile rException = new Excptionmobile();
                rException.setFromdate(balancedate);
                rException.setTodate(balancedate);
                rException.setExceptiontype("2");
                rException.setIsdeal("N");
                rException.setSerivetype(servicetype);
                rException.setSp(sp);
                rException.setMobile(e.getMobile());
                Excptionmobile excptionmobile = IFacade.INSTANCE.findExcptionmobile(rException);
                if (excptionmobile != null) {
                    SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    long timestamp1 = simple.parse(excptionmobile.getInputtime()).getTime();
                    logger.info((Object)("time1: " + timestamp1));
                    long timestamp2 = simple.parse(e.getInputtime()).getTime();
                    logger.info((Object)("time2: " + timestamp2));
                    if (timestamp1 >= timestamp2) continue;
                }
                String mobile = e.getMobile();
                PagedFliper filper = new PagedFliper();
                filper.setSortColumn("reqtime desc");
                Mobilevipreq cMobilevipreq = new Mobilevipreq();
                cMobilevipreq.setMobile(mobile);
                cMobilevipreq.setFromtime(e.getInputtime());
                cMobilevipreq.setTotime(DatetimeUtil.now());
                cMobilevipreq.setSerivetype(servicetype);
                cMobilevipreq.setSp(sp);
                List oMobilevipreq = (List)IFacade.INSTANCE.queryMobilevipreq(cMobilevipreq, filper).getDatas();
                if (oMobilevipreq == null || oMobilevipreq.size() <= 0 || !(state = ((Mobilevipreq)oMobilevipreq.get(0)).getKongdatastatus()).equals("Y")) continue;
                Mobilevipok cMobilevipok = new Mobilevipok();
                cMobilevipok.setSerivetype(servicetype);
                cMobilevipok.setSp(sp);
                cMobilevipok.setMobile(mobile);
                List oMobilevipok = (List)IFacade.INSTANCE.queryMobilevipok(cMobilevipok, null).getDatas();
                if (oMobilevipok != null && oMobilevipok.size() != 0) continue;
                this.dealVipok(balancedate, mobile, servicetype, sp);
                Excptionmobile ex = IFacade.INSTANCE.findExcptionmobile(e);
                if (ex != null) {
                    e.setIsdeal("Y");
                    IFacade.INSTANCE.updateExcptionmobile(e);
                }
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return count;
        }
    }

    private void dealVipok(String balancedate, String mobile, String servicetype, String sp) {
        try {
            Mobilevipok mobilevipok = IFacade.INSTANCE.doMobilereqToOk(mobile, servicetype, sp);
            logger.info((Object)"doMobilereqToOk succeed!");
            IFacade.INSTANCE.doPayNotice(mobilevipok);
            logger.info((Object)"doPayNotice succeed!");
            Mobilevipok ok = IFacade.INSTANCE.findMobilevipok(mobilevipok);
            if (ok != null) {
                ok.setRemark(balancedate + "\u5f02\u5e38\u53f7\u7801\u6210\u529f\u8bf7\u6c42\u5e76\u540e\u53f0\u7a0b\u5e8f\u4eba\u5de5\u5b9a\u5236");
                IFacade.INSTANCE.updateMobilevipok(ok);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String callReopenVipInterface(String userid, String phone, String orderid, String billmonth) throws IOException {
        String vipreopenUrl = String.format(this.vipReopenInterface, userid, phone, orderid, billmonth);
        logger.debug((Object)("vipreopenUrl : " + vipreopenUrl));
        return HttpRecall.sendGet(vipreopenUrl);
    }

    private void createFile(String serivetype, List<String> retStrList) {
        try {
            String path = this.retFilePath + DatetimeUtil.yesterday() + "ret2-" + serivetype + ".txt";
            logger.info((Object)("filePath:" + path));
            if (retStrList.size() > 0) {
                File file = new File(path);
                if (file.exists()) {
                    FileUtil.deleteFile((String)path);
                }
                FileCommonUtils.createFile(path);
                for (String s : retStrList) {
                    logger.info((Object)s);
                    FileCommonUtils.addToFile(path, s);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public int dealException(String balancedate, String todate, String sp, String servicetype) {
        reopenVip = 0;
        try {
            Mobilevipbill mobilevipbillQry = new Mobilevipbill();
            mobilevipbillQry.setFromdate(balancedate);
            mobilevipbillQry.setTodate(balancedate);
            mobilevipbillQry.setChargestate("Y");
            mobilevipbillQry.setDatastate("E");
            mobilevipbillQry.setExceptiondatatype("2");
            mobilevipbillQry.setDealtype("B");
            mobilevipbillQry.setSerivetype(servicetype);
            mobilevipbillQry.setSp(sp);
            List lists = (List)IFacade.INSTANCE.queryMobilevipbill(mobilevipbillQry, null).getDatas();
            for (Mobilevipbill mobilevipbill : lists) {
                String mobile = mobilevipbill.getMobile();
                PagedFliper fliper = new PagedFliper();
                fliper.setSortColumn("quittime desc");
                Mobilevipquit mobilevipquitQry = new Mobilevipquit();
                mobilevipquitQry.setMobile(mobile);
                mobilevipquitQry.setSp(sp);
                mobilevipquitQry.setSerivetype(servicetype);
                mobilevipquitQry.setFromdate(balancedate);
                mobilevipquitQry.setTodate(todate);
                List mobilevipquits = (List)IFacade.INSTANCE.queryMobilevipquit(mobilevipquitQry, fliper).getDatas();
                if (mobilevipquits == null || mobilevipquits.size() <= 0) continue;
                String userid = ((Mobilevipquit)mobilevipquits.get(0)).getXunleiid();
                String xunleipayid = ((Mobilevipquit)mobilevipquits.get(0)).getRemark().split("\uff1a")[1];
                String carrier = ((Mobilevipquit)mobilevipquits.get(0)).getCarrier();
                Mobilevipok mobilevipokQry = new Mobilevipok();
                mobilevipokQry.setMobile(mobile);
                mobilevipokQry.setSp(sp);
                List mobilevipoks = (List)IFacade.INSTANCE.queryMobilevipok(mobilevipokQry, null).getDatas();
                Mobilevipok qMobilevipok = new Mobilevipok();
                qMobilevipok.setXunleiid(userid);
                qMobilevipok.setSp(sp);
                List oMobileList = (List)IFacade.INSTANCE.queryMobilevipok(qMobilevipok, null).getDatas();
                if (mobilevipoks != null && mobilevipoks.size() != 0 || oMobileList != null && oMobileList.size() != 0) continue;
                logger.info((Object)("mobile:" + mobile + ", userid:" + userid + "\u5728\u5305\u6708\u6210\u529f\u8868\u4e2d\u4e0d\u5b58\u5728\uff0c\u7ee7\u7eed\u91cd\u65b0\u5f00\u901a\u4f1a\u5458\u903b\u8f91\uff01"));
                this.reopenVip(balancedate, mobile, servicetype, carrier, sp, userid, xunleipayid);
            }
            if (servicetype.equals("A")) {
                this.createFile(servicetype, this.retAStrList);
            } else if (servicetype.equals("C")) {
                this.createFile(servicetype, this.retCStrList);
            }
            return reopenVip;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return reopenVip;
        }
    }

    private String callReopenKKVipInterface(String userid, String phone) throws IOException {
        if ("".equals(this.kkVipBizKey)) {
            Copbizinfo copbizinfo = new Copbizinfo();
            copbizinfo.setBizno("000001043");
            copbizinfo = IFacade.INSTANCE.findCopbizinfo(copbizinfo);
            this.kkVipBizKey = copbizinfo == null ? "kYSainzt19Gklane" : copbizinfo.getBizkey();
            logger.info((Object)("kkVipBizKey:" + this.kkVipBizKey));
        }
        String toSign = new StringBuffer("userid=").append(userid).append("&phone=").append(phone).append(this.kkVipBizKey).toString();
        logger.debug((Object)("toSign:" + toSign));
        String signMsg = Md5Encrypt.md5((String)toSign, (String)"GBK");
        String vipreopenUrl = String.format(this.kkvipReopenInterface, userid, phone, signMsg);
        logger.debug((Object)("kkvipreopenUrl : " + vipreopenUrl));
        return HttpRecall.sendGet(vipreopenUrl);
    }
}

