/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.bo;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.bo.IMobileVerifyBo;
import com.xunlei.payproxy.dao.IExtumpayDao;
import com.xunlei.payproxy.dao.IVerifyMobileDao;
import com.xunlei.payproxy.exception.AccountUseNoLimitException;
import com.xunlei.payproxy.exception.PayamountLimitException;
import com.xunlei.payproxy.exception.PaycountLimitException;
import com.xunlei.payproxy.vo.Extumpay;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.vo.Libclassm;
import com.xunlei.payproxy.vo.Vmobilenoinfo;
import com.xunlei.payproxy.vo.Vmobileuserid;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileVerifyBoImpl
implements IMobileVerifyBo {
    private static final Log logger = LogFactory.getLog(MobileVerifyBoImpl.class);
    private static int sumFlag = 3;
    private IVerifyMobileDao verifyMobileDao;
    private IExtumpayDao extumpayDao;
    private Map<String, String> umpayLimitMap;

    public IVerifyMobileDao getVerifyMobileDao() {
        return this.verifyMobileDao;
    }

    public void setVerifyMobileDao(IVerifyMobileDao verifyMobileDao) {
        this.verifyMobileDao = verifyMobileDao;
    }

    public IExtumpayDao getExtumpayDao() {
        return this.extumpayDao;
    }

    public void setExtumpayDao(IExtumpayDao extumpayDao) {
        this.extumpayDao = extumpayDao;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void verifyAmountAndCount(String mobileNo, String userId, int orderAmt) {
        if (this.umpayLimitMap == null) {
            List<Libclassd> limits = Libclassm.getLibclassdValues("UmpayLimit");
            if (limits == null) {
                return;
            }
            this.umpayLimitMap = new HashMap<String, String>(limits.size());
            for (Libclassd d : limits) {
                this.umpayLimitMap.put(d.getItemno().trim(), d.getItemvalue().trim());
            }
        }
        int mobileamount = Integer.valueOf(this.umpayLimitMap.get("MobileAmountLimit"));
        int mobileaccount = Integer.valueOf(this.umpayLimitMap.get("MobileAccountLimit"));
        int accountuseno = Integer.valueOf(this.umpayLimitMap.get("VAccountUseLimit"));
        int mobliereq = Integer.valueOf(this.umpayLimitMap.get("MobileReqLimit"));
        int accountReqLimit = Integer.valueOf(this.umpayLimitMap.get("AccountReqLimit"));
        Calendar c = Calendar.getInstance();
        Date to = c.getTime();
        c.add(5, -1);
        Date from = c.getTime();
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");
        String fromDate = formate.format(from);
        String toDate = formate.format(to);
        logger.debug((Object)("userId : " + userId + " fromDate : " + fromDate + " toDate : " + toDate + " mobileNo : " + mobileNo));
        int failUserReqNum = this.extumpayDao.countExtumpayByUmpaytype(userId, fromDate, toDate, null);
        int failMobileNoReqNum = this.extumpayDao.countExtumpayByUmpaytype(null, fromDate, toDate, mobileNo);
        logger.debug((Object)("mobliereq : " + mobliereq + " failUserReqNum : " + failUserReqNum + " failMobileNoReqNum : " + failMobileNoReqNum));
        if (failUserReqNum >= accountReqLimit) {
            if (failUserReqNum != accountReqLimit) {
                logger.debug((Object)("=========== throw failUserReqNum :" + failUserReqNum));
                throw new PaycountLimitException("\u5c0a\u656c\u7684\u7528\u6237\uff0c\u60a8\u7684\u8d26\u53f7\u5df2\u7ecf\u4e0b\u8fc7\u591a\u6b21\u8ba2\u5355\uff0c\u8bf7\u786e\u8ba4\u60a8\u4e4b\u524d\u7684\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u540e\uff0c\u518d\u8fdb\u884c\u652f\u4ed8");
            }
            Extumpay ext = new Extumpay();
            ext.setXunleiid(userId);
            ext.setFromFullDate(fromDate);
            ext.setToFullDate(toDate);
            Sheet<Extumpay> sheets = this.extumpayDao.queryExtumpay(ext, new PagedFliper());
            List li = (List)sheets.getDatas();
            Extumpay extumpay = (Extumpay)li.get(0);
            if (this.decideMobileNumSimilarity(extumpay.getMobileno(), mobileNo) > sumFlag || this.decideMobileNumSimilarity(extumpay.getMobileno(), mobileNo) == 0) {
                logger.debug((Object)("========= throw failMobileNoReqNum :" + failMobileNoReqNum));
                throw new PaycountLimitException("\u5c0a\u656c\u7684\u7528\u6237\uff0c\u60a8\u7684\u8d26\u53f7\u5df2\u7ecf\u4e0b\u8fc7\u591a\u6b21\u8ba2\u5355\uff0c\u8bf7\u786e\u8ba4\u60a8\u4e4b\u524d\u7684\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u540e\uff0c\u518d\u8fdb\u884c\u652f\u4ed8");
            }
        } else if (failMobileNoReqNum >= mobliereq) {
            logger.debug((Object)("========= throw failMobileNoReqNum :" + failMobileNoReqNum));
            throw new PaycountLimitException("\u5c0a\u656c\u7684\u7528\u6237\uff0c\u60a8\u7684\u624b\u673a\u53f7\u7801\u5df2\u7ecf\u4e0b\u8fc7\u591a\u6b21\u8ba2\u5355\uff0c\u8bf7\u786e\u8ba4\u60a8\u4e4b\u524d\u7684\u8ba2\u5355\u652f\u4ed8\u5b8c\u6bd5\u540e\u518d\u8fdb\u884c\u652f\u4ed8");
        }
        Vmobilenoinfo vmobilenoinfo = this.verifyMobileDao.getVmobileinfo(mobileNo);
        List<Vmobileuserid> vmobileuserids = this.verifyMobileDao.queryVmobileuserid(userId);
        if (vmobileuserids.size() >= accountuseno) {
            throw new AccountUseNoLimitException("\u62b1\u6b49\uff0c\u5f53\u524d\u5e10\u6237\u4e00\u6bb5\u65f6\u95f4\u5185\u4f7f\u7528\u7684\u624b\u673a\u53f7\u7801\u6570\u5df2\u7ecf\u8d85\u8fc7\u9650\u5236\u3002\u8bf7\u7a0d\u5019\u4e00\u6bb5\u65f6\u95f4\u518d\u8bd5\u6216\u8005\u5c1d\u8bd5\u5176\u4ed6\u652f\u4ed8\u65b9\u5f0f\u3002");
        }
        if (StringTools.isNotEmpty((String)vmobilenoinfo.getMobileno())) {
            if (vmobilenoinfo.getAmount() + orderAmt > mobileamount) {
                throw new PayamountLimitException("\u62b1\u6b49\uff0c\u5f53\u524d\u624b\u673a\u53f7\u7801\u4e00\u6bb5\u5185\u7684\u652f\u4ed8\u91d1\u989d\u5df2\u7ecf\u8d85\u8fc7\u9650\u5236\u3002\u8bf7\u7a0d\u5019\u4e00\u6bb5\u65f6\u95f4\u518d\u8bd5\u6216\u8005\u5c1d\u8bd5\u5176\u4ed6\u652f\u4ed8\u65b9\u5f0f\u3002");
            }
            if (vmobilenoinfo.getUsercount() >= mobileaccount) {
                throw new PaycountLimitException("\u62b1\u6b49\uff0c\u5f53\u524d\u624b\u673a\u53f7\u7801\u4e00\u6bb5\u5185\u7684\u652f\u4ed8\u6b21\u6570\u5df2\u7ecf\u8d85\u8fc7\u9650\u5236\u3002\u8bf7\u7a0d\u5019\u4e00\u6bb5\u65f6\u95f4\u518d\u8bd5\u6216\u8005\u5c1d\u8bd5\u5176\u4ed6\u652f\u4ed8\u65b9\u5f0f\u3002");
            }
        }
    }

    private int decideMobileNumSimilarity(String num1, String num2) {
        int count = 0;
        for (int i = 0; i < num1.length(); ++i) {
            if (num1.charAt(i) == num2.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void updateAmountAndCount(String mobileNo, String userId, int orderAmt) {
        Vmobilenoinfo vmobilenoinfo = this.verifyMobileDao.getVmobileinfo(mobileNo);
        if (StringTools.isEmpty((String)vmobilenoinfo.getMobileno())) {
            vmobilenoinfo.setMobileno(mobileNo);
            vmobilenoinfo.setAmount(orderAmt);
            vmobilenoinfo.setUsercount(1);
        } else {
            vmobilenoinfo.setAmount(vmobilenoinfo.getAmount() + orderAmt);
            vmobilenoinfo.setUsercount(vmobilenoinfo.getUsercount() + 1);
        }
        try {
            this.verifyMobileDao.updateVmobileinfo(vmobilenoinfo);
            Vmobileuserid userid = new Vmobileuserid();
            userid.setMobileno(mobileNo);
            userid.setUserid(userId);
            this.verifyMobileDao.insertVMobileuserid(userid);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    @Override
    public void emptyMobileValidateData() {
        this.verifyMobileDao.emptyVmobileinfo();
        this.verifyMobileDao.emptyVmobileuserid();
    }

    @Override
    public List<Vmobileuserid> queryVmobileuseridByMobileno(String mobileno) {
        return this.verifyMobileDao.queryVmobileuseridByMobileno(mobileno);
    }

    @Override
    public Vmobilenoinfo getVmobileinfo(String mobileno) {
        return this.verifyMobileDao.getVmobileinfo(mobileno);
    }

    @Override
    public List<Vmobileuserid> queryVmobileuserid(String userid) {
        return this.verifyMobileDao.queryVmobileuserid(userid);
    }

    @Override
    public void deleteVmobileinfo(String mobileno) {
        this.verifyMobileDao.deleteVmobileinfo(mobileno);
    }

    @Override
    public void deleteVmobileuserid(Vmobileuserid data) {
        this.verifyMobileDao.deleteVmobileuserid(data);
    }
}

