/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.bo;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.payproxy.bo.BaseBo;
import com.xunlei.payproxy.bo.IExtunicastBo;
import com.xunlei.payproxy.dao.IExtunicastDao;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.util.HttpGetAndPostSender;
import com.xunlei.payproxy.util.MiscUtility;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Extunicast;
import com.xunlei.payproxy.vo.Extunicastok;
import java.net.URLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtunicastBoImpl
extends BaseBo
implements IExtunicastBo {
    private IExtunicastDao extunicastdao;

    public IExtunicastDao getExtunicastdao() {
        return this.extunicastdao;
    }

    public void setExtunicastdao(IExtunicastDao extunicastdao) {
        this.extunicastdao = extunicastdao;
    }

    @Override
    public Extunicast findExtunicast(Extunicast data) {
        return this.extunicastdao.findExtunicast(data);
    }

    @Override
    public Extunicast findExtunicastById(long id) {
        return this.extunicastdao.findExtunicastById(id);
    }

    @Override
    public Sheet<Extunicast> queryExtunicast(Extunicast data, PagedFliper fliper) {
        return this.extunicastdao.queryExtunicast(data, fliper);
    }

    @Override
    public void insertExtunicast(Extunicast data) {
        this.extunicastdao.insertExtunicast(data);
    }

    @Override
    public void updateExtunicast(Extunicast data) {
        this.extunicastdao.updateExtunicast(data);
    }

    @Override
    public void deleteExtunicast(Extunicast data) {
        this.extunicastdao.deleteExtunicast(data);
    }

    @Override
    public void deleteExtunicastByIds(long ... ids) {
        this.extunicastdao.deleteExtunicastByIds(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callExtunicastreq(Extunicast extuni) {
        String orderidLock1 = extuni.getOrderid();
        String string = orderidLock1.intern();
        synchronized (string) {
            this.logger.info((Object)"saveExtunicast synchronized begin");
            this.saveExtunicast(extuni);
            this.logger.info((Object)"saveExtunicast synchronized end");
        }
    }

    private void saveExtunicast(Extunicast extunicast) {
        Extunicast qExt = new Extunicast();
        qExt.setMobile(extunicast.getMobile());
        qExt.setXunleiid(extunicast.getXunleiid());
        qExt.setProducttype(extunicast.getProducttype());
        qExt.setSp(extunicast.getSp());
        Extunicast oExt = this.findExtunicast(qExt);
        if (oExt != null) {
            oExt.setRemark(oExt.getRemark() + (extunicast.getUsershow().equals(oExt.getUsershow()) ? "" : oExt.getUsershow()) + ",");
            oExt.setOrderid(extunicast.getOrderid());
            oExt.setReqtime(DatetimeUtil.now());
            oExt.setProducttype(extunicast.getProducttype());
            this.updateExtunicast(oExt);
        } else {
            Extunicast ext = new Extunicast();
            ext.setOrderid(extunicast.getOrderid());
            ext.setMobile(extunicast.getMobile());
            ext.setXunleiid(extunicast.getXunleiid());
            ext.setUsershow(extunicast.getUsershow());
            ext.setProducttype(extunicast.getProducttype());
            String carrier = "";
            if (Utility.isNumberVerify("MobileNumbers", extunicast.getMobile().substring(0, 3))) {
                carrier = "M";
            }
            if (Utility.isNumberVerify("UnionNumbers", extunicast.getMobile().substring(0, 3))) {
                carrier = "U";
            }
            if (Utility.isNumberVerify("TelecomNumbers", extunicast.getMobile().substring(0, 3))) {
                carrier = "T";
            }
            ext.setCarrier(carrier);
            ext.setReqtime(DatetimeUtil.now());
            ext.setRemark("");
            ext.setGetmostatus("N");
            ext.setSp(extunicast.getSp());
            ext.setOrderamt(extunicast.getOrderamt());
            this.insertExtunicast(ext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateExtunicastData(Extunicast ext) {
        String lock;
        String string = lock = ext.getLinkid();
        synchronized (string) {
            try {
                String mobile = ext.getMobile();
                String content = URLEncoder.encode(ext.getContent(), "utf-8");
                this.logger.info((Object)("content utf-8:" + content));
                String request_url = ext.getRequest_url();
                Extunicast qExtunicast = this.findMinExtunicast(mobile);
                if (qExtunicast == null) {
                    throw new XLRuntimeException("\u4e0d\u5b58\u5728\u624b\u673a\u53f7\u4e3a\uff1a" + mobile + "\u7684\u8bf7\u6c42\u8bb0\u5f55");
                }
                qExtunicast.setLinkid(ext.getLinkid());
                qExtunicast.setProvince(ext.getProvince());
                qExtunicast.setGetmostatus("Y");
                this.updateExtunicast(qExtunicast);
                String url = request_url + "?mobile=" + mobile + "&linkid=" + ext.getLinkid() + "&content=" + content + "&allow=true";
                this.logger.info((Object)"undate extunicast succeed!");
                this.logger.info((Object)"enter message interface!!");
                this.logger.info((Object)("url:" + url));
                String result = HttpGetAndPostSender.sendGet(url);
                this.logger.info((Object)("result:" + result));
                if (result.equals("err")) {
                    HttpGetAndPostSender.sendGet(url);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Extunicastok doExtunicastToOk(String mobile, String linkid) {
        String lock = linkid;
        String string = lock.intern();
        synchronized (string) {
            Extunicast ext = new Extunicast();
            ext.setMobile(mobile.trim());
            ext.setLinkid(linkid);
            Extunicast qExtunicast = this.findExtunicast(ext);
            Extunicastok extu = new Extunicastok();
            extu.setMobile(mobile.trim());
            extu.setLinkid(linkid);
            Extunicastok qExtunicastok = IFacade.INSTANCE.findExtunicastok(extu);
            if (qExtunicastok != null) {
                throw new XLRuntimeException("\u8be5\u7528\u6237\u6b64\u6b21\u8bf7\u6c42\u5df2\u6210\u529f\uff0c\u91cd\u4f20\u65e0\u6548\uff01");
            }
            if (qExtunicast == null) {
                throw new XLRuntimeException("\u4e0d\u5b58\u5728\u624b\u673a\u53f7\u4e3a" + mobile + "\u7684\u8bf7\u6c42\u8bb0\u5f55");
            }
            Extunicastok extunicastok = new Extunicastok();
            this.logger.info((Object)("orderid:" + qExtunicast.getOrderid()));
            this.logger.info((Object)("Linkid:" + qExtunicast.getLinkid()));
            extunicastok.setOrderid(qExtunicast.getOrderid());
            extunicastok.setOrderamt(qExtunicast.getOrderamt());
            extunicastok.setMobile(qExtunicast.getMobile());
            extunicastok.setXunleiid(qExtunicast.getXunleiid());
            extunicastok.setUsershow(qExtunicast.getUsershow());
            extunicastok.setSp(qExtunicast.getSp());
            extunicastok.setCarrier(qExtunicast.getCarrier());
            extunicastok.setProvince(qExtunicast.getProvince());
            extunicastok.setReqtime(qExtunicast.getReqtime());
            extunicastok.setSuccesstime(DatetimeUtil.now());
            extunicastok.setBalancedate(MiscUtility.dateofnow());
            extunicastok.setBizorderstatus("N");
            extunicastok.setRemark("");
            extunicastok.setProducttype(qExtunicast.getProducttype());
            extunicastok.setLinkid(qExtunicast.getLinkid());
            IFacade.INSTANCE.insertExtunicastok(extunicastok);
            this.deleteExtunicastByIds(qExtunicast.getSeqid());
            return extunicastok;
        }
    }

    @Override
    public int deleteExtunicastTodate(String todate) {
        return this.extunicastdao.deleteExtunicastTodate(todate);
    }

    @Override
    public Extunicast findMinExtunicast(String mobile) {
        return this.extunicastdao.findExtunicastByMobile(mobile);
    }
}

