/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.bo;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.payproxy.bo.BaseBo;
import com.xunlei.payproxy.bo.IExtumpayBo;
import com.xunlei.payproxy.dao.IExtumpayDao;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.util.XLAlreadyMoveException;
import com.xunlei.payproxy.vo.Extumpay;
import com.xunlei.payproxy.vo.Extumpayok;
import com.xunlei.payproxy.vo.Extumpayokinfo;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtumpayBoImpl
extends BaseBo
implements IExtumpayBo {
    private static Logger logger = Logger.getLogger(ExtumpayBoImpl.class);
    private IExtumpayDao extumpayDao;

    @Override
    public Extumpay getExtumpayById(long seqid) {
        return this.getExtumpayDao().getExtumpayById(seqid);
    }

    @Override
    public Extumpay findExtumpay(Extumpay data) {
        return this.getExtumpayDao().findExtumpay(data);
    }

    @Override
    public void insertExtumpay(Extumpay data) {
        this.getExtumpayDao().insertExtumpay(data);
    }

    @Override
    public void updateExtumpay(Extumpay data) {
        this.getExtumpayDao().updateExtumpay(data);
    }

    @Override
    public void deleteExtumpayById(long ... seqids) {
        this.getExtumpayDao().deleteExtumpayById(seqids);
    }

    @Override
    public void deleteExtumpay(Extumpay data) {
        this.getExtumpayDao().deleteExtumpay(data);
    }

    @Override
    public Sheet<Extumpay> queryExtumpay(Extumpay data, PagedFliper fliper) {
        return this.getExtumpayDao().queryExtumpay(data, fliper);
    }

    @Override
    public int deleteExtumpayTodate(String todate) {
        return this.getExtumpayDao().deleteExtumpayTodate(todate);
    }

    public IExtumpayDao getExtumpayDao() {
        return this.extumpayDao;
    }

    public void setExtumpayDao(IExtumpayDao extumpayDao) {
        this.extumpayDao = extumpayDao;
    }

    @Override
    public void moveExtumpayToSuccess(String orderId, String bizOrderStatus, String balanceDate, int transType, String remark) {
        logger.info((Object)("orderid==" + orderId + "\tbizOrderStatus=" + bizOrderStatus + "\tbalanceDate=" + balanceDate + "\ttransType=" + transType + "\tretCode==" + remark));
        Extumpayokinfo extumpayokinfoForQuery = new Extumpayokinfo();
        extumpayokinfoForQuery.setOrderid(orderId);
        IFacade facade = IFacade.INSTANCE;
        Extumpayokinfo extumpayokinfo = facade.findExtumpayokinfo(extumpayokinfoForQuery);
        logger.info((Object)("extumpayokinfo==" + (extumpayokinfo == null ? null : extumpayokinfo)));
        if (extumpayokinfo != null && !extumpayokinfo.getUmpaytype().equals("D")) {
            throw new XLAlreadyMoveException("umpay\u6210\u529f\u8868\u5df2\u7ecf\u5b58\u5728\u8ba2\u5355\u53f7\u4e3a" + orderId + "\u7684\u6570\u636e");
        }
        Extumpay extumpayForQuery = new Extumpay();
        extumpayForQuery.setOrderid(orderId);
        Extumpay extumpay = this.findExtumpay(extumpayForQuery);
        logger.info((Object)("extumpay==" + (extumpay == null ? null : extumpay)));
        if (extumpay == null && extumpayokinfo != null && !extumpayokinfo.getUmpaytype().equals("D")) {
            throw new XLRuntimeException("\u4e0d\u5b58\u5728\u8ba2\u5355\u53f7\u4e3a" + orderId + "\u7684umpay\u8bf7\u6c42\u6570\u636e");
        }
        Extumpayok newExtumpayok = new Extumpayok();
        String umpayType = "";
        if (extumpay != null) {
            Utility.copyProperties(newExtumpayok, extumpay);
            umpayType = extumpay.getUmpaytype();
        } else if (extumpayokinfo != null) {
            Utility.copyProperties(newExtumpayok, extumpayokinfo);
            umpayType = extumpayokinfo.getUmpaytype();
        }
        newExtumpayok.setSuccesstime(DatetimeUtil.now());
        newExtumpayok.setBalancedate(DatetimeUtil.today());
        newExtumpayok.setOrderid(orderId);
        newExtumpayok.setRemark(balanceDate);
        newExtumpayok.setTranstype(transType);
        newExtumpayok.setBizorderstatus(bizOrderStatus);
        logger.info((Object)("umpaytype==" + umpayType));
        if (umpayType.equals("D")) {
            Extumpayok querySameMonthlyId = new Extumpayok();
            querySameMonthlyId.setMonthlyOrderId(orderId);
            Sheet<Extumpayok> sheet = IFacade.INSTANCE.queryExtumpayok(querySameMonthlyId, null);
            int sum = sheet.getRowcount();
            logger.info((Object)("sum==" + sum));
            if (sum == 0) {
                newExtumpayok.setMonthlyOrderId(orderId);
                newExtumpayok.setOrderid(orderId + "_" + (sum + 1));
                newExtumpayok.setMonthlyEndedTime("0000");
                Extumpayokinfo endedTimeExtumpayok = new Extumpayokinfo();
                Utility.copyProperties(endedTimeExtumpayok, newExtumpayok);
                endedTimeExtumpayok.setOrderid(orderId);
                endedTimeExtumpayok.setMonthlyEndedTime("9999");
                endedTimeExtumpayok.setRemark("1");
                endedTimeExtumpayok.setBalancedate(balanceDate);
                facade.insertExtumpayokinfo(endedTimeExtumpayok);
            } else {
                newExtumpayok.setMonthlyOrderId(orderId);
                newExtumpayok.setOrderid(orderId + "_" + sum);
                newExtumpayok.setMonthlyEndedTime("0000");
                Extumpayokinfo endedTimeExtumpayokQry = new Extumpayokinfo();
                endedTimeExtumpayokQry.setOrderid(orderId);
                Extumpayokinfo upEndedTimeExtumpayok = IFacade.INSTANCE.findExtumpayokinfo(endedTimeExtumpayokQry);
                if (balanceDate.equals(upEndedTimeExtumpayok.getBalancedate())) {
                    return;
                }
                upEndedTimeExtumpayok.setRemark(String.valueOf(sum));
                upEndedTimeExtumpayok.setBalancedate(balanceDate);
                upEndedTimeExtumpayok.setSuccesstime(DatetimeUtil.now());
                IFacade.INSTANCE.updateExtumpayokinfo(upEndedTimeExtumpayok, new String[]{"SuccessTime", "BalanceDate", "Remark"});
            }
        }
        try {
            if (extumpay != null) {
                facade.updateAmountAndCount(extumpay.getMobileno(), extumpay.getXunleiid(), extumpay.getAmount());
            } else if (extumpayokinfo != null) {
                facade.updateAmountAndCount(extumpayokinfo.getMobileno(), extumpayokinfo.getXunleiid(), extumpayokinfo.getAmount());
            }
        }
        catch (Exception ex) {
            logger.error((Object)("\u66f4\u65b0\u624b\u673a\u53f7\u7801\u9a8c\u8bc1\u4fe1\u606f\u5931\u8d25:" + ex));
        }
        if (!"0000".equals(remark)) {
            logger.error((Object)("\u8ba2\u5355" + orderId + "\u7684\u8fd4\u56de\u503c" + remark));
        }
        logger.info((Object)"begin to insertExtumpayok");
        facade.insertExtumpayok(newExtumpayok);
        try {
            this.extumpayDao.deleteExtumpayById(extumpay.getSeqid());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        logger.info((Object)"done");
    }
}

