/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.bo;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.bo.BaseBo;
import com.xunlei.payproxy.bo.IExttenpayBo;
import com.xunlei.payproxy.dao.IExttenpayDao;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.util.Arith;
import com.xunlei.payproxy.util.MiscUtility;
import com.xunlei.payproxy.util.XLPayProxyRuntimeException;
import com.xunlei.payproxy.vo.Bizorderok;
import com.xunlei.payproxy.vo.Exttenpay;
import com.xunlei.payproxy.vo.Exttenpayok;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExttenpayBoImpl
extends BaseBo
implements IExttenpayBo {
    private static Logger logger = Logger.getLogger(ExttenpayBoImpl.class);
    private IExttenpayDao exttenpayDao;

    public IExttenpayDao getExttenpayDao() {
        return this.exttenpayDao;
    }

    public void setExttenpayDao(IExttenpayDao exttenpayDao) {
        this.exttenpayDao = exttenpayDao;
    }

    @Override
    public Exttenpay findExttenpay(Exttenpay data) {
        return this.exttenpayDao.findExttenpay(data);
    }

    @Override
    public Exttenpay findExttenpayById(long id) {
        return this.exttenpayDao.findExttenpayById(id);
    }

    @Override
    public Sheet<Exttenpay> queryExttenpay(Exttenpay data, PagedFliper fliper) {
        return this.exttenpayDao.queryExttenpay(data, fliper);
    }

    @Override
    public void insertExttenpay(Exttenpay data) {
        this.exttenpayDao.insertExttenpay(data);
    }

    @Override
    public void updateExttenpay(Exttenpay data) {
        this.exttenpayDao.updateExttenpay(data);
    }

    @Override
    public void deleteExttenpay(Exttenpay data) {
        this.exttenpayDao.deleteExttenpay(data);
    }

    @Override
    public void deleteExttenpayByIds(long ... ids) {
        this.exttenpayDao.deleteExttenpayByIds(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveExttenpayToSucc(Exttenpay exttenpay, Exttenpayok exttenpayok) throws XLPayProxyRuntimeException {
        logger.info((Object)("moveExttenpayToSucc start, tradeno = " + exttenpayok.getOrderid()));
        String orderId = exttenpayok.getOrderid();
        String string = orderId.intern();
        synchronized (string) {
            try {
                if (null != exttenpay) {
                    double sub = Arith.sub(exttenpayok.getOrderamt(), exttenpay.getOrderamt());
                    logger.debug((Object)("\u8d22\u4ed8\u901a\u8fd4\u56de\u7684\u8ba2\u5355\u91d1\u989d\uff1a" + exttenpayok.getOrderamt() + ", \u6570\u636e\u5e93\u5b58\u50a8\u7684\u8ba2\u5355\u91d1\u989d\uff1a" + exttenpay.getOrderamt()));
                    if (Math.abs(sub) > 0.01) {
                        exttenpayok.setBizorderstatus("W");
                    }
                    if (exttenpayok.getBizorderstatus().equals("W") && exttenpay.getExttenpaystatus().equals("W")) {
                        exttenpay.setDealtime(exttenpayok.getDealtime() == null ? "" : exttenpayok.getDealtime());
                        exttenpay.setTransactionid(exttenpayok.getTransactionid() == null ? "" : exttenpayok.getTransactionid());
                        exttenpay.setExttenpaystatus(exttenpayok.getBizorderstatus());
                        IFacade.INSTANCE.updateExttenpay(exttenpay);
                        throw new XLPayProxyRuntimeException("payedamt is not correct");
                    }
                    if (exttenpayok.getBizorderstatus().equals("Y") && !exttenpay.getExttenpaystatus().equals("Y")) {
                        exttenpayok.setBalancedate(DatetimeUtil.today());
                        exttenpayok.setInputtime(exttenpay.getInputtime());
                        exttenpayok.setBanktype(exttenpay.getBanktype());
                        exttenpayok.setBuyerid(exttenpay.getBuyerid());
                        exttenpayok.setExt1(exttenpay.getExt1());
                        exttenpayok.setExt2(exttenpay.getExt2());
                        exttenpayok.setInputip(exttenpay.getInputip());
                        exttenpayok.setUsershow(exttenpay.getUsershow());
                        exttenpayok.setXunleiid(exttenpay.getXunleiid());
                        exttenpayok.setRemark(exttenpay.getRemark());
                        exttenpayok.setBuyerid(exttenpay.getBuyerid());
                        exttenpayok.setXunleipayid(exttenpay.getXunleipayid());
                        double rate = 0.004;
                        double fareamt = MiscUtility.calTenpayFareamt(exttenpayok.getOrderamt(), rate);
                        double factamt = Arith.sub(exttenpayok.getOrderamt(), fareamt);
                        exttenpayok.setFareamt(fareamt);
                        exttenpayok.setFactamt(factamt);
                        IFacade.INSTANCE.insertExttenpayok(exttenpayok);
                        IFacade.INSTANCE.deleteExttenpay(exttenpay);
                        IFacade.INSTANCE.moveBizorderToSuccess(exttenpayok.getXunleipayid());
                        Bizorderok query = new Bizorderok();
                        query.setXunleipayid(exttenpayok.getXunleipayid());
                        Bizorderok bizorderok = IFacade.INSTANCE.findBizorderok(query);
                        if (bizorderok != null) {
                            bizorderok.setFareamt(fareamt);
                            IFacade.INSTANCE.updateBizorderok(bizorderok);
                        }
                    }
                    if (exttenpayok.getBizorderstatus().equals("W") && !exttenpay.getExttenpaystatus().equals("W")) {
                        logger.error((Object)"\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26\uff0c\u56de\u5199fail");
                        throw new XLPayProxyRuntimeException("payedamt is not correct");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)e.getMessage());
                throw new XLPayProxyRuntimeException(e);
            }
            finally {
                logger.info((Object)("moveExttenpayToSucc end, tradeno = " + exttenpayok.getOrderid()));
            }
        }
    }

    @Override
    public Exttenpay getExttenpayByOrderId(String orderid) {
        return this.exttenpayDao.getExttenpayByOrderId(orderid);
    }

    @Override
    public int deleteExttenpayToDate(String todate, String payStatus) {
        return this.exttenpayDao.deleteExttenpayToDate(todate, payStatus);
    }
}

