/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.bo;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.payproxy.bo.BaseBo;
import com.xunlei.payproxy.bo.IExtnetpayBo;
import com.xunlei.payproxy.dao.IExtnetpayDao;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.vo.Extnetpay;
import com.xunlei.payproxy.vo.Extnetpayok;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtnetpayBoImpl
extends BaseBo
implements IExtnetpayBo {
    private static final Log log = LogFactory.getLog(ExtnetpayBoImpl.class);
    private IExtnetpayDao extnetpayDao;

    @Override
    public void deleteExtnetpayById(long ... seqids) {
        this.getExtnetpayDao().deleteExtnetpayById(seqids);
    }

    @Override
    public void deleteExtnetpay(Extnetpay data) {
        this.getExtnetpayDao().deleteExtnetpay(data);
    }

    @Override
    public Extnetpay findExtnetpay(Extnetpay data) {
        return this.getExtnetpayDao().findExtnetpay(data);
    }

    @Override
    public Extnetpay getExtnetpayById(long seqid) {
        return this.getExtnetpayDao().getExtnetpayById(seqid);
    }

    @Override
    public void insertExtnetpay(Extnetpay data) {
        this.getExtnetpayDao().insertExtnetpay(data);
    }

    @Override
    public Sheet<Extnetpay> queryExtnetpay(Extnetpay data, PagedFliper fliper) {
        return this.getExtnetpayDao().queryExtnetpay(data, fliper);
    }

    @Override
    public void updateExtnetpay(Extnetpay data) {
        this.getExtnetpayDao().updateExtnetpay(data);
    }

    public IExtnetpayDao getExtnetpayDao() {
        return this.extnetpayDao;
    }

    public void setExtnetpayDao(IExtnetpayDao extnetpayDao) {
        this.extnetpayDao = extnetpayDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callExtnetpayreq(Extnetpay extnetpay) {
        String lock;
        String string = lock = extnetpay.getOrderid();
        synchronized (string) {
            this.logger.info((Object)"saveExtnetpay synchronized begin!");
            this.saveExtnetpay(extnetpay);
            this.logger.info((Object)"saveExtnetpay synchronized end!");
        }
    }

    private void saveExtnetpay(Extnetpay ext) {
        Extnetpay qExt = new Extnetpay();
        qExt.setXunleiid(ext.getXunleiid());
        qExt.setProducttype(ext.getProducttype());
        qExt.setCompanytype(ext.getCompanytype());
        Extnetpay oExt = this.findExtnetpay(qExt);
        if (oExt != null) {
            oExt.setRemark(oExt.getRemark() + (ext.getUsershow().equals(oExt.getUsershow()) ? "" : oExt.getUsershow()) + ",");
            oExt.setOrderid(ext.getOrderid());
            oExt.setInputtime(DatetimeUtil.now());
            oExt.setProducttype(ext.getProducttype());
            oExt.setUserip(ext.getUserip());
            this.updateExtnetpay(oExt);
        } else {
            Extnetpay extnetpay = new Extnetpay();
            extnetpay.setOrderid(ext.getOrderid());
            extnetpay.setXunleiid(ext.getXunleiid());
            extnetpay.setUsershow(ext.getUsershow());
            extnetpay.setUserip(ext.getUserip());
            extnetpay.setInputtime(DatetimeUtil.now());
            extnetpay.setRemark("");
            extnetpay.setCompanytype(ext.getCompanytype());
            extnetpay.setPayedamt(ext.getPayedamt());
            extnetpay.setProducttype(ext.getProducttype());
            this.insertExtnetpay(extnetpay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateExtnetpayData(Extnetpay extnetpay) {
        String lock;
        String string = lock = extnetpay.getOrderid();
        synchronized (string) {
            try {
                int companytype = extnetpay.getCompanytype();
                String netorderid = extnetpay.getNetorderid();
                String netaccoutno = extnetpay.getNetaccoutno();
                Extnetpay qExtnetpay = new Extnetpay();
                qExtnetpay.setOrderid(extnetpay.getOrderid());
                log.info((Object)("orderid: " + extnetpay.getOrderid()));
                Extnetpay oExtnetpay = this.findExtnetpay(qExtnetpay);
                if (oExtnetpay == null) {
                    throw new XLRuntimeException("\u4e0d\u5b58\u5728\u8ba2\u5355\u53f7\u4e3a\uff1a" + extnetpay.getOrderid() + "\u7684\u8bf7\u6c42\u8bb0\u5f55");
                }
                oExtnetpay.setCompanytype(companytype);
                oExtnetpay.setNetorderid(netorderid);
                oExtnetpay.setNetaccoutno(netaccoutno);
                this.updateExtnetpay(oExtnetpay);
                log.info((Object)"update extnetpay succeed!");
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void moveExtnetpayToSuccess(String orderId, String BizOrderStatus, String netOrderId, String netaccountno, String remark) {
        Extnetpay netpayForQuery = new Extnetpay();
        netpayForQuery.setOrderid(orderId);
        Extnetpay netpay = this.findExtnetpay(netpayForQuery);
        if (netpay == null) {
            throw new XLRuntimeException("\u4e0d\u5b58\u5728\u8ba2\u5355\u53f7\u4e3a" + orderId + "\u7684\u5bbd\u5e26\u8bf7\u6c42\u6570\u636e");
        }
        Extnetpayok netpayokForQuery = new Extnetpayok();
        netpayokForQuery.setOrderid(orderId);
        Extnetpayok netpayok = IFacade.INSTANCE.findExtnetpayok(netpayokForQuery);
        if (netpayok != null) {
            throw new XLRuntimeException("\u5bbd\u5e26\u652f\u4ed8\u6210\u529f\u8868\u5df2\u7ecf\u5b58\u5728\u8ba2\u5355\u53f7\u4e3a" + orderId + "\u7684\u6570\u636e");
        }
        Extnetpayok newExtnetpayok = new Extnetpayok();
        newExtnetpayok.setBalancedate(DatetimeUtil.today());
        newExtnetpayok.setBizorderstatus("Y");
        newExtnetpayok.setNetorderid(netOrderId);
        newExtnetpayok.setNetaccoutno(netaccountno == null ? netpay.getNetaccoutno() : netaccountno);
        newExtnetpayok.setInputtime(netpay.getInputtime());
        newExtnetpayok.setOrderid(orderId);
        newExtnetpayok.setUserip(netpay.getUserip());
        newExtnetpayok.setSuccesstime(DatetimeUtil.now());
        newExtnetpayok.setUsershow(netpay.getUsershow());
        newExtnetpayok.setXunleiid(netpay.getXunleiid());
        newExtnetpayok.setRemark(remark);
        newExtnetpayok.setCompanytype(netpay.getCompanytype());
        newExtnetpayok.setPayedamt(netpay.getPayedamt());
        newExtnetpayok.setBizorderstatus(BizOrderStatus == null ? "Y" : BizOrderStatus);
        IFacade.INSTANCE.insertExtnetpayok(newExtnetpayok);
        IFacade.INSTANCE.deleteExtnetpayById(netpay.getSeqid());
    }

    @Override
    public Extnetpayok moveVnetExtnetpayToSuccess(String netOrderId, String netaccountno) {
        Extnetpay netpayForQuery = new Extnetpay();
        netpayForQuery.setNetorderid(netOrderId);
        netpayForQuery.setNetaccoutno(netaccountno);
        Extnetpay netpay = this.findExtnetpay(netpayForQuery);
        if (netpay == null) {
            throw new XLRuntimeException("\u4e0d\u5b58\u5728\u4ea4\u6613\u53f7\uff08TranactionID\uff09\u4e3a" + netOrderId + "\u7684\u5bbd\u5e26\u8bf7\u6c42\u6570\u636e");
        }
        Extnetpayok netpayokForQuery = new Extnetpayok();
        netpayokForQuery.setNetorderid(netOrderId);
        netpayokForQuery.setNetaccoutno(netaccountno);
        Extnetpayok netpayok = IFacade.INSTANCE.findExtnetpayok(netpayokForQuery);
        if (netpayok != null) {
            throw new XLRuntimeException("\u5bbd\u5e26\u652f\u4ed8\u6210\u529f\u8868\u5df2\u7ecf\u5b58\u5728\u4ea4\u6613\u53f7\uff08TranactionID\uff09\u4e3a" + netOrderId + "\u7684\u6570\u636e");
        }
        Extnetpayok newExtnetpayok = new Extnetpayok();
        newExtnetpayok.setBalancedate(DatetimeUtil.today());
        newExtnetpayok.setNetorderid(netOrderId);
        newExtnetpayok.setNetaccoutno(netaccountno);
        newExtnetpayok.setInputtime(netpay.getInputtime());
        newExtnetpayok.setOrderid(netpay.getOrderid());
        newExtnetpayok.setUserip(netpay.getUserip());
        newExtnetpayok.setSuccesstime(DatetimeUtil.now());
        newExtnetpayok.setUsershow(netpay.getUsershow());
        newExtnetpayok.setXunleiid(netpay.getXunleiid());
        newExtnetpayok.setRemark("");
        newExtnetpayok.setCompanytype(netpay.getCompanytype());
        newExtnetpayok.setPayedamt(netpay.getPayedamt());
        newExtnetpayok.setProducttype(netpay.getProducttype());
        newExtnetpayok.setBizorderstatus("N");
        IFacade.INSTANCE.insertExtnetpayok(newExtnetpayok);
        IFacade.INSTANCE.deleteExtnetpayById(netpay.getSeqid());
        return newExtnetpayok;
    }

    @Override
    public int deleteExtnetpayTodate(String todate) {
        log.info((Object)("todate=" + todate));
        return this.extnetpayDao.deleteExtnetpayTodate(todate);
    }
}

