/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.bo;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.bo.BaseBo;
import com.xunlei.payproxy.bo.IExtShengPayBo;
import com.xunlei.payproxy.dao.IExtShengPayDao;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.util.Arith;
import com.xunlei.payproxy.util.MiscUtility;
import com.xunlei.payproxy.util.XLPayProxyRuntimeException;
import com.xunlei.payproxy.vo.Bizorderok;
import com.xunlei.payproxy.vo.ExtShengPay;
import com.xunlei.payproxy.vo.ExtShengPayOK;
import com.xunlei.shengpay.check.ShengPayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtShengPayBoImpl
extends BaseBo
implements IExtShengPayBo {
    private static Logger logger = LoggerFactory.getLogger(ExtShengPayBoImpl.class);
    private IExtShengPayDao extshengpayDao;

    public IExtShengPayDao getExtshengpayDao() {
        return this.extshengpayDao;
    }

    public void setExtshengpayDao(IExtShengPayDao extshengpayDao) {
        this.extshengpayDao = extshengpayDao;
    }

    @Override
    public void deleteExtShengPay(ExtShengPay data) {
        this.getExtshengpayDao().delete(data);
    }

    @Override
    public void deleteExtShengPayByIds(long ... ids) {
        this.getExtshengpayDao().deleteByIds(ids);
    }

    @Override
    public ExtShengPay findExtShengPay(ExtShengPay data) {
        return this.getExtshengpayDao().find(data);
    }

    @Override
    public ExtShengPay findExtShengPayById(long id) {
        return this.getExtshengpayDao().findById(id);
    }

    @Override
    public Sheet<ExtShengPay> queryExtShengPay(ExtShengPay data, PagedFliper fliper) {
        return this.getExtshengpayDao().query(data, fliper);
    }

    @Override
    public void saveExtShengPay(ExtShengPay data) {
        this.getExtshengpayDao().save(data);
    }

    @Override
    public void updateExtShengPay(ExtShengPay data) {
        this.getExtshengpayDao().update(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void moveExtShengPayToSuccess(ExtShengPayOK extshengpayok) {
        String orderId = extshengpayok.getOrderId();
        logger.info("MoveExtShengPayToSuccess start...orderId:{}", (Object)orderId);
        String string = orderId.intern();
        synchronized (string) {
            try {
                try {
                    Bizorderok bizorderok;
                    ExtShengPay query = new ExtShengPay();
                    query.setOrderId(orderId);
                    ExtShengPay extshengpay = this.getExtshengpayDao().find(query);
                    if (extshengpay == null) {
                        logger.info("cannot find extshengpay by orderid:{}", (Object)extshengpayok.getOrderId());
                        throw new XLPayProxyRuntimeException("\u8ba2\u5355\u53f7[" + extshengpayok.getOrderId() + "]\u4e0d\u5b58\u5728");
                    }
                    double sub = Arith.sub(extshengpayok.getOrderAmt(), extshengpay.getOrderAmt());
                    logger.info("\u76db\u4ed8\u901a\u652f\u4ed8\u8fd4\u56de\u7684\u652f\u4ed8\u91d1\u989d={}, \u6570\u636e\u5e93\u4e2d\u8ba2\u5355\u91d1\u989d={},sub={}", new Object[]{extshengpayok.getOrderAmt(), extshengpay.getOrderAmt(), sub});
                    if (Math.abs(sub) >= 0.01) {
                        extshengpayok.setBizOrderStatus("U");
                    }
                    if (extshengpayok.getBizOrderStatus().equals("U") && extshengpay.getExtpayStatus().equals("W")) {
                        logger.info("\u4f20\u5165\u7ed3\u679c\u4e0d\u7b26 :{}", (Object)extshengpayok.getBizOrderStatus());
                        extshengpay.setExtpayStatus(extshengpayok.getBizOrderStatus());
                        IFacade payproxyfacade = IFacade.INSTANCE;
                        payproxyfacade.updateExtShengPay(extshengpay);
                        throw new XLPayProxyRuntimeException("payedamt is not correct");
                    }
                    if (extshengpayok.getBizOrderStatus().equals("Y") && !extshengpay.getExtpayStatus().equals("Y")) {
                        extshengpayok.setXunleiId(extshengpay.getXunleiId());
                        extshengpayok.setUsershow(extshengpay.getUsershow());
                        extshengpayok.setExt1(extshengpay.getExt1());
                        extshengpayok.setExt2(extshengpay.getExt2());
                        extshengpayok.setInputIp(extshengpay.getInputIp());
                        extshengpayok.setInputTime(extshengpay.getInputTime());
                        extshengpayok.setBuyerContact(extshengpay.getBuyerContact());
                        if (this.isEmpty(extshengpayok.getSuccessTime())) {
                            extshengpayok.setSuccessTime(MiscUtility.timeofnow());
                        }
                        if (this.isEmpty(extshengpayok.getBalanceDate())) {
                            extshengpayok.setBalanceDate(MiscUtility.dateofnow());
                        }
                        if (this.isEmpty(extshengpayok.getBankCode())) {
                            extshengpayok.setBankCode(extshengpay.getBankCode());
                        }
                        if (this.isEmpty(extshengpayok.getRemark())) {
                            extshengpayok.setRemark(extshengpay.getRemark());
                        }
                        extshengpayok.setXunleiPayId(extshengpay.getXunleiPayId());
                        extshengpayok.setPaytype(extshengpay.getPayType());
                        extshengpayok.setType(extshengpay.getType());
                        double rate = 0.0;
                        if ("E1".equals(extshengpay.getPayType())) {
                            rate = ShengPayUtil.E1_FARE;
                        } else if ("B5".equals(extshengpay.getPayType())) {
                            rate = ShengPayUtil.B5_FARE;
                        } else if ("S3".equals(extshengpay.getPayType())) {
                            rate = ShengPayUtil.S3_FARE;
                        }
                        extshengpayok.setFareAmt(this.calShengFareamt(extshengpayok.getOrderAmt(), rate));
                        extshengpayok.setFactAmt(Arith.sub(extshengpayok.getOrderAmt(), extshengpayok.getFareAmt()));
                        IFacade payproxyfacade = IFacade.INSTANCE;
                        payproxyfacade.moveBizorderToSuccess(extshengpayok.getOrderId());
                        logger.info("saveExtShengPayOK...xunleipayid:{}", (Object)extshengpayok.getOrderId());
                        payproxyfacade.saveExtShengPayOK(extshengpayok);
                        logger.debug("delete extshengpay by seqid:{}", (Object)extshengpay.getSeqid());
                        payproxyfacade.deleteExtShengPayByIds(extshengpay.getSeqid());
                        Bizorderok bizorderokForQuery = new Bizorderok();
                        bizorderokForQuery.setXunleipayid(extshengpay.getXunleiPayId());
                        bizorderok = IFacade.INSTANCE.findBizorderok(bizorderokForQuery);
                        if (bizorderok != null) {
                            bizorderok.setFareamt(extshengpayok.getFareAmt());
                        } else {
                            logger.warn("cannot find bizorderok by xunleipayid:{},it should be saved in moveBizorderToSuccess method", (Object)extshengpay.getXunleiPayId());
                        }
                    } else {
                        if (extshengpayok.getBizOrderStatus().equals("U") && !extshengpay.getExtpayStatus().equals("W")) {
                            logger.info("\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26\u65f6\u56de\u5199fail...extshengpayok.xunleipayid:{}", (Object)extshengpayok.getXunleiPayId());
                            throw new XLPayProxyRuntimeException("payedamt is not correct");
                        }
                        logger.info("nothing to do in this status...extshengpayok.status:{},extshengpay.status:{}", (Object)extshengpayok.getBizOrderStatus(), (Object)extshengpay.getExtpayStatus());
                        throw new XLPayProxyRuntimeException("\u4e0d\u7528\u6267\u884c");
                    }
                    IFacade.INSTANCE.updateBizorderok(bizorderok);
                    Object var14_13 = null;
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new XLPayProxyRuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                logger.info("MoveExtShengPayToSuccess end");
                throw throwable;
            }
            logger.info("MoveExtShengPayToSuccess end");
            return;
        }
    }

    public double calShengFareamt(double orderAmt, double rate) {
        double i = Arith.mul(orderAmt, rate);
        double r = Arith.round(i, 2);
        return r;
    }

    @Override
    public ExtShengPay queryExtshengpaySum(ExtShengPay data, PagedFliper fliper) {
        return this.extshengpayDao.queryExtshengpaySum(data, fliper);
    }
}

