/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.bo;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.bo.IExtBaiduWalletBo;
import com.xunlei.payproxy.dao.IExtBaiduWalletDao;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.util.Arith;
import com.xunlei.payproxy.util.MiscUtility;
import com.xunlei.payproxy.util.XLPayProxyRuntimeException;
import com.xunlei.payproxy.vo.Bizorderok;
import com.xunlei.payproxy.vo.ExtBaiduWallet;
import com.xunlei.payproxy.vo.ExtBaiduWalletOk;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtBaiduWalletBoImpl
implements IExtBaiduWalletBo {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IExtBaiduWalletDao extBaiduWalletDao;

    public void setExtBaiduWalletDao(IExtBaiduWalletDao extBaiduWalletDao) {
        this.extBaiduWalletDao = extBaiduWalletDao;
    }

    @Override
    public ExtBaiduWallet findExtBaiduWallet(ExtBaiduWallet data) {
        this.logger.debug("findExtBaiduWallet...");
        return this.extBaiduWalletDao.findExtBaiduWallet(data);
    }

    @Override
    public ExtBaiduWallet findExtBaiduWalletById(long id) {
        return this.extBaiduWalletDao.findExtBaiduWalletById(id);
    }

    @Override
    public Sheet<ExtBaiduWallet> queryExtBaiduWallet(ExtBaiduWallet data, PagedFliper fliper) {
        return this.extBaiduWalletDao.queryExtBaiduWallet(data, fliper);
    }

    @Override
    public void updateExtBaiduWallet(ExtBaiduWallet data) {
        this.extBaiduWalletDao.update(data);
    }

    @Override
    public void deleteExtBaiduWalletByIds(long ... ids) {
        this.extBaiduWalletDao.deleteExtBaiduWalletByIds(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveExtBaiduWalletToSuccess(ExtBaiduWalletOk baiduWalletOk) {
        String orderId = baiduWalletOk.getOrderId();
        this.logger.info("moveExtBaiduWalletToSuccess start...orderId:{}", (Object)orderId);
        String string = orderId.intern();
        synchronized (string) {
            block19: {
                try {
                    ExtBaiduWallet query = new ExtBaiduWallet();
                    query.setOrderId(orderId);
                    ExtBaiduWallet extBaiduWallet = this.extBaiduWalletDao.findExtBaiduWallet(query);
                    if (extBaiduWallet != null) {
                        double sub = Arith.sub(baiduWalletOk.getOrderAmt(), extBaiduWallet.getOrderAmt());
                        this.logger.info("baidu-wallet...account receivable:{},real_income:{},sub={}", new Object[]{extBaiduWallet.getOrderAmt(), baiduWalletOk.getOrderAmt(), sub});
                        if (Math.abs(sub) >= 0.01) {
                            this.logger.info("baidu-wallet...money mismatch...orderId:{}", (Object)orderId);
                            baiduWalletOk.setBizOrderStatus("U");
                        }
                        if (baiduWalletOk.getBizOrderStatus().equals("U") && extBaiduWallet.getExtPayStatus().equals("W")) {
                            this.logger.info("mismatch status:{}", (Object)baiduWalletOk.getBizOrderStatus());
                            extBaiduWallet.setExtPayStatus(baiduWalletOk.getBizOrderStatus());
                            IFacade payproxyfacade = IFacade.INSTANCE;
                            payproxyfacade.updateExtBaiduWallet(extBaiduWallet);
                            throw new XLPayProxyRuntimeException("payedamt is not correct");
                        }
                        if (baiduWalletOk.getBizOrderStatus().equals("Y") && !extBaiduWallet.getExtPayStatus().equals("Y")) {
                            baiduWalletOk.setXunleiId(extBaiduWallet.getXunleiId());
                            baiduWalletOk.setUserShow(extBaiduWallet.getUserShow());
                            baiduWalletOk.setExt1(extBaiduWallet.getExt1());
                            baiduWalletOk.setExt2(extBaiduWallet.getExt2());
                            baiduWalletOk.setInputTime(extBaiduWallet.getInputTime());
                            if (StringUtils.isEmpty((String)baiduWalletOk.getSuccessTime())) {
                                baiduWalletOk.setSuccessTime(MiscUtility.timeofnow());
                            }
                            if (StringUtils.isEmpty((String)baiduWalletOk.getBalanceDate())) {
                                baiduWalletOk.setBalanceDate(MiscUtility.dateofnow());
                            }
                            if (StringUtils.isEmpty((String)baiduWalletOk.getBankCode())) {
                                baiduWalletOk.setBankCode(extBaiduWallet.getBankCode());
                            }
                            if (StringUtils.isEmpty((String)baiduWalletOk.getRemark())) {
                                baiduWalletOk.setRemark(extBaiduWallet.getRemark());
                            }
                            baiduWalletOk.setPaytype(extBaiduWallet.getPayType());
                            baiduWalletOk.setBizOrderStatus("Y");
                            IFacade payproxyfacade = IFacade.INSTANCE;
                            payproxyfacade.moveBizorderToSuccess(baiduWalletOk.getOrderId());
                            this.logger.info("save ExtBaiduWalletOk...orderId:{}", (Object)baiduWalletOk.getOrderId());
                            payproxyfacade.saveExtBaiduWalletOk(baiduWalletOk);
                            this.logger.debug("delete extBaiduWallet by seqid:{}", (Object)extBaiduWallet.getSeqid());
                            payproxyfacade.deleteExtBaiduWalletByIds(extBaiduWallet.getSeqid());
                            Bizorderok bizorderokForQuery = new Bizorderok();
                            bizorderokForQuery.setXunleipayid(extBaiduWallet.getOrderId());
                            Bizorderok bizorderok = IFacade.INSTANCE.findBizorderok(bizorderokForQuery);
                            if (bizorderok != null) {
                                bizorderok.setFareamt(baiduWalletOk.getFareAmt());
                            } else {
                                this.logger.warn("cannot find bizorderok by xunleipayid:{},it should be saved in moveBizorderToSuccess method", (Object)extBaiduWallet.getOrderId());
                            }
                            IFacade.INSTANCE.updateBizorderok(bizorderok);
                            break block19;
                        }
                        if (baiduWalletOk.getBizOrderStatus().equals("U") && !extBaiduWallet.getExtPayStatus().equals("W")) {
                            this.logger.info("account mismatch...orderId:{}", (Object)baiduWalletOk.getOrderId());
                            throw new XLPayProxyRuntimeException("payedamt is not correct");
                        }
                        this.logger.info("nothing to do in this status...baiduWalletok.status:{},baiduwallet.status:{}", (Object)baiduWalletOk.getBizOrderStatus(), (Object)extBaiduWallet.getExtPayStatus());
                        throw new XLPayProxyRuntimeException("\u4e0d\u7528\u6267\u884c");
                    }
                    this.logger.info("cannot find extBaiduWallet by orderid:{}", (Object)baiduWalletOk.getOrderId());
                    throw new XLPayProxyRuntimeException("\u8ba2\u5355\u53f7[" + baiduWalletOk.getOrderId() + "]\u4e0d\u5b58\u5728");
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    throw new XLPayProxyRuntimeException(e);
                }
                finally {
                    this.logger.info("moveExtBaiduWalletToSuccess end");
                }
            }
        }
    }

    @Override
    public ExtBaiduWallet queryExtBaiduWalletSum(ExtBaiduWallet data) {
        return this.extBaiduWalletDao.queryExtBaiduWalletSum(data);
    }

    @Override
    public void saveExtBaiduWallet(ExtBaiduWallet extBaiduWallet) {
        this.extBaiduWalletDao.save(extBaiduWallet);
    }
}

