/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.bo;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.payproxy.bo.BaseBo;
import com.xunlei.payproxy.bo.IBizorderBo;
import com.xunlei.payproxy.dao.IBizorderDao;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.util.VOCopier;
import com.xunlei.payproxy.util.XLAlreadyMoveException;
import com.xunlei.payproxy.vo.Bizorder;
import com.xunlei.payproxy.vo.Bizorderok;
import com.xunlei.payproxy.vo.Extalipay;
import java.text.ParseException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BizorderBoImpl
extends BaseBo
implements IBizorderBo {
    private static final Log logger = LogFactory.getLog(BizorderBoImpl.class);
    private IBizorderDao bizorderDao;

    @Override
    public void deleteBizorderById(long ... seqids) {
        this.getBizorderDao().deleteBizorderById(seqids);
    }

    @Override
    public void deleteBizorder(Bizorder data) {
        this.getBizorderDao().deleteBizorder(data);
    }

    @Override
    public Bizorder findBizorder(Bizorder data) {
        return this.getBizorderDao().findBizorder(data);
    }

    @Override
    public void insertBizorder(Bizorder data) {
        this.getBizorderDao().insertBizorder(data);
    }

    @Override
    public Bizorder getBizorderById(long seqid) {
        return this.getBizorderDao().getBizorderById(seqid);
    }

    @Override
    public Sheet<Bizorder> queryBizorder(Bizorder data, PagedFliper fliper) {
        return this.getBizorderDao().queryBizorder(data, fliper);
    }

    @Override
    public void updateBizorder(Bizorder data) {
        this.getBizorderDao().updateBizorder(data);
    }

    public IBizorderDao getBizorderDao() {
        return this.bizorderDao;
    }

    public void setBizorderDao(IBizorderDao bizorderDao) {
        this.bizorderDao = bizorderDao;
    }

    @Override
    public void moveBizorderToSuccess(String xunleipayid) {
        this.moveBizorderToSuccess(xunleipayid, null);
    }

    @Override
    public void moveBizorderToSuccess(String xunleipayid, String balanceDate) {
        logger.debug((Object)("\u8981\u79fb\u52a8\u8bb0\u5f55\u7684xunleipayid\uff1a" + xunleipayid));
        Bizorderok bizorderokForQuery = new Bizorderok();
        bizorderokForQuery.setXunleipayid(xunleipayid);
        Bizorderok bizorderok = IFacade.INSTANCE.findBizorderok(bizorderokForQuery);
        if (bizorderok != null) {
            throw new XLAlreadyMoveException("\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e3a" + xunleipayid + "\u7684\u4e1a\u52a1\u8ba2\u5355\u8bb0\u5f55\u5df2\u7ecf\u5b58\u5728\u6210\u529f\u8868");
        }
        Bizorder bizorderForQuery = new Bizorder();
        bizorderForQuery.setXunleipayid(xunleipayid);
        Bizorder bizorder = this.bizorderDao.findBizorder(bizorderForQuery);
        if (bizorder == null) {
            throw new XLRuntimeException("\u4e0d\u5b58\u5728\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e3a" + xunleipayid + "\u7684\u4e1a\u52a1\u8ba2\u5355\u8bb0\u5f55");
        }
        bizorderok = new Bizorderok();
        VOCopier.copy(bizorder, bizorderok);
        bizorderok.setSuccesstime(DatetimeUtil.now());
        bizorderok.setBalancedate(StringTools.isEmpty((String)balanceDate) ? DatetimeUtil.today() : balanceDate);
        bizorderok.setSendnoticestatus("N");
        if ("B".equals(bizorderok.getType())) {
            bizorderok.setSendnoticestatus("Y");
        }
        if ("A".equals(bizorder.getPaytype())) {
            bizorderok.setThunderstatus("A");
        } else if ("B".equals(bizorder.getPaytype()) || "C".equals(bizorder.getPaytype()) || "E".equals(bizorder.getPaytype())) {
            bizorderok.setThunderstatus("B");
        } else {
            bizorderok.setThunderstatus("E");
        }
        logger.debug((Object)"\u5c06\u8bb0\u5f55\u63d2\u5165\u6210\u529f\u8868");
        IFacade.INSTANCE.insertBizorderok(bizorderok);
        logger.debug((Object)("\u5220\u9664xunleipaydi\u4e3a:" + xunleipayid + ",seqid\u4e3a\uff1a" + bizorder.getSeqid() + "\u7684\u8bb0\u5f55"));
        this.getBizorderDao().deleteBizorderById(bizorder.getSeqid());
        logger.debug((Object)"\u79fb\u52a8\u8ba2\u5355\u8868\u5230\u6210\u529f\u8868\u5b8c\u6210");
    }

    @Override
    public int deleteBizorderTodate(String todate) {
        return this.bizorderDao.deleteBizorderTodate(todate);
    }

    @Override
    public void addBizorderAndExtalipay(Bizorder bizorder, Extalipay extalipay) {
        if (bizorder == null || extalipay == null) {
            return;
        }
        IFacade.INSTANCE.insertBizorder(bizorder);
        IFacade.INSTANCE.insertExtalipay(extalipay);
    }

    @Override
    public void moveBizorderAndExtalipay2Success(Bizorder bizorder, Extalipay extalipay, String bankseqno, String buyerId, String buyerEmail, String successTime, double factAmt, double fareAmt, String balanceDate, String bizOrderStatus) {
        IFacade facade = IFacade.INSTANCE;
        facade.moveBizorderToSuccess(bizorder.getXunleipayid());
        facade.moveExtalipayToSuccess(extalipay, bankseqno, buyerId, buyerEmail, successTime, factAmt, fareAmt, balanceDate, bizOrderStatus);
    }

    @Override
    public List<Bizorder> queryRefundBizorderSendNotice() {
        return this.bizorderDao.queryRefundBizorderSendNotice();
    }

    @Override
    public void moveBizorderToFail(Bizorder data) {
        this.bizorderDao.moveBizorderToFail(data);
    }

    @Override
    public List<Bizorder> queryBizorderSendnoticeYButNoInPaynotice(String startTime, String endTime) {
        return this.bizorderDao.queryBizorderSendnoticeYButNoInPaynotice(startTime, endTime);
    }

    @Override
    public Sheet<Bizorder> queryBizorderGreaterThanSeqid(Bizorder data, PagedFliper fliper) {
        return this.bizorderDao.queryBizorderGreaterThanSeqid(data, fliper);
    }

    @Override
    public void moveBizorderToHis(String time) {
        this.bizorderDao.moveBizorderToHis(time);
    }

    @Override
    public void moveBizorderToTQ(String time) throws ParseException {
        this.bizorderDao.moveBizorderToTQ(time);
    }

    @Override
    public Sheet<Bizorder> queryBizorderhis(Bizorder data, PagedFliper fliper, List<String> tables) {
        return this.bizorderDao.queryBizorderhis(data, fliper, tables);
    }
}

