/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.bo;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.bo.AutoPayDailyStatisticsBo;
import com.xunlei.payproxy.dao.AutoPayDailyStatisticsDao;
import com.xunlei.payproxy.dao.IBizorderokDao;
import com.xunlei.payproxy.vo.AutoPayDailyStatistics;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoPayDailyStatisticsBoImpl
implements AutoPayDailyStatisticsBo {
    private AutoPayDailyStatisticsDao autoPayDailyStatisticsDao;
    private IBizorderokDao bizorderokDao;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final Log logger = LogFactory.getLog(AutoPayDailyStatisticsBoImpl.class);

    @Override
    public Sheet<AutoPayDailyStatistics> getAutoPayDailyStatistics(AutoPayDailyStatistics apds, PagedFliper fliper) {
        if (apds == null) {
            return null;
        }
        return this.autoPayDailyStatisticsDao.getAutoPayDailyStatistics(apds, fliper);
    }

    @Override
    public void addStatisticsAutoPayYesterday(String bizNo, String payType, String productType) {
        Date now = new Date();
        long nowlong = now.getTime();
        long yesterday = nowlong - 86400000L;
        String yesString = sdf.format(new Date(yesterday));
        if (StringTools.isEmpty((String)bizNo)) {
            throw new RuntimeException("bizNo\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty((String)payType)) {
            throw new RuntimeException("payType\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty((String)productType)) {
            throw new RuntimeException("productType\u4e3a\u7a7a");
        }
        logger.info((Object)("bizNo{" + bizNo + "},payType{" + payType + "},productType{" + productType + "},time{" + yesString + "}"));
        Map<String, Integer> map = this.bizorderokDao.queryBizorderoksUserNum(bizNo, payType, yesString, yesString);
        if (map == null) {
            logger.info((Object)"\u67e5\u8be2\u7ed3\u679cmap\u4e3anull");
            throw new RuntimeException("\u67e5\u8be2\u7ed3\u679cmap\u4e3anull");
        }
        Integer successPayNum = map.get("successPayNum");
        Integer payNum = map.get("payNum");
        logger.info((Object)("successPayNum:" + successPayNum + ";payNum:" + payNum));
        AutoPayDailyStatistics apds = new AutoPayDailyStatistics();
        apds.setFailPayUserNum(payNum - successPayNum);
        apds.setPayType(payType);
        apds.setProductType(productType);
        apds.setStatisticsDate(yesString);
        apds.setSuccessPayUserNum(successPayNum);
        this.autoPayDailyStatisticsDao.insert(apds);
    }

    public AutoPayDailyStatisticsDao getAutoPayDailyStatisticsDao() {
        return this.autoPayDailyStatisticsDao;
    }

    public void setAutoPayDailyStatisticsDao(AutoPayDailyStatisticsDao autoPayDailyStatisticsDao) {
        this.autoPayDailyStatisticsDao = autoPayDailyStatisticsDao;
    }

    public IBizorderokDao getBizorderokDao() {
        return this.bizorderokDao;
    }

    public void setBizorderokDao(IBizorderokDao bizorderokDao) {
        this.bizorderokDao = bizorderokDao;
    }
}

