/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.bo;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.payproxy.bo.AutoPayBo;
import com.xunlei.payproxy.bo.BaseBo;
import com.xunlei.payproxy.dao.AutoPayCancleDao;
import com.xunlei.payproxy.dao.AutoPayDao;
import com.xunlei.payproxy.vo.AutoPay;
import com.xunlei.payproxy.vo.AutoPayCancle;
import com.xunlei.payproxy.vo.AutoPayCondition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoPayBoImpl
extends BaseBo
implements AutoPayBo {
    private static final Log logger = LogFactory.getLog(AutoPayBoImpl.class);
    private AutoPayDao autoPayDao;
    private AutoPayCancleDao autoPayCancleDao;

    @Override
    public AutoPay getAutoPay(long seqid) {
        return this.autoPayDao.getAutoPay(seqid);
    }

    @Override
    public void insertAutoPay(AutoPay autoPay) {
        this.autoPayDao.insertAutoPay(autoPay);
    }

    @Override
    public List<AutoPay> getAutoPay(AutoPayCondition autoPay) {
        if (autoPay == null) {
            return new ArrayList<AutoPay>();
        }
        return this.autoPayDao.getAutoPay(autoPay);
    }

    @Override
    public List<AutoPay> getAutoPay(AutoPayCondition autoPay, int start, int limit) {
        if (autoPay == null) {
            return new ArrayList<AutoPay>();
        }
        return this.autoPayDao.getAutoPay(autoPay, start, limit);
    }

    @Override
    public Sheet<AutoPay> getAutoPay(AutoPayCondition autoPay, PagedFliper fliper) {
        if (autoPay == null) {
            return null;
        }
        return this.autoPayDao.getAutoPay(autoPay, fliper);
    }

    @Override
    public void moveAutoPayToCancle(long seqId, String cancleFrom) {
        logger.info((Object)("\u5f00\u59cb\u79fb\u52a8\u53d6\u6d88\u7684\u652f\u4ed8\u5173\u7cfb\uff0cseqId:" + seqId + ";cancleFrom:" + cancleFrom));
        AutoPay autoPay = this.autoPayDao.getAutoPay(seqId);
        if (autoPay == null) {
            logger.error((Object)("\u4e0d\u5b58\u5728id\u4e3a" + seqId + "\u7684\u81ea\u52a8\u7eed\u8d39\u5173\u7cfb"));
            throw new XLRuntimeException("\u4e0d\u5b58\u5728id\u4e3a" + seqId + "\u7684\u81ea\u52a8\u7eed\u8d39\u5173\u7cfb");
        }
        if (this.isEmpty(cancleFrom)) {
            logger.error((Object)"\u81ea\u52a8\u7eed\u8d39\u53d6\u6d88\u539f\u56e0\u4e3a\u7a7a");
            throw new XLRuntimeException("\u81ea\u52a8\u7eed\u8d39\u53d6\u6d88\u539f\u56e0\u4e3a\u7a7a");
        }
        this.autoPayDao.deleteAutoPay(seqId);
        AutoPayCancle autoPayCancle = new AutoPayCancle();
        autoPayCancle.setPayType(autoPay.getPayType());
        autoPayCancle.setProductType(autoPay.getProductType());
        autoPayCancle.setPaycardno(autoPay.getPaycardno());
        autoPayCancle.setExpiredate(autoPay.getExpiredate());
        autoPayCancle.setOrderAmt(autoPay.getOrderAmt());
        autoPayCancle.setXunleiId(autoPay.getXunleiId());
        autoPayCancle.setUserShow(autoPay.getUserShow());
        autoPayCancle.setExt1(autoPay.getExt1());
        autoPayCancle.setExt2(autoPay.getExt2());
        autoPayCancle.setGenerateTime(autoPay.getGenerateTime());
        autoPayCancle.setAutopayTime(autoPay.getAutopayTime());
        autoPayCancle.setExtcardpayStatus(autoPay.getExtcardpayStatus());
        autoPayCancle.setFailTimes(autoPay.getFailTimes());
        autoPayCancle.setRemark(autoPay.getRemark());
        autoPayCancle.setFlag(autoPay.getFlag());
        autoPayCancle.setCancleFrom(cancleFrom);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now = sf.format(new Date());
        autoPayCancle.setCancleTime(now);
        this.autoPayCancleDao.insertAutoPayCancle(autoPayCancle);
        logger.info((Object)"\u6210\u529f\u79fb\u52a8\u5230\u53d6\u6d88\u8868\u4e2d");
    }

    @Override
    public Sheet<AutoPayCancle> getAutoPayCancle(AutoPayCancle autoPayCancle, PagedFliper fliper) {
        return this.autoPayCancleDao.getAutoPayCancle(autoPayCancle, fliper);
    }

    @Override
    public void updateAutoay(AutoPay autoPay) {
        this.autoPayDao.updateAutoPay(autoPay);
    }

    public AutoPayDao getAutoPayDao() {
        return this.autoPayDao;
    }

    public void setAutoPayDao(AutoPayDao autoPayDao) {
        this.autoPayDao = autoPayDao;
    }

    public AutoPayCancleDao getAutoPayCancleDao() {
        return this.autoPayCancleDao;
    }

    public void setAutoPayCancleDao(AutoPayCancleDao autoPayCancleDao) {
        this.autoPayCancleDao = autoPayCancleDao;
    }
}

