/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.ccbdudect.query;

import com.xunlei.ccbdudect.util.CCBDudectPayQueryData;
import com.xunlei.ccbdudect.util.CCBDudectPayUtil;
import com.xunlei.ccbdudect.util.PayQueryRespDetails;
import com.xunlei.payproxy.util.Arith;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorCCBDudectHandler {
    private static Logger log = LoggerFactory.getLogger(MonitorCCBDudectHandler.class);

    public HashMap<String, String> query(String orderId, String orderAmt, String orderStatus, String orderDate) {
        String orderIdResp;
        log.info("MonitorCCBDudectHandler start monitor:orderId:{},orderAmt:{},orderStatus:{},orderDate:{}", new Object[]{orderId, orderAmt, orderStatus, orderDate});
        if ("U".equals(orderStatus)) {
            log.info("orderId:{} \u9519\u8bef\u8ba2\u5355,\u8ba2\u5355\u72b6\u6001\u4e3a\u53ef\u7591", new Object[]{orderId});
            return this.getRtnMap("N", "N", "-5", "\u8ba2\u5355\u72b6\u6001\u4e3a\u53ef\u7591");
        }
        String kind = "0";
        String status = "3";
        if (!new SimpleDateFormat("yyyy-MM-dd").format(new Date()).equals(orderDate)) {
            kind = "1";
        }
        if (!kind.equals("0")) {
            status = "Y".equals(orderStatus) ? "1" : "0";
        }
        Socket socket = null;
        String resp = null;
        String requestSn = CCBDudectPayUtil.genRequstSn();
        try {
            try {
                socket = new Socket(CCBDudectPayUtil.ip, CCBDudectPayUtil.port);
                socket.setSoTimeout(CCBDudectPayUtil.socketTimeOut);
                DataOutputStream outToServer = new DataOutputStream(socket.getOutputStream());
                CCBDudectPayQueryData data = new CCBDudectPayQueryData();
                data.setRequestSn(requestSn);
                data.setOrder(orderId);
                data.setKind(kind);
                data.setStatus(status);
                String request = CCBDudectPayUtil.createPayQueryRequstXml(data);
                request = new String(request.getBytes(), "GB18030");
                log.info("orderId:{} query request:{}", new Object[]{orderId, request});
                outToServer.writeBytes(request);
                DataInputStream inputStream = new DataInputStream(socket.getInputStream());
                StringBuffer sb = new StringBuffer();
                do {
                    sb.append((char)inputStream.read());
                } while (!sb.toString().contains("</TX>"));
                resp = new String(sb.toString().getBytes("8859_1"), "gbk");
                log.info("orderId:{} query resp:{}", new Object[]{orderId, resp});
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                HashMap<String, String> hashMap = this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e2) {
                        log.error("", (Throwable)e2);
                    }
                }
                return hashMap;
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        log.info("orderId:{} with query result:{}", new Object[]{orderId, resp});
        if ("".equals(resp)) {
            log.info("orderId:{} \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6", (Object)orderId);
            return this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
        }
        PayQueryRespDetails respDetails = CCBDudectPayUtil.createPayQueryRespVoFromXml(resp);
        if (respDetails == null) {
            log.info("orderId:{} \u65e0\u6cd5\u4ece\u8fd4\u56de\u503c\u4e2d\u83b7\u53d6\u53c2\u6570\u4fe1\u606f", (Object)orderId);
            return this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
        }
        String requestSnResp = respDetails.getRequestSn();
        if (CCBDudectPayUtil.isEmptyStr(requestSn) || !requestSnResp.equals(requestSn)) {
            log.info("orderId:{} \u8fd4\u56de\u4fe1\u606f\u4e2d\u7684\u8ba2\u5355\u975e\u67e5\u8be2\u8ba2\u5355", (Object)orderId);
            return this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
        }
        if (CCBDudectPayUtil.isEmptyStr(respDetails.getReturnCode())) {
            log.info("orderId:{} \u8fd4\u56de\u4fe1\u606f\u4e2d\u7684\u8fd4\u56de\u7801\u4e3a\u7a7a", (Object)orderId);
            return this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
        }
        if (CCBDudectPayUtil.timeoutRespCode != null && CCBDudectPayUtil.timeoutRespCode.contains(respDetails.getReturnCode())) {
            log.info("orderId:{} \u8fd4\u56de\u4fe1\u606f\u4e2d\u7684\u8fd4\u56de\u7801\u4e3a\u67e5\u8be2\u5f02\u5e38\u7684\u8fd4\u56de\u7801", (Object)orderId);
            return this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
        }
        if (!"000000".equals(respDetails.getReturnCode())) {
            log.info("orderId:{} \u67e5\u8be2\u5931\u8d25,\u9519\u8bef\u7801\u4e3a\uff1a{},\u9519\u8bef\u4fe1\u606f\u4e3a:{}", new Object[]{orderId, respDetails.getReturnCode(), respDetails.getReturnMsg()});
            return this.getRtnMap("N", "N", "", "\u67e5\u8be2\u5931\u8d25\uff0c\u9519\u8bef\u7801\u4e3a\uff1a" + respDetails.getReturnCode() + ",\u9519\u8bef\u4fe1\u606f\u4e3a:" + respDetails.getReturnMsg());
        }
        String orderStatusResp = respDetails.getOrderStatus();
        if ("0".equals(orderStatusResp) || "3".equals(orderStatusResp) || "4".equals(orderStatusResp)) {
            orderIdResp = respDetails.getOrder();
            if (CCBDudectPayUtil.isEmptyStr(orderIdResp) || !orderIdResp.equals(orderId)) {
                log.info("orderId:{} \u8fd4\u56de\u4fe1\u606f\u4e2d\u7684\u8ba2\u5355\u975e\u67e5\u8be2\u8ba2\u5355", (Object)orderId);
                return this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
            }
            if ("0".equals(orderStatusResp)) {
                log.info("orderId:{} \u9519\u8bef\u8ba2\u5355,\u8fd4\u56de\u4fe1\u606f\u4e3a:\u8ba2\u5355\u652f\u4ed8\u5931\u8d25", new Object[]{orderId});
                return this.getRtnMap("N", "N", "", "\u8ba2\u5355\u652f\u4ed8\u5931\u8d25");
            }
            if ("3".equals(orderStatusResp)) {
                log.info("orderId:{} \u9519\u8bef\u8ba2\u5355,\u8fd4\u56de\u4fe1\u606f\u4e3a:\u8ba2\u5355\u5df2\u90e8\u5206\u9000\u6b3e", new Object[]{orderId});
                return this.getRtnMap("N", "N", "", "\u8ba2\u5355\u5df2\u90e8\u5206\u9000\u6b3e");
            }
            log.info("orderId:{} \u9519\u8bef\u8ba2\u5355,\u8fd4\u56de\u4fe1\u606f\u4e3a:\u8ba2\u5355\u5df2\u5168\u90e8\u9000\u6b3e", new Object[]{orderId});
            return this.getRtnMap("N", "N", "", "\u8ba2\u5355\u5df2\u5168\u90e8\u9000\u6b3e");
        }
        if ("1".equals(orderStatusResp)) {
            orderIdResp = respDetails.getOrder();
            if (CCBDudectPayUtil.isEmptyStr(orderIdResp) || !orderIdResp.equals(orderId)) {
                log.info("orderId:{} \u8fd4\u56de\u4fe1\u606f\u4e2d\u7684\u8ba2\u5355\u975e\u67e5\u8be2\u8ba2\u5355", (Object)orderId);
                return this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
            }
            String orderAmtResp = respDetails.getPaymentMoney();
            if (CCBDudectPayUtil.isEmptyStr(orderAmtResp)) {
                log.info("orderId:{} \u9519\u8bef\u8ba2\u5355,\u8fd4\u56de\u4fe1\u606f\u4e3a:\u8ba2\u5355\u91d1\u989d\u4e3a\u7a7a", new Object[]{orderId});
                return this.getRtnMap("N", "N", "", "\u8ba2\u5355\u91d1\u989d,\u67e5\u8be2\u8fd4\u56de\u91d1\u989d\u4e3a\u7a7a");
            }
            try {
                if (!(Math.abs(Arith.sub((double)Double.valueOf(orderAmtResp), (double)Double.valueOf(orderAmt))) <= 0.01)) {
                    log.info("orderId:{} \u9519\u8bef\u8ba2\u5355,\u8fd4\u56de\u4fe1\u606f\u4e3a:\u8ba2\u5355\u91d1\u989d\u4e0d\u4e00\u81f4", new Object[]{orderId});
                    return this.getRtnMap("N", "N", "", "\u8ba2\u5355\u91d1\u989d\u4e0d\u4e00\u81f4,\u67e5\u8be2\u8fd4\u56de\u4e3a\uff1a\u91d1\u989d\u4e3a" + orderAmtResp + ",\u8bb0\u5f55\u8868\u91d1\u989d\u4e3a" + orderAmt);
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                log.info("orderId:{} \u9519\u8bef\u8ba2\u5355,\u8fd4\u56de\u4fe1\u606f\u4e3a:\u8ba2\u5355\u91d1\u989d\u4e0d\u4e00\u81f4", new Object[]{orderId});
                return this.getRtnMap("N", "N", "", "\u8ba2\u5355\u91d1\u989d\u4e0d\u4e00\u81f4,\u67e5\u8be2\u8fd4\u56de\u4e3a\uff1a\u91d1\u989d\u4e3a" + orderAmtResp + ",\u8bb0\u5f55\u8868\u91d1\u989d\u4e3a" + orderAmt);
            }
            log.info("orderId:{} \u6b63\u786e\u8ba2\u5355,\u8fd4\u56de\u91d1\u989d\uff1a{}", new Object[]{orderId, respDetails.getPaymentMoney()});
            HashMap<String, String> rtnMap = this.getRtnMap("N", "Y", String.valueOf(respDetails.getPaymentMoney()), "");
            return rtnMap;
        }
        if ("2".equals(orderStatusResp) || "5".equals(orderStatusResp)) {
            log.info("orderId:{} \u67e5\u8be2\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a\u5f85\u94f6\u884c\u786e\u5b9a\u652f\u4ed8\u72b6\u6001", new Object[]{orderId});
            return this.getRtnMap("Y", "", "", "\u67e5\u8be2\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a\u5f85\u94f6\u884c\u786e\u5b9a\u652f\u4ed8\u72b6\u6001");
        }
        log.info("orderId:{} \u67e5\u8be2\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a\u8fd4\u56de\u72b6\u6001\u7801:{}\u4e0d\u7b26", new Object[]{orderId, orderStatusResp});
        return this.getRtnMap("Y", "", "", "\u67e5\u8be2\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a\u8fd4\u56de\u72b6\u6001\u7801\u4e0d\u7b26,\u72b6\u6001\u7801\u4e3a\uff1a" + orderStatusResp);
    }

    private HashMap<String, String> getRtnMap(String timeOut, String checkSuccess, String amount, String msg) {
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        rtnMap.put("timeOut", timeOut);
        rtnMap.put("checkSuccess", checkSuccess);
        rtnMap.put("amount", amount);
        rtnMap.put("msg", msg);
        return rtnMap;
    }

    public static void main(String[] args) {
        System.out.println(new MonitorCCBDudectHandler().query("13030121202603650200", "0.02", "W", "2013-03-04"));
    }
}

