/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.directpay.query;

import com.xunlei.common.util.Arith;
import com.xunlei.common.util.StringTools;
import com.xunlei.directpay.util.CCBUtil;
import com.xunlei.directpay.util.HttpsSend;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CCBQuery {
    private static final Logger logger = Logger.getLogger(CCBQuery.class);

    public static Map<String, String> defaultQuerySingleByOrderid(String orderid, double orderamt) {
        logger.info((Object)("CCBQuery-----defaultQuerySingleByOrderid-----start at time : " + new Date()));
        if (StringTools.isEmpty((String)orderid)) {
            return CCBQuery.getResultMap("N", "N", "", "\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        }
        Map<String, String> urlMap = CCBUtil.createQueryUrlByOrderid(orderid);
        Map<String, String> resultMap = CCBQuery.getResultMapByOrderid(urlMap, orderid, orderamt);
        logger.info((Object)("orderid[" + orderid + "]\uff0c\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2\u67e5\u8be2\u7ed3\u679c\u4e3a\uff1a" + resultMap));
        return resultMap;
    }

    public static Map<String, String> querySingleByOrderid(String orderid, double orderamt, String kind, String status) {
        logger.info((Object)("CCBQuery-----defaultQuerySingleByOrderid-----start at time : " + new Date()));
        if (StringTools.isEmpty((String)orderid)) {
            return CCBQuery.getResultMap("N", "N", "", "\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        }
        Map<String, String> urlMap = CCBUtil.createQueryUrlByOrderid(orderid, kind, "3", status);
        Map<String, String> resultMap = CCBQuery.getResultMapByOrderid(urlMap, orderid, orderamt);
        logger.info((Object)("orderid[" + orderid + "]\uff0c\u67e5\u8be2\u7ed3\u679c\u4e3a\uff1a" + resultMap));
        logger.info((Object)("CCBQuery-----defaultQuerySingleByOrderid-----end at time : " + new Date()));
        return resultMap;
    }

    public static Map<String, String> querySingleByOrderid(String orderid, double orderamt, String kind, String type, String status, String page, String operator, String channel) {
        logger.info((Object)("CCBQuery-----defaultQuerySingleByOrderid-----start at time : " + new Date()));
        if (StringTools.isEmpty((String)orderid)) {
            return CCBQuery.getResultMap("N", "N", "", "\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        }
        Map<String, String> urlMap = CCBUtil.createQueryUrlByOrderid(orderid, kind, type, status, "3", page, operator, channel);
        Map<String, String> resultMap = CCBQuery.getResultMapByOrderid(urlMap, orderid, orderamt);
        logger.info((Object)("orderid[" + orderid + "]\uff0c\u67e5\u8be2\u7ed3\u679c\u4e3a\uff1a" + resultMap));
        logger.info((Object)("CCBQuery-----defaultQuerySingleByOrderid-----end at time : " + new Date()));
        return resultMap;
    }

    public static synchronized Map<String, String> getResultMap(String timeOut, String checkSuccess, String amount, String msg) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("timeOut", timeOut);
        resultMap.put("checkSuccess", checkSuccess);
        resultMap.put("amount", amount);
        resultMap.put("msg", msg);
        return resultMap;
    }

    public static Map<String, String> getResultMapByOrderid(Map<String, String> urlMap, String orderid, double orderamt) {
        String url = "";
        if (urlMap.get("code").trim().equals("Y")) {
            url = urlMap.get("url");
            String queryResult = "";
            try {
                queryResult = HttpsSend.sendPost(url);
            }
            catch (Exception e) {
                logger.error((Object)("query-----http get the error: " + e.getMessage()));
            }
            if (StringTools.isEmpty((String)queryResult)) {
                return CCBQuery.getResultMap("Y", "N", "", "\u65e0\u6cd5\u83b7\u53d6\u67e5\u8be2\u7ed3\u679c");
            }
            return CCBQuery.parseXml(queryResult, orderamt);
        }
        logger.info((Object)("orderid[" + orderid + "]\uff0c\u751f\u6210URL\u5931\u8d25\uff1a " + urlMap.get("msg")));
        return CCBQuery.getResultMap("N", "N", "", urlMap.get("msg"));
    }

    public static Map<String, String> parseXml(String xmlstr, double orderamt) {
        try {
            Document document = DocumentHelper.parseText((String)xmlstr);
            Element root = document.getRootElement();
            if (root == null) {
                return CCBQuery.getResultMap("N", "N", "", "\u8fd4\u56de\u7ed3\u679c\u4e0d\u662fXML\u683c\u5f0f");
            }
            String result_code = root.elementTextTrim("RETURN_CODE");
            if (result_code.equals("000000")) {
                Element each = root.element("QUERYORDER");
                String amount = each.elementTextTrim("AMOUNT");
                if (amount == null) {
                    amount = "";
                    return CCBQuery.getResultMap("N", "N", "", "\u67e5\u8be2\u8fd4\u56de\u91d1\u989d\u4e3a\u7a7a");
                }
                double returnAmount = Double.parseDouble(amount);
                if (Math.abs(Arith.sub((double)returnAmount, (double)orderamt)) > 0.01) {
                    return CCBQuery.getResultMap("N", "N", "", "\u67e5\u8be2\u8fd4\u56de\u91d1\u989d\u4e0d\u4e00\u81f4");
                }
                return CCBQuery.getResultMap("N", "Y", amount, "");
            }
            String msg = root.elementTextTrim("RETURN_MSG");
            return CCBQuery.getResultMap("N", "N", "", msg);
        }
        catch (DocumentException e) {
            return CCBQuery.getResultMap("N", "N", "", e.getMessage());
        }
    }

    public static void main(String[] args) {
        CCBQuery.defaultQuerySingleByOrderid("13022820313106790252", 0.01);
        String orderid = "13030121202603650200";
    }
}

