/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.web.proxy.notify.abc;

import com.hitrust.trustpay.client.b2c.PaymentResult;
import com.xunlei.payproxy.constant.BankpayConstant;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.MiscUtility;
import com.xunlei.payproxy.util.ProxyHelper;
import com.xunlei.payproxy.vo.Bizorder;
import com.xunlei.payproxy.vo.Bizorderok;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.Extbankok;
import com.xunlei.payproxy.vo.Extbankreq;
import com.xunlei.util.Log;
import com.xunlei.web.payproxy.VelocityServlet;
import com.xunlei.web.payproxy.util.Utility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;

public class ABCNotifyServlet
extends VelocityServlet {
    private static Logger log = Log.getLogger();
    IFacade facade = IFacade.INSTANCE;

    protected Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context ctx) throws Exception {
        Object code = null;
        double orderAmt = 0.0;
        String redirectUrl = null;
        String xunleiId = null;
        String productName = null;
        String MSG = request.getParameter("MSG");
        String ABC = request.getParameter("ABC");
        log.info("\u519c\u884c\u8fd4\u56de:MSG=" + MSG + ",ABC=" + ABC);
        PaymentResult paymentResult = new PaymentResult(MSG);
        if (paymentResult.isSuccess()) {
            String amount = paymentResult.getValue("Amount");
            String batchNo = paymentResult.getValue("BatchNo");
            String orderId = paymentResult.getValue("OrderNo");
            String iRspRef = paymentResult.getValue("iRspRef");
            String hostDate = paymentResult.getValue("HostDate");
            String hostTime = paymentResult.getValue("HostTime");
            Extbankok okForQuery = new Extbankok();
            okForQuery.setOrderId(orderId);
            log.info("orderId=" + orderId);
            Extbankok extbankok = this.facade.findExtbankok(okForQuery);
            if (extbankok == null) {
                Extbankreq extbankreqForQuery = new Extbankreq();
                extbankreqForQuery.setOrderId(orderId);
                Extbankreq extbankreq = this.facade.findExtbankreq(extbankreqForQuery);
                if (extbankreq != null) {
                    Bizorder bizorderForQuery = new Bizorder();
                    bizorderForQuery.setXunleipayid(extbankreq.getExt2());
                    Bizorder bizorder = this.facade.findBizorder(bizorderForQuery);
                    log.info(bizorder + "====================" + orderId);
                    if (bizorder != null) {
                        log.debug("ABC B2C Transaction Success! OrderId:" + orderId);
                        extbankok = new Extbankok();
                        extbankok.setOrderId(bizorder.getExtpayorderid());
                        extbankok.setOrderAmt(Double.valueOf(amount).doubleValue());
                        extbankok.setTradeNo(iRspRef);
                        extbankok.setSuccessTime(MiscUtility.timeofnow());
                        extbankok.setDealTime(hostDate);
                        extbankok.setBizOrderStatus("Y");
                        extbankok.setMerAcct(batchNo);
                        extbankok.setDataMerAcct(batchNo);
                        log.debug(extbankok.getDealTime());
                        if (extbankok.getDealTime() != null) {
                            extbankok.setDealTime("");
                        }
                        this.facade.moveExtbankreqToSuccess(extbankok);
                        log.debug("<============xunleipayid================>" + bizorder.getXunleipayid());
                        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)bizorder.getXunleipayid());
                        return this.immediatelyNotify(request, ctx, bizorder.getExtpayorderid());
                    }
                    log.info("ABC B2C Transaction Confirm: bizorder is null! OrderId:" + orderId);
                    return this.getResultTemplate("02", redirectUrl, ctx, xunleiId, orderId, productName, String.valueOf(orderAmt), "");
                }
                log.debug("ABC\u8bf7\u6c42\u8868\u4e3a\u7a7a" + orderId);
                return this.getResultTemplate("02", redirectUrl, ctx, xunleiId, orderId, productName, String.valueOf(orderAmt), "");
            }
            log.debug("\u6b64\u5b9a\u5355\u5df2\u7ecf\u5904\u7406" + orderId);
            return this.immediatelyNotify(request, ctx, orderId);
        }
        String orderId = paymentResult.getValue("OrderNo");
        String batchNo = paymentResult.getValue("BatchNo");
        String iRspRef = paymentResult.getValue("iRspRef");
        String hostDate = paymentResult.getValue("HostDate");
        if (!Utility.isEmpty((String)orderId)) {
            Extbankreq extbankreqForQuery = new Extbankreq();
            extbankreqForQuery.setOrderId(orderId);
            Extbankreq extbankreq = this.facade.findExtbankreq(extbankreqForQuery);
            if (extbankreq != null) {
                extbankreq.setExtbankStatus(BankpayConstant.PAY_STATUS_N);
                if (Utility.isEmpty((String)iRspRef)) {
                    extbankreq.setTradeNo(iRspRef);
                }
                if (Utility.isEmpty((String)hostDate)) {
                    extbankreq.setDealTime(hostDate);
                }
                this.facade.updateExtbankreq(extbankreq);
            }
            Bizorder bizorderForQuery = new Bizorder();
            bizorderForQuery.setXunleipayid(orderId);
            Bizorder bizorder = this.facade.findBizorder(bizorderForQuery);
            if (bizorder != null) {
                bizorder.setOrderstatus(BankpayConstant.PAY_STATUS_N);
                this.facade.updateBizorder(bizorder);
            }
        }
        return null;
    }

    private Template immediatelyNotify(HttpServletRequest request, Context ctx, String bankOrderId) {
        log.debug("enter bankpay return resp method!");
        String code = null;
        double orderAmt = 0.0;
        String redirectUrl = null;
        String xunleiId = null;
        String orderId = null;
        String productName = null;
        Bizorder bizorderQuery = new Bizorder();
        bizorderQuery.setExtpayorderid(bankOrderId);
        Bizorder bizorder = this.facade.findBizorder(bizorderQuery);
        if (bizorder != null) {
            code = "01";
        } else {
            Bizorderok bizorderokForQuery = new Bizorderok();
            bizorderokForQuery.setExtpayorderid(bankOrderId);
            Bizorderok bizorderok = this.facade.findBizorderok(bizorderokForQuery);
            if (bizorderok != null) {
                Copbizinfo copbizinfoForQuery = new Copbizinfo();
                copbizinfoForQuery.setBizno(bizorderok.getBizno());
                Copbizinfo copbizinfo = IFacade.INSTANCE.findCopbizinfo(copbizinfoForQuery);
                if (copbizinfo == null) {
                    code = "03";
                } else {
                    code = "00";
                    orderAmt = bizorderok.getOrderamt();
                    if (!Utility.isEmpty((String)bizorderok.getFgurl())) {
                        redirectUrl = ProxyHelper.buildNotifyUrl((String)bizorderok.getPagecharset(), (String)bizorderok.getFgurl(), (String)bizorderok.getVersion(), (String)bizorderok.getBizorderid(), (String)String.valueOf((int)(bizorderok.getOrderamt() * 100.0)), (String)bizorderok.getOrdertime(), (String)bizorderok.getXunleipayid(), (String)bizorderok.getSuccesstime(), (String)bizorderok.getExt1(), (String)bizorderok.getExt2(), (String)"00", (String)"", (String)copbizinfo.getBizkey(), (Double)bizorderok.getFareamt());
                    }
                    xunleiId = bizorderok.getUsershow();
                    orderId = bizorderok.getBizorderid();
                    productName = bizorderok.getProductname();
                }
            } else {
                code = "02";
            }
        }
        return this.getResultTemplate(code, redirectUrl, ctx, xunleiId, orderId, productName, String.valueOf(orderAmt), "");
    }
}

