/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.xlcommons.util.utility;

import com.xunlei.xlcommons.util.Arith.Arith;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utility {
    private static final Logger logger = LoggerFactory.getLogger(Utility.class);
    private static final String[][] sqlhandles = new String[][]{{"'", "`"}, {"<", ""}, {">", ""}};
    private static final DecimalFormat amtFormat = new DecimalFormat(",##0.00");
    private static final Pattern digiRegx = Pattern.compile("^[\\d]{14}$");
    private static int se;
    private static AtomicInteger atomicOrderIdx;
    private static int maxIdx;
    private static Object orderIdxLock;
    private static final Pattern pattern;
    private static final Pattern digit;

    static {
        pattern = Pattern.compile("^\\d{8}[\\da-zA-Z][-_\\da-zA-Z]*$");
        digit = Pattern.compile("^\\d+$");
    }

    public static final String escapeSql(String str) {
        if (str == null) {
            return "";
        }
        String[][] stringArray = sqlhandles;
        int n = sqlhandles.length;
        int n2 = 0;
        while (n2 < n) {
            String[] ss = stringArray[n2];
            str = str.replaceAll(ss[0], ss[1]);
            ++n2;
        }
        return str;
    }

    public static int getSafeInt(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() != 0;
    }

    public static boolean isAnyEmpty(String ... strs) {
        if (strs == null) {
            return true;
        }
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (Utility.isEmpty(str)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getMaxString(String str, int maxLength) {
        if (str == null) {
            return "";
        }
        if (str.length() > maxLength) {
            return str.substring(0, maxLength);
        }
        return str;
    }

    public static boolean isNullorLEString(String str, int maxLength) {
        if (str == null) {
            return true;
        }
        return str.length() <= maxLength;
    }

    public static boolean isFixLenDigit(String str, int len) {
        if (Utility.isEmpty(str)) {
            return false;
        }
        if (str.length() != len) {
            return false;
        }
        Matcher m = digit.matcher(str);
        return m.find();
    }

    public static boolean isDigit(String str) {
        if (Utility.isEmpty(str)) {
            return false;
        }
        Matcher m = digit.matcher(str);
        return m.find();
    }

    public static boolean isInArray(int[] array, int value) {
        if (array == null) {
            return false;
        }
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            if (v == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String formatQishunYuan(int amount) {
        String rmb = "";
        rmb = amount < 10 ? String.valueOf(rmb) + "0" + amount : String.valueOf(rmb) + amount;
        return rmb;
    }

    public static boolean isValidPeerId(String str) {
        int length = str.length();
        if (length == 12 || length == 16) {
            Matcher matcher = Pattern.compile("^[0-9a-zA-Z]+$").matcher(str);
            return matcher.find();
        }
        return false;
    }

    public static boolean isValidEmail(String email) {
        Matcher m;
        Pattern p = Pattern.compile("[\\w\\-\\.]+@[\\w-]+(\\.[\\w-]+)");
        return email != null && email.length() > 0 && (m = p.matcher(email)).find();
    }

    public static boolean avaliableEmptyAndLength(String value, int length) {
        return value != null && !value.isEmpty() && value.length() <= length;
    }

    public static String FomatDate(String src) {
        String[] temp = src.split("-");
        if (temp[1].length() == 1) {
            temp[1] = "0" + temp[1];
        }
        if (temp[2].length() == 1) {
            temp[2] = "0" + temp[2];
        }
        return String.valueOf(temp[0]) + "-" + temp[1] + "-" + temp[2];
    }

    public static String FomatTime(String src) {
        String[] temp = src.split(":");
        if (temp[0].length() == 1) {
            temp[0] = "0" + temp[0];
        }
        if (temp[1].length() == 1) {
            temp[1] = "0" + temp[1];
        }
        if (temp[2].length() == 1) {
            temp[2] = "0" + temp[2];
        }
        return String.valueOf(temp[0]) + ":" + temp[1] + ":" + temp[2];
    }

    public static String createSerial(String src, int len) {
        String dest = "";
        dest = src.length() >= len ? src.substring(0, len) : String.valueOf(Utility.createSameChar("0", len - src.length())) + src;
        return dest;
    }

    public static String createSameChar(String src, int len) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            sb.append(src);
            ++i;
        }
        return sb.toString();
    }

    public static String getLeftFixedLengthString(String src, String c, int len) {
        if (src.length() >= len) {
            return src.substring(0, len);
        }
        StringBuffer ext = new StringBuffer();
        int i = src.length();
        while (i < len) {
            ext.append(c);
            ++i;
        }
        return String.valueOf(ext.toString()) + src;
    }

    public static int createRandomNum(int max) {
        Random random = new Random();
        return Math.abs(random.nextInt()) % max;
    }

    public static String moveChar(String pwd, int s, int e) {
        if (s > e) {
            int befor = e;
            e = s;
            s = befor;
        }
        if (s != e && s <= 19) {
            String befor1 = pwd.substring(0, s);
            String s1 = pwd.substring(s, s + 1);
            String middle = pwd.substring(s + 1, e);
            String s2 = pwd.substring(e, e + 1);
            String after = pwd.substring(e + 1);
            return String.valueOf(befor1) + s2 + middle + s1 + after;
        }
        return pwd;
    }

    public static String otherdateofnow() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(new Date());
    }

    public static String timeofnow() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar curcal = Calendar.getInstance();
        return sdf.format(curcal.getTime());
    }

    public static String addTime(String time1, String addpart, int num) {
        try {
            SimpleDateFormat e = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String now = e.format(new Date());
            String string = time1 = time1 == null ? now : time1;
            if (time1.length() < 19) {
                time1 = String.valueOf(time1) + " 00:00:00";
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(e.parse(time1));
            if (addpart.equalsIgnoreCase("Y")) {
                cal.add(1, num);
            } else if (addpart.equalsIgnoreCase("M")) {
                cal.add(2, num);
            } else if (addpart.equalsIgnoreCase("D")) {
                cal.add(5, num);
            } else if (addpart.equalsIgnoreCase("H")) {
                cal.add(10, num);
            } else if (addpart.equalsIgnoreCase("F")) {
                cal.add(12, num);
            } else if (addpart.equalsIgnoreCase("S")) {
                cal.add(13, num);
            }
            return e.format(cal.getTime());
        }
        catch (Exception var6) {
            throw new RuntimeException(var6);
        }
    }

    public static String addDate(String date1, String addpart, int num) {
        return Utility.addTime(date1, addpart, num).substring(0, 10);
    }

    public static String ConvertCN2(String is) {
        if (is != null && is.compareTo("") != 0) {
            int l = is.length();
            int os = 0;
            while (os < l) {
                char e = is.charAt(os);
                if (e > '\u00ff') {
                    return is;
                }
                ++os;
            }
            try {
                String var5 = new String(is.getBytes("ISO-8859-1"), "GBK");
                return var5;
            }
            catch (Exception var4) {
                var4.printStackTrace();
                return "";
            }
        }
        return "";
    }

    public static String getTradeSn() {
        return "" + new Date().getTime();
    }

    public static String getTimeByTradeSn(long sn) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(sn));
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getFixedLengthString(String src, String c, int len) {
        if (src.length() >= len) {
            return src.substring(0, len);
        }
        StringBuffer ext = new StringBuffer();
        int i = src.length();
        while (i < len) {
            ext.append(c);
            ++i;
        }
        return String.valueOf(src) + ext.toString();
    }

    public static String getXunleiIdHash(String xunleiid, int flag) throws Exception {
        String src = null;
        String rtn = null;
        String xunleiid2 = xunleiid.toLowerCase();
        int sum = 0;
        boolean mod = false;
        if (flag == 0) {
            src = xunleiid2.substring(0, 2);
        } else {
            if (flag != 1) {
                throw new Exception("getXunleiIdHash error");
            }
            src = xunleiid2.substring(2, 4);
        }
        byte[] bytesrc = src.getBytes();
        int i = 0;
        while (i < bytesrc.length) {
            sum += bytesrc[i];
            ++i;
        }
        int var9 = sum % 100;
        rtn = var9 < 10 ? "0" + var9 : "" + var9;
        return rtn;
    }

    public static boolean sendHtmlMail(Map<String, String> params) {
        MimeMultipart var20;
        MimeMessage ex;
        Session session;
        String password;
        String username;
        String host;
        block10: {
            host = "mail.xunlei.com";
            username = "xlpay";
            password = "xlpayabc";
            if (params.get("ccaddress") == null) {
                params.put("ccaddress", "");
            }
            if (params.get("bccaddress") == null) {
                params.put("bccaddress", "");
            }
            Properties props = new Properties();
            props.put("mail.smtp.host", host);
            props.put("mail.smtp.auth", "true");
            session = Session.getDefaultInstance((Properties)props);
            session.setDebug(true);
            try {
                String[] var16;
                String[] var15;
                String[] toAddresses;
                ex = new MimeMessage(session);
                ex.setFrom((Address)new InternetAddress(params.get("fromaddress")));
                String[] part = toAddresses = params.get("toaddress").split(";");
                int content = toAddresses.length;
                int bccAddresses = 0;
                while (bccAddresses < content) {
                    String ccAddresses = part[bccAddresses];
                    ex.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(ccAddresses));
                    ++bccAddresses;
                }
                String[] transport = var15 = params.get("ccaddress").split(";");
                int var19 = var15.length;
                content = 0;
                while (content < var19) {
                    String var17 = transport[content];
                    if (var17.trim().length() > 0) {
                        ex.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(var17));
                    }
                    ++content;
                }
                String[] var13 = var16 = params.get("bccaddress").split(";");
                int var21 = var16.length;
                var19 = 0;
                while (var19 < var21) {
                    String var18 = var13[var19];
                    if (var18.trim().length() > 0) {
                        ex.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(var18));
                    }
                    ++var19;
                }
                var20 = new MimeMultipart();
                if (var20 != null) break block10;
                return false;
            }
            catch (Exception var14) {
                return false;
            }
        }
        MimeBodyPart var22 = new MimeBodyPart();
        var22.setText(params.get("body"));
        var22.setHeader("Content-Type", "text/html;charset=GBK");
        var20.addBodyPart((BodyPart)var22);
        ex.setSubject(params.get("subject"));
        ex.setContent((Multipart)var20);
        ex.saveChanges();
        Transport var23 = session.getTransport("smtp");
        var23.connect(host, username, password);
        var23.sendMessage((Message)ex, ex.getAllRecipients());
        var23.close();
        return true;
    }

    public static DecimalFormat getNumberFormat() {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance();
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        String s = "###,##0.00";
        df.applyPattern(s);
        return df;
    }

    public static String getFormatedOrderTime(String slimtime) {
        block3: {
            try {
                Matcher ex = digiRegx.matcher(slimtime);
                if (ex.matches()) break block3;
                return null;
            }
            catch (Exception var3) {
                return null;
            }
        }
        Date d = new SimpleDateFormat("yyyyMMddHHmmss").parse(slimtime);
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(d);
    }

    public static boolean isContainsString(String str, String[] array) {
        if (array == null) {
            return false;
        }
        String[] var5 = array;
        int var4 = array.length;
        int var3 = 0;
        while (var3 < var4) {
            String s = var5[var3];
            if (s.equals(str)) {
                return true;
            }
            ++var3;
        }
        return false;
    }

    public static String getFilterSrc(String str) {
        if (str == null) {
            return "";
        }
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(str);
        String after = m.replaceAll("");
        return after;
    }

    public static void writefilefromhttpreturn(String urlName, String filepath) {
        StringBuffer sb = new StringBuffer();
        try {
            URL e = new URL(urlName);
            URLConnection connection = e.openConnection();
            connection.connect();
            String str = null;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((str = in.readLine()) != null) {
                sb.append(String.valueOf(str) + "\n");
            }
            in.close();
        }
        catch (Exception var8) {
            var8.printStackTrace();
        }
        try {
            BufferedWriter e1 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filepath), "GBK"));
            e1.write(sb.toString());
            e1.close();
        }
        catch (Exception var7) {
            var7.printStackTrace();
        }
    }

    public static double getAlipayFareamt(double payedamt) {
        double i = Arith.mul(payedamt, 0.0045);
        double r = Arith.round(i, 2);
        return r;
    }

    public static double get99BillFareamt(double orderAmt) {
        int i = (int)Arith.mul(orderAmt, 0.6);
        if (Arith.mul(orderAmt, 0.6) > (double)i) {
            ++i;
        }
        double r = (double)i / 100.0;
        return r;
    }

    public static double getYeepayFareamt(double orderAmt) {
        double i = Arith.mul(orderAmt, 0.005);
        double r = 0.0;
        r = i < 0.01 ? 0.0 : (i > 0.0 ? Arith.round(i, 2) : 0.0);
        return r;
    }

    public static String capitalize(String name) {
        return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }

    public static String toStringCommon(Object obj) {
        if (obj == null) {
            return "";
        }
        Class<?> clazz = obj.getClass();
        String clazz_fullname = clazz.getName();
        String clazz_name = clazz_fullname.substring(clazz_fullname.lastIndexOf(".") + 1);
        StringBuffer buffer = new StringBuffer();
        buffer.append(clazz_name);
        buffer.append(":[");
        AccessibleObject[] fields = clazz.getDeclaredFields();
        Field.setAccessible(fields, true);
        AccessibleObject[] var9 = fields;
        int var8 = fields.length;
        int var7 = 0;
        while (var7 < var8) {
            AccessibleObject field = var9[var7];
            try {
                buffer.append(((Field)field).getName());
                buffer.append("=");
                buffer.append(((Field)field).get(obj));
                buffer.append(", ");
            }
            catch (IllegalArgumentException var11) {
                var11.printStackTrace();
            }
            catch (IllegalAccessException var12) {
                var12.printStackTrace();
            }
            ++var7;
        }
        buffer.setLength(buffer.length() - 2);
        buffer.append("]");
        return buffer.toString();
    }
}

